/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.ContainerBCore;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ContainerBCTile<T extends TileBCore>
extends ContainerBCore<T> {
    public T tile;

    public ContainerBCTile(@Nullable MenuType<?> type, int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        super(type, windowId, playerInv, extraData);
        this.tile = (TileBCore)ContainerBCTile.getClientTile(extraData);
    }

    public ContainerBCTile(@Nullable MenuType<?> type, int windowId, Inventory player, FriendlyByteBuf extraData, ContainerSlotLayout.LayoutFactory<T> factory) {
        super(type, windowId, player, extraData, factory);
        this.tile = (TileBCore)ContainerBCTile.getClientTile(extraData);
        this.buildSlotLayout();
    }

    public ContainerBCTile(@Nullable MenuType<?> type, int windowId, Inventory player, T tile) {
        super(type, windowId, player);
        this.tile = tile;
        ((TileBCore)this.tile).onPlayerOpenContainer(player.f_35978_);
    }

    public ContainerBCTile(@Nullable MenuType<?> type, int windowId, Inventory player, T tile, ContainerSlotLayout.LayoutFactory<T> factory) {
        super(type, windowId, player, factory);
        this.tile = tile;
        ((TileBCore)this.tile).onPlayerOpenContainer(player.f_35978_);
        this.buildSlotLayout();
    }

    @Override
    protected void buildSlotLayout() {
        if (this.tile != null) {
            this.slotLayout = this.factory.buildLayout(this.player, this.tile).retrieveSlotsForContainer(x$0 -> this.m_38897_((Slot)x$0));
        }
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        ((TileBCore)this.tile).onPlayerCloseContainer(playerIn);
    }

    public void m_38946_() {
        super.m_38946_();
        ((TileBCore)this.tile).detectAndSendChanges(true);
    }

    @Override
    public void m_38893_(ContainerListener listener) {
        super.m_38893_(listener);
        if (listener instanceof ServerPlayer) {
            ((TileBCore)this.tile).getDataManager().forcePlayerSync((ServerPlayer)listener);
        }
    }

    @Override
    public boolean m_6875_(Player playerIn) {
        if (this.tile.m_58904_().m_7702_(this.tile.m_58899_()) != this.tile) {
            return false;
        }
        return this.player.m_20275_((double)this.tile.m_58899_().m_123341_() + 0.5, (double)this.tile.m_58899_().m_123342_() + 0.5, (double)this.tile.m_58899_().m_123343_() + 0.5) <= (double)((TileBCore)this.tile).getAccessDistanceSq();
    }

    @Override
    public ItemStack m_7648_(Player player, int i) {
        LazyOptional<IItemHandler> optional;
        int playerSlots = 36;
        if (this.slotLayout != null) {
            playerSlots = this.slotLayout.getPlayerSlotCount();
        }
        if ((optional = this.getItemHandler()).isPresent()) {
            IItemHandler handler = (IItemHandler)optional.orElse((Object)EmptyHandler.INSTANCE);
            Slot slot = this.m_38853_(i);
            if (slot != null && slot.m_6657_()) {
                ItemStack stack = slot.m_7993_();
                ItemStack result = stack.m_41777_();
                if (i >= playerSlots ? !this.m_38903_(stack, 0, playerSlots, false) : !this.m_38903_(stack, playerSlots, playerSlots + handler.getSlots(), false)) {
                    return ItemStack.f_41583_;
                }
                if (stack.m_41613_() == 0) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                slot.m_142406_(player, stack);
                return result;
            }
        }
        return ItemStack.f_41583_;
    }

    @Override
    public Slot m_38853_(int slotId) {
        if (slotId < this.f_38839_.size() && slotId >= 0) {
            return (Slot)this.f_38839_.get(slotId);
        }
        return null;
    }

    @Override
    public LazyOptional<IItemHandler> getItemHandler() {
        return ((TileBCore)this.tile).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    @Override
    public ContainerSlotLayout getSlotLayout() {
        return this.slotLayout;
    }

    protected static <T extends BlockEntity> T getClientTile(FriendlyByteBuf extraData) {
        return (T)Minecraft.m_91087_().f_91073_.m_7702_(extraData.m_130135_());
    }

    public PacketCustom createServerBoundPacket(int packetType) {
        PacketCustom packet = new PacketCustom(BCoreNetwork.CHANNEL, packetType);
        packet.writeInt(this.f_38840_);
        return packet;
    }

    public void handleContainerMessage(PacketCustom packet, ServerPlayer player) {
        int containerId = packet.readInt();
        if (containerId != this.f_38840_) {
            return;
        }
        byte packetID = packet.readByte();
        ((TileBCore)this.tile).receivePacketFromClient((MCDataInput)packet, player, packetID);
    }

    public void handleTileDataPacket(PacketCustom packet, ServerPlayer player) {
        int containerId = packet.readInt();
        if (containerId != this.f_38840_) {
            return;
        }
        ((TileBCore)this.tile).getDataManager().receiveDataFromClient((MCDataInput)packet);
    }
}

