/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.integration;

import com.brandon3055.brandonscore.integration.BCJEIPlugin;
import com.brandon3055.brandonscore.integration.IRecipeRenderer;
import com.brandon3055.brandonscore.integration.ModHelperBC;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class JeiHelper {
    public static boolean jeiAvailable() {
        if (!ModHelperBC.isJEIInstalled) {
            return false;
        }
        return JeiHelper.checkJEIRuntime();
    }

    public static boolean checkJEIRuntime() {
        return BCJEIPlugin.jeiRuntime != null;
    }

    public static List<IRecipeRenderer> getRecipeRenderers(ItemStack result) {
        if (!JeiHelper.jeiAvailable()) {
            return null;
        }
        return JeiHelper.getRenderers(result);
    }

    private static List<IRecipeRenderer> getRenderers(ItemStack result) {
        ArrayList<IRecipeRenderer> renderers = new ArrayList<IRecipeRenderer>();
        IRecipeManager registry = BCJEIPlugin.jeiRuntime.getRecipeManager();
        IFocus focus = BCJEIPlugin.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)result);
        registry.createRecipeCategoryLookup().limitFocus(Collections.singleton(focus)).get().forEach(category -> registry.createRecipeLookup(category.getRecipeType()).limitFocus(Collections.singleton(focus)).get().forEach(recipe -> {
            try {
                renderers.add(new RecipeRenderer((IRecipeCategory)category, recipe, result));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }));
        return renderers;
    }

    public static void openJEIRecipe(ItemStack stack, boolean usage) {
        if (JeiHelper.jeiAvailable()) {
            JeiHelper.openJEIRecipeInternal(stack, usage);
        }
    }

    private static void openJEIRecipeInternal(ItemStack stack, boolean usage) {
        if (JeiHelper.checkJEIRuntime()) {
            IFocus focus = BCJEIPlugin.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(usage ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            BCJEIPlugin.jeiRuntime.getRecipesGui().show(focus);
        }
    }

    public static int getRecipeKey(boolean usage) {
        return -1;
    }

    @Nullable
    public static ItemStack getPanelItemUnderMouse() {
        if (!JeiHelper.jeiAvailable()) {
            return null;
        }
        Optional ingredient = BCJEIPlugin.jeiRuntime.getIngredientListOverlay().getIngredientUnderMouse();
        if (ingredient == null) {
            return null;
        }
        IIngredientHelper helper = BCJEIPlugin.jeiRuntime.getIngredientManager().getIngredientHelper((Object)ingredient);
        return helper.getCheatItemStack((Object)ingredient);
    }

    private static class RecipeRenderer
    implements IRecipeRenderer {
        private IRecipeLayoutDrawable recipeLayout;
        private int width;
        private int height;
        private int xPos = 0;
        private int yPos = 0;
        private Component title;

        public RecipeRenderer(IRecipeCategory category, Object wrapper, ItemStack result) {
            IFocus focus = BCJEIPlugin.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)result);
            this.recipeLayout = BCJEIPlugin.jeiRuntime.getRecipeManager().createRecipeLayoutDrawable(category, wrapper, focus);
            this.width = category.getBackground().getWidth();
            this.height = category.getBackground().getHeight();
            this.title = category.getTitle();
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void render(Minecraft mc, int xPos, int yPos, int mouseX, int mouseY) {
            if (this.xPos != xPos || this.yPos != yPos) {
                this.xPos = xPos;
                this.yPos = yPos;
                this.recipeLayout.setPosition(xPos, yPos);
            }
            this.recipeLayout.drawRecipe(new PoseStack(), mouseX, mouseY);
        }

        @Override
        public void renderOverlay(Minecraft mc, int mouseX, int mouseY) {
            this.recipeLayout.drawOverlays(new PoseStack(), mouseX, mouseY);
        }

        @Override
        public boolean handleRecipeClick(Minecraft minecraft, double mouseX, double mouseY, boolean usage) {
            ItemStack clicked = (ItemStack)this.recipeLayout.getIngredientUnderMouse((int)mouseX, (int)mouseY, (IIngredientType)VanillaTypes.ITEM_STACK);
            if (clicked != null) {
                IFocus focus = BCJEIPlugin.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(usage ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)clicked);
                BCJEIPlugin.jeiRuntime.getRecipesGui().show(focus);
            }
            return false;
        }

        @Override
        @Nullable
        public Object getIngredientUnderMouse(double mouseX, double mouseY) {
            return this.recipeLayout.getIngredientUnderMouse((int)mouseX, (int)mouseY, () -> Object.class);
        }

        @Override
        public Component getTitle() {
            return this.title;
        }
    }
}

