/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.handlers.contributor;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.client.ClientOnly;
import com.brandon3055.brandonscore.handlers.contributor.Animations;
import com.brandon3055.brandonscore.handlers.contributor.ContributorConfig;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ContributorProperties {
    private static final Logger LOGGER = LogManager.getLogger(ContributorProperties.class);
    private final UUID userID;
    private boolean isContributor = false;
    private boolean isDev = false;
    private boolean shieldRGB = false;
    private boolean wingsRGB = false;
    private boolean isPatron = false;
    private List<ContributorConfig.Badge> badges = new ArrayList<ContributorConfig.Badge>();
    private List<TechLevel> wings = new ArrayList<TechLevel>();
    private Calendar plusOneEnd = null;
    private ContributorConfig config = null;
    private Animations anim = null;
    private boolean loadComplete = false;
    private List<Consumer<ContributorProperties>> loadWaitList = new ArrayList<Consumer<ContributorProperties>>();

    @Deprecated
    public ContributorProperties() {
        this.userID = UUID.randomUUID();
        this.wingsRGB = true;
        this.shieldRGB = true;
        this.isDev = true;
        this.isContributor = true;
        this.badges.addAll(Arrays.asList(ContributorConfig.Badge.values()));
        this.wings.addAll(Arrays.asList(TechLevel.values()));
        this.loadComplete = true;
    }

    public ContributorProperties(UUID userID, @Nullable String username) {
        ContributorHandler.getContributorStatus(userID, username, this::fetchComplete);
        this.userID = userID;
    }

    protected void fetchComplete(@Nullable Map<String, String> flags) {
        Player client;
        if (flags == null || flags.isEmpty()) {
            this.confirmationFailed();
            return;
        }
        this.config = new ContributorConfig(this);
        this.isContributor = true;
        this.isDev = flags.containsKey("dev");
        if (this.isDev) {
            this.wingsRGB = true;
            this.shieldRGB = true;
            this.badges.addAll(Arrays.asList(ContributorConfig.Badge.values()));
            this.wings.addAll(Arrays.asList(TechLevel.values()));
        } else {
            String tier;
            this.badges.add(ContributorConfig.Badge.DISABLED);
            this.shieldRGB = flags.containsKey("shield_rgb");
            this.wingsRGB = flags.containsKey("wings_rgb");
            if (flags.containsKey("lolnet")) {
                this.badges.add(ContributorConfig.Badge.LOLNET);
            }
            if (flags.containsKey("cr")) {
                this.badges.add(ContributorConfig.Badge.CR);
            }
            if (flags.containsKey("og_veteran")) {
                this.badges.add(ContributorConfig.Badge.OG_VETERAN);
            }
            if (flags.containsKey("tier+1")) {
                try {
                    String[] date = flags.get("tier+1").split("/");
                    Calendar end = Calendar.getInstance();
                    end.clear();
                    end.set(Integer.parseInt(date[0]), Integer.parseInt(date[1]) + 1, Integer.parseInt(date[2]));
                    this.plusOneEnd = end;
                }
                catch (Throwable date) {
                    // empty catch block
                }
            }
            if (flags.containsKey("wings")) {
                tier = flags.get("wings");
                if (tier.isEmpty()) {
                    this.wings.addAll(Arrays.asList(TechLevel.values()));
                } else {
                    try {
                        this.wings.add(TechLevel.valueOf(tier.toUpperCase(Locale.ENGLISH)));
                    }
                    catch (Throwable e2) {
                        LOGGER.error("Unable to parse wings tier {}", (Object)tier, (Object)e2);
                    }
                }
            }
            if (flags.containsKey("patreon")) {
                this.isPatron = true;
                tier = flags.get("patreon");
                this.badges.add(ContributorConfig.Badge.PATREON_OG);
                if (tier.isEmpty()) {
                    this.badges.addAll(Arrays.asList(ContributorConfig.Badge.PATREON_DRACONIUM, ContributorConfig.Badge.PATREON_WYVERN, ContributorConfig.Badge.PATREON_DRACONIC, ContributorConfig.Badge.PATREON_CHAOTIC));
                } else {
                    try {
                        this.badges.add(ContributorConfig.Badge.valueOf(tier.toUpperCase(Locale.ENGLISH)));
                    }
                    catch (Throwable e3) {
                        LOGGER.error("Unable to parse patreon tier {}", (Object)tier, (Object)e3);
                    }
                }
            }
        }
        if (this.badges.size() == 1 && this.badges.contains(ContributorConfig.Badge.DISABLED)) {
            this.badges.clear();
        }
        if ((client = (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> ClientOnly::getClientPlayer)) != null && client.m_142081_().equals(this.userID)) {
            this.config = ContributorConfig.load();
            this.config.props = this;
        }
        this.loadComplete = true;
        this.loadWaitList.forEach(e -> e.accept(this));
        this.loadWaitList.clear();
    }

    private void confirmationFailed() {
        this.loadComplete = true;
        this.isContributor = false;
        this.loadWaitList.clear();
    }

    public boolean isLoadComplete() {
        return this.loadComplete;
    }

    public void onContributorLoaded(Consumer<ContributorProperties> callBack) {
        if (this.loadComplete && this.isContributor()) {
            callBack.accept(this);
        } else if (!this.loadComplete) {
            this.loadWaitList.add(callBack);
        }
    }

    public void clientTick() {
        if (!this.isContributor()) {
            return;
        }
        if (TimeKeeper.getClientTick() % 20 == 0 && this.getConfig().getResetSyncRequired()) {
            BCoreNetwork.sendContributorConfigToServer(this);
        }
        this.getAnim().tick();
    }

    public UUID getUserID() {
        return this.userID;
    }

    public boolean isDev() {
        return this.isDev;
    }

    public boolean isContributor() {
        return this.isContributor;
    }

    public boolean isPatron() {
        return this.isPatron;
    }

    public boolean hasShieldRGB() {
        return this.shieldRGB;
    }

    public boolean hasWingsRGB() {
        return this.wingsRGB;
    }

    public List<TechLevel> getWingTiers() {
        return this.wings;
    }

    public boolean hasWings() {
        return !this.wings.isEmpty();
    }

    public List<ContributorConfig.Badge> getBadges() {
        return this.badges;
    }

    public ContributorConfig getConfig() {
        if (this.config == null) {
            this.setConfig(new ContributorConfig());
        }
        return this.config;
    }

    public Animations getAnim() {
        if (this.anim == null) {
            this.anim = new Animations(this);
        }
        return this.anim;
    }

    public void setConfig(ContributorConfig config) {
        this.config = config;
        this.config.props = this;
    }

    public String toString() {
        return "ContributorProperties{userID=" + this.userID + ", isContributor=" + this.isContributor + ", isDev=" + this.isDev + ", shieldRGB=" + this.shieldRGB + ", wingsRGB=" + this.wingsRGB + ", badges=" + this.badges + ", wings=" + this.wings + ", plusOneEnd=" + this.plusOneEnd + ", config=" + this.config + ", anim=" + this.anim + ", loadComplete=" + this.loadComplete + ", loadWaitList=" + this.loadWaitList + "}";
    }
}

