/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.handlers.contributor;

import com.brandon3055.brandonscore.handlers.FileHandler;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import net.covers1624.quack.net.HttpResponseException;
import net.covers1624.quack.net.java.JavaDownloadAction;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ContributorFetcher {
    private static final String CONTRIBUTOR_URL = "https://contributors.brandon3055.com/api/contributor";
    private static final String HASHES_URL = "https://contributors.brandon3055.com/api/hashes";
    private static final String LINK_URL = "https://contributors.brandon3055.com/api/link";
    private static final Map<UUID, String> HASH_CACHE = new HashMap<UUID, String>();
    private static final HashFunction SHA = Hashing.sha256();
    private static final Gson GSON = new GsonBuilder().create();
    private static final Type FLAGS_TYPE = new TypeToken<HashMap<String, HashMap<String, String>>>(){}.getType();
    private static final Type HASHES_TYPE = new TypeToken<HashSet<String>>(){}.getType();
    private static final Logger POOL_LOGGER = LogUtils.getLogger();
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger();
    private final CrashLock LOCK = new CrashLock("Already Initialized.");
    private final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("DE Contributor Fetcher #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(POOL_LOGGER)).build());
    private boolean apiError = false;
    private final List<ThreadedTask> TASK_QUE = new ArrayList<ThreadedTask>();
    private final List<Future<ThreadedTask>> FUTURE_TASKS = new ArrayList<Future<ThreadedTask>>();
    private final Map<UUID, Map<String, Map<String, String>>> CACHED_FLAGS = new HashMap<UUID, Map<String, Map<String, String>>>();
    private final List<Runnable> waitingForHashes = new ArrayList<Runnable>();
    private Set<String> contributorHashes = null;
    private int tick;

    public void init() {
        this.LOCK.lock();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.addListener(event -> this.onTick((TickEvent)event)));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> MinecraftForge.EVENT_BUS.addListener(event -> this.onTick((TickEvent)event)));
        this.downloadHashes();
    }

    private void onTick(TickEvent event) {
        if (!this.TASK_QUE.isEmpty()) {
            this.TASK_QUE.forEach(task -> this.FUTURE_TASKS.add(this.THREAD_POOL.submit(task)));
            this.TASK_QUE.clear();
        }
        if (this.tick++ % 20 != 0 || this.FUTURE_TASKS.isEmpty()) {
            return;
        }
        ArrayList<Future<ThreadedTask>> complete = new ArrayList<Future<ThreadedTask>>();
        for (Future<ThreadedTask> task2 : this.FUTURE_TASKS) {
            if (!task2.isDone()) continue;
            try {
                task2.get().finish();
            }
            catch (Throwable e) {
                LOGGER.warn("An error occurred while finalizing contributor status", e);
            }
            complete.add(task2);
        }
        this.FUTURE_TASKS.removeAll(complete);
    }

    public void fetchContributorFlags(UUID playerId, @Nullable String userName, String projectKey, Consumer<Map<String, String>> flagsCallback) {
        if (!this.isOnline(playerId, userName)) {
            flagsCallback.accept(null);
            return;
        }
        if (this.apiError) {
            flagsCallback.accept(null);
            return;
        }
        if (this.CACHED_FLAGS.containsKey(playerId)) {
            flagsCallback.accept(this.CACHED_FLAGS.get(playerId).get(projectKey));
        } else if (this.contributorHashes == null) {
            this.waitingForHashes.add(() -> this.checkAndFetchUser(playerId, map -> flagsCallback.accept(map == null ? null : (Map)map.get(projectKey))));
        } else {
            this.checkAndFetchUser(playerId, map -> flagsCallback.accept(map == null ? null : (Map)map.get(projectKey)));
        }
    }

    private void checkAndFetchUser(UUID uuid, Consumer<Map<String, Map<String, String>>> flagsCallback) {
        if (this.contributorHashes != null && this.contributorHashes.contains(this.userHash(uuid))) {
            this.queTask(new FetcherTask(uuid, flagsCallback));
        } else {
            flagsCallback.accept(null);
        }
    }

    public void linkUser(Player player, String linkCode, Consumer<Integer> callback) {
        if (!this.isOnline(player.m_142081_(), player.m_36316_().getName())) {
            player.m_6352_((Component)new TextComponent("You must be playing in online mode to link your account.").m_130940_(ChatFormatting.RED), Util.f_137441_);
        } else {
            this.queTask(new LinkTask(player.m_142081_(), linkCode, callback));
        }
    }

    public String userHash(UUID uuid) {
        return HASH_CACHE.computeIfAbsent(uuid, e -> SHA.hashBytes(e.toString().getBytes(StandardCharsets.UTF_8)).toString());
    }

    public boolean hasUser(UUID uuid) {
        return this.contributorHashes != null && !this.contributorHashes.isEmpty() && this.contributorHashes.contains(this.userHash(uuid));
    }

    private void queTask(ThreadedTask task) {
        this.TASK_QUE.add(task);
    }

    public void reload() {
        this.contributorHashes = null;
        this.apiError = false;
        this.CACHED_FLAGS.clear();
        this.downloadHashes();
    }

    private void downloadHashes() {
        File hashFile = new File(FileHandler.brandon3055Folder, "contributors.json");
        DownloadTask downloadTask = new DownloadTask(hashFile, HASHES_URL);
        downloadTask.onFinished(downloader -> {
            block8: {
                try {
                    if (downloader.errored) {
                        this.apiError = true;
                        break block8;
                    }
                    try (FileReader reader = new FileReader(downloader.file);){
                        this.contributorHashes = (Set)GSON.fromJson((Reader)reader, HASHES_TYPE);
                    }
                }
                catch (Throwable e) {
                    LOGGER.warn("An error occurred while processing contributor hashes", e);
                }
            }
            this.waitingForHashes.forEach(Runnable::run);
            this.waitingForHashes.clear();
        });
        this.queTask(downloadTask);
    }

    private boolean isOnline(UUID playerId, @Nullable String username) {
        return username == null || !playerId.equals(Player.m_36283_((String)username));
    }

    private static interface ThreadedTask
    extends Callable<ThreadedTask> {
        public void finish();
    }

    private static class FetcherTask
    implements ThreadedTask {
        private final UUID playerID;
        private final Consumer<Map<String, Map<String, String>>> flagsCallback;
        private Map<String, Map<String, String>> result = null;

        public FetcherTask(UUID playerID, Consumer<Map<String, Map<String, String>>> flagsCallback) {
            this.playerID = playerID;
            this.flagsCallback = flagsCallback;
        }

        @Override
        public FetcherTask call() throws Exception {
            String url = "https://contributors.brandon3055.com/api/contributor?uuid=" + this.playerID.toString();
            try (StringWriter writer = new StringWriter();){
                new JavaDownloadAction().setUrl(url).setDest(writer).execute();
                this.result = (Map)GSON.fromJson(writer.toString(), FLAGS_TYPE);
            }
            catch (Throwable e) {
                LOGGER.warn("Error occurred when attempting to download contributor flags: {}", (Object)url, (Object)e);
            }
            if (this.result != null && this.result.isEmpty()) {
                this.result = null;
            }
            return this;
        }

        @Override
        public void finish() {
            this.flagsCallback.accept(this.result);
        }
    }

    private static class LinkTask
    implements ThreadedTask {
        private final UUID playerId;
        private final String linkCode;
        private Consumer<Integer> onFinished;
        private int errorCode = -1;

        public LinkTask(UUID playerId, String linkCode, Consumer<Integer> onFinished) {
            this.playerId = playerId;
            this.linkCode = linkCode;
            this.onFinished = onFinished;
        }

        @Override
        public LinkTask call() {
            String url = "https://contributors.brandon3055.com/api/link?uuid=" + this.playerId.toString() + "&link_code=" + this.linkCode;
            try (StringWriter writer = new StringWriter();){
                JavaDownloadAction action = new JavaDownloadAction().setUrl(url).setDest(writer).setUseETag(true);
                action.execute();
            }
            catch (HttpResponseException e) {
                this.errorCode = e.code;
            }
            catch (IOException e) {
                LOGGER.warn("Error occurred when attempting link account", (Throwable)e);
            }
            return this;
        }

        @Override
        public void finish() {
            this.onFinished.accept(this.errorCode);
        }
    }

    private static class DownloadTask
    implements ThreadedTask {
        private final File file;
        private final String url;
        private boolean errored = false;
        private Consumer<DownloadTask> finishedCallback;

        public DownloadTask(File file, String url) {
            this.file = file;
            this.url = url;
        }

        public DownloadTask onFinished(Consumer<DownloadTask> finishedCallback) {
            this.finishedCallback = finishedCallback;
            return this;
        }

        @Override
        public DownloadTask call() {
            try {
                new JavaDownloadAction().setUrl(this.url).setDest(this.file).setUseETag(true).execute();
            }
            catch (Throwable e) {
                LOGGER.warn("Error occurred when attempting to download file: {}", (Object)this.url, (Object)e);
                this.errored = true;
            }
            return this;
        }

        @Override
        public void finish() {
            if (this.finishedCallback != null) {
                this.finishedCallback.accept(this);
            }
        }
    }
}

