/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MultiBlockProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Logger LOGGER = LogManager.getLogger(MultiBlockProvider.class);
    private final DataGenerator gen;
    private final String modid;
    private Map<String, JsonObject> builtMultiBlocks = new HashMap<String, JsonObject>();

    public MultiBlockProvider(DataGenerator gen, String modid) {
        this.gen = gen;
        this.modid = modid;
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.builtMultiBlocks.clear();
        this.buildMultiBlocks();
        for (String name : this.builtMultiBlocks.keySet()) {
            this.saveMultiBlock(cache, new ResourceLocation(this.modid, name), this.builtMultiBlocks.get(name));
        }
    }

    private void saveMultiBlock(HashCache cache, ResourceLocation id, JsonObject multiBlockJson) {
        Path mainOutput = this.gen.m_123916_();
        String pathSuffix = "data/" + id.m_135827_() + "/multiblocks/" + id.m_135815_() + ".json";
        Path outputPath = mainOutput.resolve(pathSuffix);
        try {
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)multiBlockJson, (Path)outputPath);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save multiblock structure to {}", (Object)outputPath, (Object)e);
        }
    }

    protected abstract void buildMultiBlocks();

    public Builder builder(String id) {
        return new Builder(id);
    }

    public String m_6055_() {
        return "Multi-Blocks: " + this.modid;
    }

    protected class Builder {
        private JsonObject keys = new JsonObject();
        private JsonArray layerArray = new JsonArray();
        private JsonArray currentLayer = new JsonArray();
        private String id;
        private BlockPos originPos = BlockPos.f_121853_;

        private Builder(String id) {
            this.id = id;
        }

        private Builder key(char key, String type, String value) {
            if (this.keys.has(String.valueOf(key))) {
                throw new RuntimeException("MultiBlockProvider: Attempted to add the same key twice for multiblock: " + this.id + ", Key: " + key);
            }
            JsonObject keyObj = new JsonObject();
            keyObj.addProperty(type, value);
            this.keys.add(String.valueOf(key), (JsonElement)keyObj);
            return this;
        }

        public Builder key(char key, TagKey<Block> tag) {
            return this.key(key, "tag", tag.f_203868_().toString());
        }

        public Builder key(char key, Block block) {
            return this.key(key, "block", block.getRegistryName().toString());
        }

        public Builder setOrigin(BlockPos originPos) {
            this.originPos = originPos;
            return this;
        }

        public Builder addRow(String rowOfkeys) {
            for (char keyChar : rowOfkeys.toCharArray()) {
                String key = String.valueOf(keyChar);
                if (this.keys.has(key) || key.equals(" ")) continue;
                throw new RuntimeException("MultiBlockProvider: Attempted to add undefined key for multiblock: " + this.id + ", Key: " + key);
            }
            this.currentLayer.add(rowOfkeys);
            return this;
        }

        public Builder newLayer() {
            this.layerArray.add((JsonElement)this.currentLayer);
            this.currentLayer = new JsonArray();
            return this;
        }

        public void build() {
            if (!this.currentLayer.isEmpty()) {
                this.newLayer();
            }
            JsonObject json = new JsonObject();
            json.add("keys", (JsonElement)this.keys);
            if (!this.originPos.equals((Object)BlockPos.f_121853_)) {
                JsonObject origin = new JsonObject();
                origin.addProperty("x", (Number)this.originPos.m_123341_());
                origin.addProperty("y", (Number)this.originPos.m_123342_());
                origin.addProperty("z", (Number)this.originPos.m_123343_());
                json.add("origin", (JsonElement)origin);
            }
            json.add("structure", (JsonElement)this.layerArray);
            MultiBlockProvider.this.builtMultiBlocks.put(this.id, json);
        }
    }
}

