/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.ClientOnly;
import com.brandon3055.brandonscore.client.gui.ContributorConfigGui;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiToolkitTest;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiTest;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;

public class BCClientCommands {
    private static long lastReload = 0L;
    private static long lastLink = 0L;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"bcore_client");
        builder.then(BCClientCommands.contributor());
        if (BrandonsCore.inDev) {
            builder.then(BCClientCommands.testGui());
        }
        dispatcher.register(builder);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> testGui() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"testui").requires(cs -> cs.m_6761_(0))).then(Commands.m_82127_((String)"mgui").executes(context -> {
            DelayedTask.client(10, () -> Minecraft.m_91087_().m_91152_((Screen)new ModularGuiTest((Component)new TextComponent("Test"))));
            return 0;
        }))).then(Commands.m_82127_((String)"toolkit").executes(context -> {
            DelayedTask.client(10, () -> Minecraft.m_91087_().m_91152_((Screen)new GuiToolkitTest((Component)new TextComponent("Test"))));
            return 0;
        }));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> contributor() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"contributor").requires(cs -> cs.m_6761_(0))).executes(context -> {
            Player player = ClientOnly.getClientPlayer();
            ContributorProperties props = ContributorHandler.getProps(player);
            if (!props.isLoadComplete()) {
                player.m_6352_((Component)new TextComponent("Your contributor status has not yet been determined. Please wait a few seconds and try again."), Util.f_137441_);
                return 0;
            }
            if (!props.isContributor()) {
                player.m_6352_((Component)new TextComponent("This command allows Draconic Evolution contributors to configure their contributor perks.").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
                player.m_6352_((Component)new TextComponent("Contributor perks are purely aesthetic features offered to those who support Draconic Evolution.").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
                player.m_6352_((Component)new TextComponent("You can find more information on my patreon page: ").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
                MutableComponent link = new TextComponent("www.patreon.com/brandon3055").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/brandon3055")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to open or copy link"))));
                player.m_6352_((Component)link.m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}), Util.f_137441_);
                player.m_6352_((Component)new TextComponent(""), Util.f_137441_);
                MutableComponent notLinked = new TextComponent("Please Click Here").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/bcore_client contributor help")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click for help"))));
                player.m_6352_((Component)new TextComponent("Already a contributor? ").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)notLinked.m_130940_(ChatFormatting.BLUE)), Util.f_137441_);
                return 0;
            }
            DelayedTask.client(10, () -> Minecraft.m_91087_().m_91152_((Screen)new ContributorConfigGui(player, props)));
            return 0;
        })).then(Commands.m_82127_((String)"help").executes(context -> {
            Player player = ClientOnly.getClientPlayer();
            player.m_6352_((Component)new TextComponent("If you are already a contributor but you you cant access your perks there are several possible causes.").m_130940_(ChatFormatting.YELLOW), Util.f_137441_);
            player.m_6352_((Component)new TextComponent("Your contributor status might not have have been linked to your Minecraft user id. If you are a patron then you should have received a message with instructions when you signed up. If you are playing in offline mode your contributor status can not be verified. Or your client might not be able to contact the contributor API for some reason.").m_130940_(ChatFormatting.GRAY), Util.f_137441_);
            MutableComponent link = new TextComponent("DE Discord").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/e2HBEtF")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to open or copy link"))));
            player.m_6352_((Component)new TextComponent("If you need help you can request assistance via the ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)link.m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE})), Util.f_137441_);
            return 0;
        }))).then(Commands.m_82127_((String)"reload").executes(context -> {
            if (System.currentTimeMillis() - lastReload < 30000L && !BrandonsCore.inDev) {
                Player player = ClientOnly.getClientPlayer();
                player.m_6352_((Component)new TextComponent("Please wait at least 30 seconds before running this command again").m_130940_(ChatFormatting.RED), Util.f_137441_);
            } else {
                ContributorHandler.reload();
                lastReload = System.currentTimeMillis();
            }
            return 0;
        }))).then(Commands.m_82127_((String)"link").then(Commands.m_82129_((String)"link_code", (ArgumentType)StringArgumentType.string()).executes(context -> {
            Player player = ClientOnly.getClientPlayer();
            if (System.currentTimeMillis() - lastLink < 30000L && !BrandonsCore.inDev) {
                player.m_6352_((Component)new TextComponent("Please wait at least 30 seconds before running this command again").m_130940_(ChatFormatting.RED), Util.f_137441_);
            } else {
                String linkCode = StringArgumentType.getString((CommandContext)context, (String)"link_code");
                ContributorHandler.linkUser(player, linkCode, error -> {
                    if (error == -1) {
                        player.m_6352_((Component)new TextComponent("Link Successful!").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
                    } else {
                        player.m_6352_((Component)new TextComponent("An error occurred.").m_130940_(ChatFormatting.RED), Util.f_137441_);
                        player.m_6352_((Component)new TextComponent((String)(error == 404 ? "Invalid Link Code" : "Unknown error code: " + error)).m_130940_(ChatFormatting.RED), Util.f_137441_);
                    }
                });
                lastLink = System.currentTimeMillis();
            }
            return 0;
        })));
    }
}

