/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.utils;

import com.brandon3055.brandonscore.api.TimeKeeper;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CyclingItemGroup
extends CreativeModeTab {
    private Supplier<Object[]> iconSupplier;
    private int iconIndex = 0;
    private int lastIndex = 0;
    private int cycleRate = 20;
    private ItemStack icon;
    public int timeOffset = 0;
    private List<ResourceLocation> sortOrder = null;

    public CyclingItemGroup(String label, Supplier<Object[]> iconSupplier) {
        super(label);
        this.iconSupplier = iconSupplier;
    }

    public CyclingItemGroup(String label, int cycleRate, Supplier<Object[]> iconSupplier) {
        super(label);
        this.iconSupplier = iconSupplier;
        this.cycleRate = cycleRate;
    }

    public CyclingItemGroup(String label, Supplier<Object[]> iconSupplier, List<ResourceLocation> sortOrder) {
        super(label);
        this.iconSupplier = iconSupplier;
        this.sortOrder = sortOrder;
    }

    public CyclingItemGroup(String label, int cycleRate, Supplier<Object[]> iconSupplier, List<ResourceLocation> sortOrder) {
        super(label);
        this.iconSupplier = iconSupplier;
        this.cycleRate = cycleRate;
        this.sortOrder = sortOrder;
    }

    @Nonnull
    public ItemStack m_6976_() {
        ItemStack stack;
        Object[] icons = this.iconSupplier.get();
        Object obj = icons[this.iconIndex % icons.length];
        ItemStack itemStack = obj instanceof ItemStack ? (ItemStack)obj : (stack = new ItemStack((ItemLike)(obj instanceof Item ? (Item)obj : (Block)obj)));
        if (this.icon == null || !stack.m_41619_()) {
            return stack;
        }
        ++this.iconIndex;
        return this.m_6976_();
    }

    public ItemStack m_40787_() {
        int index = (TimeKeeper.getClientTick() + this.timeOffset) / this.cycleRate;
        if (this.icon == null || index != this.lastIndex) {
            this.lastIndex = index;
            ++this.iconIndex;
            this.icon = this.m_6976_();
        }
        return this.icon;
    }

    public CyclingItemGroup setOffset(int timeOffset) {
        this.timeOffset = timeOffset;
        return this;
    }

    public void m_6151_(NonNullList<ItemStack> items) {
        if (this.sortOrder != null) {
            NonNullList sortedItems = NonNullList.m_122779_();
            for (Item item : Registry.f_122827_) {
                item.m_6787_((CreativeModeTab)this, sortedItems);
            }
            sortedItems.sort(Comparator.comparingInt(value -> this.sortOrder.indexOf(value.m_41720_().getRegistryName())));
            items.addAll((Collection)sortedItems);
        } else {
            super.m_6151_(items);
        }
    }
}

