/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.render;

import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Cuboid6;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.multiblock.MultiBlockDefinition;
import com.brandon3055.brandonscore.multiblock.MultiBlockPart;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class MultiBlockRenderers {
    private static final RenderType outlineType = RenderType.m_173209_((String)"invalid_outline", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173095_).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110687_(RenderStateShard.f_110115_).m_110663_(RenderStateShard.f_110111_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(4.0))).m_110691_(false));

    public static void renderBuildGuide(Level level, BlockPos inWorldOrigin, PoseStack poseStack, MultiBufferSource getter, MultiBlockDefinition structure, int packedLight, float partialTicks) {
        Map<BlockPos, MultiBlockPart> blocks = structure.getBlocks();
        IdentityHashMap<MultiBlockPart, BlockState> stateMap = new IdentityHashMap<MultiBlockPart, BlockState>();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int time = TimeKeeper.getClientTick() % 80;
        int anim = 5;
        if (time >= 70) {
            anim += (int)(Math.sin((double)((float)(time -= 70) / 10.0f) * Math.PI) * 5.0);
        }
        ArrayList<BlockPos> invalidBlocks = new ArrayList<BlockPos>();
        for (BlockPos pos : blocks.keySet()) {
            MultiBlockPart part = blocks.get(pos);
            if (part.validBlocks().isEmpty()) continue;
            BlockPos worldPos = inWorldOrigin.m_141952_((Vec3i)pos);
            if (level.m_46859_(worldPos)) {
                BlockState state;
                if (player != null && worldPos.m_203193_((Position)player.m_146892_()) < 16.0 || (state = stateMap.computeIfAbsent(part, e -> List.copyOf(e.validBlocks()).get(TimeKeeper.getClientTick() / 40 % e.validBlocks().size()).m_49966_())).m_60795_()) continue;
                poseStack.m_85836_();
                poseStack.m_85837_((double)pos.m_123341_() + 0.1, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.1);
                poseStack.m_85841_(0.8f, 0.8f, 0.8f);
                Minecraft.m_91087_().m_91289_().renderSingleBlock(state, poseStack, getter, packedLight, OverlayTexture.m_118093_((int)anim, (int)10), (IModelData)EmptyModelData.INSTANCE);
                poseStack.m_85849_();
                continue;
            }
            if (part.isMatch(level, worldPos)) continue;
            invalidBlocks.add(pos);
        }
        RenderUtils.endBatch(getter);
        if (!invalidBlocks.isEmpty()) {
            for (BlockPos pos : invalidBlocks) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(outlineType), poseStack);
                double invalidAnim = Math.sin((double)((float)TimeKeeper.getClientTick() + partialTicks) / 25.0 * 3.141593);
                invalidAnim = Math.max(0.1, Math.abs(invalidAnim));
                Cuboid6 box = new Cuboid6().expand(invalidAnim / 2.0);
                codechicken.lib.render.RenderUtils.bufferCuboidOutline((VertexConsumer)builder, (Cuboid6)box, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                poseStack.m_85849_();
            }
        }
    }
}

