/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.render;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.TextureAtlasHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class CustomSpriteUploader
extends TextureAtlasHolder {
    private final String prefix;
    private final Map<ResourceLocation, Consumer<TextureAtlasSprite>> registeredSprites;
    private Runnable reloadListener = null;

    public CustomSpriteUploader(Map<ResourceLocation, Consumer<TextureAtlasSprite>> registeredSprites, ResourceLocation atlasLocation, String prefix) {
        super(Minecraft.m_91087_().f_90987_, atlasLocation, prefix);
        this.prefix = prefix;
        this.registeredSprites = registeredSprites;
        ReloadableResourceManager resourceManager = (ReloadableResourceManager)Minecraft.m_91087_().m_91098_();
        resourceManager.m_7217_((PreparableReloadListener)this);
    }

    public CustomSpriteUploader(Map<ResourceLocation, Consumer<TextureAtlasSprite>> registeredSprites, ResourceLocation atlasLocation) {
        this(registeredSprites, atlasLocation, null);
    }

    protected Stream<ResourceLocation> m_7535_() {
        return this.registeredSprites.keySet().stream();
    }

    public ResourceLocation m_118906_(ResourceLocation location) {
        if (this.prefix != null) {
            return new ResourceLocation(location.m_135827_(), this.prefix + "/" + location.m_135815_());
        }
        return location;
    }

    public TextureAtlasSprite m_118901_(ResourceLocation locationIn) {
        return super.m_118901_(locationIn);
    }

    protected void m_5787_(TextureAtlas.Preparations preparations, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        super.m_5787_(preparations, resourceManager, profilerFiller);
        this.registeredSprites.entrySet().stream().filter(Objects::nonNull).filter(e -> e.getValue() != null).forEach(e -> ((Consumer)e.getValue()).accept(this.m_118901_((ResourceLocation)e.getKey())));
        if (this.reloadListener != null) {
            this.reloadListener.run();
        }
    }

    public void addReloadListener(Runnable reloadListener) {
        this.reloadListener = this.reloadListener == null ? reloadListener : () -> {
            this.reloadListener.run();
            reloadListener.run();
        };
    }
}

