/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.hud;

import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.api.math.Vector2;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.client.hud.HudData;
import com.brandon3055.brandonscore.client.hud.HudDataElement;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.covers1624.quack.util.CrashLock;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;

public class HudManager {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    private static IForgeRegistry<AbstractHudElement> HUD_REGISTRY;
    protected static Map<ResourceLocation, AbstractHudElement> hudElements;

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(HudManager::onDrawOverlayPre);
        MinecraftForge.EVENT_BUS.addListener(HudManager::onDrawOverlayPost);
        MinecraftForge.EVENT_BUS.addListener(HudManager::onClientTick);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(HudManager::createRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(HudManager::onLoadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(AbstractHudElement.class, HudManager::registerBuiltIn);
    }

    public static void onDrawOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (event.isCanceled()) {
            return;
        }
        PoseStack stack = event.getMatrixStack();
        boolean configuring = Minecraft.m_91087_().f_91080_ instanceof HudConfigGui;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (AbstractHudElement element : hudElements.values()) {
            if (!element.shouldRender(event.getType(), true)) continue;
            stack.m_85836_();
            element.render(stack, event.getPartialTicks(), configuring);
            stack.m_85849_();
        }
    }

    public static void onDrawOverlayPost(RenderGameOverlayEvent.Post event) {
        if (event.isCanceled()) {
            return;
        }
        PoseStack stack = event.getMatrixStack();
        boolean configuring = Minecraft.m_91087_().f_91080_ instanceof HudConfigGui;
        for (AbstractHudElement element : hudElements.values()) {
            if (!element.shouldRender(event.getType(), false)) continue;
            stack.m_85836_();
            element.render(stack, event.getPartialTicks(), configuring);
            stack.m_85849_();
        }
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        boolean configuring = Minecraft.m_91087_().f_91080_ instanceof HudConfigGui;
        for (AbstractHudElement element : hudElements.values()) {
            element.tick(configuring);
        }
        HudData.clientTick();
    }

    private static void createRegistry(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(new ResourceLocation("brandonscore", "hud_elements")).setType((Class)SneakyUtils.unsafeCast(AbstractHudElement.class)).disableSaving().disableSync(), ts -> {
            HUD_REGISTRY = ts;
        });
    }

    private static void onLoadComplete(FMLLoadCompleteEvent event) {
        hudElements.clear();
        for (ResourceLocation key : HUD_REGISTRY.getKeys()) {
            hudElements.put(key, (AbstractHudElement)HUD_REGISTRY.getValue(key));
        }
        HudData.loadSettings();
    }

    public static void registerBuiltIn(RegistryEvent.Register<AbstractHudElement> event) {
        event.getRegistry().register((IForgeRegistryEntry)((AbstractHudElement)new HudDataElement(new Vector2(0.0, 0.20494), true, false).setEnabled(false).setRegistryName("item_hud")));
        event.getRegistry().register((IForgeRegistryEntry)((AbstractHudElement)new HudDataElement(new Vector2(0.0, 0.04593), false, true).setEnabled(false).setRegistryName("block_hud")));
        event.getRegistry().register((IForgeRegistryEntry)((AbstractHudElement)new HudDataElement(new Vector2(0.99023, 0.72438), true, true).setRegistryName("block_item_hud")));
    }

    public static Map<ResourceLocation, AbstractHudElement> getHudElements() {
        return ImmutableMap.copyOf(hudElements);
    }

    @Nullable
    public static AbstractHudElement getHudElement(ResourceLocation key) {
        return hudElements.get(key);
    }

    static {
        hudElements = new HashMap<ResourceLocation, AbstractHudElement>();
    }
}

