/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.templates;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.IGuiParentElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEnergyBar;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiManipulable;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.inventory.SlotMover;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;

public class TGuiBase
implements IGuiTemplate {
    private boolean isInitialized = false;
    public GuiElement<?> background;
    public GuiLabel title;
    public GuiElement<?> playerSlots;
    public GuiEnergyBar energyBar;
    public GuiElement<?> powerSlot;
    public boolean makeDraggable = true;
    public int dragZoneHeight = 20;
    protected Screen gui;
    protected GuiToolkit<?> toolkit;
    protected ContainerSlotLayout slotLayout;
    protected GuiManipulable draggable;
    public LinkedList<GuiElement<?>> dynamicButtons = new LinkedList();
    public Consumer<List<GuiElement<?>>> buttonPlacer = this::positionDynamicButtons;
    public GuiButton themeButton;
    public GuiToolkit.InfoPanel infoPanel;
    private Consumer<LinkedList<GuiElement<?>>> buttonListListener;

    public TGuiBase(Screen gui) {
        this.gui = gui;
    }

    public TGuiBase(Screen gui, ContainerSlotLayout slotLayout) {
        this.slotLayout = slotLayout;
    }

    @Override
    public void addElements(IGuiParentElement<?> parent, GuiToolkit<?> toolkit) {
        this.toolkit = toolkit;
        if (this.background == null) {
            this.background = toolkit.createBackground(true);
        }
        if (parent.hasChild(this.background)) {
            parent.removeChild(this.background);
        }
        if (this.makeDraggable) {
            this.draggable = new GuiManipulable();
            parent.addChild(this.draggable);
            this.draggable.addChild(this.background);
            this.draggable.bindPosition(this.background);
            this.draggable.setSizeModifiers(() -> this.background.xSize(), () -> this.background.ySize());
            this.draggable.setDragBarHeight(this.dragZoneHeight);
            toolkit.jeiExclude(this.draggable);
        } else {
            parent.addChild(this.background);
        }
        this.title = toolkit.createHeading(this.getTitle(), this.background, true);
        this.addDynamicButtons(this.dynamicButtons);
        if (this.buttonListListener != null) {
            this.buttonListListener.accept(this.dynamicButtons);
        }
        if (this.buttonPlacer != null) {
            this.buttonPlacer.accept(this.dynamicButtons);
        }
        this.isInitialized = true;
    }

    public void addDynamicButtons(List<GuiElement<?>> dynamicButtons) {
        this.themeButton = this.toolkit.createThemeButton(this.background);
        dynamicButtons.add(this.themeButton);
        Object panelPosition = new GuiElement().setSize(12, 12);
        this.background.addChild(panelPosition);
        this.infoPanel = this.toolkit.createInfoPanel(this.background, false);
        this.background.removeChild(this.infoPanel);
        ((GuiElement)panelPosition).addChild((GuiToolkit.InfoPanel)this.infoPanel);
        this.infoPanel.setOrigin(() -> new Point(panelPosition.xPos(), panelPosition.yPos()));
        this.infoPanel.setEnabled(false);
        ((GuiElement)panelPosition).setEnabledCallback(() -> this.infoPanel.isEnabled());
        dynamicButtons.add((GuiElement<?>)panelPosition);
    }

    public void dynamicButtonPrePosition(Consumer<LinkedList<GuiElement<?>>> buttonListListener) {
        if (this.isInitialized) {
            throw new IllegalStateException("dynamicButtonPrePosition must be called before template is loaded with toolkit.loadTemplate");
        }
        this.buttonListListener = buttonListListener;
    }

    public void positionDynamicButtons(List<GuiElement<?>> dynamicButtons) {
        int i = 0;
        while (i < dynamicButtons.size()) {
            GuiElement<?> button = dynamicButtons.get(i);
            button.setXPos(this.background.maxXPos() - 15);
            int finalI = i++;
            button.setYPosMod(() -> {
                int index;
                for (index = finalI - 1; index >= 0 && !((GuiElement)dynamicButtons.get(index)).isEnabled(); --index) {
                }
                return index < 0 ? this.background.yPos() + 3 : ((GuiElement)dynamicButtons.get(index)).maxYPos() + 1;
            });
        }
    }

    public void setButtonPlacer(Consumer<List<GuiElement<?>>> buttonPlacer) {
        this.buttonPlacer = buttonPlacer;
    }

    public void addPlayerSlots() {
        this.addPlayerSlots(true, false, false);
    }

    public void addPlayerSlots(boolean title, boolean armor, boolean offHand) {
        if (this.playerSlots != null && this.playerSlots.getParent() != null) {
            this.playerSlots.getParent().removeChild(this.playerSlots);
        }
        this.playerSlots = this.toolkit.createPlayerSlots(this.background, title, armor, offHand);
        this.toolkit.placeInside(this.playerSlots, this.background, GuiToolkit.LayoutPos.BOTTOM_CENTER, 0, -7);
    }

    public void addEnergyBar(IOPStorage opStorage, boolean inventoryAligned) {
        this.checkInit();
        this.energyBar = this.toolkit.createEnergyBar(this.background, opStorage);
        if (inventoryAligned) {
            this.energyBar.setPos(this.playerSlots.xPos(), this.background.yPos() + 6);
        } else {
            this.energyBar.setPos(this.background.xPos() + 6, this.background.yPos() + 6);
        }
        ((GuiEnergyBar)this.energyBar.setXSize(14)).setMaxYPos(this.playerSlots.yPos() - 4, true);
    }

    public void addEnergyBar(IOPStorage opStorage) {
        this.addEnergyBar(opStorage, !this.toolkit.getLayout().isWide());
    }

    @Deprecated
    public void addEnergyItemSlot(@Nullable ManagedBool chargeItem, boolean bellowBar, SlotMover slotMover) {
        if (this.energyBar == null) {
            throw new RuntimeException("Must call addEnergyBar before you can add an energy item slot!");
        }
        this.powerSlot = GuiTexture.newSlot();
        this.background.addChild(this.powerSlot);
        GuiTexture bgTexture = (GuiTexture)new GuiTexture(16, 16, BCGuiSprites.get("slot_energy")).setPos(1, 1);
        this.powerSlot.addChild(bgTexture);
        if (slotMover != null) {
            this.powerSlot.addPosChangeListener((x, y) -> slotMover.setPos(x + 1 - this.toolkit.guiLeft(), y + 1 - this.toolkit.guiTop()));
        }
        GuiButton powerToggle = new GuiButton();
        powerToggle.setFillColours(0, 0x4000FF00);
        if (chargeItem != null) {
            powerToggle.onPressed(chargeItem::invert);
        }
        powerToggle.setSize(14, 14);
        powerToggle.setHoverText(element -> I18n.m_118938_((String)("gui.bc." + (chargeItem.get() ? "charging" : "discharging") + "_item.txt"), (Object[])new Object[0]));
        GuiTexture toggleTex = new GuiTexture(14, 14, BCGuiSprites.get(bellowBar ? "vertical_discharge" : "right_discharge"));
        toggleTex.setPos(powerToggle);
        if (bellowBar) {
            this.energyBar.translate(2, 0);
            toggleTex.setSize(12, 10);
            powerToggle.setSize(12, 10);
            this.powerSlot.setPos(this.energyBar.xPos() - 2, this.playerSlots.yPos() - this.powerSlot.ySize() - 6);
        } else {
            this.powerSlot.setPos(this.energyBar.maxXPos() + 2, this.energyBar.maxYPos() - this.powerSlot.ySize());
        }
        if (chargeItem != null) {
            toggleTex.setMaterialSupplier(() -> BCGuiSprites.get(!chargeItem.get() ? (bellowBar ? "btn_vertical_discharge" : "btn_right_discharge") : (bellowBar ? "btn_vertical_charge" : "btn_right_charge")));
            powerToggle.addChild(toggleTex);
            if (bellowBar) {
                powerToggle.setPos(this.powerSlot.xPos() + 3, this.powerSlot.yPos() - toggleTex.ySize() - 1);
                this.energyBar.setMaxYPos(toggleTex.yPos() - 1, true);
            } else {
                powerToggle.setPos(this.powerSlot.xPos() + 2, this.powerSlot.yPos() - powerToggle.ySize() - 2);
            }
            this.background.addChild(powerToggle);
        }
    }

    @Deprecated
    public void addEnergyItemSlot(@Nullable ManagedBool chargeItem, boolean bellowBar) {
        this.addEnergyItemSlot(chargeItem, bellowBar, null);
    }

    @Deprecated
    public void addEnergyItemSlot(@Nullable ManagedBool chargeItem, SlotMover slotMover) {
        this.addEnergyItemSlot(chargeItem, this.toolkit.getLayout().isTall());
    }

    @Deprecated
    public void addEnergyItemSlot(@Nullable ManagedBool chargeItem) {
        this.addEnergyItemSlot(chargeItem, null);
    }

    public void addEnergyItemSlot(boolean chargeItem, boolean bellowBar, SlotMover slotMover) {
        if (this.energyBar == null) {
            throw new RuntimeException("Must call addEnergyBar before you can add an energy item slot!");
        }
        this.powerSlot = GuiTexture.newSlot();
        this.background.addChild(this.powerSlot);
        GuiTexture bgTexture = (GuiTexture)new GuiTexture(16, 16, BCGuiSprites.get("slots/energy")).setPos(1, 1);
        this.powerSlot.addChild(bgTexture);
        if (slotMover != null) {
            bgTexture.setEnabledCallback(() -> !slotMover.slot.m_6657_());
            this.powerSlot.addPosChangeListener((x, y) -> slotMover.setPos(x + 1 - this.toolkit.guiLeft(), y + 1 - this.toolkit.guiTop()));
        }
        GuiTexture toggleTex = new GuiTexture(14, 14, BCGuiSprites.get("item_charge/" + (bellowBar ? "vertical" : "right") + "_" + (chargeItem ? "charge" : "discharge")));
        if (bellowBar) {
            this.energyBar.translate(2, 0);
            toggleTex.setSize(12, 10);
            this.powerSlot.setPos(this.energyBar.xPos() - 2, this.playerSlots.yPos() - this.powerSlot.ySize() - 2);
            toggleTex.setPos(this.powerSlot.xPos() + 3, this.powerSlot.yPos() - toggleTex.ySize() - 1);
            this.energyBar.setMaxYPos(toggleTex.yPos() - 1, true);
        } else {
            this.powerSlot.setPos(this.energyBar.maxXPos() + 2, this.energyBar.maxYPos() - this.powerSlot.ySize());
            if (chargeItem) {
                toggleTex.setPos(this.powerSlot.xPos(), this.powerSlot.yPos() - toggleTex.ySize() - 2);
            } else {
                toggleTex.setPos(this.powerSlot.xPos() + 1, this.powerSlot.yPos() - toggleTex.ySize());
            }
        }
        this.powerSlot.addChild(toggleTex);
    }

    public void addEnergyItemSlot(boolean chargeItem, boolean bellowBar) {
        this.addEnergyItemSlot(chargeItem, bellowBar, null);
    }

    public void addEnergyItemSlot(boolean chargeItem) {
        this.addEnergyItemSlot(chargeItem, null);
    }

    public void addEnergyItemSlot(boolean chargeItem, SlotMover slotMover) {
        this.addEnergyItemSlot(chargeItem, this.toolkit.getLayout().isTall(), slotMover);
    }

    private boolean checkInit() {
        if (!this.isInitialized) {
            LogHelperBC.bigError("Machine template must be initialized before applying any other operations.", new Object[0]);
        }
        return this.isInitialized;
    }

    public String getTitle() {
        return this.gui.m_96636_().getString();
    }
}

