/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.TextComponent;

public class LinkElement
extends MDElementBase<LinkElement> {
    private MDElementContainer container;
    private String linkTarget;
    public String altText = "";
    public Style linkStyle = Style.TEXT;
    public boolean shadow = false;
    private String displayText = "";
    public Supplier<Integer> defaultColour = null;

    public LinkElement(MDElementContainer container, String linkTarget) {
        this.container = container;
        this.linkTarget = linkTarget;
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        String string = this.displayText = this.altText.isEmpty() ? this.linkTarget : this.altText;
        if (layout.getWidth() < 10) {
            return;
        }
        int avalibleTextWidth = layout.getWidth() - this.leftPad - this.rightPad;
        List<String> wrappedText = BCFontRenderer.listFormattedStringToWidth(this.displayText, avalibleTextWidth);
        int textWidth = 0;
        for (String text : wrappedText) {
            textWidth = Math.max(textWidth, this.fontRenderer.m_92895_(text));
        }
        int textHeight = this.fontRenderer.m_92920_(this.displayText, avalibleTextWidth);
        this.setSize(textWidth + this.leftPad + this.rightPad, textHeight + this.topPad + this.bottomPad);
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        boolean isMouseOver = this.isMouseOver(mouseX, mouseY);
        int colour = this.hasColour || this.hasColourHover && isMouseOver ? this.getColour(isMouseOver) : this.defaultColour.get().intValue();
        int colourBorder = this.hasColourBorder || this.hasColourBorderHover && isMouseOver ? this.getColourBorder(isMouseOver) : colour;
        int drawX = this.xPos() + this.leftPad;
        int drawWidth = this.xSize() - this.leftPad - this.rightPad;
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.container.linkDisplayTarget != null) {
                GuiElement e = this.container.linkDisplayTarget;
                int width = this.fontRenderer.m_92895_(this.linkTarget);
                int height = this.fontRenderer.m_92920_(this.linkTarget, e.xSize()) + 4;
                this.zOffset += (double)this.container.linkDisplayZOffset;
                this.drawColouredRect(e.xPos(), e.maxYPos() - height, Math.min(Math.max(width + 4, e.xSize() / 2), e.xSize()), height, -1879048192);
                this.drawSplitString(this.fontRenderer, this.linkTarget, e.xPos() + 2, e.maxYPos() - height + 2, e.xSize(), 0xC0C0C0, false);
                this.zOffset -= (double)this.container.linkDisplayZOffset;
            }
            if (this.enableTooltip && !this.tooltip.isEmpty()) {
                PoseStack poseStack = new PoseStack();
                poseStack.m_85837_(0.0, 0.0, (double)this.getRenderZLevel());
                this.renderTooltip(poseStack, this.tooltip.stream().map(TextComponent::new).collect(Collectors.toList()), mouseX, mouseY);
            }
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.container.handleLinkClick(this.linkTarget, mouseButton);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public static enum Style {
        TEXT,
        SOLID,
        VANILLA;

    }
}

