/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.lib.DLRSCache;
import com.brandon3055.brandonscore.lib.DLResourceLocation;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ImageElement
extends MDElementBase<ImageElement> {
    private static final Random rand = new Random();
    private static final List<Block> LOADING_BLOCKS = Lists.newArrayList((Object[])new Block[]{Blocks.f_50069_, Blocks.f_49992_, Blocks.f_50034_, Blocks.f_50652_, Blocks.f_49999_, Blocks.f_50058_, Blocks.f_50195_, Blocks.f_50087_, Blocks.f_50201_, Blocks.f_50091_, Blocks.f_50322_, Blocks.f_50273_, Blocks.f_50078_, Blocks.f_50089_, Blocks.f_50080_, Blocks.f_50493_, Blocks.f_50061_, Blocks.f_50094_, Blocks.f_50335_});
    private ItemStack renderLoadingStack = ItemStack.f_41583_;
    private int loadingTime = 0;
    private int maxLoadTime = 10;
    private boolean downloading = false;
    private DLResourceLocation resourceLocation;
    private MDElementContainer container;
    private RenderType imageType;
    private String imageURL;
    public String linkTo = "";

    public ImageElement(MDElementContainer container, String imageURL) {
        this.container = container;
        this.imageURL = imageURL;
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        this.resourceLocation = DLRSCache.getResource(this.imageURL);
        int w = 0;
        int h = 0;
        if (!this.resourceLocation.dlFinished || this.resourceLocation.dlFailed) {
            w = 76;
            h = 76;
            this.downloading = true;
        } else {
            this.imageType = GuiHelper.guiTextureType(this.resourceLocation);
            if (this.width == -1 && this.height == -1) {
                this.width = 32;
            }
            if (this.width != -1) {
                int n = w = this.screenRelativeSize ? (int)(MathHelper.clip((double)((double)this.width / 100.0), (double)0.0, (double)1.0) * (double)layout.getWidth()) : MathHelper.clip((int)this.width, (int)8, (int)layout.getWidth());
                if (this.height == -1) {
                    h = this.resourceLocation.sizeSet ? (int)((double)this.resourceLocation.height / (double)this.resourceLocation.width * (double)w) : w;
                }
            }
            if (this.height != -1) {
                h = this.height;
                if (this.width == -1) {
                    w = this.resourceLocation.sizeSet ? (int)((double)this.resourceLocation.width / (double)this.resourceLocation.height * (double)this.height) : this.height;
                }
            }
        }
        this.setSize(w, h);
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.downloading || this.resourceLocation.dlFailed) {
            this.renderDownloading(partialTicks);
        } else if (this.imageType != null) {
            ResourceHelperBC.bindTexture(this.resourceLocation);
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            if (this.hasColourBorder) {
                this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 0xFF000000 | this.getColourBorder(mouseOver));
            } else if (this.hasColourBorderHover && mouseOver) {
                this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 0xFF000000 | this.colourBorderHover);
            }
            int w = this.xSize() - this.rightPad - this.leftPad;
            int h = this.ySize() - this.bottomPad - this.topPad;
            MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
            GuiHelper.drawTexture(getter.m_6299_(this.imageType), this.xPos() + this.leftPad, this.yPos() + this.topPad, w, h);
            RenderUtils.endBatch((MultiBufferSource)getter);
        }
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    private void renderDownloading(float partialTicks) {
        MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
        boolean failed = this.resourceLocation.dlFailed;
        Material mat = failed ? BCGuiSprites.get("download_failed") : BCGuiSprites.get("downloading");
        float failTicks = failed ? 0.0f : partialTicks;
        float anim = MathHelper.clip((float)(((float)this.loadingTime + failTicks) / (float)this.maxLoadTime), (float)0.0f, (float)1.0f);
        this.drawBorderedRect((MultiBufferSource)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, 0, failed ? -65536 : -16711936);
        if (failed) {
            GuiHelper.drawSprite(BCGuiSprites.builder((MultiBufferSource)getter), this.xPos(), this.yPos(), this.xSize(), this.ySize(), mat.m_119204_());
        } else {
            GuiHelper.drawPartialSprite(BCGuiSprites.builder((MultiBufferSource)getter), this.xPos(), this.yPos(), this.xSize(), (float)this.ySize() * anim, mat.m_119204_(), 0.0, 0.0, 1.0, anim);
        }
        RenderUtils.endBatch((MultiBufferSource)getter);
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (!this.linkTo.isEmpty() && this.container.linkDisplayTarget != null) {
                GuiElement e = this.container.linkDisplayTarget;
                int width = this.fontRenderer.m_92895_(this.linkTo);
                int height = this.fontRenderer.m_92920_(this.linkTo, e.xSize()) + 4;
                this.zOffset += (double)this.container.linkDisplayZOffset;
                this.drawColouredRect(e.xPos(), e.maxYPos() - height, Math.min(Math.max(width + 4, e.xSize() / 2), e.xSize()), height, -1879048192);
                this.drawSplitString(this.fontRenderer, this.linkTo, e.xPos() + 2, e.maxYPos() - height + 2, e.xSize(), 0xC0C0C0, false);
                this.zOffset -= (double)this.container.linkDisplayZOffset;
            }
            ArrayList<CallSite> tooltip = new ArrayList<CallSite>();
            if (this.resourceLocation.dlFailed) {
                tooltip.add((CallSite)((Object)(ChatFormatting.RED + I18n.m_118938_((String)"gui.bc.downloading_image_failed.info", (Object[])new Object[0]))));
            } else if (!this.resourceLocation.dlFinished) {
                tooltip.add((CallSite)((Object)(ChatFormatting.GREEN + I18n.m_118938_((String)"gui.bc.downloading_image.info", (Object[])new Object[0]))));
            }
            if (this.enableTooltip && !this.tooltip.isEmpty()) {
                tooltip.addAll(this.tooltip);
            }
            if (!tooltip.isEmpty()) {
                PoseStack poseStack = new PoseStack();
                poseStack.m_85837_(0.0, 0.0, (double)this.getRenderZLevel());
                this.renderTooltip(poseStack, tooltip.stream().map(TextComponent::new).collect(Collectors.toList()), mouseX, mouseY);
                return true;
            }
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (mouseButton == 0 && Screen.m_96638_()) {
                DLRSCache.clearFileCache(this.imageURL);
                this.loadingTime = 0;
                this.container.layoutMarkdownElements();
                return true;
            }
            if (mouseButton != 1 && !this.linkTo.isEmpty()) {
                this.container.handleLinkClick(this.linkTo, mouseButton);
                return true;
            }
            if (mouseButton == 1) {
                this.container.handleLinkClick(this.imageURL, mouseButton);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean onUpdate() {
        if (this.resourceLocation != null && this.downloading) {
            if (this.resourceLocation.dlFailed) {
                this.downloading = false;
                this.container.getTopLevelContainer().layoutMarkdownElements();
                return true;
            }
            if (this.loadingTime++ > this.maxLoadTime) {
                this.loadingTime = 0;
                if (this.resourceLocation.dlFinished || this.resourceLocation.dlFailed) {
                    this.container.getTopLevelContainer().layoutMarkdownElements();
                    this.downloading = false;
                    return true;
                }
            }
        }
        return super.onUpdate();
    }
}

