/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.lib.StringyStacks;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityElement
extends MDElementBase<EntityElement> {
    private static final Logger LOGGER = LogManager.getLogger(EntityElement.class);
    private static Map<String, Entity> renderEntityCache = new HashMap<String, Entity>();
    public int xOffset = 0;
    public int yOffset = 0;
    public double rotateSpeed = 0.0;
    public double rotation = 0.0;
    public double drawScale = 1.0;
    public boolean animate = false;
    public boolean trackMouse = false;
    public boolean drawName = false;
    public String mainHand = "";
    public String offHand = "";
    public String head = "";
    public String chest = "";
    public String legs = "";
    public String boots = "";
    private Entity renderEntity = null;
    private String entityName;
    private boolean errored = false;
    boolean animateBroken = false;
    int animTick = 0;

    public EntityElement(String entityName) {
        this.entityName = entityName;
        this.size = 64;
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        this.setSize(this.size, this.size);
        try {
            this.renderEntity = this.getRenderEntity(this.mc.f_91073_, this.entityName, EquipmentHelper.create(this));
        }
        catch (IllegalArgumentException e) {
            this.error("[Broken Entity. " + e.getMessage() + "]");
        }
        if (this.trackMouse && !(this.renderEntity instanceof LivingEntity)) {
            this.error("[Broken Entity. track_mouse is only supported with living entities]");
        }
        if (this.drawName && !(this.renderEntity instanceof Player)) {
            this.error("[Broken Entity. draw_name is only supported by player's]");
        }
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.errored || this.renderEntity == null) {
            return;
        }
        int xPos = this.xPos() + this.xOffset;
        int yPos = this.yPos() + this.yOffset;
        int scale = (int)((double)((float)this.size / Math.max(this.renderEntity.m_20206_(), this.renderEntity.m_20205_())) * this.drawScale);
        double posX = (double)xPos + (double)this.size / 2.0;
        double entityRotation = this.rotation + (double)((float)BCClientEventHandler.elapsedTicks + partialTicks) * this.rotateSpeed;
        this.renderEntity.f_19797_ = BCClientEventHandler.elapsedTicks;
        double zLevel = 25.0f + this.getRenderZLevel() + (float)scale;
        try {
            if (this.renderEntity instanceof LivingEntity) {
                int n = (int)((this.renderEntity.m_20206_() - this.renderEntity.m_20192_()) * (float)scale);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Something went wrong while attempting to render an entity on the screen!");
            LOGGER.error("Entity: " + this.renderEntity);
            e.printStackTrace();
            this.errored = true;
        }
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (!this.tooltip.isEmpty() && !this.errored && this.renderEntity != null) {
            double ar = this.renderEntity.m_20206_() / this.renderEntity.m_20205_();
            double width = (double)this.size * this.drawScale;
            double height = (double)this.size * this.drawScale;
            if (ar > 1.0) {
                width *= (double)(this.renderEntity.m_20205_() / this.renderEntity.m_20206_());
            } else {
                height *= ar;
            }
            int x = (int)((double)(this.xPos() + this.xOffset) + ((double)this.xSize() - width) / 2.0);
            int y = (int)((double)this.yPos() + ((double)this.ySize() - height) + (double)this.yOffset);
            if (GuiHelperOld.isInRect(x, y, (int)width, (int)height, mouseX, mouseY)) {
                PoseStack poseStack = new PoseStack();
                poseStack.m_85837_(0.0, 0.0, (double)this.getRenderZLevel());
                this.renderTooltip(poseStack, this.tooltip.stream().map(TextComponent::new).collect(Collectors.toList()), mouseX, mouseY);
                return true;
            }
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public static void renderEntityOnScreen(int xPos, int yPos, int scale, float mouseX, float mouseY, LivingEntity entity, double rotation, boolean trackMouse, boolean drawName) {
    }

    public Entity getRenderEntity(ClientLevel world, String entityString, EquipmentHelper helper) {
        EntityType type;
        String ident = String.format("%s|mh:%s|oh:%s|h:%s|ch:%s|le:%s|bo:%s", entityString, this.mainHand, this.offHand, this.head, this.chest, this.legs, this.boots);
        if (renderEntityCache.containsKey(ident) && !this.animate) {
            return renderEntityCache.get(ident);
        }
        if (!entityString.contains(":")) {
            throw new IllegalArgumentException("Invalid entity string! Must be ether modid:entityName or player:username");
        }
        Entity entity = null;
        if (!entityString.startsWith("player:") && (type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityString))) != null) {
            entity = type.m_20615_((Level)world);
        }
        if (entity == null) {
            throw new IllegalArgumentException("No matching entity found for string: " + entityString);
        }
        if (entity instanceof LivingEntity && helper.hasEquipment) {
            helper.apply((LivingEntity)entity);
        } else if (helper.hasEquipment) {
            throw new IllegalArgumentException("The specified entity does not allow equipment!");
        }
        if (!this.animate) {
            renderEntityCache.put(ident, entity);
        }
        return entity;
    }

    @Override
    public boolean onUpdate() {
        if (this.animate && this.renderEntity != null && !this.errored && !this.animateBroken && this.animTick != BCClientEventHandler.elapsedTicks) {
            try {
                this.renderEntity.f_19797_ = this.animTick;
                this.animTick = BCClientEventHandler.elapsedTicks;
                this.renderEntity.m_8119_();
            }
            catch (Throwable e) {
                this.animateBroken = true;
            }
        }
        return super.onUpdate();
    }

    static class EquipmentHelper {
        private ItemStack mainHand = ItemStack.f_41583_;
        private ItemStack offHand = ItemStack.f_41583_;
        private ItemStack head = ItemStack.f_41583_;
        private ItemStack chest = ItemStack.f_41583_;
        private ItemStack legs = ItemStack.f_41583_;
        private ItemStack boots = ItemStack.f_41583_;
        public boolean hasEquipment = false;

        EquipmentHelper() {
        }

        public void apply(LivingEntity entity) {
            if (!this.mainHand.m_41619_()) {
                entity.m_21008_(InteractionHand.MAIN_HAND, this.mainHand);
            }
            if (!this.offHand.m_41619_()) {
                entity.m_21008_(InteractionHand.OFF_HAND, this.offHand);
            }
            if (!this.head.m_41619_()) {
                entity.m_8061_(EquipmentSlot.HEAD, this.head);
            }
            if (!this.chest.m_41619_()) {
                entity.m_8061_(EquipmentSlot.CHEST, this.chest);
            }
            if (!this.legs.m_41619_()) {
                entity.m_8061_(EquipmentSlot.LEGS, this.legs);
            }
            if (!this.boots.m_41619_()) {
                entity.m_8061_(EquipmentSlot.FEET, this.boots);
            }
        }

        public static EquipmentHelper create(EntityElement element) {
            EquipmentHelper helper = new EquipmentHelper();
            try {
                if (!element.mainHand.isEmpty()) {
                    helper.mainHand = StringyStacks.fromString(element.mainHand);
                    if (helper.mainHand.m_41619_()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.mainHand);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
                if (!element.offHand.isEmpty()) {
                    helper.offHand = StringyStacks.fromString(element.offHand);
                    if (helper.offHand.m_41619_()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.offHand);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
                if (!element.head.isEmpty()) {
                    helper.head = StringyStacks.fromString(element.head);
                    if (helper.head.m_41619_()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.head);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
                if (!element.chest.isEmpty()) {
                    helper.chest = StringyStacks.fromString(element.chest);
                    if (helper.chest.m_41619_()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.chest);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
                if (!element.legs.isEmpty()) {
                    helper.legs = StringyStacks.fromString(element.legs);
                    if (helper.legs.m_41619_()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.legs);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
                if (!element.boots.isEmpty()) {
                    helper.boots = StringyStacks.fromString(element.boots);
                    if (helper.boots.m_41619_()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.boots);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.warn("[Entity Element] An error occurred while parsing stack string.");
                e.printStackTrace();
            }
            return helper;
        }
    }
}

