/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;

public class MarkdownTextRenderer {
    private static Vector3f SHADOW_OFFSET = new Vector3f(0.0f, 0.0f, 0.03f);
    private Style activeStyle = Style.f_131099_;
    private GuiElement<?> guiElement;
    private Font fontRenderer;

    public MarkdownTextRenderer(GuiElement<?> guiElement, Font fontRenderer) {
        this.guiElement = guiElement;
        this.fontRenderer = fontRenderer;
    }

    public int drawFormattedString(String text, float x, float y, int colour, boolean dropShadow) {
        MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
        PoseStack textStack = new PoseStack();
        textStack.m_85837_(0.0, 0.0, (double)this.guiElement.getRenderZLevel());
        Matrix4f textLocation = textStack.m_85850_().m_85861_();
        float charX = x;
        int texLen = text.length();
        for (int i = 0; i < texLen; ++i) {
            char character = text.charAt(i);
            if (character == '\u00a7') {
                if (i + 1 >= texLen) break;
                char formatChar = text.charAt(i + 1);
                ChatFormatting textformatting = ChatFormatting.m_126645_((char)formatChar);
                if (textformatting != null) {
                    if (textformatting == ChatFormatting.RESET) {
                        this.activeStyle = Style.f_131099_;
                    } else {
                        switch (textformatting) {
                            case OBFUSCATED: {
                                this.activeStyle = this.activeStyle.m_178524_(Boolean.valueOf(!this.activeStyle.m_131176_()));
                                break;
                            }
                            case BOLD: {
                                this.activeStyle = this.activeStyle.m_131136_(Boolean.valueOf(!this.activeStyle.m_131154_()));
                                break;
                            }
                            case STRIKETHROUGH: {
                                this.activeStyle = this.activeStyle.m_178522_(Boolean.valueOf(!this.activeStyle.m_131168_()));
                                break;
                            }
                            case UNDERLINE: {
                                this.activeStyle = this.activeStyle.m_131162_(Boolean.valueOf(!this.activeStyle.m_131171_()));
                                break;
                            }
                            case ITALIC: {
                                this.activeStyle = this.activeStyle.m_131155_(Boolean.valueOf(!this.activeStyle.m_131161_()));
                                break;
                            }
                            default: {
                                TextColor colourFlag = TextColor.m_131270_((ChatFormatting)textformatting);
                                this.activeStyle = colourFlag == null ? this.activeStyle.m_131148_((TextColor)null) : this.activeStyle.m_131148_(this.activeStyle.m_131135_() == colourFlag ? null : colourFlag);
                            }
                        }
                    }
                }
                ++i;
                continue;
            }
            charX = this.drawInternal(String.valueOf(character), charX, y, colour, dropShadow, textLocation, (MultiBufferSource)getter, false, 0, 0xF000F0, this.fontRenderer.m_92718_());
        }
        getter.m_109911_();
        return 0;
    }

    protected static int adjustColor(int colour) {
        return (colour & 0xFC000000) == 0 ? colour | 0xFF000000 : colour;
    }

    protected float drawInternal(String text, float x, float y, int colour, boolean shadow, Matrix4f mat4f, MultiBufferSource getter, boolean boolFalse, int int0, int int1, boolean biDirection) {
        SHADOW_OFFSET = new Vector3f(0.0f, 0.0f, 0.03f);
        if (biDirection) {
            text = this.fontRenderer.m_92801_(text);
        }
        colour = MarkdownTextRenderer.adjustColor(colour);
        Matrix4f matrix4f = mat4f.m_27658_();
        if (shadow) {
            this.renderText(text, x, y, colour, true, mat4f, getter, boolFalse, int0, int1);
            matrix4f.m_27648_(SHADOW_OFFSET);
        }
        x = this.renderText(text, x, y, colour, false, matrix4f, getter, boolFalse, int0, int1);
        return (int)x + (shadow ? 1 : 0);
    }

    protected float renderText(String text, float x, float y, int colour, boolean isShadow, Matrix4f mat4f, MultiBufferSource getter, boolean boolFalse, int int0, int int1) {
        MDCharacterRenderer characterRenderer = new MDCharacterRenderer(getter, x, y, colour, isShadow, mat4f, boolFalse, int1);
        StringDecomposer.m_14346_((String)text, (Style)this.activeStyle, (FormattedCharSink)characterRenderer);
        return characterRenderer.finish(int0, x);
    }

    public void reset() {
        this.activeStyle = Style.f_131099_;
    }

    class MDCharacterRenderer
    implements FormattedCharSink {
        final MultiBufferSource bufferSource;
        private final boolean dropShadow;
        private final float dimFactor;
        private final float r;
        private final float g;
        private final float b;
        private final float a;
        private final Matrix4f pose;
        private final Font.DisplayMode mode;
        private final int packedLightCoords;
        private float x;
        private float y;
        @Nullable
        private List<BakedGlyph.Effect> effects;

        private void addEffect(BakedGlyph.Effect p_238442_1_) {
            if (this.effects == null) {
                this.effects = Lists.newArrayList();
            }
            this.effects.add(p_238442_1_);
        }

        public MDCharacterRenderer(MultiBufferSource p_92953_, float p_92954_, float p_92955_, int p_92956_, boolean p_92957_, Matrix4f p_92958_, boolean p_92959_, int p_92960_) {
            this(p_92953_, p_92954_, p_92955_, p_92956_, p_92957_, p_92958_, p_92959_ ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, p_92960_);
        }

        public MDCharacterRenderer(MultiBufferSource p_181365_, float p_181366_, float p_181367_, int p_181368_, boolean p_181369_, Matrix4f p_181370_, Font.DisplayMode p_181371_, int p_181372_) {
            this.bufferSource = p_181365_;
            this.x = p_181366_;
            this.y = p_181367_;
            this.dropShadow = p_181369_;
            this.dimFactor = p_181369_ ? 0.25f : 1.0f;
            this.r = (float)(p_181368_ >> 16 & 0xFF) / 255.0f * this.dimFactor;
            this.g = (float)(p_181368_ >> 8 & 0xFF) / 255.0f * this.dimFactor;
            this.b = (float)(p_181368_ & 0xFF) / 255.0f * this.dimFactor;
            this.a = (float)(p_181368_ >> 24 & 0xFF) / 255.0f;
            this.pose = p_181370_;
            this.mode = p_181371_;
            this.packedLightCoords = p_181372_;
        }

        private FontSet getFontSet(ResourceLocation p_238419_1_) {
            return (FontSet)MarkdownTextRenderer.this.fontRenderer.f_92713_.apply(p_238419_1_);
        }

        public boolean m_6411_(int p_accept_1_, Style p_accept_2_, int p_accept_3_) {
            float f7;
            float f2;
            float f1;
            float f;
            FontSet font = this.getFontSet(p_accept_2_.m_131192_());
            GlyphInfo iglyph = font.m_95065_(p_accept_3_);
            BakedGlyph texturedglyph = p_accept_2_.m_131176_() && p_accept_3_ != 32 ? font.m_95067_(iglyph) : font.m_95078_(p_accept_3_);
            boolean flag = p_accept_2_.m_131154_();
            float f3 = this.a;
            TextColor color = p_accept_2_.m_131135_();
            if (color != null) {
                int i = color.m_131265_();
                f = (float)(i >> 16 & 0xFF) / 255.0f * this.dimFactor;
                f1 = (float)(i >> 8 & 0xFF) / 255.0f * this.dimFactor;
                f2 = (float)(i & 0xFF) / 255.0f * this.dimFactor;
            } else {
                f = this.r;
                f1 = this.g;
                f2 = this.b;
            }
            if (!(texturedglyph instanceof EmptyGlyph)) {
                float f5 = flag ? iglyph.m_5619_() : 0.0f;
                float f4 = this.dropShadow ? iglyph.m_5645_() : 0.0f;
                VertexConsumer ivertexbuilder = this.bufferSource.m_6299_(texturedglyph.m_181387_(this.mode));
                this.renderChar(texturedglyph, flag, p_accept_2_.m_131161_(), f5, this.x + f4, this.y + f4, this.pose, ivertexbuilder, f, f1, f2, f3, this.packedLightCoords);
            }
            float f6 = iglyph.m_83827_(flag);
            float f4 = f7 = this.dropShadow ? 1.0f : 0.0f;
            if (p_accept_2_.m_131168_()) {
                this.addEffect(new BakedGlyph.Effect(this.x + f7 - 1.0f, this.y + f7 + 4.5f, this.x + f7 + f6, this.y + f7 + 4.5f - 1.0f, 0.01f, f, f1, f2, f3));
            }
            if (p_accept_2_.m_131171_()) {
                this.addEffect(new BakedGlyph.Effect(this.x + f7 - 1.0f, this.y + f7 + 9.0f, this.x + f7 + f6, this.y + f7 + 9.0f - 1.0f, 0.01f, f, f1, f2, f3));
            }
            this.x += f6;
            return true;
        }

        public float finish(int p_238441_1_, float p_238441_2_) {
            if (p_238441_1_ != 0) {
                float f = (float)(p_238441_1_ >> 24 & 0xFF) / 255.0f;
                float f1 = (float)(p_238441_1_ >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(p_238441_1_ >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(p_238441_1_ & 0xFF) / 255.0f;
                this.addEffect(new BakedGlyph.Effect(p_238441_2_ - 1.0f, this.y + 9.0f, this.x + 1.0f, this.y - 1.0f, 0.01f, f1, f2, f3, f));
            }
            if (this.effects != null) {
                BakedGlyph texturedglyph = this.getFontSet(Style.f_131100_).m_95064_();
                VertexConsumer ivertexbuilder = this.bufferSource.m_6299_(texturedglyph.m_181387_(this.mode));
                for (BakedGlyph.Effect texturedglyph$effect : this.effects) {
                    texturedglyph.m_95220_(texturedglyph$effect, this.pose, ivertexbuilder, this.packedLightCoords);
                }
            }
            return this.x;
        }

        private void renderChar(BakedGlyph p_228077_1_, boolean p_228077_2_, boolean p_228077_3_, float p_228077_4_, float p_228077_5_, float p_228077_6_, Matrix4f p_228077_7_, VertexConsumer p_228077_8_, float p_228077_9_, float p_228077_10_, float p_228077_11_, float p_228077_12_, int p_228077_13_) {
            p_228077_1_.m_5626_(p_228077_3_, p_228077_5_, p_228077_6_, p_228077_7_, p_228077_8_, p_228077_9_, p_228077_10_, p_228077_11_, p_228077_12_, p_228077_13_);
            if (p_228077_2_) {
                p_228077_1_.m_5626_(p_228077_3_, p_228077_5_ + p_228077_4_, p_228077_6_, p_228077_7_, p_228077_8_, p_228077_9_, p_228077_10_, p_228077_11_, p_228077_12_, p_228077_13_);
            }
        }
    }
}

