/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import codechicken.lib.render.buffer.TransformingVertexConsumer;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.Material;

public class GuiTexture
extends GuiElement<GuiTexture> {
    public int texU;
    public int texV;
    public int textSheetSizeX = 256;
    public int textSheetSizeY = 256;
    private int texUSize = 0;
    private int texVSize = 0;
    private boolean texSizeOverride = false;
    private Supplier<Integer> texXGetter = null;
    private Supplier<Integer> texYGetter = null;
    private float rotation = 0.0f;
    private boolean flipX = false;
    private boolean flipY = false;
    public Material material;
    public Supplier<Material> materialSupplier;

    public GuiTexture(int xPos, int yPos, int xSize, int ySize, Material material) {
        super(xPos, yPos, xSize, ySize);
        this.material = material;
    }

    public GuiTexture(int xPos, int yPos, int xSize, int ySize, Supplier<Material> materialSupplier) {
        super(xPos, yPos, xSize, ySize);
        this.materialSupplier = materialSupplier;
    }

    public GuiTexture(int xSize, int ySize, Material material) {
        super(0, 0, xSize, ySize);
        this.material = material;
    }

    public GuiTexture(int xSize, int ySize, Supplier<Material> materialSupplier) {
        super(0, 0, xSize, ySize);
        this.materialSupplier = materialSupplier;
    }

    public GuiTexture(Supplier<Material> materialSupplier) {
        super(0, 0);
        this.materialSupplier = materialSupplier;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        Material mat = this.getMaterial();
        if (mat != null) {
            MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
            if (this.rotation != 0.0f || this.flipX || this.flipY) {
                PoseStack mStack = new PoseStack();
                mStack.m_85837_((double)this.xPos(), (double)this.yPos(), 0.0);
                mStack.m_85837_((double)this.xSize() / 2.0, (double)this.ySize() / 2.0, 0.0);
                if (this.flipX || this.flipY) {
                    mStack.m_85841_(this.flipX ? -1.0f : 1.0f, this.flipY ? -1.0f : 1.0f, 1.0f);
                }
                if (this.rotation != 0.0f) {
                    mStack.m_85845_(new Quaternion(0.0f, 0.0f, this.rotation, true));
                }
                mStack.m_85837_(-((double)this.xSize() / 2.0), -((double)this.ySize() / 2.0), 0.0);
                TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(mat.m_119201_(BCGuiSprites::makeType)), mStack);
                this.drawSprite((VertexConsumer)builder, 0.0f, 0.0f, this.xSize(), this.ySize(), mat.m_119204_());
            } else {
                this.drawSprite(getter.m_6299_(mat.m_119201_(BCGuiSprites::makeType)), this.xPos(), this.yPos(), this.xSize(), this.ySize(), mat.m_119204_());
            }
            getter.m_109911_();
        }
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    public GuiTexture setRotation(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiTexture flipX() {
        this.flipX = true;
        return this;
    }

    public GuiTexture flipY() {
        this.flipY = true;
        return this;
    }

    @Deprecated
    public GuiTexture setTexturePos(int textureX, int textureY) {
        this.texU = textureX;
        this.texV = textureY;
        return this;
    }

    public GuiTexture setMaterial(Material material) {
        this.material = material;
        return this;
    }

    public Material getMaterial() {
        return this.materialSupplier == null ? this.material : this.materialSupplier.get();
    }

    public GuiTexture setMaterialSupplier(Supplier<Material> materialSupplier) {
        this.materialSupplier = materialSupplier;
        return this;
    }

    @Deprecated
    public GuiTexture setTexSizeOverride(int texXOverride, int texYOverride) {
        this.texUSize = texXOverride;
        this.texVSize = texYOverride;
        this.texSizeOverride = true;
        return this;
    }

    @Deprecated
    public GuiTexture setTexSheetSize(int textureSizeX, int textureSizeY) {
        this.textSheetSizeX = textureSizeX;
        this.textSheetSizeY = textureSizeY;
        return this;
    }

    @Deprecated
    public GuiTexture setTexSheetSize(int textureSize) {
        return this.setTexSheetSize(textureSize, textureSize);
    }

    @Deprecated
    public GuiTexture setTexXGetter(Supplier<Integer> texXGetter) {
        this.texXGetter = texXGetter;
        return this;
    }

    @Deprecated
    public GuiTexture setTexYGetter(Supplier<Integer> texYGetter) {
        this.texYGetter = texYGetter;
        return this;
    }

    @Deprecated
    public int getTexU() {
        return this.texXGetter == null ? this.texU : this.texXGetter.get();
    }

    @Deprecated
    public int getTexV() {
        return this.texYGetter == null ? this.texV : this.texYGetter.get();
    }

    public static GuiTexture newSlot() {
        return new GuiTexture(18, 18, BCGuiSprites.themedGetter("slot"));
    }

    public static GuiTexture newDynamicTexture(int xSize, int ySize, Supplier<Material> materialSupplier) {
        return (GuiTexture)GuiTexture.newDynamicTexture(materialSupplier).setSize(xSize, ySize);
    }

    public static GuiTexture newDynamicTexture(Supplier<Material> materialSupplier) {
        return (GuiTexture)new GuiTexture(null){

            @Override
            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
                this.drawDynamicSprite(getter.m_6299_(BCGuiSprites.GUI_TYPE), this.getMaterial().m_119204_(), this.xPos(), this.yPos(), this.xSize(), this.ySize(), this.getInsets().top, this.getInsets().left, this.getInsets().bottom, this.getInsets().right);
                getter.m_109911_();
                for (GuiElement element : this.childElements) {
                    if (!element.isEnabled()) continue;
                    element.renderElement(minecraft, mouseX, mouseY, partialTicks);
                }
            }
        }.setMaterialSupplier(materialSupplier).setInsets(4, 4, 4, 4);
    }

    public GuiTexture centerOnParent() {
        if (this.getParent() != null) {
            this.setXPos(this.getParent().xPos() + this.getParent().xSize() / 2 - this.xSize() / 2);
            this.setYPos(this.getParent().yPos() + this.getParent().ySize() / 2 - this.ySize() / 2);
        }
        return this;
    }
}

