/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiColourProvider;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class GuiTextField
extends GuiElement<GuiTextField> {
    private int cursorPos;
    private int maxLength = 32;
    private int displayPos;
    private int highlightPos;
    private boolean focused;
    private boolean isEditable = true;
    private boolean isFocusable = true;
    private boolean shiftPressed;
    private boolean canLoseFocus = true;
    private Consumer<String> changeListener;
    private Consumer<String> returnListener;
    private Consumer<Boolean> focusListener;
    private Runnable onFinishEdit;
    private String _value_ = "";
    private Consumer<String> setValue = s -> {
        this._value_ = s;
    };
    private Supplier<String> getValue = () -> this._value_;
    private Supplier<String> suggestion = null;
    private Supplier<Integer> textColor = () -> 0xE0E0E0;
    private Supplier<Integer> textColorUneditable = () -> 0x707070;
    private Supplier<Boolean> shadow = () -> true;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, FormattedCharSequence> formatter = (string, pos) -> FormattedCharSequence.m_13714_((String)string, (Style)Style.f_131099_);

    public GuiTextField() {
        this.getInsets().left = 4;
    }

    public GuiTextField(String defaultText) {
        this();
        this._setValue(defaultText);
    }

    @Deprecated
    public GuiTextField linkExternalValue(Supplier<String> getValue, Consumer<String> setValue) {
        this.setValue = setValue;
        this.getValue = getValue;
        return this;
    }

    public GuiTextField onValueChanged(Consumer<String> changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public GuiTextField onValueChanged(Runnable changeListener) {
        return this.onValueChanged((String e) -> changeListener.run());
    }

    public GuiTextField onReturnPressed(Consumer<String> returnListener) {
        this.returnListener = returnListener;
        return this;
    }

    public GuiTextField onReturnPressed(Runnable returnListener) {
        return this.onReturnPressed((String e) -> returnListener.run());
    }

    public GuiTextField onFocusChanged(Consumer<Boolean> focusListener) {
        this.focusListener = focusListener;
        return this;
    }

    public GuiTextField setSuggestion(String suggestion) {
        return this.setSuggestion(suggestion == null || suggestion.isEmpty() ? null : () -> suggestion);
    }

    public GuiTextField setSuggestion(@Nullable Supplier<String> suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    public GuiTextField setFilter(Predicate<String> filter) {
        this.filter = filter;
        return this;
    }

    public GuiTextField setFormatter(BiFunction<String, Integer, FormattedCharSequence> formatter) {
        this.formatter = formatter;
        return this;
    }

    public GuiTextField setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
        return this;
    }

    public GuiTextField setTextColor(Supplier<Integer> textColor) {
        this.textColor = textColor;
        return this;
    }

    public GuiTextField setTextColor(int textColor) {
        return this.setTextColor(() -> textColor);
    }

    public GuiTextField setTextColorUneditable(Supplier<Integer> textColorUneditable) {
        this.textColorUneditable = textColorUneditable;
        return this;
    }

    public GuiTextField setTextColorUneditable(int textColorUneditable) {
        return this.setTextColorUneditable(() -> textColorUneditable);
    }

    public GuiTextField setShadow(Supplier<Boolean> shadow) {
        this.shadow = shadow;
        return this;
    }

    public GuiTextField setShadow(boolean shadow) {
        return this.setShadow(() -> shadow);
    }

    public GuiTextField addBackground(GuiColourProvider.HoverColour<Integer> fillColour, GuiColourProvider.HoverColour<Integer> borderColour) {
        GuiBorderedRect bg = new GuiBorderedRect().setFillColourL(fillColour).setBorderColourL(borderColour);
        bg.bindPosition(this);
        bg.bindSize(this, false);
        this.addChild(bg);
        return this;
    }

    public GuiTextField addBackground(int fillColour, int borderColour) {
        return this.addBackground((boolean e) -> fillColour, (boolean e) -> borderColour);
    }

    public GuiTextField addBackground(Supplier<Integer> fillColour, Supplier<Integer> borderColour) {
        return this.addBackground((boolean e) -> (Integer)fillColour.get(), (boolean e) -> (Integer)borderColour.get());
    }

    public GuiTextField onFinishEdit(Runnable onFinishEdit) {
        this.onFinishEdit = onFinishEdit;
        return this;
    }

    public GuiTextField setFocusable(boolean focusable) {
        this.isFocusable = focusable;
        return this;
    }

    public GuiTextField setValue(String newValue) {
        if (this.filter.test(newValue)) {
            if (newValue.length() > this.maxLength) {
                this._setValue(newValue.substring(0, this.maxLength));
            } else {
                this._setValue(newValue);
            }
            this.moveCursorToEnd();
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(newValue);
        }
        return this;
    }

    public GuiTextField setValueQuietly(String newValue) {
        if (this.filter.test(newValue)) {
            if (newValue.length() > this.maxLength) {
                this._setValue(newValue.substring(0, this.maxLength));
            } else {
                this._setValue(newValue);
            }
            this.moveCursorToEnd(false);
            this.setHighlightPos(this.cursorPos);
        }
        return this;
    }

    public String getValue() {
        return this.getValue.get();
    }

    private void _setValue(String newValue) {
        this.setValue.accept(newValue);
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.getValue().substring(i, j);
    }

    public void insertText(String text) {
        String newValue;
        String toInsert;
        int insertLen;
        String value = this.getValue();
        int selectStart = Math.min(this.cursorPos, this.highlightPos);
        int selectEnd = Math.max(this.cursorPos, this.highlightPos);
        int freeSpace = this.maxLength - value.length() - (selectStart - selectEnd);
        if (freeSpace < (insertLen = (toInsert = SharedConstants.m_136190_((String)text)).length())) {
            toInsert = toInsert.substring(0, freeSpace);
            insertLen = freeSpace;
        }
        if (this.filter.test(newValue = new StringBuilder(value).replace(selectStart, selectEnd, toInsert).toString())) {
            this._setValue(newValue);
            this.setCursorPosition(selectStart + insertLen);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(newValue);
        }
    }

    private void onValueChange(String newValue) {
        if (this.changeListener != null) {
            this.changeListener.accept(newValue);
        }
    }

    private void deleteText(int i) {
        if (Screen.m_96637_()) {
            this.deleteWords(i);
        } else {
            this.deleteChars(i);
        }
    }

    public void deleteWords(int i) {
        if (!this.getValue().isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(i) - this.cursorPos);
            }
        }
    }

    public void deleteChars(int i1) {
        String value = this.getValue();
        if (!value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String s;
                int k;
                int i = this.getCursorPos(i1);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(s = new StringBuilder(value).delete(j, k).toString())) {
                    this._setValue(s);
                    this.moveCursorTo(j);
                }
            }
        }
    }

    public int getWordPosition(int i) {
        return this.getWordPosition(i, this.getCursorPosition());
    }

    private int getWordPosition(int i, int i1) {
        return this.getWordPosition(i, i1, true);
    }

    private int getWordPosition(int i1, int i2, boolean b) {
        String value = this.getValue();
        int i = i2;
        boolean flag = i1 < 0;
        int j = Math.abs(i1);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = value.length();
                if ((i = value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (b && i < l && value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (b && i > 0 && value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int pos) {
        this.moveCursorTo(this.getCursorPos(pos));
    }

    private int getCursorPos(int i) {
        return Util.m_137479_((String)this.getValue(), (int)this.cursorPos, (int)i);
    }

    public void moveCursorTo(int pos, boolean notify) {
        this.setCursorPosition(pos);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
        if (notify) {
            this.onValueChange(this.getValue());
        }
    }

    public void moveCursorTo(int pos) {
        this.moveCursorTo(pos, true);
    }

    public void setCursorPosition(int pos) {
        this.cursorPos = Mth.m_14045_((int)pos, (int)0, (int)this.getValue().length());
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd(boolean notify) {
        this.moveCursorTo(this.getValue().length(), notify);
    }

    public void moveCursorToEnd() {
        this.moveCursorToEnd(true);
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public GuiTextField setEditable(boolean editable) {
        this.isEditable = editable;
        return this;
    }

    public void setFocus(boolean focused) {
        if (this.focused && !focused && this.onFinishEdit != null) {
            this.onFinishEdit.run();
        }
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public GuiTextField setMaxLength(int newWidth) {
        String value = this.getValue();
        this.maxLength = newWidth;
        if (value.length() > newWidth) {
            this._setValue(value.substring(0, newWidth));
            this.onValueChange(value);
        }
        return this;
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public int getInnerWidth() {
        return this.xSize() - this.getInsets().left - this.getInsets().right;
    }

    public void setHighlightPos(int p_94209_) {
        String value = this.getValue();
        int i = value.length();
        this.highlightPos = Mth.m_14045_((int)p_94209_, (int)0, (int)i);
        if (this.fontRenderer != null) {
            if (this.displayPos > i) {
                this.displayPos = i;
            }
            int j = this.getInnerWidth();
            String s = this.fontRenderer.m_92834_(value.substring(this.displayPos), j);
            int k = s.length() + this.displayPos;
            if (this.highlightPos == this.displayPos) {
                this.displayPos -= this.fontRenderer.m_92837_(value, j, true).length();
            }
            if (this.highlightPos > k) {
                this.displayPos += this.highlightPos - k;
            } else if (this.highlightPos <= this.displayPos) {
                this.displayPos -= this.displayPos - this.highlightPos;
            }
            this.displayPos = Mth.m_14045_((int)this.displayPos, (int)0, (int)i);
        }
    }

    @Override
    protected boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = Screen.m_96638_();
        if (Screen.m_96634_((int)keyCode)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.isEditable) {
                this.insertText(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            if (this.isEditable) {
                this.insertText("");
            }
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            case 257: {
                if (this.onFinishEdit != null) {
                    this.onFinishEdit.run();
                }
                if (this.returnListener != null) {
                    this.returnListener.accept(this.getValue());
                    return true;
                }
            }
            default: {
                return keyCode != 256;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            case 262: {
                if (Screen.m_96637_()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (Screen.m_96637_()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: 
        }
        this.moveCursorToEnd();
        return true;
    }

    public boolean canConsumeInput() {
        return this.isFocused() && this.isEditable() && this.isEnabled();
    }

    @Override
    public boolean charTyped(char charTyped, int charCode) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (SharedConstants.m_136188_((char)charTyped)) {
            if (this.isEditable) {
                this.insertText(Character.toString(charTyped));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clicked = this.isMouseOver(mouseX, mouseY);
        if (this.canLoseFocus) {
            this.setFocus(clicked && this.isFocusable);
        } else {
            this.setFocus(this.isFocusable);
        }
        if (this.isFocused() && clicked && button == 0) {
            int i = Mth.m_14107_((double)mouseX) - this.xPos();
            String s = this.fontRenderer.m_92834_(this.getValue().substring(this.displayPos), this.getInnerWidth());
            this.moveCursorTo(this.fontRenderer.m_92834_(s, i -= this.getInsets().left).length() + this.displayPos);
            return true;
        }
        return false;
    }

    @Override
    public void globalClick(double mouseX, double mouseY, int button) {
        super.globalClick(mouseX, mouseY, button);
        if (this.isFocused() && !this.isMouseOver(mouseX, mouseY)) {
            this.setFocus(this.isFocusable && !this.canLoseFocus);
        }
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_(0.0, 0.0, (double)this.getRenderZLevel());
        String value = this.getValue();
        int colour = this.isEditable ? this.textColor.get() : this.textColorUneditable.get();
        int textStart = this.cursorPos - this.displayPos;
        int highlightStart = this.highlightPos - this.displayPos;
        String displayText = this.fontRenderer.m_92834_(value.substring(this.displayPos), this.getInnerWidth());
        boolean flag = textStart >= 0 && textStart <= displayText.length();
        boolean flag1 = this.isFocused() && TimeKeeper.getClientTick() / 6 % 2 == 0 && flag;
        int l = this.xPos() + this.getInsets().left;
        int i1 = this.yPos() + (this.ySize() - 8) / 2;
        int j1 = l;
        if (highlightStart > displayText.length()) {
            highlightStart = displayText.length();
        }
        if (!displayText.isEmpty()) {
            String s1 = flag ? displayText.substring(0, textStart) : displayText;
            j1 = this.shadow.get() != false ? this.fontRenderer.m_92744_(poseStack, this.formatter.apply(s1, this.displayPos), l, i1, colour) : this.fontRenderer.m_92877_(poseStack, this.formatter.apply(s1, this.displayPos), l, i1, colour);
        }
        boolean flag2 = this.cursorPos < value.length() || value.length() >= this.getMaxLength();
        int k1 = j1;
        if (!flag) {
            k1 = textStart > 0 ? l + this.xSize() : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (!displayText.isEmpty() && flag && textStart < displayText.length()) {
            if (this.shadow.get().booleanValue()) {
                this.fontRenderer.m_92744_(poseStack, this.formatter.apply(displayText.substring(textStart), this.cursorPos), j1, i1, colour);
            } else {
                this.fontRenderer.m_92877_(poseStack, this.formatter.apply(displayText.substring(textStart), this.cursorPos), j1, i1, colour);
            }
        }
        if (this.suggestion != null && value.isEmpty()) {
            if (this.shadow.get().booleanValue()) {
                this.fontRenderer.m_92750_(poseStack, this.suggestion.get(), k1 - 1, i1, -8355712);
            } else {
                this.fontRenderer.m_92883_(poseStack, this.suggestion.get(), k1 - 1, i1, -8355712);
            }
        }
        if (flag1) {
            if (flag2) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + 9), (int)-3092272);
            } else if (this.shadow.get().booleanValue()) {
                this.fontRenderer.m_92750_(poseStack, "_", k1, i1, colour);
            } else {
                this.fontRenderer.m_92883_(poseStack, "_", k1, i1, colour);
            }
        }
        if (highlightStart != textStart) {
            int l1 = l + this.fontRenderer.m_92895_(displayText.substring(0, highlightStart));
            this.renderHighlight(k1, i1 - 1, l1 - 1, i1 + 1 + 9);
        }
    }

    private void renderHighlight(int left, int top, int right, int bottom) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        if (right > this.xPos() + this.xSize()) {
            right = this.xPos() + this.xSize();
        }
        if (left > this.xPos() + this.xSize()) {
            left = this.xPos() + this.xSize();
        }
        double renderZ = this.getRenderZLevel();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferbuilder.m_5483_((double)left, (double)bottom, renderZ).m_5752_();
        bufferbuilder.m_5483_((double)right, (double)bottom, renderZ).m_5752_();
        bufferbuilder.m_5483_((double)right, (double)top, renderZ).m_5752_();
        bufferbuilder.m_5483_((double)left, (double)top, renderZ).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }
}

