/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.lib.StringyStacks;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class GuiStackIcon
extends GuiElement<GuiStackIcon>
implements IModularGui.JEITargetAdapter {
    public static Map<String, ItemStack> stackCache = new HashMap<String, ItemStack>();
    public boolean drawCount = true;
    public boolean drawToolTip = true;
    public boolean drawHoverHighlight = false;
    private GuiElement background = null;
    protected List<Component> toolTipOverride = null;
    private String stackString;
    private ItemStack stack = ItemStack.f_41583_;
    private Runnable clickListener = null;
    private Consumer<Object> ingredientDropListener = null;
    private Supplier<ItemStack> stackSupplier = null;

    public GuiStackIcon() {
        this(ItemStack.f_41583_);
    }

    public GuiStackIcon(String stackString) {
        this.stackString = stackString;
        this.setSize(18, 18);
        this.setInsets(1, 1, 1, 1);
    }

    public GuiStackIcon(ItemStack stack) {
        this.stack = stack;
        this.setSize(18, 18);
        this.setInsets(1, 1, 1, 1);
    }

    public GuiStackIcon(int xPos, int yPos, String stackString) {
        super(xPos, yPos);
        this.stackString = stackString;
        this.setSize(18, 18);
        this.setInsets(1, 1, 1, 1);
    }

    public GuiStackIcon(int xPos, int yPos, int xSize, int ySize, String stackString) {
        super(xPos, yPos, xSize, ySize);
        this.stackString = stackString;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (this.drawHoverHighlight && this.isMouseOver(mouseX, mouseY)) {
            this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), -2130706433);
        }
        this.renderStack(minecraft);
    }

    public GuiStackIcon setDrawCount(boolean drawCount) {
        this.drawCount = drawCount;
        return this;
    }

    private void renderStack(Minecraft minecraft) {
        if (this.getStack().m_41619_()) {
            return;
        }
        float xScale = (float)this.xSize() / 18.0f;
        float yScale = (float)this.ySize() / 18.0f;
        double itemX = (float)this.xPos() + xScale * (float)this.getInsets().left;
        double itemY = (float)this.yPos() + yScale * (float)this.getInsets().top;
        this.renderGuiItem(minecraft, this.getStack(), itemX, itemY, this.getRenderZLevel(), xScale, yScale);
        this.renderItemOverlay(this.getStack(), itemX, itemY, this.getRenderZLevel(), xScale, yScale);
    }

    protected void renderGuiItem(Minecraft minecraft, ItemStack stack, double x, double y, double z, float xScale, float yScale) {
        boolean flag;
        ItemRenderer itemRenderer = minecraft.m_91291_();
        BakedModel model = itemRenderer.m_174264_(stack, null, null, 0);
        minecraft.m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_(x, y, z + 100.0);
        posestack.m_85837_(8.0 * (double)xScale, 8.0 * (double)yScale, 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        posestack.m_85841_(xScale, yScale, 1.0f);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !model.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, model);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.m_69482_();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.m_157182_();
    }

    private void renderItemOverlay(ItemStack stack, double x, double y, double z, float xScale, float yScale) {
        if (!stack.m_41619_()) {
            PoseStack poseStack = new PoseStack();
            if (stack.m_41613_() != 1 && this.drawCount) {
                String s = String.valueOf(stack.m_41613_());
                poseStack.m_85836_();
                poseStack.m_85837_(x, y, z + 200.0);
                poseStack.m_85841_(xScale, yScale, 1.0f);
                MultiBufferSource.BufferSource buffer = RenderUtils.getGuiBuffers();
                this.fontRenderer.m_92811_(s, 17 - this.fontRenderer.m_92895_(s), 9.0f, 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, 0xF000F0);
                buffer.m_109911_();
                poseStack.m_85849_();
            }
            if (stack.m_150947_()) {
                MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
                poseStack.m_85837_(x, y, z + 200.0);
                poseStack.m_85841_(xScale, yScale, 1.0f);
                int i = stack.m_150948_();
                int colour = stack.m_150949_();
                GuiHelper.drawRect((MultiBufferSource)getter, poseStack, 2.0, 13.0, 13.0, 2.0, -16777216);
                GuiHelper.drawRect((MultiBufferSource)getter, poseStack, 2.0, 13.0, i, 1.0, 0xFF000000 | colour);
                RenderUtils.endBatch((MultiBufferSource)getter);
            }
        }
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.getInsetRect().contains(mouseX, mouseY) && (this.drawToolTip || this.toolTipOverride != null) && !this.getStack().m_41619_()) {
            List<Component> list = this.toolTipOverride != null ? this.toolTipOverride : this.getTooltipFromItem(this.getStack());
            PoseStack poseStack = new PoseStack();
            poseStack.m_85837_(0.0, 0.0, (double)this.getRenderZLevel());
            this.renderTooltip(poseStack, list, mouseX, mouseY);
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.clickListener != null && this.isMouseOver(mouseX, mouseY)) {
            this.clickListener.run();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void setClickListener(Runnable clickListener) {
        this.clickListener = clickListener;
    }

    @Deprecated
    public GuiStackIcon setStack(@Nullable String stackString) {
        this.stackString = stackString;
        return this;
    }

    public GuiStackIcon setStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public GuiStackIcon setStackSupplier(Supplier<ItemStack> stackSupplier) {
        this.stackSupplier = stackSupplier;
        return this;
    }

    public GuiStackIcon setDrawToolTip(boolean drawToolTip) {
        this.drawToolTip = drawToolTip;
        return this;
    }

    public GuiStackIcon setBackground(GuiElement background) {
        if (background == null) {
            if (this.background != null) {
                this.removeChild(this.background);
                this.background = null;
            }
        } else {
            if (this.background != null) {
                this.removeChild(this.background);
            }
            this.background = background;
            background.setPos(this);
            background.setSize(this);
            this.addChild(background);
        }
        return this;
    }

    public GuiStackIcon setToolTip(boolean drawToolTip) {
        this.drawToolTip = drawToolTip;
        return this;
    }

    public ItemStack getStack() {
        if (this.stackSupplier != null) {
            return this.stackSupplier.get();
        }
        if (this.stackString == null) {
            return this.stack;
        }
        if (this.stackString.isEmpty()) {
            return ItemStack.f_41583_;
        }
        if (!stackCache.containsKey(this.stackString)) {
            ItemStack stack = StringyStacks.fromString(this.stackString, null);
            if (stack == null) {
                stack = new ItemStack((ItemLike)Blocks.f_50375_);
                this.toolTipOverride = new ArrayList<Component>();
                this.toolTipOverride.add((Component)new TextComponent("Failed to load Item Stack"));
                this.toolTipOverride.add((Component)new TextComponent("This may mean the mod the stack belongs to is not installed"));
                this.toolTipOverride.add((Component)new TextComponent("Or its just broken..."));
            }
            stackCache.put(this.stackString, stack);
        }
        return stackCache.get(this.stackString);
    }

    @Deprecated
    public GuiStackIcon setToolTipOverride(List<String> toolTipOverride) {
        this.toolTipOverride = toolTipOverride == null ? null : toolTipOverride.stream().map(TextComponent::new).collect(Collectors.toList());
        return this;
    }

    public GuiStackIcon setHoverOverride(List<Component> toolTipOverride) {
        this.toolTipOverride = toolTipOverride;
        return this;
    }

    public GuiStackIcon setDrawHoverHighlight(boolean drawHoverHighlight) {
        this.drawHoverHighlight = drawHoverHighlight;
        return this;
    }

    public GuiStackIcon addSlotBackground() {
        this.setBackground(null);
        this.background = ((GuiTexture)GuiTexture.newSlot().setPos(this)).setSizeModifiers((E guiSlotRender, Integer integer) -> this.xSize(), (E guiSlotRender, Integer integer) -> this.ySize());
        this.addChild(this.background);
        return this;
    }

    public GuiElement getBackground() {
        return this.background;
    }

    @Override
    public Rectangle getArea() {
        return this.getRect();
    }

    public void setIngredientDropListener(Consumer<Object> ingredientDropListener) {
        this.ingredientDropListener = ingredientDropListener;
    }

    @Override
    public void accept(Object ingredient) {
        if (this.ingredientDropListener != null) {
            this.ingredientDropListener.accept(ingredient);
        }
    }
}

