/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import java.util.function.Supplier;

public class GuiSlideIndicator
extends GuiElement<GuiSlideIndicator> {
    private GuiElement<?> slideElement;
    private Supplier<Double> position = () -> 0.0;
    private boolean horizontal = false;
    private int minOffset = 0;
    private int maxOffset = 0;

    public GuiSlideIndicator() {
    }

    public GuiSlideIndicator(Supplier<Double> position) {
        this.position = position;
    }

    public void setPosition(Supplier<Double> position) {
        this.position = position;
    }

    public GuiSlideIndicator setSlideElement(GuiElement<?> slideElement) {
        if (this.slideElement != null) {
            this.removeChild(this.slideElement);
        }
        this.slideElement = slideElement;
        this.addChild(this.slideElement);
        slideElement.setXPosMod(() -> {
            if (!this.horizontal) {
                return this.xPos();
            }
            int travel = this.xSize() - slideElement.xSize() - this.minOffset - this.maxOffset;
            return this.xPos() + this.minOffset + (int)((double)travel * this.getPos());
        });
        slideElement.setYPosMod(() -> {
            if (this.horizontal) {
                return this.yPos();
            }
            int travel = this.ySize() - slideElement.ySize() - this.minOffset - this.maxOffset;
            return this.maxYPos() - slideElement.ySize() - this.minOffset - (int)((double)travel * this.getPos());
        });
        return this;
    }

    public GuiSlideIndicator setOffsets(int minOffset, int maxOffset) {
        this.minOffset = minOffset;
        this.maxOffset = maxOffset;
        return this;
    }

    public GuiSlideIndicator setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        return this;
    }

    public double getPos() {
        return MathHelper.clip((double)this.position.get(), (double)0.0, (double)1.0);
    }
}

