/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiEvent;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventDispatcher;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class GuiSelectDialog<T>
extends GuiPopUpDialogBase<GuiSelectDialog<T>>
implements IGuiEventDispatcher {
    protected T selectedItem = null;
    protected boolean noScrollBars = false;
    protected boolean closeOnSelection = false;
    protected boolean playClickSound = false;
    protected boolean reloadOnSelection = false;
    protected Consumer<T> selectionListener = null;
    protected LinkedList<T> sectionItems = new LinkedList();
    protected LinkedList<T> filteredItems = new LinkedList();
    protected GuiScrollElement scrollElement;
    protected IGuiEventListener listener = null;
    protected Map<T, GuiElement> sectionElements = new HashMap<T, GuiElement>();
    protected Predicate<T> selectionFilter = null;
    protected BiConsumer<T, GuiElement<?>> toolTipHandler = null;
    private int listSpacing = 0;
    protected Function<T, GuiElement> rendererBuilder = t -> {
        GuiLabel label = ((GuiLabel)new GuiLabel(String.valueOf(t)).setInsets(0, 2, 0, 2)).setWrap(true).setShadow(false).setHoverableTextCol(hovering -> hovering ? 255 : 0);
        label.setYSizeMod((E guiLabel, Integer integer) -> guiLabel.fontRenderer.m_92920_(label.getLabelText(), Math.max(10, guiLabel.xSize() - label.getInsets().left - label.getInsets().right)) + 6);
        label.addChild((GuiTexture)((GuiTexture)GuiTexture.newDynamicTexture(BCGuiSprites.getter("light/background_dynamic")).setYSizeMod((E guiTexture, Integer integer) -> label.ySize()).setPos(label)).bindSize(label, false));
        return label;
    };

    public GuiSelectDialog(GuiElement parent) {
        super(parent);
    }

    public GuiSelectDialog(int xPos, int yPos, GuiElement parent) {
        super(xPos, yPos, parent);
    }

    public GuiSelectDialog(int xPos, int yPos, int xSize, int ySize, GuiElement parent) {
        super(xPos, yPos, xSize, ySize, parent);
    }

    public GuiSelectDialog<T> setListSpacing(int listSpacing) {
        this.listSpacing = listSpacing;
        if (this.scrollElement != null) {
            this.scrollElement.setListSpacing(listSpacing);
        }
        return this;
    }

    public GuiSelectDialog<T> setListener(IGuiEventListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    @Nullable
    public IGuiEventListener getListener() {
        return this.listener;
    }

    public GuiSelectDialog<T> setToolTipHandler(BiConsumer<T, GuiElement<?>> toolTipHandler) {
        this.toolTipHandler = toolTipHandler;
        return this;
    }

    public GuiSelectDialog<T> setPlayClickSound(boolean playClickSound) {
        this.playClickSound = playClickSound;
        return this;
    }

    public GuiSelectDialog<T> setReloadOnSelection(boolean reloadOnSelection) {
        this.reloadOnSelection = reloadOnSelection;
        return this;
    }

    @Override
    public void addChildElements() {
        super.addChildElements();
        if (this.scrollElement == null) {
            this.scrollElement = new GuiScrollElement();
            this.addChild(this.scrollElement);
            this.scrollElement.setListSpacing(this.listSpacing);
            ((GuiScrollElement)this.scrollElement.setPosAndSize(this.getInsetRect())).setStandardScrollBehavior();
            this.scrollElement.setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH);
            if (this.noScrollBars) {
                this.scrollElement.getVerticalScrollBar().setHidden(true);
                this.scrollElement.getHorizontalScrollBar().setHidden(true);
            }
        } else if (!this.childElements.contains(this.scrollElement)) {
            this.addChild(this.scrollElement);
        }
    }

    @Override
    public void reloadElement() {
        super.reloadElement();
        if (this.scrollElement != null) {
            this.scrollElement.setPosAndSize(this.getInsetRect());
        }
        this.reloadSelectionList();
    }

    protected void reloadSelectionList() {
        if (this.scrollElement == null) {
            return;
        }
        this.scrollElement.clearElements();
        this.filteredItems.clear();
        if (this.selectionFilter != null) {
            this.sectionItems.stream().filter(this.selectionFilter).forEach(t -> {
                this.scrollElement.addElement(this.sectionElements.get(t));
                this.filteredItems.add(t);
            });
        } else {
            this.sectionItems.forEach(t -> {
                this.scrollElement.addElement(this.sectionElements.get(t));
                this.filteredItems.add(t);
            });
        }
    }

    public GuiSelectDialog<T> setScrollElement(GuiScrollElement scrollElement) {
        if (scrollElement != null) {
            this.removeChild(scrollElement);
        }
        this.scrollElement = scrollElement;
        this.addChild(scrollElement);
        if (this.isElementInitialized()) {
            this.reloadElement();
        }
        return this;
    }

    public GuiScrollElement getScrollElement() {
        if (this.scrollElement == null) {
            this.scrollElement = new GuiScrollElement();
            this.scrollElement.applyGeneralElementData(this.modularGui, this.mc, this.screenWidth, this.screenHeight, this.fontRenderer);
            ((GuiScrollElement)this.scrollElement.setPosAndSize(this.getInsetRect())).setStandardScrollBehavior();
            this.scrollElement.setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH);
            if (this.noScrollBars) {
                this.scrollElement.getVerticalScrollBar().setHidden(true);
                this.scrollElement.getHorizontalScrollBar().setHidden(true);
            }
        }
        return this.scrollElement;
    }

    public GuiSelectDialog<T> setSelectionFilter(Predicate<T> selectionFilter) {
        this.selectionFilter = selectionFilter;
        return this;
    }

    public GuiSelectDialog<T> addItem(T item, @Nullable GuiElement<?> itemRenderer) {
        if (!this.sectionItems.contains(item)) {
            this.sectionItems.add(item);
        }
        this.sectionElements.put(item, itemRenderer == null ? this.buildRenderer(item) : itemRenderer);
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> addItems(Map<T, GuiElement<?>> itemMap) {
        this.sectionElements.putAll(itemMap);
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> addItems(Collection<T> itemMap) {
        itemMap.forEach(t -> {
            if (!this.sectionItems.contains(t)) {
                this.sectionItems.add(t);
            }
            this.sectionElements.put(t, this.buildRenderer(t));
        });
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> addItemAt(T item, int index, @Nullable GuiElement<?> itemRenderer) {
        this.sectionItems.add(index, item);
        this.sectionElements.put(item, itemRenderer == null ? this.buildRenderer(item) : itemRenderer);
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> removeItem(T item) {
        this.sectionItems.remove(item);
        this.sectionElements.remove(item);
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> clearItems() {
        this.sectionItems.clear();
        this.sectionElements.clear();
        if (this.scrollElement != null) {
            this.scrollElement.resetScrollPositions();
        }
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> addItem(T item) {
        this.addItem(item, null);
        return this;
    }

    public GuiSelectDialog<T> setRendererBuilder(Function<T, GuiElement> rendererBuilder) {
        this.rendererBuilder = rendererBuilder;
        this.sectionElements.replaceAll((t, element) -> this.buildRenderer(t));
        return this;
    }

    private GuiElement buildRenderer(T item) {
        GuiElement renderer = this.rendererBuilder.apply(item);
        if (this.toolTipHandler != null) {
            this.toolTipHandler.accept(item, renderer);
        }
        return renderer;
    }

    public ImmutableList<T> getItems() {
        return ImmutableList.copyOf(this.sectionItems);
    }

    public Map<T, GuiElement> getSectionElements() {
        return ImmutableMap.copyOf(this.sectionElements);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (Object item : this.filteredItems) {
                if (!this.sectionElements.get(item).isMouseOver(mouseX, mouseY)) continue;
                if (this.playClickSound) {
                    GuiButton.playGenericClick();
                }
                if (this.listener != null) {
                    this.listener.onMGuiEvent(new GuiEvent.SelectEvent(this, item, this.sectionElements.get(item)), this);
                }
                if (this.selectionListener != null) {
                    this.selectionListener.accept(item);
                }
                if (this.closeOnSelection) {
                    this.close();
                } else if (this.reloadOnSelection) {
                    this.reloadElement();
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public GuiSelectDialog<T> setSelectionListener(Consumer<T> selectionListener) {
        this.selectionListener = selectionListener;
        return this;
    }

    public GuiSelectDialog<T> setCloseOnSelection(boolean closeOnSelection) {
        this.closeOnSelection = closeOnSelection;
        return this;
    }

    public T getSelectedItem() {
        return this.selectedItem;
    }

    public GuiSelectDialog<T> setNoScrollBar() {
        this.noScrollBars = true;
        if (this.scrollElement != null) {
            this.scrollElement.getVerticalScrollBar().setHidden(true);
            this.scrollElement.getHorizontalScrollBar().setHidden(true);
        }
        return this;
    }
}

