/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.Material;

public class GuiProgressIcon
extends GuiElement<GuiProgressIcon> {
    private Material baseTexture;
    private Material overlayTexture;
    private Supplier<Material> baseTextureSupplier;
    private Supplier<Material> overlayTextureSupplier;
    private Direction direction;
    private Supplier<Double> progressSupplier = () -> 0.0;
    private int upperMargin = 0;
    private int lowerMargin = 0;

    public GuiProgressIcon(Material baseTexture, Material overlayTexture, Direction animDirection) {
        this.baseTexture = baseTexture;
        this.overlayTexture = overlayTexture;
        this.direction = animDirection;
    }

    public GuiProgressIcon(Supplier<Material> baseTexture, Supplier<Material> overlayTexture, Direction animDirection) {
        this.baseTextureSupplier = baseTexture;
        this.overlayTextureSupplier = overlayTexture;
        this.direction = animDirection;
    }

    public GuiProgressIcon setProgressSupplier(Supplier<Double> progressSupplier) {
        this.progressSupplier = progressSupplier;
        return this;
    }

    public GuiProgressIcon setProgress(double progress) {
        this.progressSupplier = () -> progress;
        return this;
    }

    public GuiProgressIcon setMargins(int lowerMargin, int upperMargin) {
        this.upperMargin = upperMargin;
        this.lowerMargin = lowerMargin;
        return this;
    }

    public double getProgress() {
        return this.progressSupplier.get();
    }

    /*
     * Unable to fully structure code
     */
    private double getRenderState() {
        progress = this.getProgress();
        if (this.direction == Direction.LEFT) ** GOTO lbl-1000
        if (this.direction == Direction.RIGHT) lbl-1000:
        // 2 sources

        {
            v0 = this.xSize();
        } else {
            v0 = this.ySize();
        }
        axis = v0;
        size = axis - (double)this.upperMargin - (double)this.lowerMargin;
        return MathHelper.clip((double)(((double)this.lowerMargin + Math.ceil(size * progress)) / axis), (double)0.0, (double)1.0);
    }

    private Material getOverlay() {
        return this.overlayTextureSupplier == null ? this.overlayTexture : this.overlayTextureSupplier.get();
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
        Material base = this.baseTextureSupplier == null ? this.baseTexture : this.baseTextureSupplier.get();
        this.drawSprite(getter.m_6299_(base.m_119201_(BCGuiSprites::makeType)), this.xPos(), this.yPos(), this.xSize(), this.ySize(), base.m_119204_());
        this.direction.draw(this, getter);
        getter.m_109911_();
    }

    public static enum Direction {
        UP((icon, getter) -> GuiHelper.drawPartialSprite(getter.m_6299_(icon.getOverlay().m_119201_(BCGuiSprites::makeType)), icon.xPos(), (double)icon.yPos() + (double)icon.ySize() * (1.0 - icon.getRenderState()), icon.xSize(), (double)icon.ySize() * icon.getRenderState(), icon.getOverlay().m_119204_(), 0.0, 1.0 - icon.getRenderState(), 1.0, 1.0)),
        DOWN((icon, getter) -> GuiHelper.drawPartialSprite(getter.m_6299_(icon.getOverlay().m_119201_(BCGuiSprites::makeType)), icon.xPos(), icon.yPos(), icon.xSize(), (double)icon.ySize() * icon.getRenderState(), icon.getOverlay().m_119204_(), 0.0, 0.0, 1.0, icon.getRenderState())),
        LEFT((icon, getter) -> GuiHelper.drawPartialSprite(getter.m_6299_(icon.getOverlay().m_119201_(BCGuiSprites::makeType)), (double)icon.xPos() + (double)icon.xSize() * (1.0 - icon.getRenderState()), icon.yPos(), (double)icon.xSize() * icon.getRenderState(), icon.ySize(), icon.getOverlay().m_119204_(), 1.0 - icon.getRenderState(), 0.0, 1.0, 1.0)),
        RIGHT((icon, getter) -> GuiHelper.drawPartialSprite(getter.m_6299_(icon.getOverlay().m_119201_(BCGuiSprites::makeType)), icon.xPos(), icon.yPos(), (double)icon.xSize() * icon.getRenderState(), icon.ySize(), icon.getOverlay().m_119204_(), 0.0, 0.0, icon.getRenderState(), 1.0));

        private BiConsumer<GuiProgressIcon, MultiBufferSource.BufferSource> drawFunc;

        private Direction(BiConsumer<GuiProgressIcon, MultiBufferSource.BufferSource> drawFunc) {
            this.drawFunc = drawFunc;
        }

        private void draw(GuiProgressIcon icon, MultiBufferSource.BufferSource getter) {
            this.drawFunc.accept(icon, getter);
        }
    }
}

