/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.CursorHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.function.Supplier;

public class GuiManipulable
extends GuiElement<GuiManipulable> {
    protected int dragXOffset = 0;
    protected int dragYOffset = 0;
    protected boolean isDragging = false;
    protected boolean dragPos = false;
    protected boolean dragTop = false;
    protected boolean dragLeft = false;
    protected boolean dragBottom = false;
    protected boolean dragRight = false;
    protected boolean enableCursors = false;
    protected Dimension minSize = new Dimension(50, 50);
    protected Dimension maxSize = new Dimension(256, 256);
    protected Supplier<Boolean> canDrag = () -> true;
    protected Supplier<Boolean> canResizeV = () -> true;
    protected Supplier<Boolean> canResizeH = () -> true;
    protected PositionValidator dragZone = (x, y) -> GuiHelperOld.isInRect(this.xPos(), this.yPos(), this.xSize(), 20, x, y);
    protected PositionValidator topResizeZone = null;
    protected PositionValidator leftResizeZone = null;
    protected PositionValidator bottomResizeZone = null;
    protected PositionValidator rightResizeZone = null;
    protected Runnable onMovedCallback = null;
    protected Runnable onResizedCallback = null;
    protected PositionRestraint positionRestraint = GuiElement::normalizePosition;

    public GuiManipulable setCanDrag(Supplier<Boolean> canDrag) {
        this.canDrag = canDrag;
        return this;
    }

    public GuiManipulable setCanResizeH(Supplier<Boolean> canResizeH) {
        this.canResizeH = canResizeH;
        return this;
    }

    public GuiManipulable setCanResizeV(Supplier<Boolean> canResizeV) {
        this.canResizeV = canResizeV;
        return this;
    }

    public GuiManipulable setDragBarHeight(int dragBarHeight) {
        this.dragZone = (x, y) -> GuiHelperOld.isInRect(this.xPos(), this.yPos(), this.xSize(), dragBarHeight, x, y);
        return this;
    }

    public GuiManipulable setDragZone(PositionValidator dragZone) {
        this.dragZone = dragZone;
        return this;
    }

    public GuiManipulable setOnMovedCallback(Runnable onMovedCallback) {
        this.onMovedCallback = onMovedCallback;
        return this;
    }

    public GuiManipulable setOnResizedCallback(Runnable onResizedCallback) {
        this.onResizedCallback = onResizedCallback;
        return this;
    }

    public GuiManipulable setPositionRestraint(PositionRestraint positionRestraint) {
        this.positionRestraint = positionRestraint;
        return this;
    }

    public GuiManipulable setEnableCursors(boolean enableCursors) {
        this.enableCursors = enableCursors;
        return this;
    }

    public void startDragging() {
        double mouseX = this.getMouseX();
        double mouseY = this.getMouseY();
        this.dragXOffset = (int)mouseX - this.xPos();
        this.dragYOffset = (int)mouseY - this.yPos();
        this.isDragging = true;
        this.dragPos = true;
        this.onStartMove(mouseX, mouseY);
        this.onStartManipulation(mouseX, mouseY);
    }

    public void setMinSize(Dimension minSize) {
        this.minSize = minSize;
    }

    public void setMaxSize(Dimension maxSize) {
        this.maxSize = maxSize;
    }

    public Dimension getMinSize() {
        return this.minSize;
    }

    public Dimension getMaxSize() {
        return this.maxSize;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean rightFlag;
        boolean lastCC = this.capturesClicks;
        this.capturesClicks = false;
        boolean captured = super.mouseClicked(mouseX, mouseY, mouseButton);
        this.capturesClicks = lastCC;
        if (captured) {
            return true;
        }
        boolean posFlag = this.dragZone != null && this.dragZone.validate(mouseX, mouseY) && this.canDrag.get() != false;
        boolean topFlag = this.topResizeZone != null && this.topResizeZone.validate(mouseX, mouseY) && this.canResizeV.get() != false;
        boolean leftFlag = this.leftResizeZone != null && this.leftResizeZone.validate(mouseX, mouseY) && this.canResizeH.get() != false;
        boolean bottomFlag = this.bottomResizeZone != null && this.bottomResizeZone.validate(mouseX, mouseY) && this.canResizeV.get() != false;
        boolean bl = rightFlag = this.rightResizeZone != null && this.rightResizeZone.validate(mouseX, mouseY) && this.canResizeH.get() != false;
        if (posFlag || topFlag || leftFlag || bottomFlag || rightFlag) {
            this.dragXOffset = (int)mouseX - this.xPos();
            this.dragYOffset = (int)mouseY - this.yPos();
            this.isDragging = true;
            if (posFlag) {
                this.dragPos = true;
                if (this.onStartMove(mouseX, mouseY)) {
                    this.isDragging = false;
                    return true;
                }
            } else {
                this.dragTop = topFlag;
                this.dragLeft = leftFlag;
                this.dragBottom = bottomFlag;
                this.dragRight = rightFlag;
                this.onStartResized(mouseX, mouseY);
            }
            if (this.onStartManipulation(mouseX, mouseY)) {
                this.dragRight = false;
                this.dragBottom = false;
                this.dragLeft = false;
                this.dragTop = false;
                this.dragPos = false;
            }
            return true;
        }
        return this.capturesClicks && this.isMouseOver(mouseX, mouseY);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dragX, double dragY) {
        if (this.isDragging) {
            double xMove = mouseX - (double)this.dragXOffset - (double)this.xPos();
            double yMove = mouseY - (double)this.dragYOffset - (double)this.yPos();
            if (this.dragPos) {
                Rectangle previous = new Rectangle(this.getRect());
                this.translate((int)xMove, (int)yMove);
                this.validatePosition();
                this.validateMove(previous, (int)mouseX, (int)mouseY);
                this.onMoved();
            } else {
                int newWidth;
                int newHeight;
                Dimension min = this.getMinSize();
                Dimension max = this.getMaxSize();
                if (this.dragTop) {
                    newHeight = (int)MathHelper.clip((double)((double)this.ySize() - yMove), (double)min.height, (double)max.height);
                    this.setYPos(this.maxYPos() - newHeight, true);
                }
                if (this.dragLeft) {
                    newWidth = (int)MathHelper.clip((double)((double)this.xSize() - xMove), (double)min.width, (double)max.width);
                    this.setXPos(this.maxXPos() - newWidth, true);
                }
                if (this.dragBottom) {
                    newHeight = (int)MathHelper.clip((double)((double)this.yPos() + ((double)this.dragYOffset + yMove - (double)this.yPos())), (double)min.height, (double)max.height);
                    this.setYSize(newHeight);
                }
                if (this.dragRight) {
                    newWidth = (int)MathHelper.clip((double)((double)this.xPos() + ((double)this.dragXOffset + xMove - (double)this.xPos())), (double)min.width, (double)max.width);
                    this.setXSize(newWidth);
                }
                this.onResized();
            }
            this.onManipulated(mouseX, mouseY);
        }
        return super.mouseDragged(mouseX, mouseY, clickedMouseButton, dragX, dragY);
    }

    protected void onMoved() {
        if (this.onMovedCallback != null) {
            this.onMovedCallback.run();
        }
    }

    protected void onResized() {
        if (this.onResizedCallback != null) {
            this.onResizedCallback.run();
        }
    }

    protected void onManipulated(double mouseX, double mouseY) {
    }

    protected boolean onStartManipulation(double mouseX, double mouseY) {
        return false;
    }

    protected void onFinishManipulation(double mouseX, double mouseY) {
    }

    protected boolean onStartMove(double mouseX, double mouseY) {
        return false;
    }

    protected void onStartResized(double mouseX, double mouseY) {
    }

    protected void onFinishMove(double mouseX, double mouseY) {
    }

    protected void onFinishResized(double mouseX, double mouseY) {
    }

    protected void validateMove(Rectangle previous, double mouseX, double mouseY) {
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        if (this.isDragging) {
            this.validatePosition();
            if (this.dragPos) {
                this.onFinishMove(mouseX, mouseY);
            } else {
                this.onFinishResized(mouseX, mouseY);
            }
            this.onFinishManipulation(mouseX, mouseY);
        }
        this.dragRight = false;
        this.dragBottom = false;
        this.dragLeft = false;
        this.dragTop = false;
        this.dragPos = false;
        this.isDragging = false;
        return super.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    public void reloadElement() {
        super.reloadElement();
        if (this.xSize() > 0 && this.ySize() > 0) {
            this.validatePosition();
        }
    }

    @Override
    public boolean onUpdate() {
        double x = this.getMouseX();
        double y = this.getMouseY();
        if (this.enableCursors) {
            boolean any;
            boolean posFlag = this.dragZone != null && this.dragZone.validate(x, y) && this.canDrag.get() != false;
            boolean topFlag = this.topResizeZone != null && this.topResizeZone.validate(x, y) && this.canResizeV.get() != false;
            boolean leftFlag = this.leftResizeZone != null && this.leftResizeZone.validate(x, y) && this.canResizeH.get() != false;
            boolean bottomFlag = this.bottomResizeZone != null && this.bottomResizeZone.validate(x, y) && this.canResizeV.get() != false;
            boolean rightFlag = this.rightResizeZone != null && this.rightResizeZone.validate(x, y) && this.canResizeH.get() != false;
            boolean bl = any = posFlag || topFlag || leftFlag || bottomFlag || rightFlag;
            if (any && !this.modularGui.getManager().isAreaUnderElement((int)x, (int)y, 1, 1, this.displayZLevel + 1)) {
                if (posFlag) {
                    this.modularGui.getManager().setCursor(CursorHelper.DRAG);
                } else if (topFlag && leftFlag || bottomFlag && rightFlag) {
                    this.modularGui.getManager().setCursor(CursorHelper.RESIZE_TLBR);
                } else if (topFlag && rightFlag || bottomFlag && leftFlag) {
                    this.modularGui.getManager().setCursor(CursorHelper.RESIZE_TRBL);
                } else if (topFlag || bottomFlag) {
                    this.modularGui.getManager().setCursor(CursorHelper.RESIZE_V);
                } else {
                    this.modularGui.getManager().setCursor(CursorHelper.RESIZE_H);
                }
            }
        }
        return super.onUpdate();
    }

    protected void validatePosition() {
        int x = this.xPos();
        int y = this.yPos();
        this.positionRestraint.restrainPosition(this);
        if ((x != this.xPos() || y != this.yPos()) && this.onMovedCallback != null) {
            this.onMovedCallback.run();
        }
    }

    public GuiManipulable setHResizeBorders(int width) {
        this.leftResizeZone = (x, y) -> GuiHelperOld.isInRect(this.xPos(), this.yPos(), width, this.ySize(), x, y);
        this.rightResizeZone = (x, y) -> GuiHelperOld.isInRect(this.maxXPos() - width, this.yPos(), width, this.ySize(), x, y);
        return this;
    }

    public GuiManipulable setVResizeBorders(int width) {
        this.topResizeZone = (x, y) -> GuiHelperOld.isInRect(this.xPos(), this.yPos(), this.xSize(), width, x, y);
        this.bottomResizeZone = (x, y) -> GuiHelperOld.isInRect(this.xPos(), this.maxYPos() - width, this.xSize(), width, x, y);
        return this;
    }

    public GuiManipulable setResizeBorders(int width) {
        this.setHResizeBorders(width);
        this.setVResizeBorders(width);
        return this;
    }

    public static interface PositionValidator {
        public boolean validate(double var1, double var3);
    }

    public static interface PositionRestraint {
        public void restrainPosition(GuiManipulable var1);
    }
}

