/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiColourProvider;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;

public class GuiLabel
extends GuiElement<GuiLabel> {
    protected boolean trim = true;
    protected boolean midTrim = false;
    protected boolean wrap = false;
    protected boolean dropShadow = true;
    protected GuiAlign alignment = GuiAlign.CENTER;
    protected GuiAlign.TextRotation rotation = GuiAlign.TextRotation.NORMAL;
    private int textColour = -1;
    private String labelText = "";
    private Supplier<String> displayStringSupplier;
    private Supplier<Component> displaySupplier;
    private Supplier<Boolean> shadowStateSupplier;
    private GuiColourProvider.HoverColour<Integer> texColGetter;

    public GuiLabel() {
    }

    public GuiLabel(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiLabel(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    public GuiLabel(String labelText) {
        this.labelText = labelText;
    }

    public GuiLabel(Component label) {
        this.displaySupplier = () -> label;
    }

    public GuiLabel(Supplier<String> displayStringSupplier) {
        this.setDisplaySupplier(displayStringSupplier);
    }

    public GuiLabel(int xPos, int yPos, String labelText) {
        this(xPos, yPos);
        this.labelText = labelText;
    }

    public GuiLabel(int xPos, int yPos, int xSize, int ySize, String labelText) {
        this(xPos, yPos, xSize, ySize);
        this.labelText = labelText;
    }

    public GuiLabel setLabelText(String displayString) {
        this.labelText = displayString;
        return this;
    }

    public GuiLabel setDisplaySupplier(Supplier<String> displayStringSupplier) {
        this.displayStringSupplier = displayStringSupplier;
        return this;
    }

    public GuiLabel setComponentSupplier(Supplier<Component> displaySupplier) {
        this.displaySupplier = displaySupplier;
        return this;
    }

    public String getLabelText() {
        return this.displayStringSupplier != null ? this.displayStringSupplier.get() : this.labelText;
    }

    public GuiLabel setAlignment(GuiAlign alignment) {
        this.alignment = alignment;
        return this;
    }

    public GuiAlign getAlignment() {
        return this.alignment;
    }

    public GuiLabel setTrim(boolean trim) {
        this.trim = trim;
        if (trim) {
            this.wrap = false;
        }
        return this;
    }

    public GuiLabel setMidTrim(boolean midTrim) {
        this.midTrim = midTrim;
        return this;
    }

    public GuiLabel setWrap(boolean wrap) {
        this.wrap = wrap;
        if (wrap) {
            this.trim = false;
        }
        return this;
    }

    public GuiLabel setRotation(GuiAlign.TextRotation rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiAlign.TextRotation getRotation() {
        return this.rotation;
    }

    public GuiLabel setShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        this.shadowStateSupplier = null;
        return this;
    }

    public GuiLabel setShadowStateSupplier(Supplier<Boolean> shadowStateSupplier) {
        this.shadowStateSupplier = shadowStateSupplier;
        return this;
    }

    public boolean hasShadow() {
        return this.shadowStateSupplier != null ? this.shadowStateSupplier.get() : this.dropShadow;
    }

    public int getTextColour(boolean hovered) {
        if (this.texColGetter != null) {
            return this.texColGetter.getColour(hovered);
        }
        return this.textColour;
    }

    public GuiLabel setHoverableTextCol(GuiColourProvider.HoverColour<Integer> texColGetter) {
        this.texColGetter = texColGetter;
        return this;
    }

    public GuiLabel setTextColGetter(GuiColourProvider<Integer> texColGetter) {
        this.texColGetter = hovering -> (Integer)texColGetter.getColour();
        return this;
    }

    public GuiLabel setTextColour(ChatFormatting colour, ChatFormatting colourHover) {
        return this.setTextColour(colour.m_126665_(), colourHover.m_126665_());
    }

    public GuiLabel setTextColour(int colour, int colourHover) {
        this.setHoverableTextCol(hovering -> hovering ? colourHover : colour);
        return this;
    }

    public GuiLabel setTextColour(int colour) {
        if (this.texColGetter != null) {
            int hover = this.texColGetter.getColour(true);
            this.setHoverableTextCol(hovering -> hovering ? hover : colour);
        }
        this.setHoverableTextCol(hovering -> colour);
        return this;
    }

    public GuiLabel setTextColour(ChatFormatting colour) {
        this.setTextColour(colour.m_126665_());
        return this;
    }

    @Override
    public void renderElement(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        TextComponent component;
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        super.renderElement(mc, mouseX, mouseY, partialTicks);
        Object object = component = this.displaySupplier == null ? new TextComponent(this.getLabelText()) : this.displaySupplier.get();
        if (!component.getString().isEmpty()) {
            int colour = this.getTextColour(mouseOver);
            int widthLimit = this.rotation == GuiAlign.TextRotation.NORMAL || this.rotation == GuiAlign.TextRotation.ROT_180 ? this.getInsetRect().width : this.getInsetRect().height;
            Objects.requireNonNull(this.fontRenderer);
            int ySize = 9;
            if (this.wrap && !this.trim) {
                int n = this.fontRenderer.m_92865_().m_92414_((FormattedText)component, widthLimit, component.m_7383_()).size();
                Objects.requireNonNull(this.fontRenderer);
                ySize = n * 9;
            }
            int yPos = this.getInsetRect().y + this.getInsetRect().height / 2 - ySize / 2;
            int xPos = this.getInsetRect().x;
            switch (this.rotation) {
                case NORMAL: {
                    this.drawCustomString(this.fontRenderer, (FormattedText)component, xPos, yPos, widthLimit, colour, this.getAlignment(), this.wrap, this.trim, this.midTrim, this.hasShadow());
                    break;
                }
                case ROT_CC: {
                    xPos = this.getInsetRect().x + this.getInsetRect().width / 2 - ySize / 2;
                    yPos = this.getInsetRect().y;
                    this.drawCustomString(this.fontRenderer, (FormattedText)component, xPos, yPos, widthLimit, colour, this.getAlignment(), this.wrap, this.trim, this.midTrim, this.hasShadow());
                    break;
                }
                case ROT_C: {
                    xPos = this.getInsetRect().x + this.getInsetRect().width / 2 - ySize / 2;
                    yPos = this.getInsetRect().y;
                    this.drawCustomString(this.fontRenderer, (FormattedText)component, xPos + ySize, yPos, widthLimit, colour, this.getAlignment(), this.wrap, this.trim, this.midTrim, this.hasShadow());
                    break;
                }
                case ROT_180: {
                    this.drawCustomString(this.fontRenderer, (FormattedText)component, xPos, yPos, widthLimit, colour, this.getAlignment(), this.wrap, this.trim, this.midTrim, this.hasShadow());
                }
            }
        }
    }

    public GuiLabel setWidthFromText() {
        int textWidth = this.fontRenderer.m_92895_(this.getLabelText());
        this.setXSize(textWidth + this.getInsets().left + this.getInsets().right);
        return this;
    }

    public GuiLabel setWidthFromText(int ySize) {
        this.setYSize(ySize);
        return this.setWidthFromText();
    }

    public GuiLabel setHeightForText() {
        int textHeight = this.fontRenderer.m_92920_(this.getLabelText(), this.getInsetRect().width);
        this.setYSize(textHeight + this.getInsets().top + this.getInsets().bottom);
        return this;
    }

    public GuiLabel setHeightForText(int xSize) {
        this.setXSize(xSize);
        return this.setHeightForText();
    }
}

