/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class GuiEntityRenderer
extends GuiElement<GuiEntityRenderer> {
    private static Map<ResourceLocation, Entity> entityCache = new HashMap<ResourceLocation, Entity>();
    private static List<ResourceLocation> invalidEntities = new ArrayList<ResourceLocation>();
    private float rotationSpeed = 1.0f;
    private float lockedRotation = 0.0f;
    private Entity entity;
    private ResourceLocation entityName;
    private boolean invalidEntity = false;
    private boolean rotationLocked = false;
    private boolean trackMouse = false;
    private boolean drawName = false;
    public boolean silentErrors = false;
    public boolean force2dSize = false;

    public GuiEntityRenderer() {
    }

    public GuiEntityRenderer(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiEntityRenderer(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    public GuiEntityRenderer setEntity(Entity entity) {
        this.entity = entity;
        if (this.entity == null) {
            if (!this.silentErrors) {
                LogHelperBC.dev("GuiEntityRenderer#setEntity: Invalid Entity - " + this.entityName);
            }
            this.invalidEntity = true;
            return this;
        }
        this.entityName = entity.m_6095_().getRegistryName();
        this.invalidEntity = false;
        if (invalidEntities.contains(this.entityName)) {
            this.invalidEntity = true;
        }
        return this;
    }

    public GuiEntityRenderer setEntity(ResourceLocation entity) {
        this.entityName = entity;
        this.entity = entityCache.computeIfAbsent(entity, resourceLocation -> {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(entity);
            return type == null ? null : type.m_20615_((Level)this.mc.f_91073_);
        });
        this.invalidEntity = false;
        if (this.entity == null) {
            if (!this.silentErrors) {
                LogHelperBC.dev("GuiEntityRenderer#setEntity: Invalid Entity - " + this.entityName);
            }
            this.invalidEntity = true;
        }
        if (invalidEntities.contains(this.entityName)) {
            this.invalidEntity = true;
        }
        return this;
    }

    public GuiEntityRenderer setSilentErrors(boolean silentErrors) {
        this.silentErrors = silentErrors;
        return this;
    }

    public GuiEntityRenderer setForce2dSize(boolean force2dSize) {
        this.force2dSize = force2dSize;
        return this;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (this.invalidEntity && !this.silentErrors) {
            LogHelperBC.dev("GuiEntityRenderer: Invalid Entity - " + this.entityName);
            return;
        }
        try {
            if (this.entity != null) {
                float rotation;
                Rectangle rect = this.getInsetRect();
                float scale = this.force2dSize ? Math.min((float)rect.height / this.entity.m_20206_(), (float)rect.width / this.entity.m_20205_()) : (float)rect.height / this.entity.m_20206_();
                double zLevel = this.getRenderZLevel() + 100.0f;
                double posX = (double)rect.x + (double)rect.width / 2.0;
                int yPos = this.yPos() + this.ySize() / 2 + rect.height / 2;
                float f = rotation = this.isRotationLocked() ? this.getLockedRotation() : ((float)BCClientEventHandler.elapsedTicks + partialTicks) * this.getRotationSpeedMultiplier();
                if (this.entity instanceof LivingEntity) {
                    int eyeOffset = (int)((this.entity.m_20206_() - this.entity.m_20192_()) * scale);
                    GuiEntityRenderer.renderEntityOnScreen((int)posX, yPos, (int)scale, (int)posX - mouseX, this.yPos() - mouseY + eyeOffset, (LivingEntity)this.entity, rotation, this.trackMouse, this.drawName, zLevel);
                }
            }
        }
        catch (Throwable e) {
            this.invalidEntity = true;
            invalidEntities.add(this.entityName);
            LogHelperBC.error("Failed to build entity in GUI. This is not a bug there are just some entities that can not be rendered like this.");
            LogHelperBC.error("Entity: " + this.entity);
            e.printStackTrace();
        }
    }

    public boolean isRotationLocked() {
        return this.rotationLocked;
    }

    public GuiEntityRenderer rotationLocked(boolean rotationLocked) {
        this.rotationLocked = rotationLocked;
        return this;
    }

    public GuiEntityRenderer setLockedRotation(float lockedRotation) {
        this.lockedRotation = lockedRotation;
        this.rotationLocked(true);
        return this;
    }

    public float getLockedRotation() {
        return this.lockedRotation;
    }

    public boolean isInvalidEntity() {
        return this.invalidEntity;
    }

    public GuiEntityRenderer setRotationSpeedMultiplier(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        return this;
    }

    public GuiEntityRenderer setTrackMouse(boolean trackMouse) {
        this.trackMouse = trackMouse;
        return this;
    }

    public GuiEntityRenderer setDrawName(boolean drawName) {
        this.drawName = drawName;
        return this;
    }

    public float getRotationSpeedMultiplier() {
        return this.rotationSpeed;
    }

    public static void renderEntityOnScreen(int xPos, int yPos, int scale, float mouseX, float mouseY, LivingEntity entity, double rotation, boolean trackMouse, boolean drawName, double zOffset) {
        float lookY;
        float lookX = trackMouse ? (float)Math.atan(mouseX / 40.0f) : 0.0f;
        float f = lookY = trackMouse ? (float)Math.atan(mouseY / 40.0f) : 0.0f;
        if (drawName && entity instanceof RemotePlayer && Minecraft.m_91087_().f_91074_ != null) {
            entity.m_6034_(Minecraft.m_91087_().f_91074_.m_20185_(), Minecraft.m_91087_().f_91074_.m_20186_(), Minecraft.m_91087_().f_91074_.m_20189_());
        } else if (entity instanceof RemotePlayer) {
            entity.m_6034_(0.0, -1000.0, 0.0);
        }
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)xPos, (double)yPos, 1050.0 + zOffset);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85837_(0.0, 0.0, 1000.0);
        posestack1.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion1 = Vector3f.f_122223_.m_122240_(lookY * 20.0f);
        quaternion.m_80148_(quaternion1);
        posestack1.m_85845_(quaternion);
        posestack1.m_85845_(Vector3f.f_122225_.m_122240_((float)rotation));
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 180.0f + lookX * 20.0f;
        entity.m_146922_(180.0f + lookX * 40.0f);
        entity.m_146926_(-lookY * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        quaternion1.m_80157_();
        entityrenderdispatcher.m_114412_(quaternion1);
        entityrenderdispatcher.m_114468_(false);
        MultiBufferSource.BufferSource irendertypebuffer$impl = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (MultiBufferSource)irendertypebuffer$impl, 0xF000F0));
        irendertypebuffer$impl.m_109911_();
        entityrenderdispatcher.m_114468_(true);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }
}

