/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEntityRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSelectDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiStackIcon;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiColourProvider;
import com.brandon3055.brandonscore.lib.StringyStacks;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterAdults;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterEntity;
import com.brandon3055.brandonscore.lib.entityfilter.FilterGroup;
import com.brandon3055.brandonscore.lib.entityfilter.FilterHostile;
import com.brandon3055.brandonscore.lib.entityfilter.FilterItem;
import com.brandon3055.brandonscore.lib.entityfilter.FilterPlayer;
import com.brandon3055.brandonscore.lib.entityfilter.FilterTamed;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class GuiEntityFilter
extends GuiElement<GuiEntityFilter> {
    private final EntityFilter entityFilter;
    private GuiScrollElement scrollElement;
    private GroupElement rootNode;
    private Supplier<GuiElement> nodeBgBuilder = GuiBorderedRect::new;
    private GuiColourProvider<Integer> nodeTitleColour = () -> 0xFFFFFF;
    private Consumer<GuiSlideControl> scrollBarCustomizer;
    private boolean updateRequired = false;

    public GuiEntityFilter(EntityFilter entityFilter) {
        this.entityFilter = entityFilter;
        this.elementTranslationExt = "entity_filter";
    }

    public void setNodeBackgroundBuilder(Supplier<GuiElement> nodeBackgroundBuilder) {
        this.nodeBgBuilder = nodeBackgroundBuilder;
    }

    public void setNodeTitleColour(GuiColourProvider<Integer> nodeTitleColour) {
        this.nodeTitleColour = nodeTitleColour;
    }

    public void setScrollBarCustomizer(Consumer<GuiSlideControl> scrollBarCustomizer) {
        this.scrollBarCustomizer = scrollBarCustomizer;
        if (this.scrollElement != null) {
            scrollBarCustomizer.accept(this.scrollElement.getVerticalScrollBar());
        }
    }

    @Override
    public void addChildElements() {
        super.addChildElements();
        this.modularGui.getJEIDropTargets().removeIf(o -> o instanceof GuiElement && ((GuiElement)o).isInGroup("[ENTITY_FILTER_STACK_DROP]"));
        this.scrollElement = new GuiScrollElement().setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH);
        this.scrollElement.setScrollBarStateChangingListener(() -> {
            this.updateRequired = true;
        });
        this.scrollElement.setStandardScrollBehavior();
        this.scrollElement.setInsets(2, 2, 2, 2);
        if (this.scrollBarCustomizer != null) {
            this.scrollBarCustomizer.accept(this.scrollElement.getVerticalScrollBar());
        }
        this.addChild(this.scrollElement);
        this.scrollElement.setPos(this);
        ((GuiScrollElement)this.scrollElement.setSize(this.getInsetRect())).bindSize(this, true);
        this.rootNode = new GroupElement(this, this.entityFilter);
        this.scrollElement.addElement(this.rootNode);
    }

    @Override
    public void reloadElement() {
        super.reloadElement();
        this.rootNode.updateChildNodes();
    }

    public GuiScrollElement getScrollElement() {
        return this.scrollElement;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean onUpdate() {
        if (this.updateRequired) {
            this.rootNode.updateChildNodes();
            this.updateRequired = false;
        }
        return super.onUpdate();
    }

    private NodeElement createElementFor(FilterBase node) {
        switch (node.getType()) {
            case HOSTILE: {
                return new NodeHostile(this, (FilterHostile)node);
            }
            case TAMED: {
                return new NodeTamed(this, (FilterTamed)node);
            }
            case ADULTS: {
                return new NodeAdults(this, (FilterAdults)node);
            }
            case PLAYER: {
                return new NodePlayers(this, (FilterPlayer)node);
            }
            case ENTITY_TYPE: {
                return new NodeEntityType(this, (FilterEntity)node);
            }
            case ITEM_FILTER: {
                return new NodeItem(this, (FilterItem)node);
            }
            case FILTER_GROUP: {
                return new GroupElement(this, (FilterGroup)node);
            }
        }
        throw new IllegalStateException("Unknown Filter Type: " + node.getType());
    }

    private static class GroupElement
    extends NodeElement<FilterGroup> {
        private static int maxDepth = 4;
        protected Int2ObjectMap<NodeElement> nodeElements = new Int2ObjectOpenHashMap();

        public GroupElement(GuiEntityFilter gui, FilterGroup filterNode) {
            super(gui, filterNode);
        }

        @Override
        public void addChildElements() {
            super.addChildElements();
            this.background.setYSizeMod(this::ySize);
            GuiButton addButton = (GuiButton)new GuiButton().setSize(10, 10);
            addButton.setHoverText(this.i18ni("add_filter"));
            GuiTexture addIcon = new GuiTexture(10, 10, BCGuiSprites.get("add"));
            addButton.onPressed(() -> {
                GuiSelectDialog<FilterType> dialog = new GuiSelectDialog<FilterType>(this.gui);
                dialog.setCloseOnSelection(true);
                dialog.setListSpacing(1);
                dialog.setInsets(2, 2, 2, 2);
                dialog.setRendererBuilder(type -> {
                    GuiButton button = new GuiButton(this.i18ni(type.name().toLowerCase(Locale.ENGLISH))).set3dText(true);
                    button.setInsets(5, 0, 5, 0);
                    button.setSize(dialog.getInsetRect().x, 14);
                    GuiBorderedRect buttonBG = (GuiBorderedRect)((GuiBorderedRect)((GuiBorderedRect)new GuiBorderedRect().setDoubleBorder(1.0).setXPos(button.xPos())).setYSizeMod(button::ySize)).bindSize(button, false);
                    buttonBG.setFillColourL(GuiToolkit.Palette.Ctrl::fill);
                    buttonBG.setBorderColourL(GuiToolkit.Palette.Ctrl::border3D);
                    buttonBG.set3dTopLeftColourL(hovering -> button.isPressed() ? GuiToolkit.Palette.Ctrl.accentDark(hovering) : GuiToolkit.Palette.Ctrl.accentLight(hovering));
                    buttonBG.set3dBottomRightColourL(hovering -> button.isPressed() ? GuiToolkit.Palette.Ctrl.accentLight(hovering) : GuiToolkit.Palette.Ctrl.accentDark(hovering));
                    button.addChild(buttonBG);
                    return button;
                });
                dialog.setSelectionListener(e -> {
                    GuiButton.playGenericClick();
                    this.gui.entityFilter.clientAddNode((FilterType)((Object)((Object)e)), (FilterGroup)this.getNode());
                });
                DataUtils.forEachMatch(FilterType.values(), e -> (e != FilterType.FILTER_GROUP || this.depth < maxDepth) && this.gui.entityFilter.isFilterAllowed((FilterType)((Object)((Object)e))), dialog::addItem);
                dialog.setSize(100, dialog.getItems().size() * 15 + 3);
                dialog.addBackGroundChild((GuiBorderedRect)new GuiBorderedRect().set3DGetters(GuiToolkit.Palette.SubItem::fill, GuiToolkit.Palette.SubItem::accentLight, GuiToolkit.Palette.SubItem::accentDark).setDoubleBorder(1.0).setBorderColourL(e -> GuiToolkit.Palette.SubItem.border3d()).setPosAndSize(dialog));
                dialog.setPos(addButton.maxXPos() - 100, addButton.maxYPos() + 2);
                dialog.show(500);
            });
            addButton.addChild(addIcon);
            ((GuiButton)addButton.setYPos(this.yPos() + 1)).setXPosMod(() -> this.trash.xPos() - 11);
            addIcon.setXPosMod(addButton::xPos);
            this.addChild(addButton);
            addButton.setEnabledCallback(() -> this.gui.entityFilter.nodeMap.size() < this.gui.entityFilter.maxFilters);
            GuiButton matchButton = (GuiButton)((GuiButton)new GuiButton().setShadow(true).setYSize(10)).setInsets(0, 0, 0, 0);
            matchButton.setDisplaySupplier(() -> ChatFormatting.UNDERLINE + this.i18ni("and_group.button." + this.isAndNode()));
            matchButton.setHoverText((E e) -> this.i18ni("and_group." + this.isAndNode()));
            matchButton.onPressed(() -> {
                if (this.getNode() != null) {
                    ((FilterGroup)this.getNode()).setAndGroup(!((FilterGroup)this.getNode()).isAndGroup());
                }
            });
            ((GuiButton)matchButton.setYPos(this.yPos() + 1)).setXPosMod(() -> addButton.xPos() - this.fontRenderer.m_92895_(matchButton.getDisplayString()) - 1);
            matchButton.setXSizeMod(() -> this.fontRenderer.m_92895_(matchButton.getDisplayString()));
            this.addChild(matchButton);
            this.updateChildNodes();
        }

        protected boolean stillHasNode(int nodeID) {
            return this.getNode() != null && ((FilterGroup)this.getNode()).getSubNodeMap().containsKey(nodeID);
        }

        protected void removeNode(NodeElement element) {
            this.removeChild(element);
            element.onRemoved();
            if (this.nodeElements.containsKey(element.nodeID)) {
                this.nodeElements.remove(element.nodeID);
                this.gui.rootNode.updateChildNodes();
                this.gui.rootNode.updateChildNodes();
            }
        }

        protected void updateChildNodes() {
            FilterGroup node;
            this.reportYSizeChange = false;
            this.setYSize(12);
            this.reportYSizeChange = true;
            if (this.getNode() instanceof EntityFilter) {
                ((GuiElement)this.setXPos(this.gui.scrollElement.getInsetRect().x)).setXSize(this.gui.scrollElement.getInsetRect().width);
            }
            if ((node = (FilterGroup)this.getNode()) == null) {
                if (this.parentGroup != null) {
                    this.parentGroup.removeNode(this);
                }
                return;
            }
            int yPos = this.yPos() + 12 + 1;
            for (int nodeID : node.getSubNodeMap().keySet()) {
                NodeElement element;
                if (!this.nodeElements.containsKey(nodeID)) {
                    element = this.gui.createElementFor(node.getSubNodeMap().get(nodeID));
                    element.parentGroup = this;
                    element.depth = this.depth + 1;
                    this.addChild(element);
                    this.nodeElements.put(nodeID, (Object)element);
                }
                element = (NodeElement)this.nodeElements.get(nodeID);
                ((GuiElement)element.setXSizeMod(() -> this.xSize() - 6)).setPos(this.xPos() + 4, yPos);
                if (element instanceof GroupElement) {
                    ((GroupElement)element).updateChildNodes();
                }
                yPos += element.ySize() + 1;
            }
            this.setYSize(this.getEnclosingRect().height + (this.nodeElements.isEmpty() ? 0 : 2));
            this.setYSize(this.ySize());
        }

        @Override
        public boolean onUpdate() {
            if (this.getNode() != null) {
                if (!((FilterGroup)this.getNode()).getSubNodeMap().keySet().stream().allMatch(arg_0 -> this.nodeElements.containsKey(arg_0))) {
                    this.gui.rootNode.updateChildNodes();
                    return true;
                }
            }
            return super.onUpdate();
        }

        private boolean isAndNode() {
            return this.getNode() != null && ((FilterGroup)this.getNode()).isAndGroup();
        }
    }

    public static class NodeHostile
    extends NodeElement<FilterHostile> {
        public NodeHostile(GuiEntityFilter gui, FilterHostile filterNode) {
            super(gui, filterNode);
            this.setYSize(12);
        }

        @Override
        public void addChildElements() {
            super.addChildElements();
            this.nodeLabel.setEnabled(false);
            GuiButton toggleHostile = new GuiButton();
            ((GuiButton)((GuiButton)toggleHostile.setPos(this)).setYSize(this.ySize())).setXSizeMod(() -> this.xSize() - 12);
            toggleHostile.setDisplaySupplier(() -> this.i18ni("hostile." + (this.getNode() != null && ((FilterHostile)this.getNode()).isWhitelistHostile())));
            toggleHostile.setAlignment(GuiAlign.LEFT);
            toggleHostile.getInsets().left = 2;
            toggleHostile.onPressed(() -> {
                if (this.getNode() != null) {
                    ((FilterHostile)this.getNode()).setWhitelistHostile(!((FilterHostile)this.getNode()).isWhitelistHostile());
                }
            });
            this.addChild(toggleHostile);
        }
    }

    public static class NodeTamed
    extends NodeElement<FilterTamed> {
        public NodeTamed(GuiEntityFilter gui, FilterTamed filterNode) {
            super(gui, filterNode);
            this.setYSize(22);
        }

        @Override
        public void addChildElements() {
            super.addChildElements();
            this.nodeLabel.setEnabled(false);
            GuiButton toggleTamed = new GuiButton();
            ((GuiButton)((GuiButton)toggleTamed.setPos(this.xPos(), this.yPos() + 2)).setYSize(8)).setXSizeMod(() -> this.xSize() - 12);
            toggleTamed.setDisplaySupplier(() -> this.i18ni("tamed." + (this.getNode() != null && ((FilterTamed)this.getNode()).isWhitelistTamed())));
            toggleTamed.setAlignment(GuiAlign.LEFT);
            toggleTamed.getInsets().left = 2;
            toggleTamed.onPressed(() -> {
                if (this.getNode() != null) {
                    ((FilterTamed)this.getNode()).setWhitelistTamed(!((FilterTamed)this.getNode()).isWhitelistTamed());
                }
            });
            this.addChild(toggleTamed);
            GuiButton toggleTamable = new GuiButton();
            ((GuiButton)((GuiButton)toggleTamable.setPos(this.xPos(), this.yPos() + 12)).setYSize(8)).setXSizeMod(() -> this.xSize() - 12);
            toggleTamable.setDisplaySupplier(() -> "[ " + this.i18ni("tamable." + (this.getNode() != null && ((FilterTamed)this.getNode()).isIncludeTamable())) + " ]");
            toggleTamable.setHoverText((E e) -> this.i18ni("tamable.info"));
            toggleTamable.setAlignment(GuiAlign.LEFT);
            toggleTamable.getInsets().left = 6;
            toggleTamable.onPressed(() -> {
                if (this.getNode() != null) {
                    ((FilterTamed)this.getNode()).setIncludeTamable(!((FilterTamed)this.getNode()).isIncludeTamable());
                }
            });
            this.addChild(toggleTamable);
        }
    }

    public static class NodeAdults
    extends NodeElement<FilterAdults> {
        public NodeAdults(GuiEntityFilter gui, FilterAdults filterNode) {
            super(gui, filterNode);
            this.setYSize(22);
        }

        @Override
        public void addChildElements() {
            super.addChildElements();
            this.nodeLabel.setEnabled(false);
            GuiButton toggleAdults = new GuiButton();
            ((GuiButton)((GuiButton)toggleAdults.setPos(this.xPos(), this.yPos() + 2)).setYSize(8)).setXSizeMod(() -> this.xSize() - 12);
            toggleAdults.setDisplaySupplier(() -> this.i18ni("adults." + (this.getNode() != null && ((FilterAdults)this.getNode()).isWhitelistAdults())));
            toggleAdults.setAlignment(GuiAlign.LEFT);
            toggleAdults.getInsets().left = 2;
            toggleAdults.onPressed(() -> {
                if (this.getNode() != null) {
                    ((FilterAdults)this.getNode()).setWhitelistAdults(!((FilterAdults)this.getNode()).isWhitelistAdults());
                }
            });
            this.addChild(toggleAdults);
            GuiButton toggleAgeable = new GuiButton();
            ((GuiButton)((GuiButton)toggleAgeable.setPos(this.xPos(), this.yPos() + 12)).setYSize(8)).setXSizeMod(() -> this.xSize() - 12);
            toggleAgeable.setDisplaySupplier(() -> "[ " + this.i18ni("non_ageable." + (this.getNode() != null && ((FilterAdults)this.getNode()).isIncludeNonAgeable())) + " ]");
            toggleAgeable.setHoverText((E e) -> this.i18ni("non_ageable.info"));
            toggleAgeable.setAlignment(GuiAlign.LEFT);
            toggleAgeable.getInsets().left = 6;
            toggleAgeable.onPressed(() -> {
                if (this.getNode() != null) {
                    ((FilterAdults)this.getNode()).setIncludeNonAgeable(!((FilterAdults)this.getNode()).isIncludeNonAgeable());
                }
            });
            this.addChild(toggleAgeable);
        }
    }

    public static class NodePlayers
    extends NodeElement<FilterPlayer> {
        public NodePlayers(GuiEntityFilter gui, FilterPlayer filterNode) {
            super(gui, filterNode);
            this.setYSize(22);
        }

        @Override
        public void addChildElements() {
            super.addChildElements();
            this.nodeLabel.setEnabled(false);
            GuiButton toggleIncludePlayers = new GuiButton();
            ((GuiButton)((GuiButton)toggleIncludePlayers.setPos(this.xPos(), this.yPos() + 2)).setYSize(8)).setXSizeMod(() -> this.xSize() - 12);
            toggleIncludePlayers.setDisplaySupplier(() -> this.i18ni("player." + (this.getNode() != null && ((FilterPlayer)this.getNode()).isWhitelistPlayers())));
            toggleIncludePlayers.setAlignment(GuiAlign.LEFT);
            toggleIncludePlayers.getInsets().left = 2;
            toggleIncludePlayers.onPressed(() -> {
                if (this.getNode() != null) {
                    ((FilterPlayer)this.getNode()).setWhitelistPlayers(!((FilterPlayer)this.getNode()).isWhitelistPlayers());
                }
            });
            toggleIncludePlayers.setHoverText(this.i18ni("player.info"));
            this.addChild(toggleIncludePlayers);
            GuiLabel nameLabel = new GuiLabel(this.i18ni("player.name")).setShadow(false).setTextColour(this.gui.nodeTitleColour.getColour());
            ((GuiLabel)nameLabel.setPos(this.xPos() + 2, this.yPos() + 12)).setWidthFromText(8);
            this.addChild(nameLabel);
            GuiTextField nameField = new GuiTextField();
            nameField.linkExternalValue(() -> this.getNode() == null ? "" : ((FilterPlayer)this.getNode()).getPlayerName(), s -> {
                if (this.getNode() != null) {
                    ((FilterPlayer)this.getNode()).setPlayerName((String)s);
                }
            });
            nameField.setFilter(s -> FilterPlayer.namePattern.matcher((CharSequence)s).find());
            nameField.setMaxLength(16);
            ((GuiTextField)((GuiTextField)nameField.setPos(nameLabel.maxXPos() + 1, this.yPos() + 12)).setYSize(10)).setXSizeMod(() -> this.xSize() - (nameLabel.xSize() + 15));
            this.addChild(nameField);
        }
    }

    public static class NodeEntityType
    extends NodeElement<FilterEntity> {
        public NodeEntityType(GuiEntityFilter gui, FilterEntity filterNode) {
            super(gui, filterNode);
            this.setYSize(22);
        }

        @Override
        public void addChildElements() {
            super.addChildElements();
            this.nodeLabel.setEnabled(false);
            GuiButton toggleIncludeEntity = new GuiButton();
            ((GuiButton)((GuiButton)toggleIncludeEntity.setPos(this.xPos(), this.yPos() + 2)).setYSize(8)).setXSizeMod(() -> this.xSize() - 12);
            toggleIncludeEntity.setDisplaySupplier(() -> this.i18ni("entity_type." + (this.getNode() != null && ((FilterEntity)this.getNode()).isWhitelistEntity())));
            toggleIncludeEntity.setAlignment(GuiAlign.LEFT);
            toggleIncludeEntity.getInsets().left = 2;
            toggleIncludeEntity.onPressed(() -> {
                if (this.getNode() != null) {
                    ((FilterEntity)this.getNode()).setWhitelistEntity(!((FilterEntity)this.getNode()).isWhitelistEntity());
                }
            });
            this.addChild(toggleIncludeEntity);
            GuiLabel nameLabel = new GuiLabel(this.i18ni("entity_type.name")).setShadow(false).setTextColour(this.gui.nodeTitleColour.getColour());
            ((GuiLabel)nameLabel.setPos(this.xPos() + 2, this.yPos() + 12)).setWidthFromText(8);
            this.addChild(nameLabel);
            GuiTextField nameField = new GuiTextField();
            nameField.setFilter(ResourceLocation::m_135830_);
            nameField.linkExternalValue(() -> this.getNode() == null ? "" : ((FilterEntity)this.getNode()).getEntityName(), s -> {
                if (this.getNode() != null) {
                    ((FilterEntity)this.getNode()).setEntityName((String)s);
                    ResourceLocation rs = new ResourceLocation(s);
                    EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(rs);
                    boolean exists = ForgeRegistries.ENTITIES.containsKey(rs);
                    String name = exists ? type.m_20675_() : "unknown";
                    nameField.setTextColor(exists ? 65280 : 0xFF0000);
                    Optional mod = ModList.get().getModContainerById(rs.m_135827_());
                    String modName = mod.isPresent() ? ((ModContainer)mod.get()).getModInfo().getDisplayName() : "[unknown-mod]";
                    String entityName = I18n.m_118938_((String)name, (Object[])new Object[0]);
                    if (exists) {
                        nameField.setHoverText(entityName, ChatFormatting.BLUE + ChatFormatting.ITALIC + modName);
                    } else {
                        nameField.setHoverText(ChatFormatting.RED + "Unknown entity string");
                    }
                }
            });
            nameField.setMaxLength(512);
            ((GuiTextField)((GuiTextField)nameField.setPos(nameLabel.maxXPos() + 1, this.yPos() + 12)).setYSize(10)).setXSizeMod(() -> this.xSize() - (nameLabel.xSize() + 15));
            this.addChild(nameField);
            GuiButton select = new GuiButton("...").setFillColour(-16777216).setBorderColour(-13619152);
            ((GuiButton)((GuiButton)((GuiButton)select.setYPos(this.yPos() + 12)).setXPosMod(() -> this.maxXPos() - 10)).setYSize(8)).setXSize(8);
            select.setHoverText(this.i18ni("entity_type.find"));
            select.setInsets(0, 1, 3, 0);
            select.onPressed(() -> {
                GuiSelectDialog<ResourceLocation> dialog = new GuiSelectDialog<ResourceLocation>(this.gui);
                dialog.setCloseOnSelection(true);
                dialog.setListSpacing(1);
                dialog.setInsets(3, 3, 15, 2);
                dialog.setRendererBuilder(rs -> {
                    GuiElement container = new GuiElement();
                    container.setYSize(20);
                    GuiEntityRenderer renderer = new GuiEntityRenderer().setEntity((ResourceLocation)rs);
                    renderer.setSize(16, 16);
                    renderer.setPos(8, 2);
                    container.addChild(renderer);
                    EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(rs);
                    String name = type == null ? "unknown" : type.m_20676_().getString();
                    GuiLabel label = new GuiLabel(I18n.m_118938_((String)I18n.m_118938_((String)name, (Object[])new Object[0]), (Object[])new Object[0]));
                    ((GuiLabel)((GuiLabel)label.setPos(renderer.maxXPos() + 6, container.yPos() + 2)).setWrap(true).setYSize(container.ySize() - 4)).setXSizeMod(() -> container.xSize() - 26);
                    container.addChild(label);
                    label.zOffset += 5.0;
                    GuiBorderedRect buttonBG = (GuiBorderedRect)((GuiBorderedRect)((GuiBorderedRect)new GuiBorderedRect().setDoubleBorder(0.0).setXPos(container.xPos())).setYSizeMod(container::ySize)).bindSize(container, false);
                    buttonBG.setFillColourL(h -> GuiToolkit.Palette.SubItem.fill());
                    buttonBG.setBorderColourL(h -> GuiToolkit.Palette.SubItem.border3d());
                    buttonBG.set3dTopLeftColourL(h -> GuiToolkit.Palette.SubItem.accentLight());
                    buttonBG.set3dBottomRightColourL(h -> GuiToolkit.Palette.SubItem.accentDark());
                    container.addChild(buttonBG);
                    return container;
                });
                dialog.setSelectionListener(rs -> {
                    GuiButton.playGenericClick();
                    if (this.getNode() != null) {
                        nameField.setValueQuietly(rs.toString());
                    }
                });
                DataUtils.forEachMatch(ForgeRegistries.ENTITIES.getEntries(), e -> ((EntityType)e.getValue()).m_20615_((Level)this.mc.f_91073_) instanceof LivingEntity, e -> dialog.addItem(((ResourceKey)e.getKey()).m_135782_()));
                dialog.setSize(150, 190);
                dialog.addBackGroundChild((GuiBorderedRect)new GuiBorderedRect().set3DGetters(GuiToolkit.Palette.SubItem::fill, GuiToolkit.Palette.SubItem::accentLight, GuiToolkit.Palette.SubItem::accentDark).setDoubleBorder(1.0).setBorderColourL(e -> GuiToolkit.Palette.SubItem.border3d()).setPosAndSize(dialog));
                GuiTextField filter = new GuiTextField();
                filter.zOffset += 5.0;
                ((GuiTextField)filter.setSize(dialog.xSize() - 6, 12)).setPos(dialog.xPos() + 3, dialog.maxYPos() - 15);
                filter.onValueChanged(s -> {
                    dialog.clearItems();
                    DataUtils.forEachMatch(ForgeRegistries.ENTITIES.getEntries(), e -> {
                        EntityType type = (EntityType)e.getValue();
                        boolean pass = s.isEmpty() || type.toString().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH));
                        String name = type.m_20676_().getString();
                        if (!pass && name.toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))) {
                            pass = true;
                        }
                        return pass && type.m_20615_((Level)this.mc.f_91073_) instanceof LivingEntity;
                    }, e -> dialog.addItem(((ResourceKey)e.getKey()).m_135782_()));
                });
                GuiLabel searchLabel = new GuiLabel(this.i18ni("search")).setTextColour(0xB0B0B0).setShadow(false);
                ((GuiLabel)searchLabel.setPosAndSize(filter)).translate(0, 1);
                searchLabel.setAlignment(GuiAlign.LEFT);
                searchLabel.getInsets().left = 3;
                searchLabel.setEnabledCallback(() -> filter.getValue().isEmpty() && !filter.isFocused());
                filter.addChild(searchLabel);
                dialog.addChild(filter);
                filter.zOffset += 1.0;
                searchLabel.zOffset += 1.0;
                dialog.showCenter(500);
                this.gui.scrollBarCustomizer.accept(dialog.scrollElement.getVerticalScrollBar());
            });
            this.addChild(select);
        }
    }

    public static class NodeItem
    extends NodeElement<FilterItem> {
        private GuiTextField countField;
        private GuiTextField metaField;
        private GuiTextField nbtField;
        private GuiStackIcon stackIcon;

        public NodeItem(GuiEntityFilter gui, FilterItem filterNode) {
            super(gui, filterNode);
            this.setYSize(41);
        }

        @Override
        public void addChildElements() {
            super.addChildElements();
            this.nodeLabel.setEnabled(false);
            GuiButton toggleWhiteList = new GuiButton();
            ((GuiButton)((GuiButton)toggleWhiteList.setPos(this.xPos(), this.yPos() + 2)).setYSize(8)).setXSizeMod(() -> this.xSize() - 12);
            toggleWhiteList.setDisplaySupplier(() -> this.i18ni("item_filter." + (this.getNode() != null && ((FilterItem)this.getNode()).isWhitelistItem())));
            toggleWhiteList.setAlignment(GuiAlign.LEFT);
            toggleWhiteList.getInsets().left = 2;
            toggleWhiteList.onPressed(() -> {
                if (this.getNode() != null) {
                    ((FilterItem)this.getNode()).setWhitelistItem(!((FilterItem)this.getNode()).isWhitelistItem());
                }
            });
            this.addChild(toggleWhiteList);
            this.stackIcon = new GuiStackIcon(ItemStack.f_41583_);
            this.updateStackIcon();
            this.stackIcon.setToolTip(false);
            this.stackIcon.addSlotBackground();
            this.stackIcon.setPos(this.xPos() + 2, this.yPos() + 11);
            this.stackIcon.setClickListener(() -> {
                if (this.getNode() != null) {
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    if (!player.f_36096_.m_142621_().m_41619_()) {
                        ItemStack stack = player.f_36096_.m_142621_().m_41777_();
                        stack.m_41764_(1);
                        ((FilterItem)this.getNode()).setItemName(stack.m_41720_().getRegistryName().toString());
                        ((FilterItem)this.getNode()).setDamage(stack.m_41763_() ? stack.m_41773_() : -1);
                        ((FilterItem)this.getNode()).setNbt(stack.m_41783_());
                    } else {
                        ((FilterItem)this.getNode()).setItemName("");
                    }
                }
            });
            this.addChild(this.stackIcon);
            this.stackIcon.addToGroup("[ENTITY_FILTER_STACK_DROP]");
            this.modularGui.getJEIDropTargets().add(this.stackIcon);
            this.stackIcon.setIngredientDropListener(e -> {
                if (e instanceof ItemStack && this.getNode() != null) {
                    ItemStack stack = ((ItemStack)e).m_41777_();
                    stack.m_41764_(1);
                    ((FilterItem)this.getNode()).setItemName(stack.m_41720_().getRegistryName().toString());
                    ((FilterItem)this.getNode()).setDamage(stack.m_41763_() ? stack.m_41773_() : -1);
                    ((FilterItem)this.getNode()).setNbt(stack.m_41783_());
                }
            });
            this.stackIcon.setEnabledCallback(() -> this.gui.scrollElement.getInsetRect().intersects(this.stackIcon.getRect()));
            GuiLabel countLabel = new GuiLabel(this.i18ni("item.count")).setShadow(false).setTextColour(this.gui.nodeTitleColour.getColour());
            ((GuiLabel)countLabel.setPos(this.stackIcon.maxXPos() + 2, this.yPos() + 12)).setWidthFromText(8);
            countLabel.setHoverText(this.i18ni("item.count.info"));
            this.addChild(countLabel);
            GuiLabel metaLabel = new GuiLabel(this.i18ni("item.damage")).setShadow(false).setTextColour(this.gui.nodeTitleColour.getColour());
            ((GuiLabel)metaLabel.setPos(this.stackIcon.maxXPos() + 2, this.yPos() + 20)).setWidthFromText(8);
            metaLabel.setHoverText(this.i18ni("item.damage.info"));
            this.addChild(metaLabel);
            this.countField = new GuiTextField();
            this.countField.setHoverText(this.i18ni("item.count.info"));
            this.countField.linkExternalValue(() -> this.getNode() == null ? "" : (((FilterItem)this.getNode()).getCount() == 0 ? "" : "" + ((FilterItem)this.getNode()).getCount()), s -> {
                if (this.getNode() != null) {
                    if (s.isEmpty()) {
                        ((FilterItem)this.getNode()).setCount(0);
                    } else {
                        ((FilterItem)this.getNode()).setCount(Utils.parseInt(s));
                    }
                }
            });
            this.countField.setFilter(s -> s.isEmpty() || Utils.validInteger(s) && Utils.parseInt(s) > 0 && Utils.parseInt(s) <= 64);
            this.countField.setMaxLength(2);
            ((GuiTextField)((GuiTextField)this.countField.setPos(Math.max(countLabel.maxXPos(), metaLabel.maxXPos()) + 1, this.yPos() + 12)).setYSize(10)).setXSize(20);
            this.addChild(this.countField);
            this.metaField = new GuiTextField();
            this.metaField.setHoverText(this.i18ni("item.damage.info"));
            this.countField.linkExternalValue(() -> this.getNode() == null ? "" : (((FilterItem)this.getNode()).getDamage() == 0 ? "" : "" + ((FilterItem)this.getNode()).getDamage()), s -> {
                if (this.getNode() != null) {
                    if (s.isEmpty()) {
                        ((FilterItem)this.getNode()).setDamage(-1);
                    } else {
                        ((FilterItem)this.getNode()).setDamage(Utils.parseInt(s));
                    }
                }
            });
            this.metaField.setFilter(s -> s.isEmpty() || Utils.validInteger(s) && Utils.parseInt(s) >= 0 && Utils.parseInt(s) <= Short.MAX_VALUE);
            this.metaField.setMaxLength(5);
            ((GuiTextField)((GuiTextField)this.metaField.setPos(Math.max(countLabel.maxXPos(), metaLabel.maxXPos()) + 1, this.yPos() + 20)).setYSize(10)).setXSize(30);
            this.addChild(this.metaField);
            GuiButton blocksItems = new GuiButton().setWrap(true);
            ((GuiButton)((GuiButton)blocksItems.setYPos(this.yPos() + 16)).setYSize(16)).setXPosMod(() -> Math.max(metaLabel.maxXPos(), countLabel.maxXPos()) + 3);
            blocksItems.setDisplaySupplier(() -> {
                if (this.getNode() != null) {
                    return ((FilterItem)this.getNode()).isFilterBlocks() ? this.i18ni("item.blocks_only") : (((FilterItem)this.getNode()).isFilterItems() ? this.i18ni("item.items_only") : this.i18ni("item.items_or_blocks"));
                }
                return "error";
            });
            blocksItems.setXSizeMod(() -> this.maxXPos() - 3 - blocksItems.xPos());
            blocksItems.setEnabledCallback(() -> this.getNode() != null && ((FilterItem)this.getNode()).getItemName().isEmpty());
            blocksItems.setAlignment(GuiAlign.RIGHT);
            blocksItems.getInsets().right = 0;
            blocksItems.getInsets().left = 0;
            blocksItems.onPressed(() -> {
                if (this.getNode() != null) {
                    if (((FilterItem)this.getNode()).isFilterItems()) {
                        ((FilterItem)this.getNode()).setFilterItemsBlocks(false, true);
                    } else if (((FilterItem)this.getNode()).isFilterBlocks()) {
                        ((FilterItem)this.getNode()).setFilterItemsBlocks(false, false);
                    } else {
                        ((FilterItem)this.getNode()).setFilterItemsBlocks(true, false);
                    }
                }
            });
            this.addChild(blocksItems);
            GuiLabel nbtLabel = new GuiLabel(this.i18ni("item.nbt")).setShadow(false).setTextColour(this.gui.nodeTitleColour.getColour());
            ((GuiLabel)nbtLabel.setPos(this.xPos() + 2, this.yPos() + 31)).setWidthFromText(8);
            nbtLabel.setHoverText(this.i18ni("item.nbt.info"));
            this.addChild(nbtLabel);
            this.nbtField = new GuiTextField();
            this.nbtField.setHoverText(this.i18ni("item.nbt.info"));
            this.nbtField.setValue(this.getNode() == null || ((FilterItem)this.getNode()).getNbt() == null ? "" : ((FilterItem)this.getNode()).getNbt().toString());
            this.nbtField.onValueChanged(s -> {
                if (this.getNode() != null) {
                    if (s.isEmpty()) {
                        ((FilterItem)this.getNode()).setNbt(null);
                        this.nbtField.setTextColor(0xFFFFFF);
                        this.nbtField.setHoverText(this.i18ni("item.nbt.info"));
                    } else {
                        try {
                            CompoundTag compound = TagParser.m_129359_((String)s);
                            ((FilterItem)this.getNode()).setNbt(compound);
                            this.nbtField.setTextColor(0xFFFFFF);
                            this.nbtField.setHoverText(this.i18ni("item.nbt.info"));
                        }
                        catch (CommandSyntaxException e) {
                            ((FilterItem)this.getNode()).setNbt(null);
                            this.nbtField.setTextColor(0xFF0000);
                            this.nbtField.setHoverText(this.i18ni("item.nbt.bad"));
                        }
                    }
                }
            });
            this.nbtField.setMaxLength(1024);
            ((GuiTextField)((GuiTextField)this.nbtField.setPos(nbtLabel.maxXPos() + 1, this.yPos() + 31)).setYSize(10)).setXSizeMod(() -> this.xSize() - (nbtLabel.xSize() + 3));
            this.addChild(this.nbtField);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            this.countField.setFocus(false);
            this.metaField.setFocus(false);
            this.nbtField.setFocus(false);
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        private void updateStackIcon() {
            if (this.getNode() != null) {
                if (((FilterItem)this.getNode()).getItemName().isEmpty()) {
                    this.stackIcon.setStack(ItemStack.f_41583_);
                    this.stackIcon.setHoverText(this.i18ni("set_stack"));
                } else {
                    ItemStack stack = StringyStacks.legacyStackConverter(((FilterItem)this.getNode()).getItemName(), ((FilterItem)this.getNode()).getCount(), ((FilterItem)this.getNode()).getDamage(), ((FilterItem)this.getNode()).getNbt());
                    this.stackIcon.setStack(stack);
                    List tooltip = stack.m_41651_((Player)this.mc.f_91074_, (TooltipFlag)(this.mc.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                    tooltip.add(new TextComponent(ChatFormatting.GRAY + "----------------------------"));
                    tooltip.add(new TranslatableComponent("set_stack"));
                    this.stackIcon.setComponentHoverText(tooltip);
                }
            }
        }

        @Override
        public boolean onUpdate() {
            if (this.getNode() != null && ((FilterItem)this.getNode()).dataChanged) {
                this.nbtField.setValue(this.getNode() == null || ((FilterItem)this.getNode()).getNbt() == null ? "" : ((FilterItem)this.getNode()).getNbt().toString());
                this.updateStackIcon();
                ((FilterItem)this.getNode()).dataChanged = false;
            }
            return super.onUpdate();
        }

        @Override
        protected void onRemoved() {
            this.modularGui.getJEIDropTargets().remove(this.stackIcon);
        }
    }

    private static abstract class NodeElement<T extends FilterBase>
    extends GuiElement {
        protected GuiEntityFilter gui;
        protected GroupElement parentGroup;
        protected int nodeID;
        protected String filterNameKey;
        public GuiLabel nodeLabel;
        public GuiElement background;
        protected int depth = 1;
        private int trashTimer = 0;
        private int trashClicks = 0;
        protected GuiButton trash;

        public NodeElement(GuiEntityFilter gui, T filterNode) {
            this.reportYSizeChange = true;
            this.gui = gui;
            this.nodeID = ((FilterBase)filterNode).getNodeId();
            this.filterNameKey = ((FilterBase)filterNode).getTranslationKey();
            this.elementTranslationExt = "entity_filter";
        }

        @Override
        public void addChildElements() {
            this.background = this.gui.nodeBgBuilder.get();
            ((GuiElement)((GuiElement)this.background.setPos(this)).setXSizeMod(this::xSize)).setYSize(this.ySize());
            this.addChild(this.background);
            this.nodeLabel = new GuiLabel(I18n.m_118938_((String)this.filterNameKey, (Object[])new Object[0]));
            this.nodeLabel.setHoverableTextCol(hovering -> this.gui.nodeTitleColour.getColour());
            this.nodeLabel.setWidthFromText(10);
            this.nodeLabel.setShadow(false);
            this.nodeLabel.setRelPos(this, 2, 1);
            this.addChild(this.nodeLabel);
            this.trash = (GuiButton)new GuiButton().setSize(10, 10);
            this.trash.setHoverText(this.i18ni("delete." + (this.nodeID == 0 ? "all" : "node")));
            GuiTexture icon = new GuiTexture(10, 10, () -> BCGuiSprites.get(this.nodeID == 0 ? "delete_all" : "delete"));
            this.trash.onPressed(() -> {
                ++this.trashClicks;
                if (this.trashClicks == 3 && this.nodeID == 0) {
                    this.gui.entityFilter.clientClearFilter();
                } else if (this.trashClicks == 2 && this.nodeID != 0) {
                    this.gui.entityFilter.clientRemoveNode(this.nodeID);
                }
                this.trashTimer = 20;
            });
            this.trash.addChild(icon);
            ((GuiButton)this.trash.setYPos(this.yPos() + 1)).setXPosMod(() -> this.maxXPos() - 11);
            icon.setXPosMod(this.trash::xPos);
            this.addChild(this.trash);
            super.addChildElements();
        }

        @Override
        public boolean onUpdate() {
            if (this.parentGroup != null && !this.parentGroup.stillHasNode(this.nodeID)) {
                this.parentGroup.removeNode(this);
                return true;
            }
            if (this.trashTimer > 0) {
                --this.trashTimer;
                if (this.trashTimer == 0) {
                    this.trashClicks = 0;
                }
            }
            return super.onUpdate();
        }

        public T getNode() {
            FilterBase node = this.gui.entityFilter.getNode(this.nodeID);
            return (T)node;
        }

        @Override
        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }

        protected void onRemoved() {
        }
    }
}

