/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.api.power.IOInfo;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.client.shader.BCShaders;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Quaternion;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;

public class GuiEnergyBar
extends GuiElement<GuiEnergyBar> {
    private static final RenderType SHADER_TYPE = RenderType.m_173215_((String)"starfield", (VertexFormat)DefaultVertexFormat.f_85814_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> BCShaders.energyBarShader)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(BCGuiSprites.ATLAS_LOCATION, false, false)).m_110691_(false));
    private IOPStorage energyHandler = null;
    private Supplier<Long> capacitySupplier = null;
    private Supplier<Long> energySupplier = null;
    private boolean rfMode = false;
    private Supplier<Boolean> shaderEnabled = () -> true;
    private Supplier<Boolean> drawHoveringText = () -> true;
    private Supplier<Boolean> disabled = () -> false;

    public GuiEnergyBar() {
        this.setSize(14, 14);
        this.elementTranslationExt = "energy_bar";
    }

    public GuiEnergyBar(int xPos, int yPos) {
        super(xPos, yPos);
        this.elementTranslationExt = "energy_bar";
    }

    public GuiEnergyBar(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
        this.elementTranslationExt = "energy_bar";
    }

    public GuiEnergyBar setEnergySupplier(Supplier<Long> energySupplier) {
        this.energySupplier = energySupplier;
        return this;
    }

    public GuiEnergyBar setCapacitySupplier(Supplier<Long> capacitySupplier) {
        this.capacitySupplier = capacitySupplier;
        return this;
    }

    public GuiEnergyBar setItemSupplier(Supplier<ItemStack> stackSupplier) {
        this.capacitySupplier = () -> EnergyUtils.isEnergyItem((ItemStack)stackSupplier.get()) ? EnergyUtils.getMaxEnergyStored((ItemStack)stackSupplier.get()) : 0L;
        this.energySupplier = () -> EnergyUtils.isEnergyItem((ItemStack)stackSupplier.get()) ? EnergyUtils.getEnergyStored((ItemStack)stackSupplier.get()) : 0L;
        return this;
    }

    public GuiEnergyBar setShaderEnabled(Supplier<Boolean> shaderEnabled) {
        this.shaderEnabled = shaderEnabled;
        return this;
    }

    public GuiEnergyBar setDisabled(Supplier<Boolean> disabled) {
        this.disabled = disabled;
        return this;
    }

    public GuiEnergyBar setRfMode(boolean rfMode) {
        this.rfMode = rfMode;
        return this;
    }

    public GuiEnergyBar setDrawHoveringText(boolean drawHoveringText) {
        this.drawHoveringText = () -> drawHoveringText;
        return this;
    }

    public GuiEnergyBar setDrawHoveringText(Supplier<Boolean> drawHoveringText) {
        this.drawHoveringText = drawHoveringText;
        return this;
    }

    public GuiEnergyBar setEnergyStorage(IOPStorage energyHandler) {
        this.energyHandler = energyHandler;
        return this;
    }

    protected boolean isRfMode() {
        return this.rfMode;
    }

    protected long getCapacity() {
        if (this.capacitySupplier != null) {
            return this.capacitySupplier.get();
        }
        if (this.energyHandler != null) {
            return this.energyHandler.getMaxOPStored();
        }
        return 0L;
    }

    protected long getEnergy() {
        if (this.energySupplier != null) {
            return this.energySupplier.get();
        }
        if (this.energyHandler != null) {
            return this.energyHandler.getOPStored();
        }
        return 0L;
    }

    protected IOInfo getIOInfo() {
        return this.energyHandler != null ? this.energyHandler.getIOInfo() : null;
    }

    protected float getSOC() {
        return MathHelper.clip((float)((float)this.getEnergy() / (float)Math.max(1L, this.getCapacity())), (float)0.0f, (float)1.0f);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        boolean horizontal = this.xSize() > this.ySize();
        int barLength = horizontal ? this.xSize() : this.ySize();
        int barWidth = horizontal ? this.ySize() : this.xSize();
        double charge = this.getSOC();
        if (Double.isNaN(charge)) {
            charge = 0.0;
        }
        int draw = (int)(charge * (double)(barLength - 2));
        int posY = this.yPos();
        int posX = this.xPos();
        PoseStack poseStack = new PoseStack();
        if (horizontal) {
            int x = posY;
            posY = posX;
            posX = x;
            poseStack.m_85837_((double)(barLength + posY * 2), 0.0, (double)this.getRenderZLevel());
            poseStack.m_85845_(new Quaternion(0.0f, 0.0f, 90.0f, true));
        }
        MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
        int light = -1;
        int dark = BCConfig.darkMode ? -8355712 : -11513776;
        GuiHelper.drawShadedRect((MultiBufferSource)getter, poseStack, posX, posY, barWidth, barLength, 1.0, 0, dark, light, GuiEnergyBar.midColour(light, dark));
        if (this.disabled.get().booleanValue()) {
            GuiHelper.drawRect((MultiBufferSource)getter, poseStack, posX + 1, posY + 1, barWidth - 2, barLength - 2, -16777216);
        } else if (!this.shaderEnabled.get().booleanValue()) {
            Material matBase = BCGuiSprites.get("bars/energy_empty");
            Material matOverlay = BCGuiSprites.get("bars/energy_full");
            TransformingVertexConsumer shaderConsumer = new TransformingVertexConsumer(getter.m_6299_(BCGuiSprites.GUI_TYPE), poseStack);
            this.sliceSprite((VertexConsumer)shaderConsumer, posX + 1, posY + 1, barWidth - 2, barLength - 2, matBase.m_119204_());
            this.sliceSprite((VertexConsumer)shaderConsumer, posX + 1, posY + barLength - draw - 1, barWidth - 2, draw, matOverlay.m_119204_());
        } else {
            Rectangle rect = this.toScreenSpace(this.xPos() + 1, this.yPos() + 1, this.xSize() - 2, this.ySize() - 2);
            BCShaders.energyBarCharge.glUniform1f(this.getSOC() * 1.01f);
            BCShaders.energyBarEPos.glUniform2i(rect.x, rect.y);
            BCShaders.energyBarESize.glUniform2i(rect.width, rect.height);
            BCShaders.energyBarScreenSize.glUniform2i(this.displayWidth(), this.displayHeight());
            TransformingVertexConsumer shaderConsumer = new TransformingVertexConsumer(getter.m_6299_(SHADER_TYPE), poseStack);
            this.drawShaderRect((VertexConsumer)shaderConsumer, posX + 1, posY + 1, barWidth - 2, barLength - 2);
        }
        getter.m_109911_();
    }

    private void drawShaderRect(VertexConsumer buffer, float x, float y, float width, float height) {
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_5752_();
        buffer.m_5483_((double)x, (double)y, 0.0).m_5752_();
    }

    public void sliceSprite(VertexConsumer buffer, int xPos, int yPos, int xSize, int ySize, TextureAtlasSprite sprite) {
        float texU = sprite.m_118409_();
        float texV = sprite.m_118411_();
        int texWidth = sprite.m_118405_();
        int texHeight = sprite.m_118408_();
        float uScale = (sprite.m_118410_() - texU) / (float)texWidth;
        float vScale = (sprite.m_118412_() - texV) / (float)texHeight;
        for (int i = 0; i < ySize; i += Math.min(texHeight - 2, ySize - i)) {
            int partSize = Math.min(texHeight, ySize - i);
            this.bufferRect(buffer, xPos, yPos + ySize - i, xSize, -partSize, sprite.m_118409_(), sprite.m_118411_(), (float)xSize * uScale, (float)partSize * vScale);
        }
    }

    private void bufferRect(VertexConsumer buffer, float x, float y, float width, float height, float minU, float minV, float tWidth, float tHeight) {
        double zLevel = this.getRenderZLevel();
        buffer.m_5483_((double)x, (double)(y + height), zLevel).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV + tHeight).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), zLevel).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU + tWidth, minV + tHeight).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, zLevel).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU + tWidth, minV).m_5752_();
        buffer.m_5483_((double)x, (double)y, zLevel).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV).m_5752_();
    }

    public Rectangle toScreenSpace(int xPos, int yPos, int xSize, int ySize) {
        double yResScale = (double)this.displayHeight() / (double)this.screenHeight;
        double xResScale = (double)this.displayWidth() / (double)this.screenWidth;
        double scaledWidth = (double)xSize * xResScale;
        double scaledHeight = (double)ySize * yResScale;
        int x = (int)((double)xPos * xResScale);
        int y = (int)((double)this.displayHeight() - (double)yPos * yResScale - scaledHeight);
        return new Rectangle(x, y, (int)scaledWidth, (int)scaledHeight);
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.drawHoveringText.get().booleanValue() && this.isMouseOver(mouseX, mouseY)) {
            long maxEnergy = this.getCapacity();
            long energy = this.getEnergy();
            String title = this.rfMode ? this.i18ni("energy_storage") : this.i18ni("operational_potential");
            boolean shift = Screen.m_96638_();
            String suffix = this.rfMode ? this.i18ni("rf") : this.i18ni("op");
            String capString = (shift ? Utils.addCommas(maxEnergy) : Utils.formatNumber(maxEnergy)) + " " + suffix;
            String storedString = (shift ? Utils.addCommas(energy) : Utils.formatNumber(energy)) + " " + suffix;
            String percent = " (" + MathUtils.round((double)energy / (double)maxEnergy * 100.0, 100.0) + "%)";
            StringBuilder builder = new StringBuilder();
            builder.append(ChatFormatting.DARK_AQUA).append(I18n.m_118938_((String)title, (Object[])new Object[0])).append("\n");
            builder.append(ChatFormatting.GOLD).append(this.i18ni("capacity")).append(" ").append(ChatFormatting.GRAY).append(capString).append("\n");
            builder.append(ChatFormatting.GOLD).append(this.i18ni("stored")).append(" ").append(ChatFormatting.GRAY).append(storedString).append(percent).append("\n");
            IOInfo ioInfo = this.getIOInfo();
            if (ioInfo != null) {
                if (shift) {
                    builder.append(ChatFormatting.GOLD).append(this.i18ni("input")).append(" ").append(ChatFormatting.GREEN).append("+").append(Utils.formatNumber(ioInfo.currentInput()));
                    builder.append(" ").append(suffix).append("/t\n");
                    builder.append(ChatFormatting.GOLD).append(this.i18ni("output")).append(" ").append(ChatFormatting.RED).append("-").append(Utils.formatNumber(ioInfo.currentOutput()));
                    builder.append(" ").append(suffix).append("/t\n");
                } else {
                    long io = ioInfo.currentInput() - ioInfo.currentOutput();
                    builder.append(ChatFormatting.GOLD).append(this.i18ni("io")).append(" ").append(io > 0L ? ChatFormatting.GREEN + "+" : (io < 0L ? ChatFormatting.RED : ChatFormatting.GRAY));
                    builder.append(Utils.formatNumber(io)).append(" ").append(suffix).append("/t\n");
                }
            }
            PoseStack poseStack = new PoseStack();
            poseStack.m_85837_(0.0, 0.0, (double)this.getRenderZLevel());
            this.renderTooltip(poseStack, Arrays.stream(builder.toString().split("\n")).map(TextComponent::new).collect(Collectors.toList()), mouseX, mouseY);
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean onUpdate() {
        return super.onUpdate();
    }
}

