/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiColourProvider;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;

public class GuiBorderedRect
extends GuiElement<GuiBorderedRect> {
    private GuiColourProvider.HoverColour<Integer> fillColour;
    private GuiColourProvider.HoverColour<Integer> borderColour;
    private GuiColourProvider.HoverColour<Integer> borderTopLeft;
    private GuiColourProvider.HoverColour<Integer> borderBottomRight;
    private boolean is3dEffect = false;
    public double borderWidth = 1.0;
    public double doubleBorder = 0.0;

    public GuiBorderedRect() {
    }

    public GuiBorderedRect(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiBorderedRect(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        boolean hovering = this.isMouseOver(mouseX, mouseY);
        MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
        if (this.is3dEffect) {
            int fill = this.getFillColour(hovering);
            int topLeft = this.getBorderTopLeft(hovering);
            int bottomRight = this.getBorderBottomRight(hovering);
            if (this.doubleBorder > 0.0) {
                int border = this.getBorderColour(hovering);
                this.drawBorderedRect((MultiBufferSource)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), this.doubleBorder, fill, border);
            }
            this.drawShadedRect((MultiBufferSource)getter, (double)this.xPos() + this.doubleBorder, (double)this.yPos() + this.doubleBorder, (double)this.xSize() - 2.0 * this.doubleBorder, (double)this.ySize() - 2.0 * this.doubleBorder, this.borderWidth, fill, topLeft, bottomRight, GuiBorderedRect.midColour(topLeft, bottomRight));
        } else {
            this.drawBorderedRect((MultiBufferSource)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), this.borderWidth, this.getFillColour(hovering), this.getBorderColour(hovering));
        }
        getter.m_109911_();
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    public GuiBorderedRect setColours(int fill, int fillHover, int border, int borderHover) {
        this.setFillColours(fill, fillHover);
        this.setBorderColours(border, borderHover);
        return this;
    }

    public GuiBorderedRect setColours(int fill, int border) {
        this.setFillColour(fill);
        this.setBorderColour(border);
        return this;
    }

    public GuiBorderedRect setColours(int fill, int topLeft, int bottomRight) {
        this.setFillColour(fill);
        this.set3dTopLeftColour(topLeft);
        this.set3dBottomRightColour(bottomRight);
        return this;
    }

    public GuiBorderedRect setBorderColourL(GuiColourProvider.HoverColour<Integer> rectBorderColour) {
        this.borderColour = rectBorderColour;
        return this;
    }

    public GuiBorderedRect setBorderColours(int border, int borderHover) {
        this.setBorderColourL(hovering -> hovering ? borderHover : border);
        return this;
    }

    public GuiBorderedRect setBorderColour(int border) {
        if (this.borderColour != null) {
            int hover = this.borderColour.getColour(true);
            this.setBorderColourL(hovering -> hovering ? hover : border);
        }
        this.setBorderColourL(hovering -> border);
        return this;
    }

    public GuiBorderedRect set3dBottomRightColourL(GuiColourProvider.HoverColour<Integer> borderBottomRight) {
        this.borderBottomRight = borderBottomRight;
        this.is3dEffect = borderBottomRight != null;
        return this;
    }

    public GuiBorderedRect set3dBottomRightColour(int border, int borderHover) {
        this.set3dBottomRightColourL(hovering -> hovering ? borderHover : border);
        return this;
    }

    public GuiBorderedRect set3dBottomRightColour(int border) {
        this.set3dBottomRightColourL(hovering -> border);
        return this;
    }

    public GuiBorderedRect set3dTopLeftColourL(GuiColourProvider.HoverColour<Integer> borderTopLeft) {
        this.borderTopLeft = borderTopLeft;
        this.is3dEffect = borderTopLeft != null;
        return this;
    }

    public GuiBorderedRect set3dTopLeftColour(int border, int borderHover) {
        this.set3dTopLeftColourL(hovering -> hovering ? borderHover : border);
        return this;
    }

    public GuiBorderedRect set3dTopLeftColour(int border) {
        this.set3dTopLeftColourL(hovering -> border);
        return this;
    }

    public GuiBorderedRect setFillColourL(GuiColourProvider.HoverColour<Integer> rectBackColour) {
        this.fillColour = rectBackColour;
        return this;
    }

    public GuiBorderedRect setFillColours(int fill, int fillHover) {
        this.setFillColourL(hovering -> hovering ? fillHover : fill);
        return this;
    }

    public GuiBorderedRect setFillColour(int fill) {
        if (this.fillColour != null) {
            int hover = this.fillColour.getColour(true);
            this.setFillColourL(hovering -> hovering ? hover : fill);
        }
        this.setFillColourL(hovering -> fill);
        return this;
    }

    public GuiBorderedRect setGetters(GuiColourProvider<Integer> fillGetter, GuiColourProvider<Integer> borderGetter) {
        this.setFillColourL(e -> (Integer)fillGetter.getColour());
        this.setBorderColourL(e -> (Integer)borderGetter.getColour());
        return this;
    }

    public GuiBorderedRect set3DGetters(GuiColourProvider<Integer> fillGetter, GuiColourProvider<Integer> topLeft, GuiColourProvider<Integer> bottomRight) {
        this.setFillColourL(e -> (Integer)fillGetter.getColour());
        this.set3dTopLeftColourL(e -> (Integer)topLeft.getColour());
        this.set3dBottomRightColourL(e -> (Integer)bottomRight.getColour());
        return this;
    }

    public GuiBorderedRect setHoverGetters(GuiColourProvider.HoverColour<Integer> fillGetter, GuiColourProvider.HoverColour<Integer> borderGetter) {
        this.setFillColourL(fillGetter);
        this.setBorderColourL(borderGetter);
        return this;
    }

    public GuiBorderedRect setHoverGetters(GuiColourProvider.HoverColour<Integer> fillGetter, GuiColourProvider.HoverColour<Integer> borderGetter, GuiColourProvider.HoverColour<Integer> shadeGetter) {
        this.setFillColourL(fillGetter);
        this.setBorderColourL(borderGetter);
        this.set3dBottomRightColourL(shadeGetter);
        return this;
    }

    public GuiBorderedRect setBorderWidth(double borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public GuiBorderedRect setDoubleBorder(double outerWidth) {
        this.doubleBorder = outerWidth;
        return this;
    }

    protected int getFillColour(boolean hover) {
        if (this.fillColour != null) {
            return this.fillColour.getColour(hover);
        }
        if (this.borderColour != null) {
            return this.borderColour.getColour(hover);
        }
        return -1;
    }

    protected int getBorderColour(boolean hover) {
        if (this.borderColour != null) {
            return this.borderColour.getColour(hover);
        }
        if (this.fillColour != null) {
            return this.fillColour.getColour(hover);
        }
        return -16777216;
    }

    protected int getBorderBottomRight(boolean hover) {
        if (this.borderBottomRight != null) {
            return this.borderBottomRight.getColour(hover);
        }
        return -16777216;
    }

    protected int getBorderTopLeft(boolean hover) {
        if (this.borderTopLeft != null) {
            return this.borderTopLeft.getColour(hover);
        }
        return -16777216;
    }
}

