/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.baseelements;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiEvent;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventDispatcher;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMouseOver;
import com.brandon3055.brandonscore.lib.functions.TriPredicate;
import com.brandon3055.brandonscore.utils.DataUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public class GuiSlideControl
extends GuiElement<GuiSlideControl>
implements IGuiEventDispatcher {
    private double dragStartX = 0.0;
    private double dragStartY = 0.0;
    private double dragStartElementX = 0.0;
    private double dragStartElementY = 0.0;
    private boolean parentScroll = false;
    private boolean reverseScrollDir = false;
    private IMouseOver parentScrollable = null;
    private List<TriPredicate<GuiSlideControl, Double, Double>> scrollChecks = new ArrayList<TriPredicate<GuiSlideControl, Double, Double>>();
    public IGuiEventListener listener;
    public Consumer<GuiSlideControl> inputListener;
    protected int sliderSize = 10;
    protected double mouseDragOffset = 0.0;
    protected double dragOutResetThreshold = 100.0;
    protected double position = 0.0;
    protected double scrollSpeed = 0.04;
    protected double posRangeMin = 0.0;
    protected double posRangeMax = 1.0;
    protected double prevPosition = 0.0;
    protected boolean isHidden = false;
    protected boolean isDragging = false;
    protected boolean allowMiddleClickDrag = false;
    protected boolean isMiddleClickDragging = false;
    protected boolean lockSliderWidthAndPos = true;
    protected boolean lockBackgroundWidthAndPos = true;
    protected SliderRotation rotation = SliderRotation.HORIZONTAL;
    protected GuiElement<? extends GuiElement> sliderElement;
    protected GuiElement<? extends GuiElement> backgroundElement;

    public GuiSlideControl() {
        this.setInsets(1, 1, 1, 1);
        this.disableOnRemove = true;
    }

    public GuiSlideControl(int xPos, int yPos) {
        super(xPos, yPos);
        this.setInsets(1, 1, 1, 1);
        this.disableOnRemove = true;
    }

    public GuiSlideControl(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
        this.setInsets(1, 1, 1, 1);
        this.disableOnRemove = true;
    }

    public GuiSlideControl(SliderRotation rotation) {
        this.rotation = rotation;
        this.setInsets(1, 1, 1, 1);
        this.disableOnRemove = true;
    }

    public GuiSlideControl(SliderRotation rotation, int xPos, int yPos) {
        super(xPos, yPos);
        this.rotation = rotation;
        this.setInsets(1, 1, 1, 1);
        this.disableOnRemove = true;
    }

    public GuiSlideControl(SliderRotation rotation, int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
        this.rotation = rotation;
        this.setInsets(1, 1, 1, 1);
        this.disableOnRemove = true;
    }

    public GuiSlideControl setListener(IGuiEventListener listener) {
        this.listener = listener;
        return this;
    }

    public GuiSlideControl setInputListener(Consumer<GuiSlideControl> inputListener) {
        this.inputListener = inputListener;
        return this;
    }

    public GuiSlideControl addInputListener(Consumer<GuiSlideControl> inputListener) {
        this.inputListener = this.inputListener == null ? inputListener : this.inputListener.andThen(inputListener);
        return this;
    }

    public GuiSlideControl setReverseScrollDir(boolean reverseScrollDir) {
        this.reverseScrollDir = reverseScrollDir;
        return this;
    }

    public Consumer<GuiSlideControl> getInputListener() {
        return this.inputListener;
    }

    @Override
    @Nullable
    public IGuiEventListener getListener() {
        return this.listener;
    }

    private boolean acceptsScrollInput(double mouseX, double mouseY) {
        for (TriPredicate<GuiSlideControl, Double, Double> check : this.scrollChecks) {
            if (check.test(this, mouseX, mouseY)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean handleMouseScroll(double mouseX, double mouseY, double scrollDirection) {
        if (!this.acceptsScrollInput(mouseX, mouseY)) {
            return super.handleMouseScroll(mouseX, mouseY, scrollDirection);
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            this.updateRawPos(this.position + (scrollDirection > 0.0 != this.reverseScrollDir ? -this.scrollSpeed : this.scrollSpeed));
            if (this.inputListener != null) {
                this.inputListener.accept(this);
            }
            return true;
        }
        if (this.parentScroll) {
            if (!(this.parentScrollable != null && this.parentScrollable.isMouseOver(mouseX, mouseY) || this.getParent() != null && this.getParent().isMouseOver(mouseX, mouseY))) {
                return super.handleMouseScroll(mouseX, mouseY, scrollDirection);
            }
            List<GuiSlideControl> slidersMouseOver = this.modularGui.getManager().getElementsAtPosition(mouseX, mouseY, GuiSlideControl.class);
            if (DataUtils.firstMatch(slidersMouseOver, slider -> slider != this && slider.isEnabled() && slider.acceptsScrollInput(mouseX, mouseY)) != null) {
                return super.handleMouseScroll(mouseX, mouseY, scrollDirection);
            }
            this.updateRawPos(this.position + (scrollDirection > 0.0 != this.reverseScrollDir ? -this.scrollSpeed : this.scrollSpeed));
            if (this.inputListener != null) {
                this.inputListener.accept(this);
            }
            return true;
        }
        return super.handleMouseScroll(mouseX, mouseY, scrollDirection);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if ((this.isMouseOver(mouseX, mouseY) && !this.isHidden() || mouseButton == 2 && this.allowMiddleClickDrag && this.getParentScrollable() != null && this.getParentScrollable().isMouseOver(mouseX, mouseY)) && this.sliderElement != null && !this.isDragging && !this.isMiddleClickDragging) {
            List<GuiSlideControl> list;
            if (mouseButton == 2 && this.getParent() != null && DataUtils.firstMatch(list = this.getParent().findChildElementsByClass(GuiSlideControl.class, new ArrayList()), e -> e != this && e.isMiddleClickDragging && e.getParentScrollable() != this.getParentScrollable()) != null) {
                return false;
            }
            this.isDragging = true;
            this.prevPosition = this.getRawPos();
            if (this.sliderElement.isMouseOver(mouseX, mouseY) && mouseButton == 0 || mouseButton == 2) {
                this.mouseDragOffset = this.rotation == SliderRotation.HORIZONTAL ? mouseX - (double)this.sliderElement.xPos() : mouseY - (double)this.sliderElement.yPos();
                if (mouseButton == 2) {
                    this.isMiddleClickDragging = true;
                    this.isDragging = false;
                    this.dragStartX = mouseX;
                    this.dragStartY = mouseY;
                    this.dragStartElementX = this.sliderElement.xPos();
                    this.dragStartElementY = this.sliderElement.yPos();
                    return false;
                }
            } else if (mouseButton == 0) {
                this.mouseDragOffset = this.sliderSize / 2;
                if (this.rotation == SliderRotation.HORIZONTAL) {
                    this.sliderElement.setXPos((int)mouseX - this.sliderElement.xSize() / 2);
                    double maxXOffset = this.getInsetRect().width - this.sliderElement.xSize();
                    double xOffset = this.sliderElement.xPos() - this.getInsetRect().x;
                    this.updateRawPos(xOffset / maxXOffset);
                    if (this.inputListener != null) {
                        this.inputListener.accept(this);
                    }
                } else {
                    this.sliderElement.setYPos((int)mouseY - this.sliderElement.ySize() / 2);
                    double maxYOffset = this.getInsetRect().height - this.sliderElement.ySize();
                    double yOffset = this.sliderElement.yPos() - this.getInsetRect().y;
                    this.updateRawPos(yOffset / maxYOffset);
                    if (this.inputListener != null) {
                        this.inputListener.accept(this);
                    }
                }
            } else {
                this.isDragging = false;
                return super.mouseClicked(mouseX, mouseY, mouseButton);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dragX, double dragY) {
        if (this.isDragging || this.isMiddleClickDragging) {
            if ((double)this.distFromElement(mouseX, mouseY) > this.dragOutResetThreshold && this.isDragging) {
                this.updateRawPos(this.prevPosition);
                if (this.inputListener != null) {
                    this.inputListener.accept(this);
                }
                return true;
            }
            if (this.rotation == SliderRotation.HORIZONTAL) {
                if (this.isMiddleClickDragging) {
                    this.sliderElement.setXPos((int)this.dragStartElementX + (int)((mouseX - this.dragStartX) * this.scrollSpeed * -2.0));
                } else {
                    this.sliderElement.setXPos((int)(mouseX - this.mouseDragOffset));
                }
                double maxXOffset = this.getInsetRect().width - this.sliderElement.xSize();
                double xOffset = this.sliderElement.xPos() - this.getInsetRect().x;
                this.updateRawPos(xOffset / maxXOffset);
                if (this.inputListener != null) {
                    this.inputListener.accept(this);
                }
            } else {
                if (this.isMiddleClickDragging) {
                    this.sliderElement.setYPos((int)this.dragStartElementY + (int)((mouseY - this.dragStartY) * this.scrollSpeed * -2.0));
                } else {
                    this.sliderElement.setYPos((int)(mouseY - this.mouseDragOffset));
                }
                double maxYOffset = this.getInsetRect().height - this.sliderElement.ySize();
                double yOffset = this.sliderElement.yPos() - this.getInsetRect().y;
                this.updateRawPos(yOffset / maxYOffset);
                if (this.inputListener != null) {
                    this.inputListener.accept(this);
                }
            }
            return !this.isMiddleClickDragging;
        }
        return super.mouseDragged(mouseX, mouseY, clickedMouseButton, dragX, dragY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        if (this.isDragging || this.isMiddleClickDragging) {
            this.isDragging = false;
            this.isMiddleClickDragging = false;
            if (this.listener != null) {
                this.listener.onMGuiEvent(new GuiEvent.SliderMoveEvent(this, this.getPosition(), this.getPosition(), false), this);
            }
            if (this.inputListener != null) {
                this.inputListener.accept(this);
            }
        }
        return super.mouseReleased(mouseX, mouseY, state);
    }

    public GuiSlideControl setRotation(SliderRotation rotation) {
        this.rotation = rotation;
        return this;
    }

    public double getPosition() {
        return MathHelper.map((double)this.getRawPos(), (double)0.0, (double)1.0, (double)this.posRangeMin, (double)this.posRangeMax);
    }

    public double getRawPos() {
        return Double.isNaN(this.position) ? 0.0 : this.position;
    }

    public GuiSlideControl updateRawPos(double position, boolean fireEvent) {
        if (this.position == position) {
            return this;
        }
        double previousPos = this.getPosition();
        this.position = MathHelper.clip((double)position, (double)0.0, (double)1.0);
        this.updateSliderPos();
        if (fireEvent && this.listener != null) {
            this.listener.onMGuiEvent(new GuiEvent.SliderMoveEvent(this, this.getPosition(), previousPos, this.isDragging), this);
        }
        return this;
    }

    public GuiSlideControl updateRawPos(double position) {
        return this.updateRawPos(position, true);
    }

    public GuiSlideControl updatePos(double position, boolean fireEvent) {
        double value = MathHelper.map((double)position, (double)this.posRangeMin, (double)this.posRangeMax, (double)0.0, (double)1.0);
        this.updateRawPos(Double.isNaN(value) ? 0.0 : value, fireEvent);
        return this;
    }

    public GuiSlideControl updatePos(double position) {
        return this.updatePos(position, true);
    }

    public GuiSlideControl setSliderElement(GuiElement sliderElement) {
        if (this.sliderElement != null) {
            this.removeChild(this.sliderElement);
        }
        this.sliderElement = sliderElement;
        this.addChild(sliderElement);
        this.updateElements();
        return this;
    }

    public GuiElement<? extends GuiElement> getSliderElement() {
        return this.sliderElement;
    }

    public GuiSlideControl setBackgroundElement(GuiElement backgroundElement) {
        if (this.backgroundElement != null) {
            this.removeChild(this.backgroundElement);
        }
        this.backgroundElement = backgroundElement;
        this.addChild(backgroundElement);
        this.updateElements();
        return this;
    }

    public GuiElement<? extends GuiElement> getBackgroundElement() {
        return this.backgroundElement;
    }

    public GuiSlideControl setSliderSize(int sliderSize) {
        int maxSize = this.rotation == SliderRotation.HORIZONTAL ? this.getInsetRect().width : this.getInsetRect().height;
        this.sliderSize = MathHelper.clip((int)sliderSize, (int)0, (int)maxSize);
        this.updateElements();
        return this;
    }

    public int getSliderSize() {
        return this.sliderSize;
    }

    public GuiSlideControl setScaledSliderSize(double scaledSize, boolean updateScrollSpeed) {
        int maxSize = this.rotation == SliderRotation.HORIZONTAL ? this.getInsetRect().width : this.getInsetRect().height;
        this.sliderSize = MathHelper.clip((int)((int)((double)maxSize * scaledSize)), (int)3, (int)maxSize);
        this.updateSliderPos();
        if (updateScrollSpeed) {
            double scrollSpeed = scaledSize / 2.0;
            this.setScrollSpeed(scrollSpeed);
        }
        return this;
    }

    public GuiSlideControl setScaledSliderSize(double scaledSize) {
        return this.setScaledSliderSize(scaledSize, true);
    }

    public GuiSlideControl lockSliderWidthPos(boolean lockSliderWidth) {
        this.lockSliderWidthAndPos = lockSliderWidth;
        return this;
    }

    public GuiSlideControl lockBackgroundWidthPos(boolean lockBackgroundWidth) {
        this.lockBackgroundWidthAndPos = lockBackgroundWidth;
        return this;
    }

    public GuiSlideControl setDefaultBackground(int fillColour, int borderColour) {
        this.lockBackgroundWidthPos(true);
        this.setBackgroundElement(new GuiBorderedRect().setColours(fillColour, borderColour));
        return this;
    }

    public GuiSlideControl setDefaultBackground(int colour) {
        return this.setDefaultBackground(colour, colour);
    }

    public GuiSlideControl setDefaultSlider(int fillColour, int hoverFillColour, int borderColour, int hoverBorderColour) {
        this.lockSliderWidthPos(true);
        this.setSliderElement(new GuiBorderedRect().setColours(fillColour, hoverFillColour, borderColour, hoverBorderColour));
        return this;
    }

    public GuiSlideControl setDefaultSlider(Supplier<Integer> fillColour, Supplier<Integer> hoverFillColour, Supplier<Integer> borderColour, Supplier<Integer> hoverBorderColour) {
        this.lockSliderWidthPos(true);
        this.setSliderElement(new GuiBorderedRect().setFillColourL(hovering -> hovering ? (Integer)hoverFillColour.get() : (Integer)fillColour.get()).setBorderColourL(hovering -> hovering ? (Integer)hoverBorderColour.get() : (Integer)borderColour.get()));
        return this;
    }

    public GuiSlideControl setDefaultSlider(int fillColour, int borderColour) {
        this.lockSliderWidthPos(true);
        this.setSliderElement(new GuiBorderedRect().setColours(fillColour, borderColour));
        return this;
    }

    public GuiSlideControl setDefaultSlider(int colour) {
        return this.setDefaultSlider(colour, colour);
    }

    public GuiSlideControl setDragOutResetThreshold(int dragOutResetThreshold) {
        this.dragOutResetThreshold = dragOutResetThreshold;
        return this;
    }

    public GuiSlideControl addScrollCheck(TriPredicate<GuiSlideControl, Double, Double> predicate) {
        this.scrollChecks.add(predicate);
        return this;
    }

    public GuiSlideControl clearScrollChecks() {
        this.scrollChecks.clear();
        return this;
    }

    public GuiSlideControl setParentScroll(boolean parentScroll) {
        this.parentScroll = parentScroll;
        return this;
    }

    public GuiSlideControl setParentScrollable(IMouseOver parentScrollable) {
        this.parentScrollable = parentScrollable;
        return this.setParentScroll(true);
    }

    public GuiSlideControl setRange(double min, double max) {
        this.posRangeMin = min;
        this.posRangeMax = max;
        return this;
    }

    public GuiSlideControl allowMiddleClickDrag(boolean allowMiddleClickDrag) {
        this.allowMiddleClickDrag = allowMiddleClickDrag;
        return this;
    }

    public GuiSlideControl setHidden(boolean hidden) {
        this.isHidden = hidden;
        return this;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public GuiSlideControl setBarStyleBackground(final int colour) {
        this.setBackgroundElement(new GuiElement(){

            @Override
            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                if (GuiSlideControl.this.rotation == SliderRotation.HORIZONTAL) {
                    this.drawColouredRect(this.xPos(), this.yPos() + this.ySize() / 2, this.xSize(), 1.0, colour);
                    this.drawColouredRect(this.xPos(), this.yPos(), 1.0, this.ySize(), colour);
                    this.drawColouredRect(this.xPos() + this.xSize() - 1, this.yPos(), 1.0, this.ySize(), colour);
                } else {
                    this.drawColouredRect(this.xPos() + this.xSize() / 2, this.yPos(), 1.0, this.ySize(), colour);
                    this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), 1.0, colour);
                    this.drawColouredRect(this.xPos(), this.yPos() + this.ySize() - 1, this.xSize(), 1.0, colour);
                }
            }
        });
        this.lockSliderWidthPos(true);
        this.updateElements();
        return this;
    }

    public boolean isDragging() {
        return this.isDragging || this.isMiddleClickDragging;
    }

    public void updateElements() {
        if (this.backgroundElement != null && this.lockBackgroundWidthAndPos) {
            this.backgroundElement.setPos(this).setSize(this);
        }
        if (this.sliderElement != null && this.lockSliderWidthAndPos) {
            if (this.rotation == SliderRotation.HORIZONTAL) {
                this.sliderElement.setYSize(this.getInsetRect().height);
                this.sliderElement.setYPos(this.getInsetRect().y);
            } else {
                this.sliderElement.setXSize(this.getInsetRect().width);
                this.sliderElement.setXPos(this.getInsetRect().x);
            }
        }
        this.updateSliderPos();
    }

    public void updateSliderPos() {
        if (this.sliderElement != null) {
            if (this.rotation == SliderRotation.HORIZONTAL) {
                this.sliderElement.setXSize(this.sliderSize);
                int maxMove = this.getInsetRect().width - this.sliderElement.xSize();
                this.sliderElement.setXPos(this.getInsetRect().x + (int)((double)maxMove * this.getRawPos()));
            } else {
                this.sliderElement.setYSize(this.sliderSize);
                int maxMove = this.getInsetRect().height - this.sliderElement.ySize();
                this.sliderElement.setYPos(this.getInsetRect().y + (int)((double)maxMove * this.getRawPos()));
            }
        }
    }

    public IMouseOver getParentScrollable() {
        return this.parentScrollable == null ? this.getParent() : this.parentScrollable;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.isHidden()) {
            return;
        }
        if (this.backgroundElement != null && this.backgroundElement.isEnabled()) {
            this.backgroundElement.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
        for (GuiElement element : this.childElements) {
            if (!element.isEnabled() || element == this.backgroundElement) continue;
            element.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    public GuiSlideControl setScrollSpeed(double increment) {
        this.scrollSpeed = increment;
        return this;
    }

    public double getScrollSpeed() {
        return this.scrollSpeed;
    }

    public static enum SliderRotation {
        HORIZONTAL,
        VERTICAL;

    }
}

