/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.baseelements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiEvent;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventDispatcher;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import com.brandon3055.brandonscore.lib.ScissorHelper;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.google.common.collect.ImmutableList;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class GuiScrollElement
extends GuiElement<GuiScrollElement>
implements IGuiEventListener {
    public static final String DEFAULT_SCROLL_BAR_GROUP = "GuiScrollElement_Default_Scroll_Bars";
    protected int listSpacing = 0;
    protected int verticalScrollPos = 0;
    protected int horizontalScrollPos = 0;
    protected int animSpeed = 1;
    protected Insets defaultInsets = new Insets(0, 0, 0, 0);
    protected boolean smoothScroll = false;
    protected boolean insetScrollBars = false;
    protected boolean reloadOnUpdate = false;
    protected boolean enableVerticalScroll = true;
    protected boolean useAbsoluteElementSize = false;
    protected boolean enableHorizontalScroll = true;
    protected boolean scrollBarExclusionMode = true;
    protected boolean disableOffScreenElements = false;
    protected ListMode listMode = ListMode.DISABLED;
    protected Rectangle scrollBounds = new Rectangle();
    protected GuiElement backgroundElement = null;
    protected GuiSlideControl verticalScrollBar = null;
    protected GuiSlideControl horizontalScrollBar = null;
    protected Runnable scrollBarStateChangingListener = null;
    protected LinkedList<GuiElement> scrollingElements = new LinkedList();
    protected LinkedList<GuiElement> foregroundElements = new LinkedList();
    protected LinkedList<GuiElement> backgroundElements = new LinkedList();

    public GuiScrollElement() {
    }

    public GuiScrollElement(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiScrollElement(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    @Override
    public void reloadElement() {
        super.reloadElement();
        this.resetScrollPositions();
        this.updateScrollElement();
        this.resetScrollPositions();
    }

    public GuiScrollElement setInsetScrollBars(boolean insetScrollBars) {
        this.insetScrollBars = insetScrollBars;
        return this;
    }

    public GuiScrollElement setDisableOffScreenElements(boolean disableOffScreenElements) {
        this.disableOffScreenElements = disableOffScreenElements;
        return this;
    }

    public GuiScrollElement setScrollBarStateChangingListener(Runnable scrollBarStateChangingListener) {
        this.scrollBarStateChangingListener = scrollBarStateChangingListener;
        return this;
    }

    public GuiScrollElement setAllowedScrollAxes(boolean vertical, boolean horizontal) {
        this.enableVerticalScroll = vertical;
        this.enableHorizontalScroll = horizontal;
        return this;
    }

    public GuiScrollElement setVerticalScrollBar(GuiSlideControl verticalScrollBar) {
        if (this.verticalScrollBar != null) {
            this.removeChild(this.verticalScrollBar);
        }
        this.verticalScrollBar = verticalScrollBar;
        this.verticalScrollBar.setListener(this);
        this.addChild(this.verticalScrollBar);
        return this;
    }

    public GuiSlideControl getVerticalScrollBar() {
        this.validateScrollBarExistence();
        return this.verticalScrollBar;
    }

    public GuiScrollElement setHorizontalScrollBar(GuiSlideControl horizontalScrollBar) {
        if (this.horizontalScrollBar != null) {
            this.removeChild(this.horizontalScrollBar);
        }
        this.horizontalScrollBar = horizontalScrollBar;
        this.horizontalScrollBar.setListener(this);
        this.addChild(this.horizontalScrollBar);
        return this;
    }

    public GuiSlideControl getHorizontalScrollBar() {
        this.validateScrollBarExistence();
        return this.horizontalScrollBar;
    }

    public GuiScrollElement setScrollBarExclusionMode(boolean scrollBarExclusionMode) {
        this.scrollBarExclusionMode = scrollBarExclusionMode;
        return this;
    }

    public GuiScrollElement setSmoothScroll(boolean smoothScroll, int speed) {
        this.smoothScroll = smoothScroll;
        this.animSpeed = speed;
        return this;
    }

    public GuiScrollElement useAbsoluteElementSize(boolean useAbsoluteElementSize) {
        this.useAbsoluteElementSize = useAbsoluteElementSize;
        return this;
    }

    public GuiScrollElement setStandardScrollBehavior() {
        this.validateScrollBarExistence();
        this.verticalScrollBar.setParentScroll(true);
        this.verticalScrollBar.allowMiddleClickDrag(true);
        this.verticalScrollBar.clearScrollChecks();
        this.verticalScrollBar.addScrollCheck((slider, mouseX, mouseY) -> slider.isMouseOver((double)mouseX, (double)mouseY) || !Screen.m_96638_());
        this.horizontalScrollBar.setParentScroll(true);
        this.horizontalScrollBar.allowMiddleClickDrag(true);
        this.horizontalScrollBar.clearScrollChecks();
        this.horizontalScrollBar.addScrollCheck((slider, mouseX, mouseY) -> slider.isMouseOver((double)mouseX, (double)mouseY) || Screen.m_96638_());
        return this;
    }

    @Override
    public GuiScrollElement setInsets(int top, int left, int bottom, int right) {
        this.defaultInsets.set(top, left, bottom, right);
        return (GuiScrollElement)super.setInsets(top, left, bottom, right);
    }

    @Override
    public GuiScrollElement setInsets(Insets insets) {
        this.defaultInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        return (GuiScrollElement)super.setInsets(insets);
    }

    public GuiScrollElement addElement(GuiElement element) {
        this.scrollingElements.add(element);
        super.addChild(element);
        this.updateScrollElement();
        return this;
    }

    public GuiScrollElement removeElement(GuiElement element) {
        this.removeChild(element);
        this.updateScrollElement();
        return this;
    }

    @Override
    public <C extends GuiElement> C removeChild(C child) {
        this.scrollingElements.remove(child);
        this.backgroundElements.remove(child);
        this.foregroundElements.remove(child);
        return super.removeChild(child);
    }

    @Override
    public final <C extends GuiElement> C addChild(C child) {
        this.foregroundElements.add(child);
        return super.addChild(child);
    }

    public <C extends GuiElement> C addBackgroundChild(C child) {
        this.backgroundElements.add(child);
        return super.addChild(child);
    }

    public void clearElements() {
        this.scrollingElements.forEach(x$0 -> super.removeChild(x$0));
        this.scrollingElements.clear();
        this.updateScrollElement();
    }

    public ImmutableList<GuiElement> getScrollingElements() {
        return ImmutableList.copyOf(this.scrollingElements);
    }

    protected int elementXSize(GuiElement element) {
        if (this.useAbsoluteElementSize) {
            return element.getEnclosingRect().width;
        }
        return element.xSize();
    }

    protected int elementYSize(GuiElement element) {
        if (this.useAbsoluteElementSize) {
            return element.getEnclosingRect().height;
        }
        return element.ySize();
    }

    public void updateScrollElement() {
        if (this.listMode != ListMode.DISABLED) {
            int lastPos = this.listMode.horizontal() ? this.getInsetRect().x : this.getInsetRect().y;
            for (GuiElement element : this.scrollingElements) {
                if (!element.isEnabled() || element == this.backgroundElement) continue;
                if (this.listMode.horizontal()) {
                    if (this.listMode.lockPos()) {
                        element.setYPos(this.getInsetRect().y);
                    }
                    if (this.listMode.lockWidth()) {
                        element.setYSize(this.getInsetRect().height);
                    }
                    element.setXPos(lastPos);
                    lastPos += this.elementXSize(element) + this.listSpacing;
                } else {
                    if (this.listMode.lockPos()) {
                        element.setXPos(this.getInsetRect().x);
                    }
                    if (this.listMode.lockWidth()) {
                        element.setXSize(this.getInsetRect().width);
                    }
                    element.setYPos(lastPos);
                    lastPos += this.elementYSize(element) + this.listSpacing;
                }
                if (!this.reloadOnUpdate) continue;
                element.reloadElement();
            }
        }
        this.updateScrollBounds();
        this.updateScrollbars();
        if (this.backgroundElement != null) {
            this.backgroundElement.setPosAndSize(this.scrollBounds);
        }
        if (this.disableOffScreenElements) {
            this.scrollingElements.forEach(e -> e.setEnabled(this.getInsetRect().intersects(e.getRect())));
        }
    }

    protected void updateScrollBounds() {
        int yMin;
        int xMin;
        int xMax = xMin = this.getInsetRect().x;
        int yMax = yMin = this.getInsetRect().y;
        if (DataUtils.firstMatch(this.scrollingElements, elementBase -> elementBase.isEnabled() || elementBase != this.backgroundElement) == null) {
            xMin = this.xPos();
            xMax = this.maxXPos();
            yMin = this.yPos();
            yMax = this.maxYPos();
        } else {
            for (GuiElement element : this.scrollingElements) {
                if (!element.isEnabled() || element == this.backgroundElement) continue;
                Rectangle rect = element.getEnclosingRect();
                if (rect.x < xMin) {
                    xMin = rect.x;
                }
                if (rect.getMaxX() > (double)xMax) {
                    xMax = (int)rect.getMaxX();
                }
                if (rect.y < yMin) {
                    yMin = rect.y;
                }
                if (!(rect.getMaxY() > (double)yMax)) continue;
                yMax = (int)rect.getMaxY();
            }
        }
        this.scrollBounds.setBounds(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public boolean updateScrollbars() {
        boolean scrollStateChange;
        boolean canDisHoz;
        this.validateScrollBarExistence();
        this.setInsets(this.defaultInsets.top, this.defaultInsets.left, this.defaultInsets.bottom, this.defaultInsets.right);
        double verticalMinScroll = Math.min(0, this.scrollBounds.y - this.getInsetRect().y);
        double verticalMaxScroll = Math.max(0.0, this.scrollBounds.getMaxY() - this.getInsetRect().getMaxY());
        boolean vertNoExc = Math.abs(verticalMinScroll) + Math.abs(verticalMaxScroll) <= 0.0;
        double horizontalMinScroll = Math.min(0, this.scrollBounds.x - this.getInsetRect().x);
        double horizontalMaxScroll = Math.max(0.0, this.scrollBounds.getMaxX() - this.getInsetRect().getMaxX());
        boolean hozNoExc = Math.abs(horizontalMinScroll) + Math.abs(horizontalMaxScroll) <= 0.0;
        verticalMinScroll = Math.min(0, this.scrollBounds.y - this.getInsetRect().y);
        verticalMaxScroll = Math.max(0.0, this.scrollBounds.getMaxY() - this.getInsetRect().getMaxY());
        boolean vertExc = Math.abs(verticalMinScroll) + Math.abs(verticalMaxScroll) <= 0.0;
        horizontalMinScroll = Math.min(0, this.scrollBounds.x - this.getInsetRect().x);
        horizontalMaxScroll = Math.max(0.0, this.scrollBounds.getMaxX() - this.getInsetRect().getMaxX());
        boolean hozExc = Math.abs(horizontalMinScroll) + Math.abs(horizontalMaxScroll) <= 0.0;
        boolean canDisVert = vertExc || !this.enableVerticalScroll || this.scrollingElements.isEmpty();
        boolean bl = canDisHoz = hozExc || !this.enableHorizontalScroll || this.scrollingElements.isEmpty();
        if (!canDisVert && vertNoExc) {
            boolean bl2 = canDisVert = canDisHoz || hozNoExc;
        }
        if (!canDisHoz && hozNoExc) {
            canDisHoz = canDisVert;
        }
        boolean bl3 = canDisVert == this.verticalScrollBar.isEnabled() || (!canDisHoz && this.enableHorizontalScroll) != this.horizontalScrollBar.isEnabled() ? true : (scrollStateChange = false);
        if (scrollStateChange && this.scrollBarStateChangingListener != null) {
            this.scrollBarStateChangingListener.run();
        }
        this.verticalScrollBar.setEnabled(!canDisVert);
        this.horizontalScrollBar.setEnabled(!canDisHoz && this.enableHorizontalScroll);
        this.setInsets(this.defaultInsets.top, this.defaultInsets.left, this.defaultInsets.bottom, this.defaultInsets.right);
        this.updateScrollbarExclusion();
        if ((!this.verticalScrollBar.isEnabled() || this.verticalScrollBar.isHidden()) && this.horizontalScrollBar.isEnabled() && this.horizontalScrollBar.isInGroup(DEFAULT_SCROLL_BAR_GROUP)) {
            ((GuiSlideControl)((GuiSlideControl)this.horizontalScrollBar.setXSize(this.insetScrollBars ? this.getActualInsetRect().width : this.xSize())).setYPos(this.maxYPos() - (this.horizontalScrollBar.ySize() + (this.insetScrollBars ? this.defaultInsets.bottom : 0)))).updateElements();
        } else if (this.horizontalScrollBar.isInGroup(DEFAULT_SCROLL_BAR_GROUP)) {
            if (this.insetScrollBars) {
                ((GuiSlideControl)((GuiSlideControl)((GuiSlideControl)this.horizontalScrollBar.setXPos(this.getActualInsetRect().x)).setXSize(this.xSize() - this.verticalScrollBar.xSize())).setYPos(this.getActualInsetRect().y + this.getActualInsetRect().height - this.horizontalScrollBar.ySize())).updateElements();
            } else {
                ((GuiSlideControl)((GuiSlideControl)this.horizontalScrollBar.setXSize(this.xSize() - this.verticalScrollBar.xSize())).setYPos(this.maxYPos() - this.horizontalScrollBar.ySize())).updateElements();
            }
        }
        if ((!this.horizontalScrollBar.isEnabled() || this.horizontalScrollBar.isHidden()) && this.verticalScrollBar.isEnabled() && this.verticalScrollBar.isInGroup(DEFAULT_SCROLL_BAR_GROUP)) {
            ((GuiSlideControl)((GuiSlideControl)this.verticalScrollBar.setYSize(this.insetScrollBars ? this.getActualInsetRect().height : this.ySize())).setXPos(this.maxXPos() - (this.verticalScrollBar.xSize() + (this.insetScrollBars ? this.defaultInsets.right : 0)))).updateElements();
        } else if (this.verticalScrollBar.isInGroup(DEFAULT_SCROLL_BAR_GROUP)) {
            if (this.insetScrollBars) {
                ((GuiSlideControl)((GuiSlideControl)((GuiSlideControl)this.verticalScrollBar.setYPos(this.getActualInsetRect().y)).setYSize(this.getActualInsetRect().height - this.horizontalScrollBar.ySize())).setXPos(this.getActualInsetRect().x + this.getActualInsetRect().width - this.verticalScrollBar.xSize())).updateElements();
            } else {
                ((GuiSlideControl)((GuiSlideControl)this.verticalScrollBar.setYSize(this.ySize() - this.horizontalScrollBar.ySize())).setXPos(this.maxXPos() - this.verticalScrollBar.xSize())).updateElements();
            }
        }
        double contentHeight = Math.abs(verticalMinScroll) + (double)this.getInsetRect().height + Math.abs(verticalMaxScroll);
        this.verticalScrollBar.setRange(verticalMinScroll, verticalMaxScroll);
        this.verticalScrollBar.setScaledSliderSize((double)this.getInsetRect().height / contentHeight);
        this.verticalScrollBar.updatePos(this.verticalScrollPos, false);
        double contentWidth = Math.abs(horizontalMinScroll) + (double)this.getInsetRect().width + Math.abs(horizontalMaxScroll);
        this.horizontalScrollBar.setRange(horizontalMinScroll, horizontalMaxScroll);
        this.horizontalScrollBar.setScaledSliderSize((double)this.getInsetRect().width / contentWidth);
        this.horizontalScrollBar.updatePos(this.horizontalScrollPos, false);
        return scrollStateChange;
    }

    private Rectangle getActualInsetRect() {
        return new Rectangle(this.xPos() + this.defaultInsets.left, this.yPos() + this.defaultInsets.top, this.xSize() - this.defaultInsets.left - this.defaultInsets.right, this.ySize() - this.defaultInsets.top - this.defaultInsets.bottom);
    }

    protected void updateScrollbarExclusion() {
        if (this.scrollBarExclusionMode) {
            if (this.verticalScrollBar.isEnabled() && !this.verticalScrollBar.isHidden()) {
                if (this.verticalScrollBar.getRect().getCenterX() > this.getRect().getCenterX()) {
                    if (this.getInsetRect().getMaxX() > (double)this.verticalScrollBar.xPos()) {
                        this.getInsets().right = this.maxXPos() - this.verticalScrollBar.xPos();
                    }
                } else if (this.getInsetRect().getX() < (double)this.verticalScrollBar.maxXPos()) {
                    this.getInsets().left = this.verticalScrollBar.maxXPos() - this.xPos();
                }
            }
            if (this.horizontalScrollBar.isEnabled() && !this.horizontalScrollBar.isHidden()) {
                if (this.horizontalScrollBar.getRect().getCenterY() > this.getRect().getCenterY()) {
                    if (this.getInsetRect().getMaxY() > (double)this.horizontalScrollBar.yPos()) {
                        this.getInsets().bottom = this.maxYPos() - this.horizontalScrollBar.yPos();
                    }
                } else if (this.getInsetRect().getY() < (double)this.horizontalScrollBar.maxYPos()) {
                    this.getInsets().top = this.horizontalScrollBar.maxYPos() - this.yPos();
                }
            }
        }
    }

    private void validateScrollBarExistence() {
        if (this.verticalScrollBar == null) {
            this.setVerticalScrollBar(((GuiSlideControl)((GuiSlideControl)new GuiSlideControl(GuiSlideControl.SliderRotation.VERTICAL).setPos(this.maxXPos() - (10 + (this.insetScrollBars ? this.getInsets().right : 0)), this.yPos() + (this.insetScrollBars ? this.getInsets().top : 0))).setSize(10, (this.insetScrollBars ? this.getInsetRect().height : this.ySize()) - 10)).setDefaultBackground(-16777216, -1).setDefaultSlider(-6250336, -9408400));
            this.verticalScrollBar.addToGroup(DEFAULT_SCROLL_BAR_GROUP);
        }
        if (this.horizontalScrollBar == null) {
            this.setHorizontalScrollBar(((GuiSlideControl)((GuiSlideControl)new GuiSlideControl().setPos(this.xPos(), this.maxYPos() - 10)).setSize(this.xSize() - 10, 10)).setDefaultBackground(-16777216, -1).setDefaultSlider(-6250336, -9408400));
            this.horizontalScrollBar.addToGroup(DEFAULT_SCROLL_BAR_GROUP);
        }
    }

    public void resetScrollPositions() {
        this.validateScrollBarExistence();
        this.verticalScrollBar.updatePos(0.0);
        this.horizontalScrollBar.updatePos(0.0);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.getInsetRect().contains(mouseX, mouseY)) {
            for (GuiElement element : this.scrollingElements) {
                if (!element.isEnabled() || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
        }
        for (GuiElement element : this.foregroundElements) {
            if (!element.isEnabled() || this.scrollingElements.contains(element) || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dragX, double dragY) {
        for (GuiElement element : this.scrollingElements) {
            if (!element.isEnabled() || !element.mouseDragged(mouseX, mouseY, clickedMouseButton, dragX, dragY)) continue;
            return true;
        }
        for (GuiElement element : this.foregroundElements) {
            if (!element.isEnabled() || this.scrollingElements.contains(element) || !element.mouseDragged(mouseX, mouseY, clickedMouseButton, dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMouseScroll(double mouseX, double mouseY, double scrollDirection) {
        for (GuiElement element : this.scrollingElements) {
            if (!element.isEnabled() || !element.handleMouseScroll(mouseX, mouseY, scrollDirection)) continue;
            return true;
        }
        for (GuiElement element : this.foregroundElements) {
            if (!element.isEnabled() || this.scrollingElements.contains(element) || !element.handleMouseScroll(mouseX, mouseY, scrollDirection)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onMGuiEvent(GuiEvent event, GuiElement eventSource) {
        int xAdjustment = 0;
        int yAdjustment = 0;
        if (eventSource == this.verticalScrollBar) {
            yAdjustment = this.verticalScrollPos - (int)this.verticalScrollBar.getPosition();
            this.verticalScrollPos = (int)this.verticalScrollBar.getPosition();
        } else if (eventSource == this.horizontalScrollBar) {
            xAdjustment = this.horizontalScrollPos - (int)this.horizontalScrollBar.getPosition();
            this.horizontalScrollPos = (int)this.horizontalScrollBar.getPosition();
        }
        for (GuiElement scrollableElement : this.scrollingElements) {
            if (this.smoothScroll) {
                scrollableElement.translateAnim(xAdjustment, yAdjustment, this.animSpeed);
            } else {
                scrollableElement.translate(xAdjustment, yAdjustment);
            }
            if (!this.disableOffScreenElements) continue;
            this.scrollingElements.forEach(e -> e.setEnabled(this.getInsetRect().intersects(e.getRect())));
        }
    }

    public GuiScrollElement setReloadOnUpdate(boolean reloadOnUpdate) {
        this.reloadOnUpdate = reloadOnUpdate;
        return this;
    }

    public GuiScrollElement setListMode(ListMode listMode) {
        this.listMode = listMode;
        if (listMode != ListMode.DISABLED) {
            this.setAllowedScrollAxes(!listMode.horizontal(), listMode.horizontal());
        }
        return this;
    }

    public GuiScrollElement setListSpacing(int listSpacing) {
        this.listSpacing = listSpacing;
        return this;
    }

    public GuiScrollElement applyBackgroundElement(GuiElement backgroundElement) {
        if (this.backgroundElement != null) {
            this.removeChild(this.backgroundElement);
        }
        this.backgroundElement = backgroundElement;
        this.addElement(this.backgroundElement);
        this.updateScrollElement();
        return this;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (GuiElement element : this.backgroundElements) {
            if (!element.isEnabled()) continue;
            element.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
        double xPos = this.getInsetRect().x;
        double yPos = this.getInsetRect().y;
        double xSize = this.getInsetRect().width + 1;
        double ySize = this.getInsetRect().height + 1;
        double yResScale = (double)this.displayHeight() / (double)this.screenHeight;
        double xResScale = (double)this.displayWidth() / (double)this.screenWidth;
        double scaledWidth = xSize * xResScale;
        double scaledHeight = ySize * yResScale;
        int x = (int)(xPos * xResScale);
        int y = (int)((double)this.displayHeight() - yPos * yResScale - scaledHeight);
        ScissorHelper.pushScissor(x, y, (int)scaledWidth, (int)scaledHeight);
        if (this.backgroundElement != null) {
            this.backgroundElement.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
        for (GuiElement element : this.scrollingElements) {
            if (!element.isEnabled() || element == this.backgroundElement) continue;
            element.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
        ScissorHelper.popScissor();
        for (GuiElement element : this.foregroundElements) {
            if (!element.isEnabled() || this.scrollingElements.contains(element)) continue;
            element.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void addDefaultListener(GuiElement childElement) {
        if (childElement instanceof IGuiEventDispatcher && ((IGuiEventDispatcher)((Object)childElement)).getListener() == null) {
            if (this.getParent() instanceof IGuiEventListener) {
                ((IGuiEventDispatcher)((Object)childElement)).setListener((IGuiEventListener)((Object)this.getParent()));
            } else if (this.modularGui instanceof IGuiEventListener) {
                ((IGuiEventDispatcher)((Object)childElement)).setListener((IGuiEventListener)((Object)this.modularGui));
            }
        }
    }

    @Override
    public Rectangle addBoundsToRect(Rectangle enclosingRect) {
        int enRectMaxX = (int)enclosingRect.getMaxX();
        int enRectMaxY = (int)enclosingRect.getMaxY();
        if (this.getRect().x < enclosingRect.x) {
            enclosingRect.x = this.getRect().x;
            enclosingRect.width = enRectMaxX - enclosingRect.x;
        }
        if (this.getRect().getMaxX() > (double)enRectMaxX) {
            enclosingRect.width = (int)this.getRect().getMaxX() - enclosingRect.x;
        }
        if (this.getRect().y < enclosingRect.y) {
            enclosingRect.y = this.getRect().y;
            enclosingRect.height = enRectMaxY - enclosingRect.y;
        }
        if (this.getRect().getMaxY() > (double)enRectMaxY) {
            enclosingRect.height = (int)this.getRect().getMaxY() - enclosingRect.y;
        }
        for (GuiElement element : this.childElements) {
            if (this.scrollingElements.contains(element)) continue;
            element.addBoundsToRect(enclosingRect);
        }
        return enclosingRect;
    }

    @Override
    public boolean allowMouseOver(GuiElement elementRequesting, double mouseX, double mouseY) {
        if (this.scrollingElements.contains(elementRequesting)) {
            return this.getInsetRect().contains(mouseX, mouseY);
        }
        return super.allowMouseOver(elementRequesting, mouseX, mouseY);
    }

    @Override
    public void xSizeChanged(GuiElement elementChanged) {
        if (this.scrollingElements.contains(elementChanged) && elementChanged.reportXSizeChange) {
            int vsp = this.verticalScrollPos;
            int hsp = this.horizontalScrollPos;
            this.resetScrollPositions();
            this.updateScrollElement();
            this.resetScrollPositions();
            this.verticalScrollBar.updatePos(vsp);
            this.horizontalScrollBar.updatePos(hsp);
        }
    }

    @Override
    public void ySizeChanged(GuiElement elementChanged) {
        if (this.scrollingElements.contains(elementChanged) && elementChanged.reportYSizeChange) {
            int vsp = this.verticalScrollPos;
            int hsp = this.horizontalScrollPos;
            this.resetScrollPositions();
            this.updateScrollBounds();
            this.updateScrollElement();
            this.resetScrollPositions();
            this.verticalScrollBar.updatePos(vsp);
            this.horizontalScrollBar.updatePos(hsp);
        }
    }

    public Rectangle getScrollBounds() {
        return this.scrollBounds;
    }

    public static enum ListMode {
        DISABLED(false, false, false),
        VERTICAL(false, false, false),
        VERT_LOCK_POS(false, false, true),
        VERT_LOCK_POS_WIDTH(false, true, true),
        HORIZONTAL(true, false, false),
        HORIZ_LOCK_POS(true, false, true),
        HORIZ_LOCK_POS_HEIGHT(true, true, true);

        private final boolean horizontal;
        private final boolean lockWidth;
        private final boolean lockPos;

        private ListMode(boolean horizontal, boolean lockWidth, boolean lockPos) {
            this.horizontal = horizontal;
            this.lockWidth = lockWidth;
            this.lockPos = lockPos;
        }

        public boolean horizontal() {
            return this.horizontal;
        }

        public boolean lockPos() {
            return this.lockPos;
        }

        public boolean lockWidth() {
            return this.lockWidth;
        }
    }
}

