/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.baseelements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import java.awt.Rectangle;
import javax.annotation.Nullable;

public class GuiPopUpDialogBase<E extends GuiElement<E>>
extends GuiElement<E> {
    protected int dragXOffset = 0;
    protected int dragYOffset = 0;
    protected int defaultDisplayZ = 500;
    protected boolean dragging = false;
    protected boolean closeOnOutsideClick = true;
    protected boolean closeOnScroll = false;
    protected boolean isVisible = false;
    protected boolean blockOutsideClicks = false;
    protected boolean closeOnCapturedClick = false;
    protected Rectangle dragZone = null;
    protected Runnable escapeCallback = null;
    protected Runnable closeCallback = null;

    public GuiPopUpDialogBase(GuiElement parent) {
        this.setParent(parent);
        if (parent.modularGui == null) {
            throw new RuntimeException("GuiPopUpDialogBase parent has must be initialized!");
        }
        this.applyGeneralElementData(parent.modularGui, parent.mc, parent.screenWidth, parent.screenHeight, parent.fontRenderer);
    }

    public GuiPopUpDialogBase(int xPos, int yPos, GuiElement parent) {
        super(xPos, yPos);
        this.setParent(parent);
        this.applyGeneralElementData(parent.modularGui, parent.mc, parent.screenWidth, parent.screenHeight, parent.fontRenderer);
    }

    public GuiPopUpDialogBase(int xPos, int yPos, int xSize, int ySize, GuiElement parent) {
        super(xPos, yPos, xSize, ySize);
        this.setParent(parent);
        this.applyGeneralElementData(parent.modularGui, parent.mc, parent.screenWidth, parent.screenHeight, parent.fontRenderer);
    }

    @Override
    public void addChildElements() {
        super.addChildElements();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.closeOnOutsideClick && !this.isMouseOver(mouseX, mouseY)) {
            this.close();
            return true;
        }
        boolean captured = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (captured && this.closeOnCapturedClick) {
            this.close();
        }
        if (!captured && this.dragZone != null && this.dragZone.contains(mouseX - (double)this.xPos(), mouseY - (double)this.yPos())) {
            this.dragging = true;
            this.dragXOffset = (int)mouseX - this.xPos();
            this.dragYOffset = (int)mouseY - this.yPos();
            captured = true;
        }
        return captured || this.blockOutsideClicks;
    }

    @Override
    public boolean allowMouseOver(GuiElement elementRequesting, double mouseX, double mouseY) {
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dragX, double dragY) {
        if (this.dragging) {
            double xMove = mouseX - (double)this.dragXOffset - (double)this.xPos();
            double yMove = mouseY - (double)this.dragYOffset - (double)this.yPos();
            this.translate((int)xMove, (int)yMove);
        }
        return super.mouseDragged(mouseX, mouseY, clickedMouseButton, dragX, dragY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    public boolean handleMouseScroll(double mouseX, double mouseY, double scrollDirection) {
        if (this.closeOnScroll) {
            this.close();
        }
        return super.handleMouseScroll(mouseX, mouseY, scrollDirection) || this.blockOutsideClicks;
    }

    @Override
    protected boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 1) {
            this.close();
            if (this.escapeCallback != null) {
                this.escapeCallback.run();
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char charTyped, int charCode) {
        return super.charTyped(charTyped, charCode);
    }

    public E setCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.closeOnOutsideClick = closeOnOutsideClick;
        return (E)this;
    }

    public E setCloseOnScroll(boolean closeOnScroll) {
        this.closeOnScroll = closeOnScroll;
        return (E)this;
    }

    public E setDragZone(@Nullable Rectangle rectangle) {
        this.dragZone = rectangle;
        return (E)this;
    }

    public E setDragZone(int x, int y, int width, int height) {
        this.dragZone = new Rectangle(x, y, width, height);
        return (E)this;
    }

    public E setDragBar(int height) {
        return this.setDragZone(0, 0, this.xSize(), height);
    }

    public E setCloseOnCapturedClick(boolean closeOnCapturedClick) {
        this.closeOnCapturedClick = closeOnCapturedClick;
        return (E)this;
    }

    public E setBlockOutsideClicks(boolean blockOutsideClicks) {
        this.blockOutsideClicks = blockOutsideClicks;
        return (E)this;
    }

    public E setEscapeCallback(Runnable escapeCallback) {
        this.escapeCallback = escapeCallback;
        return (E)this;
    }

    public E setCloseCallback(Runnable closeCallback) {
        this.closeCallback = closeCallback;
        return (E)this;
    }

    public void show(int displayZLevel) {
        this.isVisible = true;
        this.modularGui.getManager().addChild(this, displayZLevel, false);
    }

    public void show() {
        int pz = this.getParent() == null ? 100 : this.getParent().displayZLevel;
        this.show(pz >= this.defaultDisplayZ ? pz + 50 : this.defaultDisplayZ);
    }

    public void showCenter(int displayZLevel) {
        this.show(displayZLevel);
        this.setXPos(this.screenWidth / 2 - this.xSize() / 2);
        this.setYPos(this.screenHeight / 2 - this.ySize() / 2);
    }

    public void showCenter() {
        int pz = this.getParent() == null ? 100 : this.getParent().displayZLevel;
        this.showCenter(pz >= this.defaultDisplayZ ? pz + 50 : this.defaultDisplayZ);
    }

    public void showCenter(GuiElement centerOn, int displayZLevel) {
        this.show(displayZLevel);
        this.setXPos(centerOn.xPos() + centerOn.xSize() / 2 - this.xSize() / 2);
        this.setYPos(centerOn.yPos() + centerOn.ySize() / 2 - this.ySize() / 2);
    }

    public void showCenter(GuiElement centerOn) {
        int pz = this.getParent() == null ? 100 : this.getParent().displayZLevel;
        this.showCenter(centerOn, pz >= this.defaultDisplayZ ? pz + 50 : this.defaultDisplayZ);
    }

    public void close() {
        this.modularGui.getManager().removeChild(this);
        if (this.getParent() != null && this.getParent().hasChild(this)) {
            this.getParent().removeChild(this);
        }
        this.isVisible = false;
        if (this.closeCallback != null) {
            this.closeCallback.run();
        }
    }

    public void toggleShown(boolean centre, int displayZLevel) {
        if (this.isVisible) {
            this.close();
        } else if (centre) {
            this.showCenter(displayZLevel);
        } else {
            this.show(displayZLevel);
        }
    }

    public void toggleShown(boolean centre) {
        this.toggleShown(centre, this.defaultDisplayZ);
    }

    public void toggleShown() {
        this.toggleShown(true);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public static class PopoutDialog
    extends GuiPopUpDialogBase<PopoutDialog> {
        public PopoutDialog(GuiElement parent) {
            super(parent);
        }

        public PopoutDialog(int xPos, int yPos, GuiElement parent) {
            super(xPos, yPos, parent);
        }

        public PopoutDialog(int xPos, int yPos, int xSize, int ySize, GuiElement parent) {
            super(xPos, yPos, xSize, ySize, parent);
        }
    }
}

