/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.inventory.ContainerBCore;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class ModularGuiContainer<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IModularGui<ModularGuiContainer> {
    protected GuiElementManager manager = new GuiElementManager(this);
    public final Inventory playerInv;
    protected int zLevel = 0;
    protected T container;
    protected boolean itemTooltipsEnabled = true;
    public boolean enableDefaultBackground = true;
    private boolean experimentalSlotOcclusion = false;
    @Deprecated
    protected boolean dumbGui = false;
    private FloatingItemRenderOverride floatingItemOverride = null;

    public ModularGuiContainer(T container, Inventory playerInv, Component titleIn) {
        super(container, playerInv, titleIn);
        this.container = container;
        this.playerInv = playerInv;
        this.f_96541_ = Minecraft.m_91087_();
        this.f_96542_ = this.f_96541_.m_91291_();
        this.f_96547_ = this.f_96541_.f_91062_;
        this.f_96543_ = this.f_96541_.m_91268_().m_85445_();
        this.f_96544_ = this.f_96541_.m_91268_().m_85446_();
        this.manager.setWorldAndResolution(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    public final void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        this.manager.onGuiInit(this.f_96541_, this.f_96543_, this.f_96544_);
        this.reloadGui();
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void reloadGui() {
        this.manager.reloadElements();
    }

    @Override
    public ModularGuiContainer getScreen() {
        return this;
    }

    @Override
    public int xSize() {
        return this.f_97726_;
    }

    @Override
    public int ySize() {
        return this.f_97727_;
    }

    @Override
    public void setUISize(int xSize, int ySize) {
        this.f_97726_ = xSize;
        this.f_97727_ = ySize;
    }

    @Override
    public int guiLeft() {
        return this.f_97735_;
    }

    @Override
    public int guiTop() {
        return this.f_97736_;
    }

    @Override
    public GuiElementManager getManager() {
        return this.manager;
    }

    @Override
    public void setZLevel(int zLevel) {
        this.zLevel = zLevel;
    }

    @Override
    public int getZLevel() {
        return this.zLevel;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.dumbGui && this.manager.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.dumbGui && this.manager.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.manager.mouseMoved(mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int clickedMouseButton, double dragX, double dragY) {
        if (!this.dumbGui && this.manager.mouseDragged(mouseX, mouseY, clickedMouseButton, dragX, dragY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, clickedMouseButton, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.dumbGui && this.manager.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        boolean handled = this.m_97805_(keyCode, scanCode);
        if (this.f_97734_ != null && this.f_97734_.m_6657_()) {
            if (this.f_96541_.f_91066_.f_92097_.isActiveAndMatches(mouseKey)) {
                this.m_6597_(this.f_97734_, this.f_97734_.f_40219_, 0, ClickType.CLONE);
                handled = true;
            } else if (this.f_96541_.f_91066_.f_92094_.isActiveAndMatches(mouseKey)) {
                this.m_6597_(this.f_97734_, this.f_97734_.f_40219_, ModularGuiContainer.m_96637_() ? 1 : 0, ClickType.THROW);
                handled = true;
            }
        } else if (this.f_96541_.f_91066_.f_92094_.isActiveAndMatches(mouseKey)) {
            handled = true;
        }
        return handled;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (!this.dumbGui && this.manager.keyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char charTyped, int charCode) {
        if (!this.dumbGui && this.manager.charTyped(charTyped, charCode)) {
            return true;
        }
        return super.m_5534_(charTyped, charCode);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        if (!this.dumbGui && this.manager.mouseScrolled(mouseX, mouseY, scrollAmount)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollAmount);
    }

    public double getMouseX() {
        return this.f_96541_.f_91067_.m_91589_() * (double)this.f_96541_.m_91268_().m_85445_() / (double)this.f_96541_.m_91268_().m_85443_();
    }

    public double getMouseY() {
        return this.f_96541_.f_91067_.m_91594_() * (double)this.f_96541_.m_91268_().m_85446_() / (double)this.f_96541_.m_91268_().m_85444_();
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.renderBackgroundLayer(mouseX, mouseY, partialTicks);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.dumbGui) {
            super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            return;
        }
        if (this.enableDefaultBackground) {
            this.m_7333_(matrixStack);
        }
        this.renderSuperScreen(matrixStack, mouseX, mouseY, partialTicks);
        this.renderOverlayLayer(mouseX, mouseY, partialTicks);
        if (this.itemTooltipsEnabled) {
            matrixStack.m_85837_(0.0, 0.0, 510.0);
            this.m_7025_(matrixStack, mouseX, mouseY);
            matrixStack.m_85837_(0.0, 0.0, -510.0);
        }
    }

    public void renderBackgroundLayer(int mouseX, int mouseY, float partialTicks) {
        this.manager.renderElements(this.f_96541_, mouseX, mouseY, partialTicks);
    }

    public void renderOverlayLayer(int mouseX, int mouseY, float partialTicks) {
        this.manager.renderOverlayLayer(this.f_96541_, mouseX, mouseY, partialTicks);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.manager.onUpdate();
        T t = this.container;
        if (t instanceof ContainerBCore) {
            ContainerBCore c = (ContainerBCore)((Object)t);
            c.clientTick();
        }
    }

    private void renderSuperScreen(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        ItemStack itemstack;
        int left = this.f_97735_;
        int top = this.f_97736_;
        this.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.DrawBackground((AbstractContainerScreen)this, poseStack, mouseX, mouseY));
        RenderSystem.m_69465_();
        for (Widget widget : this.f_169369_) {
            widget.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)left, (double)top, 0.0);
        RenderSystem.m_157182_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_97734_ = null;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int k = 0; k < this.f_97732_.f_38839_.size(); ++k) {
            boolean occluded;
            Slot slot = (Slot)this.f_97732_.f_38839_.get(k);
            if (slot.m_6659_()) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                this.m_97799_(poseStack, slot);
            }
            if ((occluded = this.manager.isAreaUnderElement(slot.f_40220_ + this.guiLeft(), slot.f_40221_ + this.guiTop(), 16, 16, 100)) && !this.experimentalSlotOcclusion) continue;
            if (!occluded && this.m_97774_(slot, mouseX, mouseY) && slot.m_6659_()) {
                this.f_97734_ = slot;
                int l = slot.f_40220_;
                int i1 = slot.f_40221_;
                ModularGuiContainer.renderSlotHighlight((PoseStack)poseStack, (int)l, (int)i1, (int)this.m_93252_(), (int)this.getSlotColor(k));
            }
            this.drawSlotOverlay(slot, occluded);
        }
        this.m_7027_(poseStack, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.DrawForeground((AbstractContainerScreen)this, poseStack, mouseX, mouseY));
        ItemStack itemStack = itemstack = this.f_97711_.m_41619_() ? this.f_97732_.m_142621_() : this.f_97711_;
        if (!itemstack.m_41619_()) {
            int l1 = 8;
            int i2 = this.f_97711_.m_41619_() ? 8 : 16;
            String s = null;
            if (!this.f_97711_.m_41619_() && this.f_97710_) {
                itemstack = itemstack.m_41777_();
                itemstack.m_41764_(Mth.m_14167_((float)((float)itemstack.m_41613_() / 2.0f)));
            } else if (this.f_97738_ && this.f_97737_.size() > 1) {
                itemstack = itemstack.m_41777_();
                itemstack.m_41764_(this.f_97720_);
                if (itemstack.m_41619_()) {
                    s = ChatFormatting.YELLOW + "0";
                }
            }
            this.m_97782_(itemstack, mouseX - left - 8, mouseY - top - i2, s);
        }
        if (!this.f_97715_.m_41619_()) {
            float f = (float)(Util.m_137550_() - this.f_97714_) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.f_97715_ = ItemStack.f_41583_;
            }
            int j2 = this.f_97707_.f_40220_ - this.f_97712_;
            int k2 = this.f_97707_.f_40221_ - this.f_97713_;
            int j1 = this.f_97712_ + (int)((float)j2 * f);
            int k1 = this.f_97713_ + (int)((float)k2 * f);
            this.m_97782_(this.f_97715_, j1, k1, null);
        }
        posestack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
    }

    public void m_97799_(PoseStack poseStack, Slot slot) {
        Pair pair;
        int xPos = slot.f_40220_;
        int yPos = slot.f_40221_;
        boolean occluded = this.manager.isAreaUnderElement(xPos + this.guiLeft(), yPos + this.guiTop(), 16, 16, 100);
        if (occluded && !this.experimentalSlotOcclusion) {
            return;
        }
        ItemStack itemstack = slot.m_7993_();
        boolean flag = false;
        boolean flag1 = slot == this.f_97706_ && !this.f_97711_.m_41619_() && !this.f_97710_;
        ItemStack carried = this.f_97732_.m_142621_();
        String countText = null;
        if (slot == this.f_97706_ && !this.f_97711_.m_41619_() && this.f_97710_ && !itemstack.m_41619_()) {
            itemstack = itemstack.m_41777_();
            itemstack.m_41764_(itemstack.m_41613_() / 2);
        } else if (this.f_97738_ && this.f_97737_.contains(slot) && !carried.m_41619_()) {
            if (this.f_97737_.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.m_38899_((Slot)slot, (ItemStack)carried, (boolean)true) && this.f_97732_.m_5622_(slot)) {
                itemstack = carried.m_41777_();
                flag = true;
                AbstractContainerMenu.m_38922_((Set)this.f_97737_, (int)this.f_97717_, (ItemStack)itemstack, (int)(slot.m_7993_().m_41619_() ? 0 : slot.m_7993_().m_41613_()));
                int k = Math.min(itemstack.m_41741_(), slot.m_5866_(itemstack));
                if (itemstack.m_41613_() > k) {
                    countText = ChatFormatting.YELLOW.toString() + k;
                    itemstack.m_41764_(k);
                }
            } else {
                this.f_97737_.remove(slot);
                this.m_97818_();
            }
        }
        this.m_93250_(100);
        this.f_96542_.f_115093_ = 100.0f;
        if (itemstack.m_41619_() && slot.m_6659_() && (pair = slot.m_7543_()) != null) {
            TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.f_96541_.m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
            ModularGuiContainer.m_93200_((PoseStack)poseStack, (int)xPos, (int)yPos, (int)this.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                ModularGuiContainer.m_93172_((PoseStack)poseStack, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-2130706433);
            }
            RenderSystem.m_69482_();
            this.f_96542_.m_174229_((LivingEntity)this.f_96541_.f_91074_, itemstack, xPos, yPos, slot.f_40220_ + slot.f_40221_ * this.f_97726_);
            if (!occluded) {
                this.f_96542_.m_115174_(this.f_96547_, itemstack, xPos, yPos, countText);
            }
        }
        this.f_96542_.f_115093_ = 0.0f;
        this.m_93250_(0);
    }

    protected void drawSlotOverlay(Slot slot, boolean occluded) {
    }

    public void setExperimentalSlotOcclusion(boolean experimentalSlotOcclusion) {
        this.experimentalSlotOcclusion = experimentalSlotOcclusion;
    }

    public int getGuiLeft() {
        return this.guiLeft();
    }

    public int getGuiTop() {
        return this.guiTop();
    }

    public int getXSize() {
        return this.xSize();
    }

    public int getYSize() {
        return this.ySize();
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeft, int guiTop, int button) {
        return super.m_7467_(mouseX, mouseY, guiLeft, guiTop, button) && this.manager.getElementsAtPosition(mouseX, mouseY).stream().noneMatch(GuiElement::isEnabled);
    }

    public T getContainer() {
        return this.container;
    }

    public void m_97782_(ItemStack stack, int x, int y, String altText) {
        if (this.floatingItemOverride != null && this.floatingItemOverride.renderFloatingItem(stack, x, y, altText)) {
            return;
        }
        super.m_97782_(stack, x, y, altText);
    }

    public void setFloatingItemOverride(FloatingItemRenderOverride floatingItemOverride) {
        this.floatingItemOverride = floatingItemOverride;
    }

    public static interface FloatingItemRenderOverride {
        public boolean renderFloatingItem(ItemStack var1, int var2, int var3, String var4);
    }
}

