/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import com.brandon3055.brandonscore.client.CursorHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.IGuiParentElement;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventDispatcher;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;

public class GuiElementManager
implements IGuiParentElement<GuiElementManager> {
    protected LinkedList<GuiElement> elements = new LinkedList();
    protected LinkedList<GuiElement> actionList = new LinkedList();
    private boolean requiresReSort = false;
    private boolean initialized = false;
    private IModularGui parentGui;
    private Minecraft mc;
    private int width;
    private int height;
    private List<GuiElement> toRemove = new ArrayList<GuiElement>();
    private Supplier<List<GuiElement<?>>> jeiExclusions = null;
    private List<IModularGui.JEITargetAdapter> jeiGhostTargets = new ArrayList<IModularGui.JEITargetAdapter>();
    private ResourceLocation newCursor = null;
    private boolean mousePressed = false;
    private Runnable onTick = null;
    private static Comparator<GuiElement> renderSorter = (o1, o2) -> o1.displayZLevel < o2.displayZLevel ? -1 : (o1.displayZLevel > o2.displayZLevel ? 1 : 0);
    private static Comparator<GuiElement> actionSorter = (o1, o2) -> o1.displayZLevel < o2.displayZLevel ? 1 : (o1.displayZLevel > o2.displayZLevel ? -1 : 0);

    public GuiElementManager(IModularGui parentGui) {
        this.parentGui = parentGui;
    }

    public void onGuiInit(Minecraft mc, int width, int height) {
        this.setWorldAndResolution(mc, width, height);
        if (!this.initialized) {
            this.parentGui.addElements(this);
            this.initialized = true;
        }
    }

    public void reinitialize(Minecraft mc, int width, int height) {
        this.elements.clear();
        this.actionList.clear();
        this.toRemove.clear();
        this.initialized = false;
        this.onGuiInit(mc, width, height);
    }

    public void reloadElements() {
        for (GuiElement element : this.elements) {
            element.reloadElement();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setCursor(ResourceLocation cursor) {
        this.newCursor = cursor;
    }

    public Runnable onTick(Runnable onTick) {
        this.onTick = onTick;
        return onTick;
    }

    public <C extends GuiElement> C addChild(C element, int displayZLevel, boolean first) {
        if (displayZLevel >= 950) {
            LogHelperBC.error("ModularGui Display Level Out Of Bounds! Can not be greater than 950 " + displayZLevel);
        }
        this.toRemove.remove(element);
        element.applyGeneralElementData(this.parentGui, this.mc, this.width, this.height, BCFontRenderer.convert(this.mc.f_91062_));
        element.displayZLevel = displayZLevel;
        if (first) {
            this.elements.addFirst(element);
        } else {
            this.elements.add(element);
        }
        if (!element.isElementInitialized()) {
            element.addChildElements();
            element.setElementInitialized();
        }
        this.requiresReSort = true;
        if (element instanceof IGuiEventDispatcher && ((IGuiEventDispatcher)((Object)element)).getListener() == null && this.parentGui instanceof IGuiEventListener) {
            ((IGuiEventDispatcher)((Object)element)).setListener((IGuiEventListener)((Object)this.parentGui));
        }
        element.reloadElement();
        return element;
    }

    @Override
    public <C extends GuiElement> boolean hasChild(C child) {
        return this.elements.contains(child);
    }

    @Override
    public <C extends GuiElement> C addChild(C element) {
        return this.addChild(element, 0, false);
    }

    @Override
    public <C extends GuiElement> C addBackGroundChild(C element) {
        return this.addChild(element, 0, true);
    }

    @Override
    public GuiElementManager addChildren(Collection<? extends GuiElement> elements) {
        return null;
    }

    @Override
    public <C extends GuiElement> C removeChild(C element) {
        if (this.elements.contains(element)) {
            this.toRemove.add(element);
            this.requiresReSort = true;
            return element;
        }
        return null;
    }

    @Override
    public GuiElementManager removeChildByID(String id) {
        for (GuiElement element : this.elements) {
            if (element.id == null || !element.id.equals(id)) continue;
            this.toRemove.add(element);
            this.requiresReSort = true;
            return this;
        }
        return this;
    }

    @Override
    public GuiElementManager removeChildByGroup(String group) {
        for (GuiElement element : this.elements) {
            if (!element.isInGroup(group)) continue;
            this.toRemove.add(element);
            this.requiresReSort = true;
        }
        return this;
    }

    @Override
    public GuiElementManager setChildIDEnabled(String id, boolean enabled) {
        for (GuiElement element : this.elements) {
            if (element.id == null || !element.id.equals(id)) continue;
            element.setEnabled(enabled);
            return this;
        }
        return this;
    }

    @Override
    public GuiElementManager setChildGroupEnabled(String group, boolean enabled) {
        for (GuiElement element : this.elements) {
            if (!element.isInGroup(group)) continue;
            element.setEnabled(enabled);
        }
        return this;
    }

    public List<GuiElement> getElements() {
        return this.elements;
    }

    public void clear() {
        this.elements.clear();
        this.requiresReSort = true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.mousePressed = true;
        int clickedDisplay = -100;
        for (GuiElement element : this.actionList) {
            if (element.isEnabled() && clickedDisplay > -100 && element.displayZLevel < clickedDisplay) continue;
            if (element.isEnabled() && element.isMouseOver(mouseX, mouseY)) {
                clickedDisplay = element.displayZLevel;
            }
            if (!element.isEnabled() || !element.mouseClicked(mouseX, mouseY, button)) continue;
            this.globalClick(mouseX, mouseY, button);
            return true;
        }
        this.globalClick(mouseX, mouseY, button);
        return false;
    }

    public void globalClick(double mouseX, double mouseY, int button) {
        for (GuiElement element : this.actionList) {
            if (!element.isEnabled()) continue;
            element.globalClick(mouseX, mouseY, button);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.mousePressed = false;
        for (GuiElement element : this.actionList) {
            if (!element.isEnabled() || !element.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dragX, double dragY) {
        for (GuiElement element : this.actionList) {
            if (!element.isEnabled() || !element.mouseDragged(mouseX, mouseY, clickedMouseButton, dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        for (GuiElement element : this.actionList) {
            if (!element.isEnabled() || !element.mouseMoved(mouseX, mouseY)) continue;
            return;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (GuiElement element : this.actionList) {
            if (!element.isEnabled() || !element.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (GuiElement element : this.actionList) {
            if (!element.isEnabled() || !element.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char charTyped, int charCode) {
        for (GuiElement element : this.actionList) {
            if (!element.isEnabled() || !element.charTyped(charTyped, charCode)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        for (GuiElement element : this.actionList) {
            if (!element.isEnabled() || !element.handleMouseScroll(mouseX, mouseY, scrollAmount)) continue;
            return true;
        }
        return false;
    }

    public List<GuiElement> getElementsAtPosition(double posX, double posY) {
        LinkedList<GuiElement> list = new LinkedList<GuiElement>();
        for (GuiElement element : this.elements) {
            element.getElementsAtPosition(posX, posY, list);
        }
        return list;
    }

    public <C extends GuiElement> List<C> getElementsAtPosition(double posX, double posY, Class<C> clazz) {
        List<GuiElement> list = this.getElementsAtPosition(posX, posY);
        LinkedList matches = new LinkedList();
        DataUtils.forEachMatch(list, element -> clazz.isAssignableFrom(element.getClass()), element -> matches.add((GuiElement)clazz.cast(element)));
        return matches;
    }

    public void renderElements(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        for (GuiElement element : this.elements) {
            if (!element.isEnabled()) continue;
            this.parentGui.setZLevel(element.displayZLevel);
            element.preDraw(mc, mouseX, mouseY, partialTicks);
            element.renderElement(mc, mouseX, mouseY, partialTicks);
            element.postDraw(mc, mouseX, mouseY, partialTicks);
            this.parentGui.setZLevel(0);
        }
    }

    public boolean renderOverlayLayer(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        int renderDisplay = -100;
        for (GuiElement element : this.actionList) {
            if (element.isEnabled() && renderDisplay > -100 && element.displayZLevel < renderDisplay) {
                return true;
            }
            if (element.isEnabled() && element.isMouseOver(mouseX, mouseY)) {
                renderDisplay = element.displayZLevel;
            }
            if (!element.isEnabled() || !element.renderOverlayLayer(mc, mouseX, mouseY, partialTicks)) continue;
            return true;
        }
        return false;
    }

    public boolean isAreaUnderElement(int posX, int posY, int xSize, int ySize, int zLevel) {
        for (GuiElement element : this.elements) {
            if (!element.isEnabled() || element.displayZLevel < zLevel || !element.getRect().intersects(posX, posY, xSize, ySize)) continue;
            return true;
        }
        return false;
    }

    public boolean isPointUnderElement(int posX, int posY, int zLevel) {
        for (GuiElement element : this.elements) {
            if (!element.isEnabled() || element.displayZLevel < zLevel || !element.getRect().contains(posX, posY)) continue;
            return true;
        }
        return false;
    }

    public void onUpdate() {
        GuiElement element;
        this.newCursor = null;
        if (!this.toRemove.isEmpty()) {
            this.elements.removeAll(this.toRemove);
            this.toRemove.clear();
        }
        if (this.onTick != null) {
            this.onTick.run();
        }
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext() && !(element = (GuiElement)iterator.next()).onUpdate()) {
        }
        if (this.requiresReSort) {
            this.sort();
        }
        if (!this.mousePressed) {
            CursorHelper.setCursor(this.newCursor);
        }
    }

    public void setWorldAndResolution(Minecraft mc, int width, int height) {
        this.mc = mc;
        this.width = width;
        this.height = height;
        for (GuiElement element : this.elements) {
            element.applyGeneralElementData(this.parentGui, mc, width, height, BCFontRenderer.convert(mc.f_91062_));
        }
        this.reloadElements();
    }

    private void sort() {
        Collections.sort(this.elements, renderSorter);
        this.actionList.clear();
        this.actionList.addAll(this.elements);
        Collections.sort(this.actionList, actionSorter);
    }

    public IModularGui getParentGui() {
        return this.parentGui;
    }

    public void setJeiExclusions(Supplier<List<GuiElement<?>>> exclusions) {
        this.jeiExclusions = exclusions;
    }

    public List<Rect2i> getJeiExclusions() {
        if (this.jeiExclusions == null) {
            return Collections.emptyList();
        }
        return this.jeiExclusions.get().stream().filter(GuiElement::isEnabled).map(elementBase -> {
            Rectangle rect = elementBase.getRect();
            return new Rect2i(rect.x, rect.y, rect.width, rect.height);
        }).collect(Collectors.toList());
    }

    public List<IModularGui.JEITargetAdapter> getJeiGhostTargets() {
        return this.jeiGhostTargets;
    }
}

