/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui;

import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.CursorHelper;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiScreen;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiManipulable;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.hud.HudData;
import com.brandon3055.brandonscore.client.hud.HudManager;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;

public class HudConfigGui
extends ModularGuiScreen {
    protected GuiToolkit<HudConfigGui> toolkit = new GuiToolkit<HudConfigGui>(this, 0, 0).setTranslationPrefix("gui.brandonscore.hud_config");

    public HudConfigGui() {
        super((Component)new TranslatableComponent("gui.brandonscore.hud_config.name"));
    }

    @Override
    public void addElements(GuiElementManager manager) {
        GuiManipulable titleElement = (GuiManipulable)new GuiManipulable().setEnableCursors(true).setSize(150, 13);
        GuiBorderedRect bg = new GuiBorderedRect().setFillColour(Integer.MIN_VALUE);
        titleElement.addChild(((GuiElement)bg.setPosAndSize(titleElement)).translate(0, -1));
        ((GuiLabel)this.toolkit.createHeading("gui.brandonscore.hud_config.name", bg).setPosAndSize(titleElement)).setAlignment(GuiAlign.CENTER);
        manager.addChild(titleElement);
        titleElement.setPos((this.f_96543_ - titleElement.xSize()) / 2, 30);
        for (AbstractHudElement element : HudManager.getHudElements().values()) {
            manager.addChild(new ElementHandler(element));
        }
    }

    public void m_7379_() {
        super.m_7379_();
        HudData.saveIfDirty();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    private class ElementHandler
    extends GuiElement<ElementHandler> {
        private AbstractHudElement element;
        private float borderAnim = 0.0f;
        private float bgAnim = 0.0f;
        private int tick = 0;
        boolean dragging = false;
        private GuiButton settings;
        private GuiElement<?> settingsElement = null;

        public ElementHandler(AbstractHudElement element) {
            this.element = element;
        }

        @Override
        public void addChildElements() {
            this.settings = HudConfigGui.this.toolkit.createIconButton(this, 10, BCGuiSprites.getter("dark/gear"));
            this.settings.setPosModifiers(() -> (int)(this.element.xPos() + this.element.width() - (double)this.settings.xSize()) - 2, () -> (int)this.element.yPos() + 2);
            this.settings.setHoverText(HudConfigGui.this.toolkit.i18n("settings", new Object[0]));
            this.settings.setResetHoverOnClick(true);
            this.settings.onReleased(() -> {
                if (this.settingsElement != null) {
                    this.removeChild(this.settingsElement);
                    this.settingsElement = null;
                } else {
                    this.settingsElement = this.element.createConfigDialog(this.settings);
                    this.settingsElement.setPos(this.settings.maxXPos(), this.settings.yPos());
                    this.addChild(this.settingsElement);
                    this.settingsElement.normalizePosition();
                }
            });
            String infoKey = String.format("hud.%s.%s.info", this.element.getRegistryName().m_135827_(), this.element.getRegistryName().m_135815_());
            String translatedInfo = I18n.m_118938_((String)infoKey, (Object[])new Object[0]);
            if (!infoKey.equals(translatedInfo)) {
                GuiButton infoButton = HudConfigGui.this.toolkit.createIconButton(this, 10, BCGuiSprites.getter("dark/info_icon"));
                infoButton.setPosModifiers(() -> (int)(this.element.xPos() + 2.0), () -> (int)this.element.yPos() + 2);
                infoButton.setHoverText(translatedInfo);
                infoButton.setHoverTextDelay(0);
                infoButton.playClick = false;
            }
        }

        @Override
        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
            PoseStack mStack = new PoseStack();
            mStack.m_85837_(0.0, 0.0, (double)this.getRenderZLevel());
            double x = this.element.xPos();
            double y = this.element.yPos();
            double w = this.element.width();
            double h = this.element.height();
            int rgb = Color.HSBtoRGB(((float)this.tick + partialTicks) / 200.0f, 1.0f, 1.0f);
            this.drawBackground((MultiBufferSource)getter, x, y, w, h, partialTicks, rgb);
            if (this.bgAnim > 0.0f) {
                TranslatableComponent name = new TranslatableComponent(String.format("hud.%s.%s.name", this.element.getRegistryName().m_135827_(), this.element.getRegistryName().m_135815_()));
                int tw = this.fontRenderer.m_92852_((FormattedText)name);
                float bgAnim = Math.min(this.bgAnim + partialTicks * 0.1f, 1.0f);
                this.fontRenderer.m_92841_((Component)name, (float)(x + (w - (double)tw) / 2.0), (float)y + ((float)h - 8.0f) / 2.0f, 0xFFFFFF | (int)(255.0f * bgAnim) << 24, false, mStack.m_85850_().m_85861_(), (MultiBufferSource)getter, false, 0, 0xF000F0);
            }
            getter.m_109911_();
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }

        @Override
        public boolean onUpdate() {
            if (this.borderAnim < 1.0f) {
                this.borderAnim = (float)((double)this.borderAnim + 0.1);
            } else if (this.bgAnim < 1.0f) {
                this.bgAnim = (float)((double)this.bgAnim + 0.1);
            }
            ++this.tick;
            double mouseX = this.getMouseX();
            double mouseY = this.getMouseY();
            if (this.isMouseOver(mouseX, mouseY) && this.childElements.stream().noneMatch(e -> e.isMouseOver(mouseX, mouseY))) {
                this.modularGui.getManager().setCursor(CursorHelper.DRAG);
            }
            return super.onUpdate();
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            boolean captured = super.mouseClicked(mouseX, mouseY, button);
            if (!captured && this.settingsElement != null && !this.settingsElement.isMouseOver(mouseX, mouseY)) {
                this.removeChild(this.settingsElement);
                this.settingsElement = null;
                return true;
            }
            if (!captured && this.isMouseOver(mouseX, mouseY)) {
                this.dragging = true;
                this.element.startMoving(mouseX, mouseY);
                return true;
            }
            return captured;
        }

        @Override
        public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dragX, double dragY) {
            if (this.dragging) {
                this.element.onDragged(mouseX, mouseY);
                return true;
            }
            return super.mouseDragged(mouseX, mouseY, clickedMouseButton, dragX, dragY);
        }

        @Override
        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            if (this.dragging) {
                this.element.stopMoving();
                this.dragging = false;
            }
            return super.mouseReleased(mouseX, mouseY, button);
        }

        @Override
        public boolean isMouseOver(double mouseX, double mouseY) {
            return GuiHelper.isInRect(this.element.xPos(), this.element.yPos(), this.element.width(), this.element.height(), mouseX, mouseY);
        }

        private void drawBackground(MultiBufferSource getter, double x, double y, double w, double h, float partialTicks, int colour) {
            double p;
            double sh;
            double sw;
            float borderAnim = this.borderAnim + partialTicks * 0.1f;
            float bgAnim = Math.min(this.bgAnim + partialTicks * 0.1f, 1.0f);
            this.drawColouredRect(getter, x, y, w, h, 0 | (int)(143.0f * bgAnim) << 24);
            double boarderLength = w * 2.0 + h * 2.0;
            double bp = boarderLength * (double)borderAnim;
            if (bp > 0.0) {
                sw = Math.min(w, bp);
                this.drawGradientQuad(getter, x, y, x + sw, y, x + sw - 1.0, y + 1.0, x + 1.0, y + 1.0, -16777216, colour);
                this.drawGradientQuad(getter, x + 1.0, y + 1.0, x + sw - 1.0, y + 1.0, x + sw - 2.0, y + 2.0, x + 2.0, y + 2.0, colour, -16777216);
            }
            if (bp - w > 0.0) {
                sh = Math.min(h, bp - w);
                double p2 = sh / h;
                this.drawGradientQuad(getter, x + w, y, x + w, y + sh, x + w - 1.0, y + sh - 1.0 * p2, x + w - 1.0, y + 1.0, -16777216, colour);
                this.drawGradientQuad(getter, x + w - 1.0, y + 1.0, x + w - 1.0, y + sh - 1.0, x + w - 2.0, y + sh - 2.0 * p2, x + w - 2.0, y + 2.0, colour, -16777216);
            }
            if (bp - w - h > 0.0) {
                sw = Math.min(w, bp - w - h);
                double sx = x + w - sw;
                p = sw / w;
                this.drawGradientQuad(getter, sx + 2.0 * p, y + h - 2.0, sx + sw - 2.0, y + h - 2.0, sx + sw - 1.0, y + h - 1.0, sx + 1.0, y + h - 1.0, -16777216, colour);
                this.drawGradientQuad(getter, sx + 1.0 * p, y + h - 1.0, sx + sw - 1.0, y + h - 1.0, sx + sw, y + h, sx, y + h, colour, -16777216);
            }
            if (bp - w - h - w > 0.0) {
                sh = Math.min(h, bp - w - h - w);
                double sy = y + h - sh;
                p = sh / h;
                this.drawGradientQuad(getter, x + 1.0, sy + 1.0 * p, x + 1.0, sy + sh - 1.0, x, sy + sh, x, sy, colour, -16777216);
                this.drawGradientQuad(getter, x + 2.0, sy + 2.0 * p, x + 2.0, sy + sh - 2.0, x + 1.0, sy + sh - 1.0, x + 1.0, sy + 1.0 * p, -16777216, colour);
            }
        }

        private void drawGradientQuad(MultiBufferSource getter, double p1A, double p1B, double p2A, double p2B, double p3A, double p3B, double p4A, double p4B, int startColor, int endColor) {
            if (startColor == endColor && endColor == 0) {
                return;
            }
            double zLevel = this.getRenderZLevel();
            float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
            float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
            float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
            float startBlue = (float)(startColor & 0xFF) / 255.0f;
            float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
            float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
            float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
            float endBlue = (float)(endColor & 0xFF) / 255.0f;
            VertexConsumer builder = getter.m_6299_(transColourType);
            builder.m_5483_(p1A, p1B, zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
            builder.m_5483_(p2A, p2B, zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
            builder.m_5483_(p3A, p3B, zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
            builder.m_5483_(p4A, p4B, zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        }
    }
}

