/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiScreen;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEntityRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiManipulable;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiPickColourDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTooltipBackground;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.handlers.contributor.ContributorConfig;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ContributorConfigGui
extends ModularGuiScreen {
    protected GuiToolkit<ContributorConfigGui> toolkit = new GuiToolkit<ContributorConfigGui>(this, 0, 0).setTranslationPrefix("");
    private Player player;
    private ContributorProperties props;
    private ContributorConfig cfg;
    private GuiEntityRenderer playerRender;
    private GuiManipulable container;
    private GuiPickColourDialog wingColourA;
    private GuiPickColourDialog wingColourB;
    private GuiPickColourDialog shieldColour;
    private boolean dragging = false;

    public ContributorConfigGui(Player player, ContributorProperties props) {
        super((Component)new TextComponent("Contributor Configuration"));
        this.player = player;
        this.props = props;
        this.cfg = props.getConfig();
    }

    @Override
    public void addElements(GuiElementManager manager) {
        GuiManipulable titleElement = ((GuiManipulable)manager.addChild(new GuiManipulable()).setEnableCursors(true).setSize(150, 13)).onReload(e -> e.setPos((this.f_96543_ - e.xSize()) / 2, 15));
        Object bg = ((GuiBorderedRect)titleElement.addChild(new GuiBorderedRect()).setFillColour(Integer.MIN_VALUE).setPosAndSize(titleElement)).translate(0, -1);
        ((GuiLabel)this.toolkit.createHeading("Contributor Configuration", (GuiElement<?>)bg).setPosAndSize(titleElement)).setAlignment(GuiAlign.CENTER);
        this.container = ((GuiManipulable)manager.addChild(new GuiManipulable()).setSize(100, 100)).setDragBarHeight(100).setCanResizeH(() -> false).setCanResizeV(() -> false).setEnableCursors(true).onReload(e -> e.setPos(this.f_96543_ / 2 - e.xSize() / 2, this.f_96544_ / 2 - e.ySize() / 2));
        this.playerRender = ((GuiEntityRenderer)this.container.addChild(new GuiEntityRenderer()).setEntity((Entity)this.player).setSize(100, 100)).onReload(e -> this.toolkit.center((GuiElement<?>)e, this.container, 0, 0));
        manager.addChild(((GuiButton)this.createButton("Rotate").setSize(80, 16)).onReload(e -> e.setPos(this.f_96543_ / 2 - 40, this.f_96544_ - 19)).setToggleMode(true).setToggleStateSupplier(() -> !this.playerRender.isRotationLocked()).onPressed(() -> this.playerRender.rotationLocked(!this.playerRender.isRotationLocked())));
        ArrayList leftControls = new ArrayList();
        ArrayList rightControls = new ArrayList();
        this.createControls(leftControls, rightControls);
        this.arrangeControls(manager.addChild(new GuiElement()), leftControls).onReload(e -> e.setPos(3, this.f_96544_ - e.ySize() - 3));
        this.arrangeControls(manager.addChild(new GuiElement()), rightControls).onReload(e -> e.setPos(this.f_96543_ - e.xSize() - 3, this.f_96544_ - e.ySize() - 3));
    }

    private void createControls(List<GuiElement<?>> leftControls, List<GuiElement<?>> rightControls) {
        int width = 150;
        int height = 14;
        leftControls.add((GuiElement<?>)((GuiButton)this.createListButton("Wings: ", () -> this.cfg.getWingsTier(), e -> this.cfg.setWingsTier((TechLevel)((Object)e)), this.props.getWingTiers(), true).setEnabledCallback(() -> !this.props.getWingTiers().isEmpty())).setSize(width, height));
        this.wingColourA = this.createColourPicker(() -> this.cfg.getWingsOverrideBoneColour(), e -> this.cfg.setWingsOverrideBoneColour((int)e), () -> this.cfg.getBaseColourI(this.cfg.getWingsTier()));
        leftControls.add(((GuiButton)((GuiButton)this.createEnableButton("Wings Colour A: ", () -> this.cfg.overrideWingBoneColour(), e -> this.cfg.setOverrideWingBoneColour((boolean)e), "Custom", "Default").setEnabledCallback(() -> this.props.hasWingsRGB())).setSize(width, height)).addChild((GuiButton)((GuiButton)((GuiButton)this.colourPickerButton(this.wingColourA, () -> this.f_96543_ - 83, () -> 3).setEnabledCallback(() -> this.cfg.overrideWingBoneColour())).setXPos(width + 1)).setSize(height, height)).addChild((GuiButton)((GuiButton)((GuiButton)this.colourRGBButton(() -> this.cfg.getWingRGBBoneColour(), e -> this.cfg.setWingRGBBoneColour((boolean)e)).setEnabledCallback(() -> this.cfg.overrideWingBoneColour())).setXPos(width + 16)).setSize(height, height)).getParent().getParent());
        this.wingColourB = this.createColourPicker(() -> this.cfg.getWingsOverrideWebColour(), e -> this.cfg.setWingsOverrideWebColour((int)e), () -> this.cfg.getBaseColourI(this.cfg.getWingsTier()));
        leftControls.add(((GuiButton)((GuiButton)this.createEnableButton("Wings Colour B: ", () -> this.cfg.overrideWingWebColour(), e -> this.cfg.setOverrideWingsWebColour((boolean)e), "Custom", "Default").setEnabledCallback(() -> this.props.hasWingsRGB())).setSize(width, height)).addChild((GuiButton)((GuiButton)((GuiButton)this.colourPickerButton(this.wingColourB, () -> this.f_96543_ - 83, () -> 80).setEnabledCallback(() -> this.cfg.overrideWingWebColour())).setXPos(width + 1)).setSize(height, height)).addChild((GuiButton)((GuiButton)((GuiButton)this.colourRGBButton(() -> this.cfg.getWingRGBWebColour(), e -> this.cfg.setWingRGBWebColour((boolean)e)).setEnabledCallback(() -> this.cfg.overrideWingWebColour())).setXPos(width + 16)).setSize(height, height)).getParent().getParent());
        leftControls.add((GuiElement<?>)((GuiButton)this.createEnableButton("Wings Shader A: ", () -> this.cfg.getWingsBoneShader(), e -> this.cfg.setWingsBoneShader((boolean)e)).setEnabledCallback(() -> this.props.hasWings())).setSize(width, height));
        leftControls.add((GuiElement<?>)((GuiButton)this.createEnableButton("Wings Shader B: ", () -> this.cfg.getWingsWebShader(), e -> this.cfg.setWingsWebShader((boolean)e)).setEnabledCallback(() -> this.props.hasWings())).setSize(width, height));
        this.shieldColour = this.createColourPicker(() -> this.cfg.getShieldOverride(), e -> this.cfg.setShieldOverride((int)e), () -> this.cfg.getBaseColourI(this.cfg.getWingsTier()));
        leftControls.add(((GuiButton)((GuiButton)this.createEnableButton("Shield Colour: ", () -> this.cfg.overrideShield(), e -> this.cfg.setOverrideShield((boolean)e), "Custom", "Default").setEnabledCallback(() -> this.props.hasShieldRGB())).setSize(width, height)).addChild((GuiButton)((GuiButton)((GuiButton)this.colourPickerButton(this.shieldColour, () -> 3, () -> 3).setEnabledCallback(() -> this.cfg.overrideShield())).setXPos(width + 1)).setSize(height, height)).addChild((GuiButton)((GuiButton)((GuiButton)this.colourRGBButton(() -> this.cfg.getShieldRGB(), e -> this.cfg.setShieldRGB((boolean)e)).setEnabledCallback(() -> this.cfg.overrideShield())).setXPos(width + 16)).setSize(height, height)).getParent().getParent());
        rightControls.add((GuiElement<?>)this.createEnableButton("Welcome Message: ", () -> this.cfg.showWelcome(), e -> this.cfg.setShowWelcome((boolean)e)).setSize(width, height));
        rightControls.add((GuiElement<?>)((GuiButton)this.createListButton("Front Badge: ", () -> this.cfg.getChestBadge(), e -> this.cfg.setChestBadge((ContributorConfig.Badge)e), this.props.getBadges(), false).setEnabledCallback(() -> !this.props.getBadges().isEmpty())).setSize(width, height));
        rightControls.add((GuiElement<?>)((GuiButton)this.createListButton("Back Badge: ", () -> this.cfg.getBackBadge(), e -> this.cfg.setBackBadge((ContributorConfig.Badge)e), this.props.getBadges(), false).setEnabledCallback(() -> !this.props.getBadges().isEmpty())).setSize(width, height));
        rightControls.add((GuiElement<?>)((GuiLabel)new GuiLabel(ChatFormatting.UNDERLINE + " Wing Behavior ").setEnabledCallback(() -> this.props.hasWings())).setSize(width, height));
        rightControls.add((GuiElement<?>)((GuiButton)((GuiButton)this.createEnumButton("Grounded: ", ContributorConfig.WingBehavior.class, () -> this.cfg.getWingsGround(), e -> this.cfg.setWingsGround((ContributorConfig.WingBehavior)e)).setEnabledCallback(() -> this.props.hasWings())).setSize(width, height)).setHoverText("What happens when you are not flying"));
        rightControls.add((GuiElement<?>)((GuiButton)((GuiButton)this.createEnumButton("Creative: ", ContributorConfig.WingBehavior.class, () -> this.cfg.getWingsCreative(), e -> this.cfg.setWingsCreative((ContributorConfig.WingBehavior)e)).setEnabledCallback(() -> this.props.hasWings())).setSize(width, height)).setHoverText("When using creative style flight"));
        rightControls.add((GuiElement<?>)((GuiButton)this.createEnumButton("Elytra: ", ContributorConfig.WingElytraCompat.class, () -> this.cfg.getWingsElytra(), e -> this.cfg.setWingsElytra((ContributorConfig.WingElytraCompat)e)).setEnabledCallback(() -> this.props.hasWings())).setSize(width, height));
    }

    private GuiElement<?> arrangeControls(GuiElement<?> container, List<GuiElement<?>> controls) {
        int y = 0;
        for (GuiElement<?> control : controls) {
            if (!control.isEnabled()) continue;
            container.addChild(control).setYPos(y);
            y += control.ySize() + 1;
        }
        container.setBoundsToChildren();
        return container;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1 && this.playerRender.isMouseOver(mouseX, mouseY)) {
            this.dragging = true;
            return true;
        }
        boolean ret = super.m_6375_(mouseX, mouseY, button);
        this.dragging = !ret;
        return ret;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int clickedMouseButton, double dragX, double dragY) {
        if (this.dragging) {
            this.playerRender.setLockedRotation(this.playerRender.getLockedRotation() + (float)dragX);
        }
        return super.m_7979_(mouseX, mouseY, clickedMouseButton, dragX, dragY);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        int size = this.playerRender.xSize();
        size = (int)MathHelper.clip((double)((double)size + scrollAmount * (double)Math.max(size / 10, 1)), (double)10.0, (double)500.0);
        this.playerRender.setSize(size, size);
        this.playerRender.reloadElement();
        return super.m_6050_(mouseX, mouseY, scrollAmount);
    }

    @Override
    public void m_6305_(PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(mStack);
        super.m_6305_(mStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        this.cfg = this.props.getConfig();
    }

    private GuiButton createButton(String text) {
        return new GuiButton(text).setFillColours(-1879048192, -1877909487).setTextColour(GuiToolkit.Palette.Ctrl.textH(false), GuiToolkit.Palette.Ctrl.textH(true)).setBorderColours(-10461088, -7302913);
    }

    private GuiButton createEnableButton(String text, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return this.createEnableButton(text, getter, setter, "Enabled", "Disabled");
    }

    private GuiButton createEnableButton(String text, Supplier<Boolean> getter, Consumer<Boolean> setter, String trueText, String falseText) {
        return new GuiButton().setDisplaySupplier(() -> text + ((Boolean)getter.get() != false ? trueText : falseText)).setFillColours(-1879048192, -1877909487).setTextColour(GuiToolkit.Palette.Ctrl.textH(false), GuiToolkit.Palette.Ctrl.textH(true)).setBorderColours(-10461088, -7302913).setToggleStateSupplier(getter).onPressed(() -> setter.accept((Boolean)getter.get() == false));
    }

    private <T> GuiButton createListButton(String text, Supplier<T> getter, Consumer<T> setter, List<T> values, boolean nullOption) {
        return new GuiButton().setDisplaySupplier(() -> text + (getter.get() == null ? "Disabled" : getter.get().toString())).setFillColours(-1879048192, -1877909487).setTextColour(GuiToolkit.Palette.Ctrl.textH(false), GuiToolkit.Palette.Ctrl.textH(true)).setBorderColours(-10461088, -7302913).setHoverText(e -> {
            String[] stringArray;
            Object patt13271$temp = getter.get();
            if (patt13271$temp instanceof ContributorConfig.HoverText) {
                ContributorConfig.HoverText h = (ContributorConfig.HoverText)patt13271$temp;
                stringArray = h.getHoverText();
            } else {
                stringArray = null;
            }
            return stringArray;
        }).onPressed(() -> {
            if (values.isEmpty()) {
                return;
            }
            Object current = getter.get();
            if (current == null) {
                setter.accept(values.get(0));
            } else if (nullOption && values.indexOf(current) == values.size() - 1) {
                setter.accept(null);
            } else {
                setter.accept(values.get((values.indexOf(current) + 1) % values.size()));
            }
        });
    }

    private GuiButton colourPickerButton(GuiPickColourDialog dialog, Supplier<Integer> xPos, Supplier<Integer> yPos) {
        GuiButton button = this.toolkit.createIconButton(null, 14, BCGuiSprites.getter("color_picker"));
        dialog.setEnabledCallback(button::isEnabled);
        button.onPressed(() -> {
            dialog.setPos((Integer)xPos.get(), (Integer)yPos.get());
            dialog.toggleShown(false, 200);
        });
        return button;
    }

    private GuiButton colourRGBButton(Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return ((GuiButton)this.toolkit.createIconButton(null, 14, BCGuiSprites.getter("rgb_checker")).setToggleStateSupplier(getter).setHoverText("Enable rainbow RGB mode.", "Use the colour picker to configure,", "Red = Cycle Speed", "Green = Saturation", "Blue = Brightness")).onPressed(() -> setter.accept((Boolean)getter.get() == false));
    }

    private GuiPickColourDialog createColourPicker(Supplier<Integer> getter, Consumer<Integer> setter, Supplier<Integer> getDefault) {
        GuiPickColourDialog dialog = ((GuiPickColourDialog)new GuiPickColourDialog(this.container).setBackgroundElement(new GuiTooltipBackground()).setColour(getter.get()).setColourChangeListener(setter).setIncludeAlpha(false).setCloseOnOutsideClick(false)).setCancelEnabled(true);
        dialog.onReload(e -> ((GuiButton)e.cancelButton.setText("Reset").setTrim(false).setHoverText("Apply the default colours for the currently selected Wings tier")).onPressed(() -> ContributorConfigGui.lambda$createColourPicker$80(dialog, (Supplier)getDefault)), false);
        return dialog;
    }

    private <E extends Enum<E>> GuiButton createEnumButton(String text, Class<E> clazz, Supplier<E> getter, Consumer<E> setter) {
        return new GuiButton().setDisplaySupplier(() -> text + ((Enum)getter.get()).toString()).setHoverText(e -> {
            String[] stringArray;
            Object patt15791$temp = getter.get();
            if (patt15791$temp instanceof ContributorConfig.HoverText) {
                ContributorConfig.HoverText hover = (ContributorConfig.HoverText)patt15791$temp;
                stringArray = hover.getHoverText();
            } else {
                stringArray = null;
            }
            return stringArray;
        }).setFillColours(-1879048192, -1877909487).setTextColour(GuiToolkit.Palette.Ctrl.textH(false), GuiToolkit.Palette.Ctrl.textH(true)).setBorderColours(-10461088, -7302913).onButtonPressed(button -> setter.accept(((Enum[])clazz.getEnumConstants())[(((Enum)getter.get()).ordinal() + (button == 0 ? 1 : -1)) % ((Enum[])clazz.getEnumConstants()).length]));
    }

    private static /* synthetic */ void lambda$createColourPicker$80(GuiPickColourDialog dialog, Supplier getDefault) {
        dialog.updateColour((Integer)getDefault.get());
    }
}

