/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client;

import codechicken.lib.render.buffer.TransformingVertexConsumer;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.render.CustomSpriteUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;

public class BCGuiSprites {
    public static final ResourceLocation ATLAS_LOCATION = new ResourceLocation("brandonscore", "textures/atlas/gui.png");
    private static CustomSpriteUploader customSpriteUploader;
    private static final Map<ResourceLocation, Consumer<TextureAtlasSprite>> registeredSprites;
    private static final Map<String, Material> matCache;
    public static final RenderType GUI_TYPE;
    private static String[] ARMOR_ORDER;

    public static void initialize(ColorHandlerEvent.Block event) {
        customSpriteUploader = new CustomSpriteUploader(registeredSprites, ATLAS_LOCATION, "gui");
        Stream.of(GuiToolkit.GuiLayout.values()).filter(e -> e.xSize != -1).forEach(layout -> BCGuiSprites.registerThemed("brandonscore", layout.textureName()));
        BCGuiSprites.registerThemed("brandonscore", "background_dynamic");
        BCGuiSprites.registerThemed("brandonscore", "bg_dynamic_small");
        BCGuiSprites.registerThemed("brandonscore", "borderless_bg_dynamic_small");
        BCGuiSprites.registerThemed("brandonscore", "button");
        BCGuiSprites.registerThemed("brandonscore", "button_highlight");
        BCGuiSprites.registerThemed("brandonscore", "button_disabled");
        BCGuiSprites.registerThemed("brandonscore", "button_borderless");
        BCGuiSprites.registerThemed("brandonscore", "button_borderless_invert");
        BCGuiSprites.registerThemed("brandonscore", "slot");
        BCGuiSprites.registerThemed("brandonscore", "slot_large");
        BCGuiSprites.registerThemed("brandonscore", "resize");
        BCGuiSprites.registerThemed("brandonscore", "reposition");
        BCGuiSprites.registerThemed("brandonscore", "copy");
        BCGuiSprites.registerThemed("brandonscore", "theme");
        BCGuiSprites.registerThemed("brandonscore", "gear");
        BCGuiSprites.registerThemed("brandonscore", "advanced");
        BCGuiSprites.registerThemed("brandonscore", "arrow_left");
        BCGuiSprites.registerThemed("brandonscore", "arrow_right");
        BCGuiSprites.registerThemed("brandonscore", "expand_content");
        BCGuiSprites.registerThemed("brandonscore", "collapse_content");
        BCGuiSprites.registerThemed("brandonscore", "preset_icon");
        BCGuiSprites.registerThemed("brandonscore", "global_icon");
        BCGuiSprites.registerThemed("brandonscore", "global_icon_inactive");
        BCGuiSprites.registerThemed("brandonscore", "global_key_icon");
        BCGuiSprites.registerThemed("brandonscore", "grid_small");
        BCGuiSprites.registerThemed("brandonscore", "grid_large");
        BCGuiSprites.registerThemed("brandonscore", "item_config");
        BCGuiSprites.registerThemed("brandonscore", "hud_button");
        BCGuiSprites.registerThemed("brandonscore", "info_icon");
        BCGuiSprites.registerThemed("brandonscore", "prog_arrow_right");
        BCGuiSprites.registerThemed("brandonscore", "prog_arrow_right_over");
        BCGuiSprites.registerThemed("brandonscore", "prog_arrow_up");
        BCGuiSprites.registerThemed("brandonscore", "prog_arrow_up_over");
        BCGuiSprites.registerThemed("brandonscore", "prog_arrow_up_tall");
        BCGuiSprites.registerThemed("brandonscore", "prog_arrow_up_tall_over");
        BCGuiSprites.registerThemed("brandonscore", "pwr_btn");
        BCGuiSprites.register("brandonscore", "add");
        BCGuiSprites.register("brandonscore", "delete");
        BCGuiSprites.register("brandonscore", "delete_all");
        BCGuiSprites.register("brandonscore", "info_panel");
        BCGuiSprites.register("brandonscore", "reposition_gray");
        BCGuiSprites.register("brandonscore", "new_group");
        BCGuiSprites.register("brandonscore", "color_picker");
        BCGuiSprites.register("brandonscore", "legacy");
        BCGuiSprites.register("brandonscore", "rgb_checker");
        BCGuiSprites.register("brandonscore", "redstone/always_active");
        BCGuiSprites.register("brandonscore", "redstone/active_high");
        BCGuiSprites.register("brandonscore", "redstone/active_low");
        BCGuiSprites.register("brandonscore", "redstone/never_active");
        BCGuiSprites.register("brandonscore", "slots/fuel");
        BCGuiSprites.register("brandonscore", "slots/energy");
        BCGuiSprites.register("brandonscore", "slots/armor_boots");
        BCGuiSprites.register("brandonscore", "slots/armor_chestplate");
        BCGuiSprites.register("brandonscore", "slots/armor_helmet");
        BCGuiSprites.register("brandonscore", "slots/armor_leggings");
        BCGuiSprites.register("brandonscore", "slots/armor_shield");
        BCGuiSprites.register("brandonscore", "slots/sword");
        BCGuiSprites.register("brandonscore", "slots/trash");
        BCGuiSprites.register("brandonscore", "slots/filter");
        BCGuiSprites.register("brandonscore", "item_charge/btn_right_charge");
        BCGuiSprites.register("brandonscore", "item_charge/btn_right_discharge");
        BCGuiSprites.register("brandonscore", "item_charge/btn_right_disabled");
        BCGuiSprites.register("brandonscore", "item_charge/btn_right_both");
        BCGuiSprites.register("brandonscore", "item_charge/btn_vertical_charge");
        BCGuiSprites.register("brandonscore", "item_charge/btn_vertical_discharge");
        BCGuiSprites.register("brandonscore", "item_charge/btn_vertical_disabled");
        BCGuiSprites.register("brandonscore", "item_charge/btn_vertical_both");
        BCGuiSprites.register("brandonscore", "item_charge/horizontal_charge");
        BCGuiSprites.register("brandonscore", "item_charge/horizontal_discharge");
        BCGuiSprites.register("brandonscore", "item_charge/right_charge");
        BCGuiSprites.register("brandonscore", "item_charge/right_discharge");
        BCGuiSprites.register("brandonscore", "item_charge/vertical_charge");
        BCGuiSprites.register("brandonscore", "item_charge/vertical_discharge");
        BCGuiSprites.register("brandonscore", "bars/food_empty");
        BCGuiSprites.register("brandonscore", "bars/food_half");
        BCGuiSprites.register("brandonscore", "bars/food_full");
        BCGuiSprites.register("brandonscore", "bars/energy_empty");
        BCGuiSprites.register("brandonscore", "bars/energy_full");
        BCGuiSprites.register("brandonscore", "downloading");
        BCGuiSprites.register("brandonscore", "download_failed");
    }

    public static void registerThemed(String modid, String location) {
        BCGuiSprites.register(modid, "light/" + location);
        BCGuiSprites.register(modid, "dark/" + location);
    }

    public static void register(String modid, String location) {
        BCGuiSprites.register(new ResourceLocation(modid, location), (TextureAtlasSprite equipmentManager) -> {});
    }

    public static void register(ResourceLocation location) {
        BCGuiSprites.register(location, null);
    }

    public static void register(String modid, String location, Consumer<TextureAtlasSprite> onLoad) {
        BCGuiSprites.register(new ResourceLocation(modid, location), onLoad);
    }

    public static void register(ResourceLocation location, Consumer<TextureAtlasSprite> onLoad) {
        registeredSprites.put(location, onLoad);
    }

    public static Material getThemed(String modid, String location) {
        return BCGuiSprites.get(modid, (BCConfig.darkMode ? "dark/" : "light/") + location);
    }

    public static Material getThemed(String location) {
        return BCGuiSprites.get("brandonscore", (BCConfig.darkMode ? "dark/" : "light/") + location);
    }

    public static Material get(String modid, String location) {
        return matCache.computeIfAbsent(modid + ":" + location, s -> new CustomMat(ATLAS_LOCATION, new ResourceLocation(modid, location)));
    }

    public static Material get(String location) {
        return BCGuiSprites.get("brandonscore", location);
    }

    public static TextureAtlasSprite getSprite(String location) {
        return BCGuiSprites.get(location).m_119204_();
    }

    public static Supplier<Material> themedGetter(String modid, String location) {
        return () -> BCGuiSprites.get(modid, (BCConfig.darkMode ? "dark/" : "light/") + location);
    }

    public static Supplier<Material> themedGetter(String location) {
        return () -> BCGuiSprites.get("brandonscore", (BCConfig.darkMode ? "dark/" : "light/") + location);
    }

    public static Supplier<Material> getter(String modid, String location) {
        return () -> matCache.computeIfAbsent(modid + ":" + location, s -> new CustomMat(ATLAS_LOCATION, new ResourceLocation(modid, location)));
    }

    public static Supplier<Material> getter(String location) {
        return () -> BCGuiSprites.get("brandonscore", location);
    }

    public static Material getButton(int state) {
        return BCGuiSprites.getThemed(state == 1 ? "button" : (state == 2 ? "button_highlight" : "button_disabled"));
    }

    public static Material getArmorSlot(int slot) {
        return BCGuiSprites.get(ARMOR_ORDER[slot]);
    }

    public static RenderType makeType(ResourceLocation location) {
        return RenderType.m_173209_((String)"sprite_type", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172817_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
    }

    public static VertexConsumer builder(MultiBufferSource getter, PoseStack mStack) {
        return new TransformingVertexConsumer(getter.m_6299_(GUI_TYPE), mStack);
    }

    public static VertexConsumer builder(MultiBufferSource getter) {
        return getter.m_6299_(GUI_TYPE);
    }

    static {
        registeredSprites = new HashMap<ResourceLocation, Consumer<TextureAtlasSprite>>();
        matCache = new HashMap<String, Material>();
        GUI_TYPE = RenderType.m_173209_((String)"gui_tex", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172814_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ATLAS_LOCATION, false, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
        ARMOR_ORDER = new String[]{"slots/armor_boots", "slots/armor_leggings", "slots/armor_chestplate", "slots/armor_helmet"};
    }

    private static class CustomMat
    extends Material {
        public CustomMat(ResourceLocation atlasLocationIn, ResourceLocation textureLocationIn) {
            super(atlasLocationIn, textureLocationIn);
        }

        public TextureAtlasSprite m_119204_() {
            return customSpriteUploader.m_118901_(this.m_119203_());
        }
    }
}

