/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IDataRetainingTile;
import com.brandon3055.brandonscore.api.event.TileBCoreInitEvent;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.IOTracker;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileCapabilityManager;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.ContainerBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IDataManagerProvider;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.TileDataManager;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileBCore
extends BlockEntity
implements IDataManagerProvider,
IDataRetainingTile,
Nameable {
    public static final Logger LOGGER = LogManager.getLogger();
    protected boolean playerAccessTracking = false;
    protected TileCapabilityManager capManager = new TileCapabilityManager(this);
    protected TileDataManager<TileBCore> dataManager = new TileDataManager<TileBCore>(this);
    private Map<Integer, BiConsumer<MCDataInput, ServerPlayer>> serverPacketHandlers = new HashMap<Integer, BiConsumer<MCDataInput, ServerPlayer>>();
    protected Map<String, INBTSerializable<CompoundTag>> savedItemDataObjects = new HashMap<String, INBTSerializable<CompoundTag>>();
    protected Map<String, INBTSerializable<CompoundTag>> savedDataObjects = new HashMap<String, INBTSerializable<CompoundTag>>();
    private Map<Integer, Consumer<MCDataInput>> clientPacketHandlers = new HashMap<Integer, Consumer<MCDataInput>>();
    private boolean debugOutputEnabled = false;
    private ManagedBool debugEnabled = null;
    private List<Runnable> tickables = new ArrayList<Runnable>();
    private ManagedEnum<IRSSwitchable.RSMode> rsControlMode = this instanceof IRSSwitchable ? this.register(new ManagedEnum<IRSSwitchable.RSMode>("rs_mode", IRSSwitchable.RSMode.ALWAYS_ACTIVE, DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.CLIENT_CONTROL)) : null;
    private ManagedBool rsPowered = this instanceof IRSSwitchable ? this.register(new ManagedBool("rs_powered", false, DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE)) : null;
    private String customName = "";
    private Set<Player> accessingPlayers = new HashSet<Player>();
    private int tick = 0;

    public TileBCore(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        MinecraftForge.EVENT_BUS.post((Event)new TileBCoreInitEvent(this));
    }

    @Override
    public TileDataManager getDataManager() {
        return this.dataManager;
    }

    public TileCapabilityManager getCapManager() {
        return this.capManager;
    }

    public <M extends IManagedData> M register(M managedData) {
        return this.dataManager.register(managedData);
    }

    public void tick() {
        this.tickables.forEach(Runnable::run);
        this.detectAndSendChanges(false);
        ++this.tick;
    }

    public void detectAndSendChanges(boolean containerListeners) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (containerListeners) {
                this.dataManager.detectAndSendChangesToListeners(this.getAccessingPlayers());
                this.capManager.detectAndSendChangesToListeners(this.getAccessingPlayers());
            } else {
                this.dataManager.detectAndSendChanges();
                this.capManager.detectAndSendChanges();
            }
        }
    }

    public int getAccessDistanceSq() {
        return 64;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        this.dataManager.writeSyncNBT(compound);
        this.writeExtraNBT(compound);
        return compound;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.dataManager.readSyncNBT(pkt.m_131708_());
        this.readExtraNBT(pkt.m_131708_());
    }

    public PacketCustom createServerBoundPacket(int id) {
        AbstractContainerMenu container;
        Player player = BrandonsCore.proxy.getClientPlayer();
        if (player != null && (container = player.f_36096_) instanceof ContainerBCTile && ((ContainerBCTile)container).tile == this) {
            PacketCustom packet = ((ContainerBCTile)container).createServerBoundPacket(1);
            packet.writeByte((int)((byte)id));
            return packet;
        }
        return new PacketCustom(BCoreNetwork.CHANNEL, 99);
    }

    public void sendPacketToServer(Consumer<MCDataOutput> writer, int id) {
        PacketCustom packet = this.createServerBoundPacket(id);
        writer.accept((MCDataOutput)packet);
        packet.sendToServer();
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        if (this.serverPacketHandlers.containsKey(id)) {
            this.serverPacketHandlers.get(id).accept(data, client);
        }
    }

    public PacketCustom createClientBoundPacket(int id) {
        PacketCustom packet = new PacketCustom(BCoreNetwork.CHANNEL, 2);
        packet.writePos(this.f_58858_);
        packet.writeByte((int)((byte)id));
        return packet;
    }

    public PacketCustom sendPacketToClient(Consumer<MCDataOutput> writer, int id) {
        PacketCustom packet = this.createClientBoundPacket(id);
        writer.accept((MCDataOutput)packet);
        return packet;
    }

    public void sendPacketToClient(ServerPlayer player, Consumer<MCDataOutput> writer, int id) {
        this.sendPacketToClient(writer, id).sendToPlayer(player);
    }

    public void sendPacketToClients(Collection<Player> players, Consumer<MCDataOutput> writer, int id) {
        PacketCustom packet = this.createClientBoundPacket(id);
        writer.accept((MCDataOutput)packet);
        this.sendPacketToClients(players, packet);
    }

    public void sendPacketToClients(Collection<Player> players, PacketCustom packet) {
        players.stream().filter(e -> e instanceof ServerPlayer).map(e -> (ServerPlayer)e).forEach(arg_0 -> ((PacketCustom)packet).sendToPlayer(arg_0));
    }

    public void sendPacketToChunk(Consumer<MCDataOutput> writer, int id) {
        this.sendPacketToClient(writer, id).sendToChunk((BlockEntity)this);
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        if (this.clientPacketHandlers.containsKey(id)) {
            this.clientPacketHandlers.get(id).accept(data);
        }
    }

    public void setClientSidePacketHandler(int packetId, Consumer<MCDataInput> handler) {
        this.clientPacketHandlers.put(packetId, handler);
    }

    public void setServerSidePacketHandler(int packetId, BiConsumer<MCDataInput, ServerPlayer> handler) {
        this.serverPacketHandlers.put(packetId, handler);
    }

    public void updateBlock() {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
    }

    public void dirtyBlock() {
        LevelChunk chunk = this.f_58857_.m_46745_(this.m_58899_());
        chunk.m_8092_(true);
    }

    public <T extends Runnable> T addTickable(T runnable) {
        this.tickables.add(runnable);
        return runnable;
    }

    public boolean removeTickable(Runnable runnable) {
        return this.tickables.remove(runnable);
    }

    @Override
    public void writeToItemStack(CompoundTag nbt, boolean willHarvest) {
        this.dataManager.writeToStackNBT(nbt);
        this.savedItemDataObjects.forEach((tagName, serializable) -> nbt.m_128365_(tagName, serializable.serializeNBT()));
        CompoundTag capTags = this.capManager.serialize(true);
        if (!capTags.m_128456_()) {
            nbt.m_128365_("bc_caps", (Tag)capTags);
        }
        this.writeExtraTileAndStack(nbt);
    }

    @Override
    public void readFromItemStack(CompoundTag nbt) {
        this.dataManager.readFromStackNBT(nbt);
        this.savedItemDataObjects.forEach((tagName, serializable) -> serializable.deserializeNBT((Tag)nbt.m_128469_(tagName)));
        if (nbt.m_128441_("bc_caps")) {
            this.capManager.deserialize(nbt.m_128469_("bc_caps"));
        }
        this.readExtraTileAndStack(nbt);
    }

    public void writeExtraNBT(CompoundTag nbt) {
        CompoundTag capTags = this.capManager.serialize(false);
        if (!capTags.m_128456_()) {
            nbt.m_128365_("bc_caps", (Tag)capTags);
        }
        if (!this.customName.isEmpty()) {
            nbt.m_128359_("custom_name", this.customName);
        }
        this.savedDataObjects.forEach((tagName, serializable) -> nbt.m_128365_(tagName, serializable.serializeNBT()));
        this.writeExtraTileAndStack(nbt);
    }

    public void readExtraNBT(CompoundTag nbt) {
        if (nbt.m_128441_("bc_caps")) {
            this.capManager.deserialize(nbt.m_128469_("bc_caps"));
        }
        if (nbt.m_128425_("custom_name", 8)) {
            this.customName = nbt.m_128461_("custom_name");
        }
        this.savedDataObjects.forEach((tagName, serializable) -> serializable.deserializeNBT((Tag)nbt.m_128469_(tagName)));
        this.readExtraTileAndStack(nbt);
    }

    public void writeExtraTileAndStack(CompoundTag nbt) {
    }

    public void readExtraTileAndStack(CompoundTag nbt) {
    }

    protected final void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.dataManager.writeToNBT(nbt);
        this.writeExtraNBT(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.dataManager.readFromNBT(nbt);
        this.readExtraNBT(nbt);
        this.onTileLoaded();
    }

    public void onTileLoaded() {
    }

    public void setSavedDataObject(String tagName, INBTSerializable<CompoundTag> dataObject) {
        this.savedDataObjects.put(tagName, dataObject);
    }

    public void setItemSavedDataObject(String tagName, INBTSerializable<CompoundTag> dataObject) {
        this.savedItemDataObjects.put(tagName, dataObject);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        LazyOptional ret = this.capManager.getCapability(capability, side);
        return ret.isPresent() ? ret : super.getCapability(capability, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capManager.invalidate();
    }

    public long sendEnergyToAll(long maxPerTarget, long maxAvailable) {
        long i = 0L;
        for (Direction direction : Direction.values()) {
            i += this.sendEnergyTo(Math.min(maxPerTarget, maxAvailable - i), direction);
        }
        return i;
    }

    public long sendEnergyTo(long maxSend, Direction side) {
        if (maxSend == 0L) {
            return 0L;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_142300_(side));
        if (tile != null) {
            return EnergyUtils.insertEnergy(tile, maxSend, side.m_122424_(), false);
        }
        return 0L;
    }

    public static long sendEnergyTo(LevelReader world, BlockPos pos, long maxSend, Direction side) {
        if (maxSend == 0L) {
            return 0L;
        }
        BlockEntity tile = world.m_7702_(pos.m_142300_(side));
        if (tile != null) {
            return EnergyUtils.insertEnergy(tile, maxSend, side.m_122424_(), false);
        }
        return 0L;
    }

    public static long sendEnergyToAll(LevelReader world, BlockPos pos, long maxPerTarget, long maxAvailable) {
        long i = 0L;
        for (Direction direction : Direction.values()) {
            i += TileBCore.sendEnergyTo(world, pos, Math.min(maxPerTarget, maxAvailable - i), direction);
        }
        return i;
    }

    public void installIOTracker(OPStorage storage) {
        storage.setIOTracker(this.addTickable(new IOTracker()));
    }

    public void setupPowerSlot(IItemHandler itemHandler, int slot, IOPStorage storage, ManagedBool chargeItem) {
        this.setupPowerSlot(itemHandler, slot, storage, chargeItem::get);
    }

    public void setupPowerSlot(IItemHandler itemHandler, int slot, IOPStorage storage, boolean chargeItem) {
        this.setupPowerSlot(itemHandler, slot, storage, () -> chargeItem);
    }

    private void setupPowerSlot(IItemHandler itemHandler, int slot, IOPStorage storage, Supplier<Boolean> chargeItem) {
        if (itemHandler instanceof TileItemStackHandler) {
            ((TileItemStackHandler)itemHandler).setSlotValidator(slot, stack -> (Boolean)chargeItem.get() != false ? EnergyUtils.canReceiveEnergy(stack) : EnergyUtils.canExtractEnergy(stack));
        }
        if (EffectiveSide.get().isServer()) {
            this.addTickable(() -> {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (!stack.m_41619_()) {
                    if (((Boolean)chargeItem.get()).booleanValue()) {
                        EnergyUtils.transferEnergy(storage, stack);
                    } else {
                        EnergyUtils.transferEnergy(stack, storage);
                    }
                }
            });
        }
    }

    public int getTime() {
        return this.tick;
    }

    public boolean onInterval(int tickInterval) {
        return this.tick % tickInterval == 0;
    }

    public IRSSwitchable.RSMode getRSMode() {
        if (!(this instanceof IRSSwitchable)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        return this.rsControlMode.get();
    }

    public void setRSMode(IRSSwitchable.RSMode mode) {
        if (!(this instanceof IRSSwitchable)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        this.rsControlMode.set(mode);
    }

    public void cycleRSMode(boolean reverse) {
        this.rsControlMode.set(this.rsControlMode.get().next(reverse));
    }

    public void onNeighborChange(BlockPos neighbor) {
        if (this instanceof IRSSwitchable) {
            boolean lastSignal = this.rsPowered.get();
            this.rsPowered.set(this.f_58857_.m_46753_(this.f_58858_));
            if (this.rsPowered.get() != lastSignal) {
                this.onSignalChange(this.rsPowered.get());
            }
        }
    }

    public void onSignalChange(boolean newSignal) {
    }

    public boolean isTileEnabled() {
        if (this instanceof IRSSwitchable) {
            return this.rsControlMode.get().canRun(this.rsPowered.get());
        }
        return true;
    }

    public boolean hasRSSignal() {
        return this.f_58857_.m_46753_(this.m_58899_());
    }

    public int getRSSignal() {
        return this.f_58857_.m_46755_(this.m_58899_());
    }

    public Component m_7755_() {
        if (this.m_8077_()) {
            return new TextComponent(this.customName);
        }
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }

    public boolean m_8077_() {
        return !this.customName.isEmpty();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName.isEmpty() ? null : this.m_7755_();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public void enablePlayerAccessTracking(boolean playerAccessTracking) {
        this.playerAccessTracking = playerAccessTracking;
    }

    public Set<Player> getAccessingPlayers() {
        this.accessingPlayers.removeIf(e -> !(e.f_36096_ instanceof ContainerBCore) || ((ContainerBCTile)e.f_36096_).tile != this);
        return this.accessingPlayers;
    }

    public void onPlayerOpenContainer(Player player) {
        this.accessingPlayers.add(player);
    }

    public void onPlayerCloseContainer(Player player) {
        this.accessingPlayers.remove(player);
        this.accessingPlayers.removeIf(e -> !(e.f_36096_ instanceof ContainerBCore) || ((ContainerBCTile)e.f_36096_).tile != this);
    }

    public int posSeed() {
        return (int)this.f_58858_.m_121878_();
    }

    protected void enableTileDebug() {
        this.debugEnabled = new ManagedBool("tile.debugging.enabled", false, DataFlags.SYNC_TILE);
        this.register(this.debugEnabled);
    }

    public boolean toggleDebugOutput(Player player) {
        if (this.debugEnabled == null) {
            return false;
        }
        this.debugEnabled.invert();
        player.m_6352_((Component)new TextComponent("Debug is now " + (this.debugEnabled.get() ? "Enabled (Check Server/Client console)" : "Disabled")), Util.f_137441_);
        return true;
    }

    public void debug(Object text) {
        if (this.debugEnabled()) {
            LOGGER.info("TileDebug:" + this.m_58899_() + ", " + this.m_58904_().m_46472_().m_135782_() + ": " + text);
        }
    }

    public boolean debugEnabled() {
        return this.debugEnabled != null && this.debugEnabled.get();
    }
}

