/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IDataRetainingTile;
import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.IBCoreBlock;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRedstoneEmitter;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawSelectionEvent;

public class BlockBCore
extends Block
implements IBCoreBlock {
    public static final String BC_TILE_DATA_TAG = "bc_tile_data";
    public static final String BC_MANAGED_DATA_FLAG = "bc_managed_data";
    protected boolean canProvidePower = false;
    protected boolean isMobResistant = false;
    private boolean blockSpawns = false;
    private boolean isLightTransparent = false;

    public BlockBCore(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockBCore setLightTransparent() {
        this.isLightTransparent = true;
        return this;
    }

    public BlockBCore setMobResistant() {
        this.isMobResistant = true;
        return this;
    }

    @Deprecated
    protected boolean hasBlockEntity() {
        return this instanceof EntityBlockBCore;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return !this.blockSpawns && super.isValidSpawn(state, level, pos, type, entityType);
    }

    public float m_7749_(BlockState p_60472_, BlockGetter p_60473_, BlockPos p_60474_) {
        return this.isLightTransparent ? 1.0f : super.m_7749_(p_60472_, p_60473_, p_60474_);
    }

    public BlockBCore dontSpawnOnMe() {
        this.blockSpawns = true;
        return this;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof IDataRetainingTile && !BrandonsCore.proxy.isCTRLKeyDown()) {
            CompoundTag tileData = new CompoundTag();
            ((IDataRetainingTile)tile).writeToItemStack(tileData, false);
            if (!tileData.m_128456_()) {
                ItemNBTHelper.getCompound(stack).m_128365_(BC_TILE_DATA_TAG, (Tag)tileData);
            }
        }
        if (tile instanceof Nameable && ((Nameable)tile).m_8077_()) {
            stack.m_41714_(((Nameable)tile).m_7755_());
        }
        return stack;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        if (this.hasBlockEntity()) {
            BlockEntity tile = world.m_7702_(pos);
            return tile instanceof IRedstoneEmitter;
        }
        return this.canProvidePower || super.canConnectRedstone(state, world, pos, side);
    }

    public boolean m_7899_(BlockState state) {
        return this.canProvidePower;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        if (this.hasBlockEntity()) {
            BlockEntity tile = world.m_7702_(pos);
            return tile instanceof IChangeListener;
        }
        return super.shouldCheckWeakPower(state, world, pos, side);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity tile;
        if (this.hasBlockEntity() && (tile = blockAccess.m_7702_(pos)) instanceof IRedstoneEmitter) {
            return ((IRedstoneEmitter)tile).getWeakPower(blockState, side);
        }
        return super.m_6378_(blockState, blockAccess, pos, side);
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity tile;
        if (this.hasBlockEntity() && (tile = blockAccess.m_7702_(pos)) instanceof IRedstoneEmitter) {
            return ((IRedstoneEmitter)tile).getStrongPower(blockState, side);
        }
        return super.m_6376_(blockState, blockAccess, pos, side);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity tile;
        if (this.hasBlockEntity() && (tile = world.m_7702_(pos)) instanceof IChangeListener) {
            ((IChangeListener)tile).onNeighborChange(fromPos);
        }
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile;
        if (this.hasBlockEntity() && (tile = world.m_7702_(pos)) instanceof IInteractTile) {
            return ((IInteractTile)tile).onBlockUse(state, player, hand, hit);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        BlockEntity tile;
        if (this.hasBlockEntity() && (tile = world.m_7702_(pos)) instanceof IInteractTile) {
            ((IInteractTile)tile).onBlockAttack(state, player);
        }
        super.m_6256_(state, world, pos, player);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IDataRetainingTile && stack.m_41782_() && stack.m_41783_().m_128441_(BC_TILE_DATA_TAG)) {
            ((IDataRetainingTile)tile).readFromItemStack(stack.m_41737_(BC_TILE_DATA_TAG));
        }
        if (tile instanceof TileBCore && stack.m_41788_()) {
            ((TileBCore)tile).setCustomName(stack.m_41786_().getString());
        }
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity te, ItemStack heldStack) {
        ItemStack stack = null;
        if (te instanceof IDataRetainingTile && ((IDataRetainingTile)te).saveToItem()) {
            CompoundTag tileData = new CompoundTag();
            ((IDataRetainingTile)te).writeToItemStack(tileData, true);
            if (!tileData.m_128456_()) {
                stack = new ItemStack((ItemLike)this, 1);
                ItemNBTHelper.getCompound(stack).m_128365_(BC_TILE_DATA_TAG, (Tag)tileData);
            }
        }
        if (te instanceof Nameable && ((Nameable)te).m_8077_()) {
            if (stack == null) {
                stack = new ItemStack((ItemLike)this, 1);
            }
            stack.m_41714_(((Nameable)te).m_7755_());
        }
        if (stack != null) {
            player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
            player.m_36399_(0.005f);
            BlockBCore.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
            world.m_46747_(pos);
        } else {
            super.m_6240_(world, player, pos, state, te, heldStack);
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        if (!this.isMobResistant) {
            return super.canEntityDestroy(state, world, pos, entity);
        }
        return entity instanceof Player;
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (!this.isMobResistant) {
            super.onBlockExploded(state, world, pos, explosion);
        }
    }

    public boolean m_6903_(Explosion explosionIn) {
        if (!this.isMobResistant) {
            return super.m_6903_(explosionIn);
        }
        return false;
    }

    public static int getRedstonePower(LevelReader world, BlockPos pos, Direction facing) {
        BlockState blockstate = world.m_8055_(pos);
        return blockstate.shouldCheckWeakPower(world, pos, facing) ? BlockBCore.getStrongPower(world, pos) : blockstate.m_60746_((BlockGetter)world, pos, facing);
    }

    public static int getStrongPower(LevelReader world, BlockPos pos) {
        int i = 0;
        if ((i = Math.max(i, world.m_46852_(pos.m_7495_(), Direction.DOWN))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.m_46852_(pos.m_7494_(), Direction.UP))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.m_46852_(pos.m_142127_(), Direction.NORTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.m_46852_(pos.m_142128_(), Direction.SOUTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, world.m_46852_(pos.m_142125_(), Direction.WEST))) >= 15) {
            return i;
        }
        return (i = Math.max(i, world.m_46852_(pos.m_142126_(), Direction.EAST))) >= 15 ? i : i;
    }

    public static boolean isBlockPowered(LevelReader world, BlockPos pos) {
        if (BlockBCore.getRedstonePower(world, pos.m_7495_(), Direction.DOWN) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.m_7494_(), Direction.UP) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.m_142127_(), Direction.NORTH) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.m_142128_(), Direction.SOUTH) > 0) {
            return true;
        }
        if (BlockBCore.getRedstonePower(world, pos.m_142125_(), Direction.WEST) > 0) {
            return true;
        }
        return BlockBCore.getRedstonePower(world, pos.m_142126_(), Direction.EAST) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_() && stack.m_41783_().m_128441_(BC_TILE_DATA_TAG)) {
            tooltip.add((Component)new TranslatableComponent("info.brandonscore.block_has_saved_data"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderSelectionBox(DrawSelectionEvent.HighlightBlock event, Level level) {
        return true;
    }
}

