/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.render;

import codechicken.lib.render.buffer.TransformingVertexConsumer;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.utils.Utils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class GuiHelper {
    public static final RenderType transColourType = RenderType.m_173209_((String)"ghv2_trans_colour", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));

    public static void drawHoverRect(MultiBufferSource getter, PoseStack mStack, double x, double y, double width, double height, int backgroundColor, int borderColorStart, int borderColorEnd, boolean empty) {
        GuiHelper.drawGradient(getter, mStack, x + 1.0, y, width - 2.0, 1.0, backgroundColor, backgroundColor);
        GuiHelper.drawGradient(getter, mStack, x + 1.0, y + height - 1.0, width - 2.0, 1.0, backgroundColor, backgroundColor);
        GuiHelper.drawGradient(getter, mStack, x, y + 1.0, 1.0, height - 2.0, backgroundColor, backgroundColor);
        GuiHelper.drawGradient(getter, mStack, x + width - 1.0, y + 1.0, 1.0, height - 2.0, backgroundColor, backgroundColor);
        if (!empty) {
            GuiHelper.drawGradient(getter, mStack, x + 1.0, y + 1.0, width - 2.0, height - 2.0, backgroundColor, backgroundColor);
        }
        GuiHelper.drawGradient(getter, mStack, x + 1.0, y + 1.0, 1.0, height - 2.0, borderColorStart, borderColorEnd);
        GuiHelper.drawGradient(getter, mStack, x + width - 2.0, y + 1.0, 1.0, height - 2.0, borderColorStart, borderColorEnd);
        GuiHelper.drawGradient(getter, mStack, x + 2.0, y + 1.0, width - 4.0, 1.0, borderColorStart, borderColorStart);
        GuiHelper.drawGradient(getter, mStack, x + 2.0, y + height - 2.0, width - 4.0, 1.0, borderColorEnd, borderColorEnd);
    }

    public static void drawHoverRect(MultiBufferSource getter, PoseStack mStack, double x, double y, double width, double height, int backgroundColor, int borderColor, boolean empty) {
        int borderColorEnd = (borderColor & 0xFEFEFE) >> 1 | borderColor & 0xFF000000;
        GuiHelper.drawHoverRect(getter, mStack, x, y, width, height, backgroundColor, borderColor, borderColorEnd, empty);
    }

    public static void drawHoverRect(MultiBufferSource getter, PoseStack mStack, double x, double y, double width, double height, boolean empty) {
        GuiHelper.drawHoverRect(getter, mStack, x, y, width, height, -267386864, 0x505000FF, empty);
    }

    public static void drawHoverRect(MultiBufferSource getter, PoseStack mStack, double x, double y, double width, double height, int backgroundColor, int borderColor) {
        int borderColorEnd = (borderColor & 0xFEFEFE) >> 1 | borderColor & 0xFF000000;
        GuiHelper.drawHoverRect(getter, mStack, x, y, width, height, backgroundColor, borderColor, borderColorEnd, false);
    }

    public static void drawHoverRect(MultiBufferSource getter, PoseStack mStack, double x, double y, double width, double height) {
        GuiHelper.drawHoverRect(getter, mStack, x, y, width, height, -267386864, 0x505000FF, false);
    }

    public static void drawGradient(MultiBufferSource getter, PoseStack mStack, double x, double y, double width, double height, int startColor, int endColor) {
        GuiHelper.drawGradientRect(getter, mStack, x, y, x + width, y + height, startColor, endColor);
    }

    public static void drawRect(MultiBufferSource getter, PoseStack mStack, double x, double y, double width, double height, int colour) {
        GuiHelper.drawGradientRect(getter, mStack, x, y, x + width, y + height, colour, colour);
    }

    public static void drawGradientRect(MultiBufferSource getter, PoseStack mStack, double left, double top, double right, double bottom, int startColor, int endColor) {
        if (startColor == endColor && endColor == 0) {
            return;
        }
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(transColourType), mStack);
        builder.m_5483_(right, top, 0.0).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_5483_(left, top, 0.0).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_5483_(left, bottom, 0.0).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        builder.m_5483_(right, bottom, 0.0).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
    }

    public static void drawMultiPassGradientRect(MultiBufferSource getter, PoseStack mStack, double left, double top, double right, double bottom, int startColor, int endColor, int layers) {
        if (startColor == endColor && endColor == 0) {
            return;
        }
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(transColourType), mStack);
        for (int i = 0; i < layers; ++i) {
            builder.m_5483_(right, top, 0.0).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
            builder.m_5483_(left, top, 0.0).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
            builder.m_5483_(left, bottom, 0.0).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
            builder.m_5483_(right, bottom, 0.0).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        }
    }

    public static void drawShadedRect(MultiBufferSource getter, PoseStack poseStack, double x, double y, double width, double height, double borderWidth, int fill, int topLeftColour, int bottomRightColour, int cornerMixColour) {
        GuiHelper.drawRect(getter, poseStack, x + borderWidth, y + borderWidth, width - borderWidth * 2.0, height - borderWidth * 2.0, fill);
        GuiHelper.drawRect(getter, poseStack, x, y, width - borderWidth, borderWidth, topLeftColour);
        GuiHelper.drawRect(getter, poseStack, x, y + borderWidth, borderWidth, height - borderWidth * 2.0, topLeftColour);
        GuiHelper.drawRect(getter, poseStack, x + borderWidth, y + height - borderWidth, width - borderWidth, borderWidth, bottomRightColour);
        GuiHelper.drawRect(getter, poseStack, x + width - borderWidth, y + borderWidth, borderWidth, height - borderWidth * 2.0, bottomRightColour);
        GuiHelper.drawRect(getter, poseStack, x + width - borderWidth, y, borderWidth, borderWidth, cornerMixColour);
        GuiHelper.drawRect(getter, poseStack, x, y + height - borderWidth, borderWidth, borderWidth, cornerMixColour);
    }

    public static void drawBorderedRect(MultiBufferSource getter, PoseStack poseStack, double x, double y, double width, double height, double borderWidth, int fillColour, int borderColour) {
        GuiHelper.drawRect(getter, poseStack, x + borderWidth, y + borderWidth, width - borderWidth * 2.0, height - borderWidth * 2.0, fillColour);
        GuiHelper.drawRect(getter, poseStack, x, y, width, borderWidth, borderColour);
        GuiHelper.drawRect(getter, poseStack, x, y + borderWidth, borderWidth, height - borderWidth * 2.0, borderColour);
        GuiHelper.drawRect(getter, poseStack, x, y + height - borderWidth, width, borderWidth, borderColour);
        GuiHelper.drawRect(getter, poseStack, x + width - borderWidth, y + borderWidth, borderWidth, height - borderWidth * 2.0, borderColour);
    }

    public static void drawSprite(VertexConsumer builder, double x, double y, double width, double height, TextureAtlasSprite sprite) {
        builder.m_5483_(x, y + height, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
        builder.m_5483_(x + width, y + height, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
        builder.m_5483_(x + width, y, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
        builder.m_5483_(x, y, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
    }

    public static void drawSprite(VertexConsumer builder, double x, double y, double width, double height, TextureAtlasSprite sprite, int colour) {
        float alpha = (float)(colour >> 24 & 0xFF) / 255.0f;
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        GuiHelper.drawSprite(builder, x, y, width, height, sprite, red, green, blue, alpha);
    }

    public static void drawSprite(VertexConsumer builder, double x, double y, double width, double height, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        builder.m_5483_(x, y + height, 0.0).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
        builder.m_5483_(x + width, y + height, 0.0).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
        builder.m_5483_(x + width, y, 0.0).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
        builder.m_5483_(x, y, 0.0).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
    }

    public static void drawPartialSprite(VertexConsumer builder, double x, double y, double width, double height, TextureAtlasSprite sprite, double minU, double minV, double maxU, double maxV) {
        float sW = sprite.m_118410_() - sprite.m_118409_();
        float sH = sprite.m_118412_() - sprite.m_118411_();
        float uMin = sprite.m_118409_() + sW * (float)minU;
        float uMax = sprite.m_118409_() + sW * (float)maxU;
        float vMin = sprite.m_118411_() + sH * (float)minV;
        float vMax = sprite.m_118411_() + sH * (float)maxV;
        builder.m_5483_(x, y + height, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMin, vMax).m_5752_();
        builder.m_5483_(x + width, y + height, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMax).m_5752_();
        builder.m_5483_(x + width, y, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMin).m_5752_();
        builder.m_5483_(x, y, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMin, vMin).m_5752_();
    }

    public static void drawPartialSprite(VertexConsumer builder, double x, double y, double width, double height, TextureAtlasSprite sprite, double minU, double minV, double maxU, double maxV, double texWidth, double texHeight) {
        GuiHelper.drawPartialSprite(builder, x, y, width, height, sprite, minU / texHeight, minV / texHeight, maxU / texWidth, maxV / texHeight);
    }

    public static void drawPartialSprite(VertexConsumer builder, double x, double y, double width, double height, TextureAtlasSprite sprite, double minU, double minV, double maxU, double maxV, float red, float green, float blue, float alpha) {
        float sW = sprite.m_118410_() - sprite.m_118409_();
        float sH = sprite.m_118412_() - sprite.m_118411_();
        float uMin = sprite.m_118409_() + sW * (float)minU;
        float uMax = sprite.m_118409_() + sW * (float)maxU;
        float vMin = sprite.m_118411_() + sH * (float)minV;
        float vMax = sprite.m_118411_() + sH * (float)maxV;
        builder.m_5483_(x, y + height, 0.0).m_85950_(red, green, blue, alpha).m_7421_(uMin, vMax).m_5752_();
        builder.m_5483_(x + width, y + height, 0.0).m_85950_(red, green, blue, alpha).m_7421_(uMax, vMax).m_5752_();
        builder.m_5483_(x + width, y, 0.0).m_85950_(red, green, blue, alpha).m_7421_(uMax, vMin).m_5752_();
        builder.m_5483_(x, y, 0.0).m_85950_(red, green, blue, alpha).m_7421_(uMin, vMin).m_5752_();
    }

    public static void drawPartialSprite(VertexConsumer builder, double x, double y, double width, double height, TextureAtlasSprite sprite, double minU, double minV, double maxU, double maxV, double texWidth, double texHeight, int colour) {
        float alpha = (float)(colour >> 24 & 0xFF) / 255.0f;
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        GuiHelper.drawPartialSprite(builder, x, y, width, height, sprite, minU / texHeight, minV / texHeight, maxU / texWidth, maxV / texHeight, red, green, blue, alpha);
    }

    public static void drawTexture(VertexConsumer builder, double x, double y, double width, double height) {
        builder.m_5483_(x, y + height, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
        builder.m_5483_(x + width, y + height, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
        builder.m_5483_(x + width, y, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
        builder.m_5483_(x, y, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
    }

    public static void drawPieProgress(MultiBufferSource getter, PoseStack mStack, double x, double y, double diameter, double progress, double offsetAngle, int colour) {
        float alpha = (float)(colour >> 24 & 0xFF) / 255.0f;
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        double radius = diameter / 2.0;
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(GuiHelperOld.FAN_TYPE), mStack);
        builder.m_5483_(x + radius, y + radius, 0.0).m_6122_(0, 255, 255, 64).m_5752_();
        for (double d = 0.0; d <= 1.0; d += 0.03333333333333333) {
            double angle = d * progress + 0.5 - progress;
            angle *= Math.PI * 2;
            double vertX = x + radius + Math.sin(angle += 0.017453292519943 * offsetAngle) * radius;
            double vertY = y + radius + Math.cos(angle) * radius;
            builder.m_5483_(vertX, vertY, 0.0).m_85950_(red, green, blue, alpha).m_5752_();
        }
    }

    public static void renderGuiStack(ItemStack stack, PoseStack poseStack, double x, double y, double width, double height) {
        boolean noBlockLight;
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        BakedModel model = itemRenderer.m_174264_(stack, null, null, 0);
        float xScale = (float)width / 16.0f;
        float yScale = (float)height / 16.0f;
        minecraft.m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_85837_(x + 8.0 * (double)xScale, y + 8.0 * (double)yScale, 0.0);
        poseStack.m_85841_(16.0f, -16.0f, 16.0f);
        poseStack.m_85841_(xScale, yScale, 1.0f);
        GuiHelper.pushModelViewPoseStack(poseStack);
        poseStack.m_85849_();
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = noBlockLight = !model.m_7547_();
        if (noBlockLight) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, new PoseStack(), (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_, model);
        buffers.m_109911_();
        RenderSystem.m_69482_();
        if (noBlockLight) {
            Lighting.m_84931_();
        }
        GuiHelper.popModelViewPoseStack(poseStack);
    }

    public static void renderStackOverlay(ItemStack stack, PoseStack poseStack, Font font, double x, double y, double width, double height, boolean drawCount) {
        float xScale = (float)width / 16.0f;
        float yScale = (float)height / 16.0f;
        if (!stack.m_41619_()) {
            poseStack.m_85836_();
            if (stack.m_41613_() != 1 && drawCount) {
                String s = String.valueOf(stack.m_41613_());
                poseStack.m_85837_(x, y, 0.0);
                poseStack.m_85841_(xScale, yScale, 1.0f);
                MultiBufferSource.BufferSource buffer = RenderUtils.getGuiBuffers();
                font.m_92811_(s, (float)(17 - font.m_92895_(s)), 9.0f, 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, 0xF000F0);
                buffer.m_109911_();
            }
            if (stack.m_150947_()) {
                MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
                poseStack.m_85837_(x, y, 0.0);
                poseStack.m_85841_(xScale, yScale, 1.0f);
                int i = stack.m_150948_();
                int colour = stack.m_150949_();
                GuiHelper.drawRect((MultiBufferSource)getter, poseStack, 2.0, 13.0, 13.0, 2.0, -16777216);
                GuiHelper.drawRect((MultiBufferSource)getter, poseStack, 2.0, 13.0, i, 1.0, 0xFF000000 | colour);
                RenderUtils.endBatch((MultiBufferSource)getter);
            }
            poseStack.m_85849_();
        }
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX < (double)(x + xSize) && mouseY >= (double)y && mouseY < (double)(y + ySize);
    }

    public static boolean isInRect(double x, double y, double xSize, double ySize, double mouseX, double mouseY) {
        return mouseX >= x && mouseX < x + xSize && mouseY >= y && mouseY < y + ySize;
    }

    public static double distToRect(double x, double y, double xSize, double ySize, double mouseX, double mouseY) {
        if (GuiHelper.isInRect(x, y, xSize, ySize, mouseX, mouseY)) {
            return 0.0;
        }
        if (mouseY >= y && mouseY < y + ySize) {
            return mouseX >= x + xSize ? mouseX - (x + xSize) : x - mouseX;
        }
        if (mouseX >= x && mouseX < x + xSize) {
            return mouseY < y ? y - mouseY : mouseY - (y + ySize);
        }
        double cx = mouseX < x ? x : x + xSize;
        double cy = mouseY < y ? y : y + ySize;
        return Utils.getDistance(cx, cy, mouseX, mouseY);
    }

    public static RenderType guiTextureType(ResourceLocation resource) {
        return RenderType.m_173209_((String)"gui_resource", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172814_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resource, false, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
    }

    public static int mixColours(int colour1, int colour2) {
        return GuiHelper.mixColours(colour1, colour2, false);
    }

    public static int mixColours(int colour1, int colour2, boolean subtract) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        int alpha = Mth.m_14045_((int)(alpha1 + (subtract ? -alpha2 : alpha2)), (int)0, (int)255);
        int red = Mth.m_14045_((int)(red1 + (subtract ? -red2 : red2)), (int)0, (int)255);
        int green = Mth.m_14045_((int)(green1 + (subtract ? -green2 : green2)), (int)0, (int)255);
        int blue = Mth.m_14045_((int)(blue1 + (subtract ? -blue2 : blue2)), (int)0, (int)255);
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static double getMouseX() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91067_.m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_();
    }

    public static double getMouseY() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_();
    }

    public static void pushModelViewPoseStack(PoseStack poseStack) {
        PoseStack viewStack = RenderSystem.m_157191_();
        if (viewStack == poseStack) {
            return;
        }
        viewStack.m_85836_();
        viewStack.m_85850_().m_85861_().m_27644_(poseStack.m_85850_().m_85861_());
        viewStack.m_85850_().m_85864_().m_8178_(poseStack.m_85850_().m_85864_());
        RenderSystem.m_157182_();
    }

    public static void popModelViewPoseStack(PoseStack poseStack) {
        PoseStack viewStack = RenderSystem.m_157191_();
        if (viewStack == poseStack) {
            return;
        }
        viewStack.m_85849_();
        RenderSystem.m_157182_();
    }
}

