/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.hud;

import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IHudDisplay {
    @OnlyIn(value=Dist.CLIENT)
    default public double computeHudWidth(Minecraft mc, List<Component> displayList) {
        double maxWidth = 0.0;
        for (Component text : displayList) {
            maxWidth = Math.max(maxWidth, (double)mc.f_91062_.m_92852_((FormattedText)text));
        }
        return maxWidth + 8.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public double computeHudHeight(Minecraft mc, List<Component> displayList) {
        return displayList.size() * 10 + 6;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderHudBackground(MultiBufferSource getter, PoseStack mStack, double width, double height, List<Component> displayList) {
        GuiHelper.drawHoverRect(getter, mStack, 0.0, 0.0, width, height);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderHudContent(Font font, PoseStack mStack, double width, double height, List<Component> displayList) {
        mStack.m_85837_(4.0, 4.0, 0.0);
        for (Component text : displayList) {
            font.m_92763_(mStack, text, 0.0f, 0.0f, 0xFFFFFF);
            mStack.m_85837_(0.0, 10.0, 0.0);
        }
    }
}

