/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.UUIDMap;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ClientCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"emotes-client").then(Commands.m_82127_((String)"play").then(Commands.m_82129_((String)"emote", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new EmoteArgumentHelper()).executes(ctx -> {
            if (!ClientEmotePlay.clientStartLocalEmote(EmoteArgumentHelper.getEmote((CommandContext<CommandSourceStack>)ctx, "emote"))) {
                throw new SimpleCommandExceptionType((Message)new TranslatableComponent("emotecraft.cant.override.forced")).create();
            }
            return 0;
        })))).then(Commands.m_82127_((String)"stop").executes(ctx -> {
            if (ClientEmotePlay.isForcedEmote()) {
                throw new SimpleCommandExceptionType((Message)new TranslatableComponent("emotecraft.cant.override.forced")).create();
            }
            ClientEmotePlay.clientStopLocalEmote();
            return 0;
        })));
    }

    private static class EmoteArgumentHelper
    implements SuggestionProvider<CommandSourceStack> {
        private EmoteArgumentHelper() {
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
            UUIDMap<EmoteHolder> emotes = EmoteHolder.list;
            LinkedList<String> suggestions = new LinkedList<String>();
            for (EmoteHolder emote : emotes.values()) {
                if (!emote.name.getString().equals("")) {
                    Object name = emote.name.getString();
                    if (((String)name).contains(" ")) {
                        name = "\"" + (String)name + "\"";
                    }
                    suggestions.add((String)name);
                    continue;
                }
                suggestions.add(emote.getUuid().toString());
            }
            return SharedSuggestionProvider.m_82967_((String[])((String[])suggestions.toArray(String[]::new)), (SuggestionsBuilder)builder);
        }

        public static KeyframeAnimation getEmote(CommandContext<CommandSourceStack> context, String argumentName) throws CommandSyntaxException {
            String id = StringArgumentType.getString(context, (String)argumentName);
            UUIDMap<EmoteHolder> emotes = EmoteHolder.list;
            try {
                UUID emoteID = UUID.fromString(id);
                EmoteHolder emote = (EmoteHolder)emotes.get((Object)emoteID);
                if (emote == null) {
                    throw new SimpleCommandExceptionType((Message)new TextComponent("No emote with ID: " + emoteID)).create();
                }
                return emote.getEmote();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                for (EmoteHolder emote : emotes.values()) {
                    if (!emote.name.getString().equals(id)) continue;
                    return emote.getEmote();
                }
                throw new SimpleCommandExceptionType((Message)new TextComponent("Not emote with name: " + id)).create();
            }
        }
    }
}

