/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.tools;

import dev.kosmx.playerAnim.core.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;

public class BiMap<L, R>
implements Collection<Pair<L, R>> {
    final HashMap<L, R> lToR = new HashMap();
    final HashMap<R, L> rToL = new HashMap();
    final HashSet<Pair<L, R>> collection = new HashSet();

    public R getR(L key) {
        return this.lToR.get(key);
    }

    public L getL(R key) {
        return this.rToL.get(key);
    }

    public boolean containsL(L l) {
        return this.lToR.containsKey(l);
    }

    public boolean containsR(R r) {
        return this.rToL.containsKey(r);
    }

    public Pair<L, R> put(L l, R r) {
        if (l == null || r == null) {
            throw new NullPointerException("BiMap does not allow null elements");
        }
        Object ol = null;
        Object or = null;
        if (this.lToR.containsKey(l) || this.rToL.containsKey(r)) {
            ol = this.rToL.remove(r);
            or = this.lToR.remove(l);
            this.collection.removeIf(obj -> obj.getLeft() == l || obj.getRight() == r);
        }
        this.rToL.put(r, l);
        this.lToR.put(l, r);
        this.collection.add(new Pair(l, r));
        return new Pair(ol, or);
    }

    @Override
    public boolean add(Pair<L, R> pair) {
        if (pair == null || pair.getLeft() == null || pair.getRight() == null) {
            throw new NullPointerException("BiMap does not allow null elements");
        }
        if (this.collection.contains(pair)) {
            return false;
        }
        this.put(pair.getLeft(), pair.getRight());
        return true;
    }

    public R removeL(L l) {
        if (l == null) {
            throw new NullPointerException("BiMap does not allow null elements");
        }
        R r = this.lToR.remove(l);
        if (r != null) {
            this.rToL.remove(r);
            this.collection.remove(new Pair(l, r));
        }
        return r;
    }

    public L removeR(R r) {
        if (r == null) {
            throw new NullPointerException("BiMap does not allow null elements");
        }
        L l = this.rToL.remove(r);
        if (l != null) {
            this.rToL.remove(r);
            this.collection.remove(new Pair(l, r));
        }
        return l;
    }

    @Override
    public boolean remove(Object o) {
        boolean bl = this.collection.remove(o);
        if (bl) {
            Pair pair = (Pair)o;
            this.lToR.remove(pair.getLeft());
            this.rToL.remove(pair.getRight());
        }
        return bl;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.collection.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Pair<L, R>> c) {
        boolean bl = false;
        for (Pair<L, R> pair : c) {
            bl |= this.add(pair);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean bl = false;
        for (Object pair : c) {
            bl |= this.remove(pair);
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        Iterator<Pair<L, R>> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.lToR.clear();
        this.rToL.clear();
        this.collection.clear();
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public Iterator<Pair<L, R>> iterator() {
        return new Iterator<Pair<L, R>>(){
            final Iterator<Pair<L, R>> _iter;
            Pair<L, R> _var;
            {
                this._iter = BiMap.this.collection.iterator();
                this._var = null;
            }

            @Override
            public boolean hasNext() {
                return this._iter.hasNext();
            }

            @Override
            public Pair<L, R> next() {
                this._var = this._iter.next();
                return this._var;
            }

            @Override
            public void remove() {
                this._iter.remove();
                BiMap.this.lToR.remove(this._var.getLeft());
                BiMap.this.rToL.remove(this._var.getRight());
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collection.toArray(a);
    }

    private void idk() {
        this.iterator().remove();
    }

    @Override
    public int hashCode() {
        return this.collection.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BiMap) {
            return this.collection.equals(((BiMap)obj).collection);
        }
        return false;
    }
}

