/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotMenu;
import vectorwing.farmersdelight.common.block.entity.inventory.CookingPotItemHandler;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class CookingPotBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
HeatableBlockEntity,
Nameable,
RecipeHolder {
    public static final int MEAL_DISPLAY_SLOT = 6;
    public static final int CONTAINER_SLOT = 7;
    public static final int OUTPUT_SLOT = 8;
    public static final int INVENTORY_SIZE = 9;
    public static final Map<Item, Item> INGREDIENT_REMAINDER_OVERRIDES = Map.ofEntries(Map.entry(Items.f_151055_, Items.f_42446_), Map.entry(Items.f_151057_, Items.f_42446_), Map.entry(Items.f_42458_, Items.f_42446_), Map.entry(Items.f_42456_, Items.f_42446_), Map.entry(Items.f_42457_, Items.f_42446_), Map.entry(Items.f_42459_, Items.f_42446_), Map.entry(Items.f_42718_, Items.f_42399_), Map.entry(Items.f_42400_, Items.f_42399_), Map.entry(Items.f_42699_, Items.f_42399_), Map.entry(Items.f_42734_, Items.f_42399_), Map.entry(Items.f_42589_, Items.f_42590_), Map.entry(Items.f_42736_, Items.f_42590_), Map.entry(Items.f_42739_, Items.f_42590_), Map.entry(Items.f_42612_, Items.f_42590_));
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new CookingPotItemHandler((IItemHandler)this.inventory, Direction.UP));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new CookingPotItemHandler((IItemHandler)this.inventory, Direction.DOWN));
    private int cookTime;
    private int cookTimeTotal;
    private ItemStack mealContainerStack = ItemStack.f_41583_;
    private Component customName;
    protected final ContainerData cookingPotData = this.createIntArray();
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker = new Object2IntOpenHashMap();
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe = true;

    public CookingPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.COOKING_POT.get(), pos, state);
    }

    public static ItemStack getMealFromItem(ItemStack cookingPotStack) {
        CompoundTag inventoryTag;
        if (!cookingPotStack.m_150930_((Item)ModItems.COOKING_POT.get())) {
            return ItemStack.f_41583_;
        }
        CompoundTag compound = cookingPotStack.m_41737_("BlockEntityTag");
        if (compound != null && (inventoryTag = compound.m_128469_("Inventory")).m_128425_("Items", 9)) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(inventoryTag);
            return handler.getStackInSlot(6);
        }
        return ItemStack.f_41583_;
    }

    public static void takeServingFromItem(ItemStack cookingPotStack) {
        CompoundTag inventoryTag;
        if (!cookingPotStack.m_150930_((Item)ModItems.COOKING_POT.get())) {
            return;
        }
        CompoundTag compound = cookingPotStack.m_41737_("BlockEntityTag");
        if (compound != null && (inventoryTag = compound.m_128469_("Inventory")).m_128425_("Items", 9)) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(inventoryTag);
            ItemStack newMealStack = handler.getStackInSlot(6);
            newMealStack.m_41774_(1);
            compound.m_128473_("Inventory");
            compound.m_128365_("Inventory", (Tag)handler.serializeNBT());
        }
    }

    public static ItemStack getContainerFromItem(ItemStack cookingPotStack) {
        if (!cookingPotStack.m_150930_((Item)ModItems.COOKING_POT.get())) {
            return ItemStack.f_41583_;
        }
        CompoundTag compound = cookingPotStack.m_41737_("BlockEntityTag");
        if (compound != null) {
            return ItemStack.m_41712_((CompoundTag)compound.m_128469_("Container"));
        }
        return ItemStack.f_41583_;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.cookTime = compound.m_128451_("CookTime");
        this.cookTimeTotal = compound.m_128451_("CookTimeTotal");
        this.mealContainerStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Container"));
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        CompoundTag compoundRecipes = compound.m_128469_("RecipesUsed");
        for (String key : compoundRecipes.m_128431_()) {
            this.usedRecipeTracker.put((Object)new ResourceLocation(key), compoundRecipes.m_128451_(key));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("CookTime", this.cookTime);
        compound.m_128405_("CookTimeTotal", this.cookTimeTotal);
        compound.m_128365_("Container", (Tag)this.mealContainerStack.serializeNBT());
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        CompoundTag compoundRecipes = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)compoundRecipes);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Container", (Tag)this.mealContainerStack.serializeNBT());
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public CompoundTag writeMeal(CompoundTag compound) {
        if (this.getMeal().m_41619_()) {
            return compound;
        }
        ItemStackHandler drops = new ItemStackHandler(9);
        for (int i = 0; i < 9; ++i) {
            drops.setStackInSlot(i, i == 6 ? this.inventory.getStackInSlot(i) : ItemStack.f_41583_);
        }
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Container", (Tag)this.mealContainerStack.serializeNBT());
        compound.m_128365_("Inventory", (Tag)drops.serializeNBT());
        return compound;
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, CookingPotBlockEntity cookingPot) {
        boolean isHeated = cookingPot.isHeated(level, pos);
        boolean didInventoryChange = false;
        if (isHeated && cookingPot.hasInput()) {
            Optional<CookingPotRecipe> recipe = cookingPot.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)cookingPot.inventory));
            if (recipe.isPresent() && cookingPot.canCook(recipe.get())) {
                didInventoryChange = cookingPot.processCooking(recipe.get(), cookingPot);
            } else {
                cookingPot.cookTime = 0;
            }
        } else if (cookingPot.cookTime > 0) {
            cookingPot.cookTime = Mth.m_14045_((int)(cookingPot.cookTime - 2), (int)0, (int)cookingPot.cookTimeTotal);
        }
        ItemStack mealStack = cookingPot.getMeal();
        if (!mealStack.m_41619_()) {
            if (!cookingPot.doesMealHaveContainer(mealStack)) {
                cookingPot.moveMealToOutput();
                didInventoryChange = true;
            } else if (!cookingPot.inventory.getStackInSlot(7).m_41619_()) {
                cookingPot.useStoredContainersOnMeal();
                didInventoryChange = true;
            }
        }
        if (didInventoryChange) {
            cookingPot.inventoryChanged();
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, CookingPotBlockEntity cookingPot) {
        if (cookingPot.isHeated(level, pos)) {
            double z;
            double y;
            double x;
            Random random = level.f_46441_;
            if (random.nextFloat() < 0.2f) {
                x = (double)pos.m_123341_() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
                y = (double)pos.m_123342_() + 0.7;
                z = (double)pos.m_123343_() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 0.0, 0.0, 0.0);
            }
            if (random.nextFloat() < 0.05f) {
                x = (double)pos.m_123341_() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                y = (double)pos.m_123342_() + 0.5;
                z = (double)pos.m_123343_() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                double motionY = random.nextBoolean() ? 0.015 : 0.005;
                level.m_7106_((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
            }
        }
    }

    private Optional<CookingPotRecipe> getMatchingRecipe(RecipeWrapper inventoryWrapper) {
        Object recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = ((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap((RecipeType)ModRecipeTypes.COOKING.get()).get(this.lastRecipeID)) instanceof CookingPotRecipe) {
            if (recipe.m_5818_((Container)inventoryWrapper, this.f_58857_)) {
                return Optional.of((CookingPotRecipe)recipe);
            }
            if (recipe.m_8043_().m_41656_(this.getMeal())) {
                return Optional.empty();
            }
        }
        if (this.checkNewRecipe && ((Optional)(recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.COOKING.get(), (Container)inventoryWrapper, this.f_58857_))).isPresent()) {
            ResourceLocation newRecipeID = ((CookingPotRecipe)((Optional)recipe).get()).m_6423_();
            if (this.lastRecipeID != null && !this.lastRecipeID.equals((Object)newRecipeID)) {
                this.cookTime = 0;
            }
            this.lastRecipeID = newRecipeID;
            return recipe;
        }
        this.checkNewRecipe = false;
        return Optional.empty();
    }

    public ItemStack getContainer() {
        ItemStack mealStack = this.getMeal();
        if (!mealStack.m_41619_() && !this.mealContainerStack.m_41619_()) {
            return this.mealContainerStack;
        }
        return mealStack.getContainerItem();
    }

    private boolean hasInput() {
        for (int i = 0; i < 6; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(CookingPotRecipe recipe) {
        if (this.hasInput()) {
            ItemStack resultStack = recipe.m_8043_();
            if (resultStack.m_41619_()) {
                return false;
            }
            ItemStack storedMealStack = this.inventory.getStackInSlot(6);
            if (storedMealStack.m_41619_()) {
                return true;
            }
            if (!storedMealStack.m_41656_(resultStack)) {
                return false;
            }
            if (storedMealStack.m_41613_() + resultStack.m_41613_() <= this.inventory.getSlotLimit(6)) {
                return true;
            }
            return storedMealStack.m_41613_() + resultStack.m_41613_() <= resultStack.m_41741_();
        }
        return false;
    }

    private boolean processCooking(CookingPotRecipe recipe, CookingPotBlockEntity cookingPot) {
        if (this.f_58857_ == null) {
            return false;
        }
        ++this.cookTime;
        this.cookTimeTotal = recipe.getCookTime();
        if (this.cookTime < this.cookTimeTotal) {
            return false;
        }
        this.cookTime = 0;
        this.mealContainerStack = recipe.getOutputContainer();
        ItemStack resultStack = recipe.m_8043_();
        ItemStack storedMealStack = this.inventory.getStackInSlot(6);
        if (storedMealStack.m_41619_()) {
            this.inventory.setStackInSlot(6, resultStack.m_41777_());
        } else if (storedMealStack.m_41656_(resultStack)) {
            storedMealStack.m_41769_(resultStack.m_41613_());
        }
        cookingPot.m_6029_(recipe);
        for (int i = 0; i < 6; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.hasContainerItem()) {
                this.ejectIngredientRemainder(slotStack.getContainerItem());
            } else if (INGREDIENT_REMAINDER_OVERRIDES.containsKey(slotStack.m_41720_())) {
                this.ejectIngredientRemainder(INGREDIENT_REMAINDER_OVERRIDES.get(slotStack.m_41720_()).m_7968_());
            }
            if (slotStack.m_41619_()) continue;
            slotStack.m_41774_(1);
        }
        return true;
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        Direction direction = ((Direction)this.m_58900_().m_61143_((Property)CookingPotBlock.FACING)).m_122428_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
        double y = (double)this.f_58858_.m_123342_() + 0.7;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
        ItemUtils.spawnItemEntity(this.f_58857_, remainderStack, x, y, z, (float)direction.m_122429_() * 0.08f, 0.25, (float)direction.m_122431_() * 0.08f);
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.m_6423_();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_8015_(Player player) {
        List<Recipe<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.f_19853_, player.m_20182_());
        player.m_7281_(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<Recipe<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                CookingPotBlockEntity.splitAndSpawnExperience((ServerLevel)level, pos, entry.getIntValue(), ((CookingPotRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.m_14143_((float)((float)craftedAmount * experience));
        float expFraction = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public boolean isHeated() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.isHeated(this.f_58857_, this.f_58858_);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getMeal() {
        return this.inventory.getStackInSlot(6);
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        for (int i = 0; i < 9; ++i) {
            if (i == 6) continue;
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    private void moveMealToOutput() {
        ItemStack mealStack = this.inventory.getStackInSlot(6);
        ItemStack outputStack = this.inventory.getStackInSlot(8);
        int mealCount = Math.min(mealStack.m_41613_(), mealStack.m_41741_() - outputStack.m_41613_());
        if (outputStack.m_41619_()) {
            this.inventory.setStackInSlot(8, mealStack.m_41620_(mealCount));
        } else if (outputStack.m_41720_() == mealStack.m_41720_()) {
            mealStack.m_41774_(mealCount);
            outputStack.m_41769_(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        ItemStack mealStack = this.inventory.getStackInSlot(6);
        ItemStack containerInputStack = this.inventory.getStackInSlot(7);
        ItemStack outputStack = this.inventory.getStackInSlot(8);
        if (this.isContainerValid(containerInputStack) && outputStack.m_41613_() < outputStack.m_41741_()) {
            int smallerStackCount = Math.min(mealStack.m_41613_(), containerInputStack.m_41613_());
            int mealCount = Math.min(smallerStackCount, mealStack.m_41741_() - outputStack.m_41613_());
            if (outputStack.m_41619_()) {
                containerInputStack.m_41774_(mealCount);
                this.inventory.setStackInSlot(8, mealStack.m_41620_(mealCount));
            } else if (outputStack.m_41720_() == mealStack.m_41720_()) {
                mealStack.m_41774_(mealCount);
                containerInputStack.m_41774_(mealCount);
                outputStack.m_41769_(mealCount);
            }
        }
    }

    public ItemStack useHeldItemOnMeal(ItemStack container) {
        if (this.isContainerValid(container) && !this.getMeal().m_41619_()) {
            container.m_41774_(1);
            return this.getMeal().m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    private boolean doesMealHaveContainer(ItemStack meal) {
        return !this.mealContainerStack.m_41619_() || meal.hasContainerItem();
    }

    public boolean isContainerValid(ItemStack containerItem) {
        if (containerItem.m_41619_()) {
            return false;
        }
        if (!this.mealContainerStack.m_41619_()) {
            return this.mealContainerStack.m_41656_(containerItem);
        }
        return this.getMeal().getContainerItem().m_41656_(containerItem);
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : TextUtils.getTranslation("container.cooking_pot", new Object[0]);
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory player, Player entity) {
        return new CookingPotMenu(id, player, this, this.cookingPotData);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
    }

    @Override
    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                if (slot >= 0 && slot < 6) {
                    CookingPotBlockEntity.this.checkNewRecipe = true;
                }
                CookingPotBlockEntity.this.inventoryChanged();
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> CookingPotBlockEntity.this.cookTime;
                    case 1 -> CookingPotBlockEntity.this.cookTimeTotal;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        CookingPotBlockEntity.this.cookTime = value;
                        break;
                    }
                    case 1: {
                        CookingPotBlockEntity.this.cookTimeTotal = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }
}

