/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.mojang.math.Vector4f;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import com.razz.decocraft.models.libgdx.Matrix4;
import com.razz.decocraft.models.libgdx.Quaternion;
import com.razz.decocraft.models.libgdx.Vector3;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraftforge.client.ForgeHooksClient;

public class BlockbenchBakery {
    private static Vector3 vec3iToVec3(Vec3i vec3i) {
        return new Vector3(vec3i.m_123341_(), vec3i.m_123342_(), vec3i.m_123343_());
    }

    public BakedQuad bakeQuad(BBModelParts.Element element, BlockbenchLoader.BlockbenchSetting settings, BBModelParts.Element rootNode, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, TextureAtlasSprite texture, Direction direc, ModelState modelTransform) {
        int[] vertices = this.makeVertices(element, settings, rootNode, uvs, resolution, texture, direc, this.setupShape(element.from, element.to, element.inflate), modelTransform.m_6189_());
        Direction direction = this.calculateFacing(vertices);
        ForgeHooksClient.fillNormal((int[])vertices, (Direction)direction);
        return new BakedQuad(vertices, -1, direction, texture, element.shade);
    }

    private int[] makeVertices(BBModelParts.Element element, BlockbenchLoader.BlockbenchSetting setting, BBModelParts.Element rootNode, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, TextureAtlasSprite texture, Direction direction, float[] positions, Transformation transformationMatrix) {
        int[] vertices = new int[32];
        for (int i = 0; i < 4; ++i) {
            this.bakeVertex(vertices, i, rootNode, direction, setting, uvs, resolution, positions, texture, transformationMatrix, element);
        }
        return vertices;
    }

    private void bakeVertex(int[] vertices, int index, BBModelParts.Element rootNode, Direction direction, BlockbenchLoader.BlockbenchSetting setting, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, float[] positions, TextureAtlasSprite texture, Transformation transformationMatrix, BBModelParts.Element element) {
        FaceInfo.VertexInfo vertexInfo = FaceInfo.m_108984_((Direction)direction).m_108982_(index);
        Vector3 pos = new Vector3(positions[vertexInfo.f_108998_], positions[vertexInfo.f_108999_], positions[vertexInfo.f_109000_]);
        this.applyElementRotation(pos, element);
        Matrix4 mat4 = new Matrix4();
        this.applyTransform(pos, mat4.setToScaling(setting.scale, setting.scale, setting.scale));
        this.applyTransform(pos, mat4.setToTranslation(0.5f, 0.0f, 0.5f));
        if (rootNode != null) {
            if (rootNode.position != null) {
                this.applyTransform(pos, mat4.setToTranslation(-rootNode.position.x / 16.0f, -rootNode.position.y / 16.0f, -rootNode.position.z / 16.0f));
            } else if (rootNode.from != null) {
                this.applyTransform(pos, mat4.setToTranslation(-rootNode.from.x / 16.0f, -rootNode.from.y / 16.0f, -rootNode.from.z / 16.0f));
            }
        }
        this.applyModelRotation(pos, new Vector3(0.5f, 0.5f, 0.5f), transformationMatrix);
        this.fillVertex(vertices, index, setting, pos, texture, uvs, resolution);
    }

    private void applyTransform(Vector3 pos, Matrix4 trans) {
        pos.set(trans.val[0] * pos.x + trans.val[4] * pos.y + trans.val[8] * pos.z + trans.val[12] * 1.0f, trans.val[1] * pos.x + trans.val[5] * pos.y + trans.val[9] * pos.z + trans.val[13] * 1.0f, trans.val[2] * pos.x + trans.val[6] * pos.y + trans.val[10] * pos.z + trans.val[14] * 1.0f);
    }

    private void rotateVertexBy(Vector3 pos, Vector3 origin, Matrix4 mat4) {
        Vector3 delta = new Vector3(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z);
        this.applyTransform(delta, mat4);
        pos.set(delta.x + origin.x, delta.y + origin.y, delta.z + origin.z);
    }

    private void rotateVertexBy(Vector3 pos, Vector3 origin, Matrix4f mat4) {
        Vector4f delta = new Vector4f(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z, 1.0f);
        delta.m_123607_(mat4);
        pos.set(delta.m_123601_() + origin.x, delta.m_123615_() + origin.y, delta.m_123616_() + origin.z);
    }

    private void applyModelRotation(Vector3 pos, Vector3 rot, Transformation transformationMatrix) {
        if (transformationMatrix != Transformation.m_121093_()) {
            this.rotateVertexBy(pos, rot, transformationMatrix.m_121104_());
        }
    }

    private void applyElementRotation(Vector3 pos, BBModelParts.Element element) {
        Vector3 origin = new Vector3(element.origin.x, element.origin.y, element.origin.z);
        Vector3 rotation = element.rotation;
        BBModelParts.OutlinerGroup parent = element.parent;
        Quaternion quaternion = new Quaternion();
        while (true) {
            if (rotation.x != 0.0f) {
                quaternion.set(Vector3.X, rotation.x);
                this.rotateVertexBy(pos, new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f), new Matrix4(quaternion));
            }
            if (rotation.y != 0.0f) {
                quaternion.set(Vector3.Y, rotation.y);
                this.rotateVertexBy(pos, new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f), new Matrix4(quaternion));
            }
            if (rotation.z != 0.0f) {
                quaternion.set(Vector3.Z, rotation.z);
                this.rotateVertexBy(pos, new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f), new Matrix4(quaternion));
            }
            if (parent == null) break;
            origin = parent.origin;
            rotation = parent.rotation;
            parent = parent.parent;
        }
    }

    private void fillVertex(int[] vertices, int index, BlockbenchLoader.BlockbenchSetting setting, Vector3 pos, TextureAtlasSprite texture, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution) {
        int i = index * 8;
        float u = -1.0f;
        float v = -1.0f;
        if (!setting.flipV) {
            switch (index) {
                case 0: {
                    u = uvs.u0;
                    v = uvs.v0;
                    break;
                }
                case 1: {
                    u = uvs.u0;
                    v = uvs.v1;
                    break;
                }
                case 2: {
                    u = uvs.u1;
                    v = uvs.v1;
                    break;
                }
                case 3: {
                    u = uvs.u1;
                    v = uvs.v0;
                }
            }
        } else {
            switch (index) {
                case 2: {
                    u = uvs.u1;
                    v = uvs.v0;
                    break;
                }
                case 3: {
                    u = uvs.u1;
                    v = uvs.v1;
                    break;
                }
                case 0: {
                    u = uvs.u0;
                    v = uvs.v1;
                    break;
                }
                case 1: {
                    u = uvs.u0;
                    v = uvs.v0;
                }
            }
        }
        vertices[i] = Float.floatToRawIntBits(pos.x);
        vertices[i + 1] = Float.floatToRawIntBits(pos.y);
        vertices[i + 2] = Float.floatToRawIntBits(pos.z);
        vertices[i + 3] = -1;
        vertices[i + 4] = Float.floatToRawIntBits(texture.m_118367_((double)(u / ((float)resolution.width / 16.0f))));
        vertices[i + 4 + 1] = Float.floatToRawIntBits(texture.m_118393_((double)(v / ((float)resolution.height / 16.0f))));
    }

    private float[] setupShape(Vector3 from, Vector3 to, float inflate) {
        float[] afloat = new float[Direction.values().length];
        afloat[FaceInfo.Constants.f_108996_] = (from.x - inflate / 2.0f) / 16.0f;
        afloat[FaceInfo.Constants.f_108995_] = (from.y - inflate / 2.0f) / 16.0f;
        afloat[FaceInfo.Constants.f_108994_] = (from.z - inflate / 2.0f) / 16.0f;
        afloat[FaceInfo.Constants.f_108993_] = (to.x + inflate / 2.0f) / 16.0f;
        afloat[FaceInfo.Constants.f_108992_] = (to.y + inflate / 2.0f) / 16.0f;
        afloat[FaceInfo.Constants.f_108991_] = (to.z + inflate / 2.0f) / 16.0f;
        return afloat;
    }

    private Direction calculateFacing(int[] vertices) {
        Vector3 pos1 = new Vector3(Float.intBitsToFloat(vertices[0]), Float.intBitsToFloat(vertices[1]), Float.intBitsToFloat(vertices[2]));
        Vector3 pos2 = new Vector3(Float.intBitsToFloat(vertices[8]), Float.intBitsToFloat(vertices[9]), Float.intBitsToFloat(vertices[10]));
        Vector3 pos3 = new Vector3(Float.intBitsToFloat(vertices[16]), Float.intBitsToFloat(vertices[17]), Float.intBitsToFloat(vertices[18]));
        Vector3 delta1 = pos1.cpy();
        delta1.sub(pos2);
        Vector3 delta2 = pos3.cpy();
        delta2.sub(pos2);
        Vector3 cross = delta2.cpy();
        cross.crs(delta1);
        cross.nor();
        Direction direction = null;
        float f = 0.0f;
        for (Direction direc : Direction.values()) {
            Vector3 normal = BlockbenchBakery.vec3iToVec3(direc.m_122436_());
            float f1 = cross.dot(normal);
            if (!(f1 >= 0.0f) || !(f1 > f)) continue;
            f = f1;
            direction = direc;
        }
        return direction == null ? Direction.UP : direction;
    }
}

