/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.common.ModuleItems;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.items.DecoBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DecobenchTileEntity
extends BlockEntity {
    public static final float COLORS_MAX = 256.0f;
    public static final float RAW_MATERIAL_MAX = 128.0f;
    public static final float CRAFTING_TIME = 40.0f;
    private final SimpleContainer result = new SimpleContainer(1);
    private final SimpleContainer input = new SimpleContainer(1);
    private ItemStack pendingCrafting = ItemStack.f_41583_;
    private ItemStack currentCrafting = ItemStack.f_41583_;
    private int colorRed = 0;
    private int colorGreen = 0;
    private int colorBlue = 0;
    private int rawMaterial = 0;
    private int timer = 0;
    private int craft = 0;
    private int craftingTimer = 0;

    public DecobenchTileEntity(BlockPos pos, BlockState state) {
        super(ModuleTileEntities.DECOBENCH_TE, pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (!level.m_5776_()) {
            DecobenchTileEntity be = (DecobenchTileEntity)blockEntity;
            ++be.timer;
            if (be.timer % 10 == 0) {
                be.timer = 0;
                ItemStack inputStack = be.input.m_8020_(0);
                if (inputStack.m_41720_() instanceof DyeItem) {
                    Color color = Color.byName(((DyeItem)inputStack.m_41720_()).m_41089_().m_41065_(), Color.BLACK);
                    if (color != Color.BLACK && (float)(be.colorRed + color.getRed()) <= 256.0f && (float)(be.colorGreen + color.getGreen()) <= 256.0f && (float)(be.colorBlue + color.getBlue()) <= 256.0f) {
                        inputStack.m_41764_(inputStack.m_41613_() - 1);
                        be.input.m_6836_(0, inputStack);
                        be.colorRed += color.getRed();
                        be.colorGreen += color.getGreen();
                        be.colorBlue += color.getBlue();
                    }
                } else if (inputStack.m_41720_() == ModuleItems.RAW_MATERIAL && (float)(be.rawMaterial + 1) <= 128.0f) {
                    inputStack.m_41764_(inputStack.m_41613_() - 1);
                    be.input.m_6836_(0, inputStack);
                    ++be.rawMaterial;
                }
            }
            if (be.currentCrafting == ItemStack.f_41583_ && be.pendingCrafting != ItemStack.f_41583_) {
                be.currentCrafting = be.pendingCrafting;
            }
            if (be.craft == 1 && be.currentCrafting != ItemStack.f_41583_ && be.currentCrafting.m_41720_() instanceof DecoBlockItem && be.result.m_19183_(be.currentCrafting) && ((DecoBlockItem)be.currentCrafting.m_41720_()).getRed() <= be.getColorRed() && ((DecoBlockItem)be.currentCrafting.m_41720_()).getGreen() <= be.getColorGreen() && ((DecoBlockItem)be.currentCrafting.m_41720_()).getBlue() <= be.getColorBlue() && ((DecoBlockItem)be.currentCrafting.m_41720_()).getMaterial() <= be.getRawMaterial() && ((DecoBlockItem)be.currentCrafting.m_41720_()).getRed() >= 0 && ((DecoBlockItem)be.currentCrafting.m_41720_()).getGreen() >= 0 && ((DecoBlockItem)be.currentCrafting.m_41720_()).getBlue() >= 0) {
                ++be.craftingTimer;
                if ((float)be.craftingTimer >= 40.0f) {
                    be.colorRed -= ((DecoBlockItem)be.currentCrafting.m_41720_()).getRed();
                    be.colorGreen -= ((DecoBlockItem)be.currentCrafting.m_41720_()).getGreen();
                    be.colorBlue -= ((DecoBlockItem)be.currentCrafting.m_41720_()).getBlue();
                    be.rawMaterial -= ((DecoBlockItem)be.currentCrafting.m_41720_()).getMaterial();
                    be.craftingTimer = 0;
                    be.craft = 0;
                    be.result.m_19173_(be.currentCrafting.m_41777_());
                    be.currentCrafting = ItemStack.f_41583_;
                }
            } else {
                be.currentCrafting = ItemStack.f_41583_;
                be.craftingTimer = 0;
                be.craft = 0;
            }
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.colorRed = nbt.m_128451_("color_red");
        this.colorGreen = nbt.m_128451_("color_green");
        this.colorBlue = nbt.m_128451_("color_blue");
        this.rawMaterial = nbt.m_128451_("raw_material");
        this.craft = nbt.m_128451_("craft");
        this.craftingTimer = nbt.m_128451_("crafting_timer");
        this.currentCrafting = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("current_crafting"));
        this.result.m_6836_(0, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("result")));
        this.input.m_6836_(0, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("input")));
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.saveNBTCustom(nbt);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.saveNBTCustom(nbt);
        return nbt;
    }

    private void saveNBTCustom(CompoundTag nbt) {
        nbt.m_128405_("color_red", this.colorRed);
        nbt.m_128405_("color_green", this.colorGreen);
        nbt.m_128405_("color_blue", this.colorBlue);
        nbt.m_128405_("raw_material", this.rawMaterial);
        nbt.m_128405_("craft", this.craft);
        nbt.m_128405_("crafting_timer", this.craftingTimer);
        CompoundTag currentCraftingNBT = new CompoundTag();
        this.currentCrafting.m_41739_(currentCraftingNBT);
        CompoundTag resultNBT = new CompoundTag();
        this.result.m_8020_(0).m_41739_(resultNBT);
        CompoundTag inputNBT = new CompoundTag();
        this.input.m_8020_(0).m_41739_(inputNBT);
        nbt.m_128365_("current_crafting", (Tag)currentCraftingNBT);
        nbt.m_128365_("result", (Tag)resultNBT);
        nbt.m_128365_("input", (Tag)inputNBT);
    }

    public int getColorRed() {
        return this.colorRed;
    }

    public int getColorGreen() {
        return this.colorGreen;
    }

    public int getColorBlue() {
        return this.colorBlue;
    }

    public int getRawMaterial() {
        return this.rawMaterial;
    }

    public SimpleContainer getInput() {
        return this.input;
    }

    public SimpleContainer getResult() {
        return this.result;
    }

    public void setResult(ItemStack result) {
        this.result.m_6836_(0, result);
    }

    public int getCraft() {
        return this.craft;
    }

    public void setCraft(int craft) {
        this.craft = craft;
    }

    public int getCraftingTimer() {
        return this.craftingTimer;
    }

    public void setPendingCrafting(ItemStack pendingCrafting) {
        this.pendingCrafting = pendingCrafting == null ? ItemStack.f_41583_ : pendingCrafting;
    }

    private static enum Color {
        WHITE(0, "white", 4, 4, 4),
        GRAY(7, "gray", 2, 2, 2),
        LIGHT_GRAY(8, "light_gray", 1, 1, 1),
        BLACK(15, "black", 0, 0, 0),
        ORANGE(1, "orange", 6, 3, 1),
        MAGENTA(2, "magenta", 6, 0, 6),
        LIGHT_BLUE(3, "light_blue", 1, 3, 6),
        YELLOW(4, "yellow", 6, 6, 0),
        LIME(5, "lime", 1, 6, 0),
        PINK(6, "pink", 6, 1, 3),
        CYAN(9, "cyan", 0, 6, 6),
        PURPLE(10, "purple", 3, 0, 3),
        BROWN(12, "brown", 1, 1, 0),
        BLUE(11, "blue", 0, 0, 12),
        GREEN(13, "green", 0, 12, 0),
        RED(14, "red", 12, 0, 0);

        private final int id;
        private final String name;
        private final int red;
        private final int green;
        private final int blue;

        private Color(int id, String name, int r, int g, int b) {
            this.id = id;
            this.name = name;
            this.red = r;
            this.green = g;
            this.blue = b;
        }

        public static Color byName(String name, Color fallback) {
            for (Color color : Color.values()) {
                if (!color.name.equals(name)) continue;
                return color;
            }
            return fallback;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }
    }
}

