/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.razz.decocraft.DecoException;
import com.razz.decocraft.client.render.AnimatedModelRenderer;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.common.properties.DecoProperty;
import com.razz.decocraft.common.tileentities.AnimatedTileEntity;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AnimatedRenderer
implements BlockEntityRenderer<AnimatedTileEntity> {
    private static final String ROOT = "ROOT";
    private static Map<String, ModelPart> CACHE = new HashMap<String, ModelPart>();
    private final BlockEntityRendererProvider.Context context;

    public AnimatedRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(AnimatedTileEntity tileEntity, float partialTick, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        tileEntity.addTimer(partialTick / 20.0f);
        if (!tileEntity.m_58898_()) {
            return;
        }
        BlockState blockstate = tileEntity.m_58904_().m_8055_(tileEntity.m_58899_());
        if (!blockstate.m_61138_((Property)DecoProperty.FACING)) {
            return;
        }
        Direction facing = (Direction)blockstate.m_61143_((Property)DecoProperty.FACING);
        DecocraftBlock block = (DecocraftBlock)blockstate.m_60734_();
        ModelPart model = this.parseModel(block.meta, block.model, tileEntity);
        Material material = new Material(TextureAtlas.f_118259_, new ResourceLocation("decocraft", block.meta.material));
        VertexConsumer vertexUV = material.m_119194_(bufferIn, RenderType::m_110473_);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(new Quaternion(Vector3f.f_122224_, facing.m_122435_(), true));
        matrixStackIn.m_85845_(new Quaternion(Vector3f.f_122222_, 180.0f, true));
        matrixStackIn.m_85845_(new Quaternion(Vector3f.f_122226_, 180.0f, true));
        switch (facing) {
            case NORTH: {
                matrixStackIn.m_85837_(0.5, 0.0, 0.5);
                break;
            }
            case SOUTH: {
                matrixStackIn.m_85837_(-0.5, 0.0, -0.5);
                break;
            }
            case EAST: {
                matrixStackIn.m_85837_(0.5, 0.0, -0.5);
                break;
            }
            case WEST: {
                matrixStackIn.m_85837_(-0.5, 0.0, 0.5);
                break;
            }
        }
        model.m_104301_(matrixStackIn, vertexUV, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
    }

    private ModelPart parseModel(JsonContainer.Entry meta, BBModel bbmodel, AnimatedTileEntity tileEntity) {
        AnimatedModelRenderer model = new AnimatedModelRenderer(bbmodel.resolution.width, bbmodel.resolution.height, null, ROOT);
        Map<String, Map<BBModelParts.Channel, float[]>> keyframes = tileEntity.getKeyframes();
        this.parseOutliners(bbmodel.resolution.width, bbmodel.resolution.height, new BBModelParts.ElementBase(), bbmodel.outliner, bbmodel.uuidMap, model, ROOT, keyframes);
        return model;
    }

    private void parseOutliners(int width, int height, BBModelParts.ElementBase topNode, List<BBModelParts.OutlinerNode> nodes, Map<String, BBModelParts.ElementBase> uuidMap, AnimatedModelRenderer topRenderer, String path, Map<String, Map<BBModelParts.Channel, float[]>> keyframes) {
        for (BBModelParts.OutlinerNode outNode : nodes) {
            BBModelParts.ElementBase elementBase;
            if (outNode instanceof BBModelParts.OutlinerGroup) {
                elementBase = (BBModelParts.OutlinerGroup)outNode;
            } else if (outNode instanceof BBModelParts.OutlinerCube) {
                elementBase = uuidMap.get(((BBModelParts.OutlinerCube)outNode).uuid);
            } else {
                throw new DecoException("Error processing the outliners");
            }
            String name = path + "/" + elementBase.name;
            AnimatedModelRenderer modelRenderer = new AnimatedModelRenderer(width, height, Objects.equals(elementBase.type, "cube") ? (BBModelParts.Element)elementBase : null, name);
            float[] animRot = new float[]{0.0f, 0.0f, 0.0f};
            float[] animPos = new float[]{0.0f, 0.0f, 0.0f};
            if (keyframes.get(elementBase.uuid) != null) {
                if (keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.ROTATION) != null) {
                    animRot = keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.ROTATION);
                }
                if (keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.POSITION) != null) {
                    animPos = keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.POSITION);
                }
            }
            modelRenderer.m_104227_(elementBase.origin.x - topNode.origin.x - animPos[0], elementBase.origin.y - topNode.origin.y + animPos[1], elementBase.origin.z - topNode.origin.z + animPos[2]);
            modelRenderer.f_104203_ = elementBase.rotation.x - animRot[0];
            modelRenderer.f_104204_ = elementBase.rotation.y - animRot[1];
            modelRenderer.f_104205_ = elementBase.rotation.z + animRot[2];
            topRenderer.addChild(name, modelRenderer);
            if (Objects.equals(elementBase.type, "cube")) {
                BBModelParts.Element element = (BBModelParts.Element)elementBase;
                modelRenderer.addBox(element.from.x - element.origin.x, element.from.y - element.origin.y, element.from.z - element.origin.z, element.to.x - element.from.x, element.to.y - element.from.y, element.to.z - element.from.z);
                continue;
            }
            BBModelParts.ElementBase group = elementBase;
            this.parseOutliners(width, height, elementBase, group.children, uuidMap, modelRenderer, name, keyframes);
        }
    }
}

