/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.core.api.worldgen;

import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public abstract class BiomeWriter {
    @SafeVarargs
    public final void add(Consumer<BiomeWriter> writer, ResourceKey<Biome> ... biomes) {
        for (ResourceKey<Biome> biome : biomes) {
            if (!this.is(biome)) continue;
            writer.accept(this);
        }
    }

    public final void add(Consumer<BiomeWriter> writer, Biome.BiomeCategory ... categories) {
        for (Biome.BiomeCategory category : categories) {
            if (!this.is(category)) continue;
            writer.accept(this);
        }
    }

    public boolean is(ResourceKey<Biome> biome) {
        return biome == ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)this.name());
    }

    public boolean is(Biome.BiomeCategory category) {
        return category == this.category();
    }

    public abstract ResourceLocation name();

    public abstract Biome.BiomeCategory category();

    public abstract void addFeature(GenerationStep.Decoration var1, Holder<PlacedFeature> var2);

    public abstract void addSpawn(MobCategory var1, EntityType<?> var2, int var3, int var4, int var5);
}

