/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.core.api;

import com.cursedcauldron.wildbackport.core.api.forge.CoreRegistryImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public abstract class CoreRegistry<T> {
    protected final Registry<T> registry;
    protected final String modId;
    protected boolean isPresent;

    protected CoreRegistry(Registry<T> registry, String modId) {
        this.registry = registry;
        this.modId = modId;
        this.isPresent = false;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> CoreRegistry<T> create(Registry<T> key, String modId) {
        void var1_1;
        return CoreRegistryImpl.create(key, (String)var1_1);
    }

    public abstract <E extends T> Supplier<E> register(String var1, Supplier<E> var2);

    public void register() {
        if (this.isPresent) {
            throw new IllegalArgumentException("Duplication of Registry: " + this.registry);
        }
        this.isPresent = true;
        this.bootstrap();
    }

    protected abstract void bootstrap();

    public static class DefaultRegistry<T>
    extends CoreRegistry<T> {
        public DefaultRegistry(Registry<T> registry, String modId) {
            super(registry, modId);
        }

        @Override
        public <E extends T> Supplier<E> register(String key, Supplier<E> entry) {
            Object registry = Registry.m_122965_((Registry)this.registry, (ResourceLocation)new ResourceLocation(this.modId, key), entry.get());
            return () -> registry;
        }

        @Override
        public void bootstrap() {
        }
    }
}

