/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.decorator;

import com.cursedcauldron.wildbackport.common.registry.worldgen.WBTreeDecorators;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class WeightedLeaveVineDecorator
extends TreeDecorator {
    public static final Codec<WeightedLeaveVineDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(WeightedLeaveVineDecorator::new, decorator -> Float.valueOf(decorator.probability)).codec();
    private final float probability;

    public WeightedLeaveVineDecorator(float probability) {
        this.probability = probability;
    }

    public void m_142741_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> replacer, Random random, List<BlockPos> trunkPositions, List<BlockPos> foliagePositions) {
        foliagePositions.forEach(pos -> {
            if (random.nextFloat() < this.probability && Feature.m_65810_((LevelSimulatedReader)level, (BlockPos)pos.m_142125_())) {
                WeightedLeaveVineDecorator.addHangingVine(level, pos.m_142125_(), VineBlock.f_57835_, replacer);
            }
            if (random.nextFloat() < this.probability && Feature.m_65810_((LevelSimulatedReader)level, (BlockPos)pos.m_142126_())) {
                WeightedLeaveVineDecorator.addHangingVine(level, pos.m_142126_(), VineBlock.f_57837_, replacer);
            }
            if (random.nextFloat() < this.probability && Feature.m_65810_((LevelSimulatedReader)level, (BlockPos)pos.m_142127_())) {
                WeightedLeaveVineDecorator.addHangingVine(level, pos.m_142127_(), VineBlock.f_57836_, replacer);
            }
            if (random.nextFloat() < this.probability && Feature.m_65810_((LevelSimulatedReader)level, (BlockPos)pos.m_142128_())) {
                WeightedLeaveVineDecorator.addHangingVine(level, pos.m_142128_(), VineBlock.f_57834_, replacer);
            }
        });
    }

    private static void addHangingVine(LevelSimulatedReader level, BlockPos pos, BooleanProperty property, BiConsumer<BlockPos, BlockState> replacer) {
        LeaveVineDecorator.m_161750_(replacer, (BlockPos)pos, (BooleanProperty)property);
        pos = pos.m_7495_();
        for (int i = 4; Feature.m_65810_((LevelSimulatedReader)level, (BlockPos)pos) && i > 0; --i) {
            LeaveVineDecorator.m_161750_(replacer, (BlockPos)pos, (BooleanProperty)property);
            pos = pos.m_7495_();
        }
    }

    protected TreeDecoratorType<?> m_6663_() {
        return WBTreeDecorators.WEIGHTED_LEAVE_VINE.get();
    }
}

