/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.decorator;

import com.cursedcauldron.wildbackport.common.registry.worldgen.WBTreeDecorators;
import com.cursedcauldron.wildbackport.common.utils.ModUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class AttachedToLeavesDecorator
extends TreeDecorator {
    public static final Codec<AttachedToLeavesDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(decorator -> decorator.exclusionRadiusXZ), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_y").forGetter(decorator -> decorator.exclusionRadiusY), (App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(decorator -> decorator.blockProvider), (App)Codec.intRange((int)1, (int)16).fieldOf("required_empty_blocks").forGetter(decorator -> decorator.requiredEmptyBlocks), (App)Direction.f_175356_.listOf().fieldOf("directions").forGetter(decorator -> decorator.directions)).apply((Applicative)instance, AttachedToLeavesDecorator::new));
    protected final float probability;
    protected final int exclusionRadiusXZ;
    protected final int exclusionRadiusY;
    protected final BlockStateProvider blockProvider;
    protected final int requiredEmptyBlocks;
    protected final List<Direction> directions;

    public AttachedToLeavesDecorator(float probability, int exclusionRadiusXZ, int exclusionRadiusY, BlockStateProvider blockProvider, int requiredEmptyBlocks, List<Direction> directions) {
        this.probability = probability;
        this.exclusionRadiusXZ = exclusionRadiusXZ;
        this.exclusionRadiusY = exclusionRadiusY;
        this.blockProvider = blockProvider;
        this.requiredEmptyBlocks = requiredEmptyBlocks;
        this.directions = directions;
    }

    public void m_142741_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> replacer, Random random, List<BlockPos> trunkPositions, List<BlockPos> foliagePositions) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (BlockPos pos : ModUtils.copyShuffled(new ObjectArrayList(foliagePositions), random)) {
            Direction direction;
            BlockPos offset = pos.m_142300_(direction = (Direction)Util.m_143804_(this.directions, (Random)random));
            if (positions.contains(offset) || !(random.nextFloat() < this.probability) || !this.meetsRequiredEmptyBlocks(level, pos, direction)) continue;
            BlockPos minRadius = offset.m_142082_(-this.exclusionRadiusXZ, -this.exclusionRadiusY, -this.exclusionRadiusXZ);
            BlockPos maxRadius = offset.m_142082_(this.exclusionRadiusXZ, this.exclusionRadiusY, this.exclusionRadiusXZ);
            for (BlockPos position : BlockPos.m_121940_((BlockPos)minRadius, (BlockPos)maxRadius)) {
                positions.add(position.m_7949_());
            }
            replacer.accept(offset, this.blockProvider.m_7112_(random, offset));
        }
    }

    private boolean meetsRequiredEmptyBlocks(LevelSimulatedReader level, BlockPos pos, Direction direction) {
        for (int i = 1; i <= this.requiredEmptyBlocks; ++i) {
            if (Feature.m_65810_((LevelSimulatedReader)level, (BlockPos)pos.m_5484_(direction, i))) continue;
            return false;
        }
        return true;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return WBTreeDecorators.ATTACHED_TO_LEAVES.get();
    }
}

