/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.warden;

import com.cursedcauldron.wildbackport.client.registry.WBParticleTypes;
import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.cursedcauldron.wildbackport.core.mixin.access.DamageSourceAccessor;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class SonicBoom
extends Behavior<Warden> {
    private static final int SOUND_DELAY = Mth.m_14165_((double)34.0);
    private static final int DURATION = Mth.m_14167_((float)60.0f);

    public SonicBoom() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, WBMemoryModules.SONIC_BOOM_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT, WBMemoryModules.SONIC_BOOM_SOUND_COOLDOWN.get(), (Object)MemoryStatus.REGISTERED, WBMemoryModules.SONIC_BOOM_SOUND_DELAY.get(), (Object)MemoryStatus.REGISTERED), DURATION);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Warden warden) {
        return warden.closerThan((Entity)warden.m_6274_().m_21952_(MemoryModuleType.f_26372_).get(), 15.0, 20.0);
    }

    protected boolean canStillUse(ServerLevel level, Warden warden, long time) {
        return true;
    }

    protected void start(ServerLevel level, Warden warden, long time) {
        warden.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)DURATION);
        warden.m_6274_().m_21882_(WBMemoryModules.SONIC_BOOM_SOUND_DELAY.get(), (Object)Unit.INSTANCE, (long)(SOUND_DELAY + 5));
        level.m_7605_((Entity)warden, (byte)62);
        warden.m_5496_(WBSoundEvents.WARDEN_SONIC_CHARGE, 3.0f, 1.0f);
    }

    protected void tick(ServerLevel level, Warden warden, long time) {
        warden.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> warden.m_21563_().m_24964_(target.m_20182_()));
        if (!warden.m_6274_().m_21874_(WBMemoryModules.SONIC_BOOM_SOUND_DELAY.get()) && !warden.m_6274_().m_21874_(WBMemoryModules.SONIC_BOOM_SOUND_COOLDOWN.get())) {
            warden.m_6274_().m_21882_(WBMemoryModules.SONIC_BOOM_SOUND_COOLDOWN.get(), (Object)Unit.INSTANCE, (long)(DURATION - SOUND_DELAY + 5));
            warden.m_6274_().m_21952_(MemoryModuleType.f_26372_).filter(warden::isValidTarget).filter(target -> warden.closerThan((Entity)target, 15.0, 20.0)).ifPresent(target -> {
                Vec3 sourcePos = warden.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
                Vec3 targetPos = target.m_146892_().m_82546_(sourcePos);
                Vec3 distance = targetPos.m_82541_();
                for (int i = 1; i < Mth.m_14107_((double)targetPos.m_82553_()) + 7; ++i) {
                    Vec3 charge = sourcePos.m_82549_(distance.m_82490_((double)i));
                    level.m_8767_((ParticleOptions)WBParticleTypes.SONIC_BOOM.get(), charge.f_82479_, charge.f_82480_, charge.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
                warden.m_5496_(WBSoundEvents.WARDEN_SONIC_BOOM, 3.0f, 1.0f);
                target.m_6469_(SonicBoom.sonicBoom((Entity)warden), 10.0f);
                double yKnockback = 0.5 * (1.0 - target.m_21133_(Attributes.f_22278_));
                double xzKnockback = 2.5 * (1.0 - target.m_21133_(Attributes.f_22278_));
                target.m_5997_(distance.m_7096_() * xzKnockback, distance.m_7098_() * yKnockback, distance.m_7094_() * xzKnockback);
            });
        }
    }

    protected void stop(ServerLevel level, Warden warden, long time) {
        SonicBoom.setCooldown((LivingEntity)warden, 60L);
    }

    public static void setCooldown(LivingEntity entity, long cooldown) {
        entity.m_6274_().m_21882_(WBMemoryModules.SONIC_BOOM_COOLDOWN.get(), (Object)Unit.INSTANCE, cooldown);
    }

    public static DamageSource sonicBoom(Entity entity) {
        return ((DamageSourceAccessor)new EntityDamageSource("sonic_boom", entity)).callBypassArmor().m_19389_();
    }
}

